/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.primitives.Longs;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t]h\u0001B\u001c9\u0001\u0005CQA\u0014\u0001\u0005\u0002=CqA\u0015\u0001C\u0002\u0013%1\u000b\u0003\u0004Y\u0001\u0001\u0006I\u0001\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u0011\u0019\u0011\u0007\u0001)A\u00057\")1\r\u0001C\u0001I\")Q\u000e\u0001C\u0001]\")Q\u000f\u0001C\u0001m\")1\u0010\u0001C\u0001y\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0001\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002l\u0001!\t!!\u001c\t\u0011\u0005]\u0004\u0001\"\u0001;\u0003sB\u0001\"!$\u0001\t\u0003Q\u0014q\u0012\u0005\t\u00033\u0003A\u0011\u0001\u001e\u0002\u0010\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAN\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0003/\u0004A\u0011AAm\u0011\u001d\t9\u000e\u0001C\u0001\u0003?Dq!!:\u0001\t\u0003\t9\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\u0005M\b\u0001\"\u0001\u0002|\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0001\u0001\u0011\u0005!q\u0001\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011!\u0011\u0019\u0003\u0001C\u0001u\t\u0015\u0002\"\u0003B\u0019\u0001\t\u0007I\u0011\u0002B\u001a\u0011!\u0011)\u0005\u0001Q\u0001\n\tU\u0002b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\t\u0005#\u0002A\u0011\u0001\u001e\u0003T!A!q\f\u0001\u0005\u0002i\u0012\t\u0007C\u0004\u0003\n\u0002!\tAa#\t\u000f\t=\u0005\u0001\"\u0001\u0003\u0012\"9!q\u0013\u0001\u0005\u0002\teua\u0002BWq!\u0005!q\u0016\u0004\u0007oaB\tA!-\t\r9;C\u0011\u0001BZ\u0011)\u0011)l\nEC\u0002\u0013%!q\u0017\u0005\n\u0005s;#\u0019!C\u0001\u0005wC\u0001Ba3(A\u0003%!Q\u0018\u0005\n\u0005\u001b<#\u0019!C\u0001\u0005wC\u0001Ba4(A\u0003%!Q\u0018\u0005\u000b\u0005#<#\u0019!C\u0001u\tM\u0007\u0002\u0003BkO\u0001\u0006IAa\n\t\u0015\t]wE1A\u0005\u0002i\u0012Y\f\u0003\u0005\u0003Z\u001e\u0002\u000b\u0011\u0002B_\u0011\u001d\u0011Yn\nC\u0001\u0005oC\u0001B!8(\t\u0003Q$q\u001c\u0005\t\u0003\u000b:C\u0011\u0001\u001e\u0003h\"11p\nC\u0005\u0005WDq!!\u0001(\t\u0013\u0011\tPA\bTa\u0006\u00148\u000eS1e_>\u0004X\u000b^5m\u0015\tI$(\u0001\u0004eKBdw.\u001f\u0006\u0003wq\nQa\u001d9be.T!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO\u000e\u00011c\u0001\u0001C\u0011B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n1\u0011I\\=SK\u001a\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u001e\u0002\u0011%tG/\u001a:oC2L!!\u0014&\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u0015\t\u0003#\u0002i\u0011\u0001O\u0001\ngB\f'o[\"p]\u001a,\u0012\u0001\u0016\t\u0003+Zk\u0011AO\u0005\u0003/j\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015M\u0004\u0018M]6D_:4\u0007%\u0001\u0003d_:4W#A.\u0011\u0005q\u0003W\"A/\u000b\u0005es&BA0=\u0003\u0019A\u0017\rZ8pa&\u0011\u0011-\u0018\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000b\r|gN\u001a\u0011\u0002\u001dI,h.Q:Ta\u0006\u00148.V:feR\u0011Q\r\u001b\t\u0003\u0007\u001aL!a\u001a#\u0003\tUs\u0017\u000e\u001e\u0005\u0006S\u001a\u0001\rA[\u0001\u0005MVt7\rE\u0002DW\u0016L!\u0001\u001c#\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014aD2sK\u0006$Xm\u00159be.,6/\u001a:\u0015\u0003=\u0004\"\u0001]:\u000e\u0003ET!A\u001d0\u0002\u0011M,7-\u001e:jifL!\u0001^9\u0003)U\u001bXM]$s_V\u0004\u0018J\u001c4pe6\fG/[8o\u0003M!(/\u00198tM\u0016\u00148I]3eK:$\u0018.\u00197t)\r)w/\u001f\u0005\u0006q\"\u0001\ra\\\u0001\u0007g>,(oY3\t\u000biD\u0001\u0019A8\u0002\t\u0011,7\u000f^\u0001%CB\u0004XM\u001c3Tg\u0005sGm\u00159be.D\u0015\rZ8pa\u000e{gNZ5hkJ\fG/[8ogR\u0019Q- @\t\u000beK\u0001\u0019\u0001+\t\u000b}L\u0001\u0019A.\u0002\u0015!\fGm\\8q\u0007>tg-\u0001\rbaB,g\u000eZ*qCJ\\\u0007*\u00193p_B\u001cuN\u001c4jON$R!ZA\u0003\u0003\u000fAQ!\u0017\u0006A\u0002QCQa \u0006A\u0002m#R!ZA\u0006\u0003kAq!!\u0004\f\u0001\u0004\ty!\u0001\u0004te\u000el\u0015\r\u001d\t\t\u0003#\tY\"a\b\u0002 5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011\u0004#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0005M!aA'baB!\u0011\u0011EA\u0018\u001d\u0011\t\u0019#a\u000b\u0011\u0007\u0005\u0015B)\u0004\u0002\u0002()\u0019\u0011\u0011\u0006!\u0002\rq\u0012xn\u001c;?\u0013\r\ti\u0003R\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00121\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055B\tC\u0004\u00028-\u0001\r!!\u000f\u0002\u000f\u0011,7\u000f^'baBA\u00111HA!\u0003?\ty\"\u0004\u0002\u0002>)!\u0011qHA\f\u0003\u001diW\u000f^1cY\u0016LA!a\u0011\u0002>\t9\u0001*Y:i\u001b\u0006\u0004\u0018\u0001\u00058fo\u000e{gNZ5hkJ\fG/[8o)\rY\u0016\u0011\n\u0005\u000632\u0001\r\u0001V\u0001\u000fC\u0012$7I]3eK:$\u0018.\u00197t)\r)\u0017q\n\u0005\u000736\u0001\r!!\u0015\u0011\t\u0005M\u0013\u0011L\u0007\u0003\u0003+R1!a\u0016_\u0003\u0019i\u0017\r\u001d:fI&!\u00111LA+\u0005\u001dQuNY\"p]\u001a\f\u0011$\u00193e\u0007V\u0014(/\u001a8u+N,'o\u0011:fI\u0016tG/[1mgR\u0019Q-!\u0019\t\u000f\u0005\rd\u00021\u0001\u0002f\u0005)1M]3egB\u0019\u0001/a\u001a\n\u0007\u0005%\u0014OA\u0006De\u0016$WM\u001c;jC2\u001c\u0018a\u00057pO&tWk]3s\rJ|WnS3zi\u0006\u0014G#B3\u0002p\u0005M\u0004bBA9\u001f\u0001\u0007\u0011qD\u0001\u000eaJLgnY5qC2t\u0015-\\3\t\u000f\u0005Ut\u00021\u0001\u0002 \u0005q1.Z=uC\n4\u0015\u000e\\3oC6,\u0017aE1eI\u0012+G.Z4bi&|g\u000eV8lK:\u001cH#B3\u0002|\u0005-\u0005bBA?!\u0001\u0007\u0011qP\u0001\u0007i>\\WM\\:\u0011\u000b\r\u000b\t)!\"\n\u0007\u0005\rEIA\u0003BeJ\f\u0017\u0010E\u0002D\u0003\u000fK1!!#E\u0005\u0011\u0011\u0015\u0010^3\t\u000bI\u0003\u0002\u0019\u0001+\u0002=\u001d,GOR*CsR,7OU3bI>sG\u000b\u001b:fC\u0012\u001c\u0015\r\u001c7cC\u000e\\GCAAI!\u0011\u00195.a%\u0011\u0007\r\u000b)*C\u0002\u0002\u0018\u0012\u0013A\u0001T8oO\u0006\ts-\u001a;G'\nKH/Z:Xe&$H/\u001a8P]RC'/Z1e\u0007\u0006dGNY1dW\u0006\u0001B.[:u\u0019\u0016\fgm\u0015;biV\u001cXm\u001d\u000b\u0007\u0003?\u000bi,!2\u0011\r\u0005\u0005\u00161VAY\u001d\u0011\t\u0019+a*\u000f\t\u0005\u0015\u0012QU\u0005\u0002\u000b&\u0019\u0011\u0011\u0016#\u0002\u000fA\f7m[1hK&!\u0011QVAX\u0005\r\u0019V-\u001d\u0006\u0004\u0003S#\u0005\u0003BAZ\u0003sk!!!.\u000b\u0007\u0005]f,\u0001\u0002gg&!\u00111XA[\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\b\u0003o\u001b\u0002\u0019AA`!\u0011\t\u0019,!1\n\t\u0005\r\u0017Q\u0017\u0002\u000b\r&dWmU=ti\u0016l\u0007bBAd'\u0001\u0007\u0011\u0011Z\u0001\tE\u0006\u001cX\rU1uQB!\u00111WAf\u0013\u0011\ti-!.\u0003\tA\u000bG\u000f\u001b\u000b\u0007\u0003?\u000b\t.a5\t\u000f\u0005]F\u00031\u0001\u0002@\"9\u0011Q\u001b\u000bA\u0002\u0005E\u0016A\u00032bg\u0016\u001cF/\u0019;vg\u0006\u0019B.[:u\u0019\u0016\fg\rR5s'R\fG/^:fgR1\u0011qTAn\u0003;Dq!a.\u0016\u0001\u0004\ty\fC\u0004\u0002HV\u0001\r!!3\u0015\r\u0005}\u0015\u0011]Ar\u0011\u001d\t9L\u0006a\u0001\u0003\u007fCq!!6\u0017\u0001\u0004\t\t,\u0001\u0006jg\u001ecwN\u0019)bi\"$B!!;\u0002pB\u00191)a;\n\u0007\u00055HIA\u0004C_>dW-\u00198\t\u000f\u0005Ex\u00031\u0001\u0002J\u00069\u0001/\u0019;uKJt\u0017\u0001C4m_\n\u0004\u0016\r\u001e5\u0015\t\u0005]\u0018\u0011 \t\u0007\u0003C\u000bY+!3\t\u000f\u0005E\b\u00041\u0001\u0002JR1\u0011q_A\u007f\u0003\u007fDq!a.\u001a\u0001\u0004\ty\fC\u0004\u0002rf\u0001\r!!3\u0002'\u001ddwN\u0019)bi\"LeMT3dKN\u001c\u0018M]=\u0015\t\u0005](Q\u0001\u0005\b\u0003cT\u0002\u0019AAe)\u0019\t9P!\u0003\u0003\f!9\u0011qW\u000eA\u0002\u0005}\u0006bBAy7\u0001\u0007\u0011\u0011Z\u0001\u0010Y&\u001cHOR5mKN\u001cvN\u001d;fIRQ!\u0011\u0003B\n\u0005/\u0011YBa\b\u0011\u000b\r\u000b\t)!-\t\u000f\tUA\u00041\u0001\u0002@\u0006A!/Z7pi\u001645\u000fC\u0004\u0003\u001aq\u0001\r!!3\u0002\u0007\u0011L'\u000fC\u0004\u0003\u001eq\u0001\r!a\b\u0002\rA\u0014XMZ5y\u0011\u001d\u0011\t\u0003\ba\u0001\u0003?\tq\"\u001a=dYV\u001c\u0018n\u001c8Tk\u001a4\u0017\u000e_\u0001\u001cO\u0016$8+\u001e4gSb4uN]\"sK\u0012,g\u000e^5bYN\u0004\u0016\r\u001e5\u0015\t\t\u001d\"Q\u0006\t\u0004\u0007\n%\u0012b\u0001B\u0016\t\n\u0019\u0011J\u001c;\t\u000f\t=R\u00041\u0001\u0002J\u0006y1M]3eK:$\u0018.\u00197t!\u0006$\b.A\nI\u0003\u0012{u\nU0D\u001f:3u\fU!U)\u0016\u0013f*\u0006\u0002\u00036A!!q\u0007B!\u001b\t\u0011ID\u0003\u0003\u0003<\tu\u0012\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\t}B)\u0001\u0003vi&d\u0017\u0002\u0002B\"\u0005s\u0011q\"\u00168b]\u000eDwN]3e%\u0016<W\r_\u0001\u0015\u0011\u0006#uj\u0014)`\u0007>sei\u0018)B)R+%K\u0014\u0011\u00023M,(m\u001d;jiV$X\rS1e_>\u0004h+\u0019:jC\ndWm\u001d\u000b\u0007\u0003?\u0011YEa\u0014\t\u000f\t5\u0003\u00051\u0001\u0002 \u0005!A/\u001a=u\u0011\u0015y\b\u00051\u0001\\\u0003)!W/\u001c9U_.,gn\u001d\u000b\u0005\u0005+\u0012Y\u0006\u0005\u0004\u0002\"\n]\u0013qD\u0005\u0005\u00053\nyK\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011i&\ta\u0001\u0003K\n1b\u0019:fI\u0016tG/[1mg\u0006iAo\\6f]R{7\u000b\u001e:j]\u001e$B!a\b\u0003d!9!Q\r\u0012A\u0002\t\u001d\u0014!\u0002;pW\u0016t\u0007\u0007\u0002B5\u0005o\u0002bAa\u001b\u0003p\tMTB\u0001B7\u0015\r\u0011)']\u0005\u0005\u0005c\u0012iGA\u0003U_.,g\u000e\u0005\u0003\u0003v\t]D\u0002\u0001\u0003\r\u0005s\u0012\u0019'!A\u0001\u0002\u000b\u0005!1\u0010\u0002\u0004?\u0012\n\u0014\u0003\u0002B?\u0005\u0007\u00032a\u0011B@\u0013\r\u0011\t\t\u0012\u0002\b\u001d>$\b.\u001b8h!\u0011\u0011YG!\"\n\t\t\u001d%Q\u000e\u0002\u0010)>\\WM\\%eK:$\u0018NZ5fe\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003\u007f\u0012i\tC\u0004\u0002d\r\u0002\r!!\u001a\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0005\u0003K\u0012\u0019\nC\u0004\u0003\u0016\u0012\u0002\r!a \u0002\u0015Q|7.\u001a8CsR,7/A\u0006jgB\u0013x\u000e_=Vg\u0016\u0014H\u0003BAu\u00057CaA!(&\u0001\u0004y\u0017aA;hS\"\u001a\u0001A!)\u0011\t\t\r&\u0011V\u0007\u0003\u0005KS1Aa*;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005W\u0013)K\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018.A\bTa\u0006\u00148\u000eS1e_>\u0004X\u000b^5m!\t\tve\u0005\u0002(\u0005R\u0011!qV\u0001\tS:\u001cH/\u00198dKV\t\u0001+A\u0010T!\u0006\u00136jX-B%:{6IU#E'~#V)\u0014)`\u000bb#VIT*J\u001f:+\"A!0\u0011\t\t}&\u0011Z\u0007\u0003\u0005\u0003TAAa1\u0003F\u0006!A.\u00198h\u0015\t\u00119-\u0001\u0003kCZ\f\u0017\u0002BA\u0019\u0005\u0003\f\u0001e\u0015)B%.{\u0016,\u0011*O?\u000e\u0013V\tR*`)\u0016k\u0005kX#Y)\u0016s5+S(OA\u0005q2\u000bU!S\u0017~K\u0016I\u0015(`\u0007J+EiU0D\u001fVsE+\u0012*`\t\u0016c\u0015*T\u0001 'B\u000b%kS0Z\u0003Jsul\u0011*F\tN{6iT+O)\u0016\u0013v\fR#M\u00136\u0003\u0013!J+Q\t\u0006#ViX%O!V#v,T#U%&\u001b5kX%O)\u0016\u0013f+\u0011'`%\u0016\u001buJ\u0015#T+\t\u00119#\u0001\u0014V!\u0012\u000bE+R0J\u001dB+FkX'F)JK5iU0J\u001dR+%KV!M?J+5i\u0014*E'\u0002\nac\u0015)B%.{\u0006*\u0011#P\u001fB{6i\u0014(G?\u001aKE*R\u0001\u0018'B\u000b%kS0I\u0003\u0012{u\nU0D\u001f:3uLR%M\u000b\u0002\n1aZ3u\u0003eqW\r\u001f;De\u0016$WM\u001c;jC2\u0014VM\\3xC2$\u0016.\\3\u0015\r\u0005M%\u0011\u001dBs\u0011\u001d\u0011\u0019o\ra\u0001\u0003'\u000ba\"\u001a=qSJ\fG/[8o\t\u0006$X\rC\u0003Zg\u0001\u0007A\u000bF\u0002\\\u0005SDQ!\u0017\u001bA\u0002Q#R!\u001aBw\u0005_DQ!W\u001bA\u0002QCQa`\u001bA\u0002m#R!\u001aBz\u0005kDQ!\u0017\u001cA\u0002QCQa \u001cA\u0002m\u0003")
public class SparkHadoopUtil
implements Logging {
    private final SparkConf sparkConf;
    private final Configuration conf;
    private final UnanchoredRegex HADOOP_CONF_PATTERN;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static SparkHadoopUtil get() {
        return SparkHadoopUtil$.MODULE$.get();
    }

    public static String SPARK_YARN_CREDS_COUNTER_DELIM() {
        return SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM();
    }

    public static String SPARK_YARN_CREDS_TEMP_EXTENSION() {
        return SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration conf() {
        return this.conf;
    }

    public void runAsSparkUser(Function0<BoxedUnit> func) {
        this.createSparkUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(null, func){
            private final Function0 func$1;

            public void run() {
                this.func$1.apply$mcV$sp();
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public UserGroupInformation createSparkUser() {
        void var2_2;
        String user = Utils$.MODULE$.getCurrentUserName();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(23).append("creating UGI for user: ").append(user).toString());
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        this.transferCredentials(UserGroupInformation.getCurrentUser(), ugi);
        return var2_2;
    }

    public void transferCredentials(UserGroupInformation source, UserGroupInformation dest) {
        dest.addCredentials(source.getCredentials());
    }

    public void appendS3AndSparkHadoopConfigurations(SparkConf conf, Configuration hadoopConf) {
        SparkHadoopUtil$.MODULE$.org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopConfigurations(conf, hadoopConf);
    }

    public void appendSparkHadoopConfigs(SparkConf conf, Configuration hadoopConf) {
        SparkHadoopUtil$.MODULE$.org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(conf, hadoopConf);
    }

    public void appendSparkHadoopConfigs(Map<String, String> srcMap, HashMap<String, String> destMap) {
        srcMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil.$anonfun$appendSparkHadoopConfigs$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil.$anonfun$appendSparkHadoopConfigs$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Option option = destMap.put((Object)key.substring("spark.hadoop.".length()), (Object)value);
            return option;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(SparkConf conf) {
        void var2_2;
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.newConfiguration(conf);
        hadoopConf.addResource(SparkHadoopUtil$.MODULE$.SPARK_HADOOP_CONF_FILE());
        return var2_2;
    }

    public void addCredentials(JobConf conf) {
        Credentials jobCreds = conf.getCredentials();
        jobCreds.mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
    }

    public void addCurrentUserCredentials(Credentials creds) {
        UserGroupInformation.getCurrentUser().addCredentials(creds);
    }

    public void loginUserFromKeytab(String principalName, String keytabFilename) {
        if (!new File(keytabFilename).exists()) {
            throw new SparkException(new java.lang.StringBuilder(28).append("Keytab file: ").append(keytabFilename).append(" does not exist").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(62).append("Attempting to login to Kerberos ").append("using principal: ").append(principalName).append(" and keytab: ").append(keytabFilename).toString());
        UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keytabFilename);
    }

    public void addDelegationTokens(byte[] tokens, SparkConf sparkConf) {
        UserGroupInformation.setConfiguration((Configuration)this.newConfiguration(sparkConf));
        Credentials creds = this.deserialize(tokens);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating delegation tokens for current user.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("Adding/updating delegation tokens ").append(this.dumpTokens(creds)).toString());
        this.addCurrentUserCredentials(creds);
    }

    public Function0<Object> getFSBytesReadOnThreadCallback() {
        JFunction0.mcJ.sp & Serializable & scala.Serializable f = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(FileSystem.getAllStatistics()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)SparkHadoopUtil.$anonfun$getFSBytesReadOnThreadCallback$2(x$3)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Tuple2.mcJJ.sp baseline = new Tuple2.mcJJ.sp(Thread.currentThread().getId(), f.apply$mcJ$sp());
        return new Function0.mcJ.sp(null, (Function0)f, (Tuple2)baseline){
            private final HashMap<Object, Object> org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap;
            private final Function0 f$1;
            private final Tuple2 baseline$1;

            public boolean apply$mcZ$sp() {
                return Function0.apply$mcZ$sp$((Function0)this);
            }

            public byte apply$mcB$sp() {
                return Function0.apply$mcB$sp$((Function0)this);
            }

            public char apply$mcC$sp() {
                return Function0.apply$mcC$sp$((Function0)this);
            }

            public double apply$mcD$sp() {
                return Function0.apply$mcD$sp$((Function0)this);
            }

            public float apply$mcF$sp() {
                return Function0.apply$mcF$sp$((Function0)this);
            }

            public int apply$mcI$sp() {
                return Function0.apply$mcI$sp$((Function0)this);
            }

            public short apply$mcS$sp() {
                return Function0.apply$mcS$sp$((Function0)this);
            }

            public void apply$mcV$sp() {
                Function0.apply$mcV$sp$((Function0)this);
            }

            public String toString() {
                return Function0.toString$((Function0)this);
            }

            public HashMap<Object, Object> org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap() {
                return this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap;
            }

            public long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                long l;
                HashMap<Object, Object> hashMap = this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap();
                synchronized (hashMap) {
                    this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap().put((Object)BoxesRunTime.boxToLong((long)Thread.currentThread().getId()), (Object)BoxesRunTime.boxToLong((long)this.f$1.apply$mcJ$sp()));
                    l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$apply$1(this, x0$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                }
                return l;
            }

            public static final /* synthetic */ long $anonfun$apply$1($anon$2 $this, Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long k = tuple2._1$mcJ$sp();
                long v = tuple2._2$mcJ$sp();
                long l = v - (k == $this.baseline$1._1$mcJ$sp() ? $this.baseline$1._2$mcJ$sp() : 0L);
                return l;
            }
            {
                this.f$1 = f$1;
                this.baseline$1 = baseline$1;
                Function0.$init$((Function0)this);
                this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap = new HashMap();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1$adapted(org.apache.spark.deploy.SparkHadoopUtil$$anon$2 scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public Function0<Object> getFSBytesWrittenOnThreadCallback() {
        Buffer threadStats = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(FileSystem.getAllStatistics()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getThreadStatistics(), Buffer$.MODULE$.canBuildFrom());
        JFunction0.mcJ.sp & Serializable & scala.Serializable f = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)threadStats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getBytesWritten()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long baselineBytesWritten = f.apply$mcJ$sp();
        return () -> SparkHadoopUtil.$anonfun$getFSBytesWrittenOnThreadCallback$4((Function0)f, baselineBytesWritten);
    }

    public Seq<FileStatus> listLeafStatuses(FileSystem fs, Path basePath) {
        return this.listLeafStatuses(fs, fs.getFileStatus(basePath));
    }

    public Seq<FileStatus> listLeafStatuses(FileSystem fs, FileStatus baseStatus) {
        return baseStatus.isDirectory() ? this.recurse$1(baseStatus, fs) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{baseStatus}));
    }

    public Seq<FileStatus> listLeafDirStatuses(FileSystem fs, Path basePath) {
        return this.listLeafDirStatuses(fs, fs.getFileStatus(basePath));
    }

    public Seq<FileStatus> listLeafDirStatuses(FileSystem fs, FileStatus baseStatus) {
        Predef$.MODULE$.assert(baseStatus.isDirectory());
        return this.recurse$2(baseStatus, fs);
    }

    public boolean isGlobPath(Path pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains(elem)));
    }

    public Seq<Path> globPath(Path pattern) {
        FileSystem fs = pattern.getFileSystem(this.conf());
        return this.globPath(fs, pattern);
    }

    public Seq<Path> globPath(FileSystem fs, Path pattern) {
        return (Seq)Option$.MODULE$.apply((Object)fs.globStatus(pattern)).map((Function1 & Serializable & scala.Serializable)statuses -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getPath().makeQualified(fs.getUri(), fs.getWorkingDirectory()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    public Seq<Path> globPathIfNecessary(Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public Seq<Path> globPathIfNecessary(FileSystem fs, Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(fs, pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public FileStatus[] listFilesSorted(FileSystem remoteFs, Path dir, String prefix, String exclusionSuffix) {
        FileStatus[] fileStatusArray;
        try {
            FileStatus[] fileStatuses = remoteFs.listStatus(dir, new PathFilter(null, prefix, exclusionSuffix){
                private final String prefix$1;
                private final String exclusionSuffix$1;

                public boolean accept(Path path) {
                    String name = path.getName();
                    return name.startsWith(this.prefix$1) && !name.endsWith(this.exclusionSuffix$1);
                }
                {
                    this.prefix$1 = prefix$1;
                    this.exclusionSuffix$1 = exclusionSuffix$1;
                }
            });
            Arrays.sort((Object[])fileStatuses, new Comparator<FileStatus>(null){

                public Comparator<FileStatus> reversed() {
                    return Comparator.super.reversed();
                }

                public Comparator<FileStatus> thenComparing(Comparator<? super FileStatus> x$1) {
                    return Comparator.super.thenComparing(x$1);
                }

                public <U> Comparator<FileStatus> thenComparing(Function<? super FileStatus, ? extends U> x$1, Comparator<? super U> x$2) {
                    return Comparator.super.thenComparing(x$1, x$2);
                }

                public <U extends Comparable<? super U>> Comparator<FileStatus> thenComparing(Function<? super FileStatus, ? extends U> x$1) {
                    return Comparator.super.thenComparing(x$1);
                }

                public Comparator<FileStatus> thenComparingInt(ToIntFunction<? super FileStatus> x$1) {
                    return Comparator.super.thenComparingInt(x$1);
                }

                public Comparator<FileStatus> thenComparingLong(ToLongFunction<? super FileStatus> x$1) {
                    return Comparator.super.thenComparingLong(x$1);
                }

                public Comparator<FileStatus> thenComparingDouble(ToDoubleFunction<? super FileStatus> x$1) {
                    return Comparator.super.thenComparingDouble(x$1);
                }

                public int compare(FileStatus o1, FileStatus o2) {
                    return Longs.compare((long)o1.getModificationTime(), (long)o2.getModificationTime());
                }
            });
            fileStatusArray = fileStatuses;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while attempting to list files from application staging dir", e);
            FileStatus[] fileStatusArray2 = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
            fileStatusArray = fileStatusArray2;
        }
        return fileStatusArray;
    }

    public int getSuffixForCredentialsPath(Path credentialsPath) {
        String fileName = credentialsPath.getName();
        return new StringOps(Predef$.MODULE$.augmentString(fileName.substring(fileName.lastIndexOf(SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()) + 1))).toInt();
    }

    private UnanchoredRegex HADOOP_CONF_PATTERN() {
        return this.HADOOP_CONF_PATTERN;
    }

    public String substituteHadoopVariables(String text, Configuration hadoopConf) {
        String string;
        String string2 = text;
        Option option = ((Regex)this.HADOOP_CONF_PATTERN()).unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String matched = (String)((LinearSeqOptimized)option.get()).apply(0);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(9).append(text).append(" matched ").append(this.HADOOP_CONF_PATTERN()).toString());
            String key = matched.substring(13, matched.length() - 1);
            Option eval = Option$.MODULE$.apply((Object)hadoopConf.get(key)).map((Function1 & Serializable & scala.Serializable)value -> {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Substituted ").append(matched).append(" with ").append((String)value).toString());
                return text.replace(matched, (CharSequence)value);
            });
            string = eval.isEmpty() ? text : this.substituteHadoopVariables((String)eval.get(), hadoopConf);
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append(text).append(" didn't match ").append(this.HADOOP_CONF_PATTERN()).toString());
            string = text;
        }
        return string;
    }

    public Iterable<String> dumpTokens(Credentials credentials) {
        return credentials != null ? (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(credentials.getAllTokens()).asScala()).map((Function1 & Serializable & scala.Serializable)token -> this.tokenToString((Token<? extends TokenIdentifier>)token), scala.collection.Iterable$.MODULE$.canBuildFrom()) : (Iterable)Seq$.MODULE$.empty();
    }

    public String tokenToString(Token<? extends TokenIdentifier> token) {
        BoxedUnit boxedUnit;
        DateFormat df = DateFormat.getDateTimeInstance(3, 3, Locale.US);
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(token.toString());
        try {
            BoxedUnit boxedUnit2;
            TokenIdentifier ti = token.decodeIdentifier();
            buffer.append("; ").append((Object)ti);
            TokenIdentifier tokenIdentifier = ti;
            if (tokenIdentifier instanceof AbstractDelegationTokenIdentifier) {
                AbstractDelegationTokenIdentifier abstractDelegationTokenIdentifier = (AbstractDelegationTokenIdentifier)tokenIdentifier;
                buffer.append("; Renewer: ").append((Object)abstractDelegationTokenIdentifier.getRenewer());
                buffer.append("; Issued: ").append(df.format(new Date(abstractDelegationTokenIdentifier.getIssueDate())));
                boxedUnit2 = buffer.append("; Max Date: ").append(df.format(new Date(abstractDelegationTokenIdentifier.getMaxDate())));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boxedUnit = boxedUnit2;
        }
        catch (IOException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Failed to decode ").append(token).append(": ").append(e).toString(), e);
            boxedUnit = BoxedUnit.UNIT;
        }
        return buffer.toString();
    }

    public byte[] serialize(Credentials creds) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        creds.writeTokenStorageToStream(dataStream);
        return byteStream.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public Credentials deserialize(byte[] tokenBytes) {
        void var3_3;
        ByteArrayInputStream tokensBuf = new ByteArrayInputStream(tokenBytes);
        Credentials creds = new Credentials();
        creds.readTokenStorageStream(new DataInputStream(tokensBuf));
        return var3_3;
    }

    public boolean isProxyUser(UserGroupInformation ugi) {
        UserGroupInformation.AuthenticationMethod authenticationMethod = ugi.getAuthenticationMethod();
        UserGroupInformation.AuthenticationMethod authenticationMethod2 = UserGroupInformation.AuthenticationMethod.PROXY;
        return !(authenticationMethod != null ? !authenticationMethod.equals(authenticationMethod2) : authenticationMethod2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hadoop.");
        return bl;
    }

    public static final /* synthetic */ long $anonfun$getFSBytesReadOnThreadCallback$2(FileSystem.Statistics x$3) {
        return x$3.getThreadStatistics().getBytesRead();
    }

    public static final /* synthetic */ long $anonfun$getFSBytesWrittenOnThreadCallback$4(Function0 f$2, long baselineBytesWritten$1) {
        return f$2.apply$mcJ$sp() - baselineBytesWritten$1;
    }

    private final Seq recurse$1(FileStatus status, FileSystem fs$1) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$1.listStatus(status.getPath()))).partition((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDirectory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileStatus[] directories = (FileStatus[])tuple2._1();
        FileStatus[] leaves = (FileStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)directories, (Object)leaves);
        Tuple2 tuple23 = tuple22;
        FileStatus[] directories2 = (FileStatus[])tuple23._1();
        FileStatus[] leaves2 = (FileStatus[])tuple23._2();
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directories2)).flatMap((Function1 & Serializable & scala.Serializable)f -> this.listLeafStatuses(fs$1, (FileStatus)f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class))))), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private final Seq recurse$2(FileStatus status, FileSystem fs$2) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$2.listStatus(status.getPath()))).partition((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDirectory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileStatus[] directories = (FileStatus[])tuple2._1();
        FileStatus[] files = (FileStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)directories, (Object)files);
        Tuple2 tuple23 = tuple22;
        FileStatus[] directories2 = (FileStatus[])tuple23._1();
        FileStatus[] files2 = (FileStatus[])tuple23._2();
        Seq leaves = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directories2)).isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{status})) : (Seq)Seq$.MODULE$.empty();
        return (Seq)leaves.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directories2)).flatMap((Function1 & Serializable & scala.Serializable)dir -> this.listLeafDirStatuses(fs$2, (FileStatus)dir), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class))))), Seq$.MODULE$.canBuildFrom());
    }

    public SparkHadoopUtil() {
        Logging.$init$(this);
        this.sparkConf = new SparkConf(false).loadFromSystemProperties(true);
        this.conf = this.newConfiguration(this.sparkConf());
        UserGroupInformation.setConfiguration((Configuration)this.conf());
        this.HADOOP_CONF_PATTERN = new StringOps(Predef$.MODULE$.augmentString("(\\$\\{hadoopconf-[^\\}\\$\\s]+\\})")).r().unanchored();
    }
}

