/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkSubmitUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DependencyUtils$
implements Logging {
    public static DependencyUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DependencyUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String resolveMavenDependencies(String packagesExclusions, String packages, String repositories, String ivyRepoPath, Option<String> ivySettingsPath) {
        IvySettings ivySettings;
        Nil$ exclusions = !StringUtils.isBlank((CharSequence)packagesExclusions) ? Predef$.MODULE$.wrapRefArray((Object[])packagesExclusions.split(",")) : Nil$.MODULE$;
        Option<String> option = ivySettingsPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            ivySettings = SparkSubmitUtils$.MODULE$.loadIvySettings(path, (Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath));
        } else if (None$.MODULE$.equals(option)) {
            ivySettings = SparkSubmitUtils$.MODULE$.buildIvySettings((Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath));
        } else {
            throw new MatchError(option);
        }
        IvySettings ivySettings2 = ivySettings;
        return SparkSubmitUtils$.MODULE$.resolveMavenCoordinates(packages, ivySettings2, (Seq<String>)exclusions, SparkSubmitUtils$.MODULE$.resolveMavenCoordinates$default$4());
    }

    public String resolveAndDownloadJars(String jars, String userJar, SparkConf sparkConf, Configuration hadoopConf, SecurityManager secMgr) {
        File targetDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        String userJarName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(userJar)).split(File.separatorChar))).last();
        return (String)Option$.MODULE$.apply((Object)jars).map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.resolveGlobPaths((String)x$1, hadoopConf).split(","))).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(userJarName))))).mkString(",")).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$resolveAndDownloadJars$3(x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.downloadFileList((String)x$4, targetDir, sparkConf, hadoopConf, secMgr)).orNull(Predef$.MODULE$.$conforms());
    }

    public void addJarsToClassPath(String jars, MutableURLClassLoader loader) {
        block0: {
            if (jars == null) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars.split(","))).foreach((Function1 & Serializable & scala.Serializable)jar -> {
                DependencyUtils$.MODULE$.addJarToClasspath(jar, loader);
                return BoxedUnit.UNIT;
            });
        }
    }

    public String downloadFileList(String fileList, File targetDir, SparkConf sparkConf, Configuration hadoopConf, SecurityManager secMgr) {
        Predef$.MODULE$.require(fileList != null, (Function0 & Serializable & scala.Serializable)() -> "fileList cannot be null.");
        return ((TraversableOnce)Utils$.MODULE$.stringToSeq(fileList).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.downloadFile((String)x$5, targetDir, sparkConf, hadoopConf, secMgr), Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public String downloadFile(String path, File targetDir, SparkConf sparkConf, Configuration hadoopConf, SecurityManager secMgr) {
        String string;
        Predef$.MODULE$.require(path != null, (Function0 & Serializable & scala.Serializable)() -> "path cannot be null.");
        URI uri = Utils$.MODULE$.resolveURI(path);
        String string2 = uri.getScheme();
        boolean bl = "file".equals(string2) ? true : "local".equals(string2);
        if (bl) {
            string = path;
        } else {
            boolean bl2 = "http".equals(string2) ? true : ("https".equals(string2) ? true : "ftp".equals(string2));
            if (bl2 && Utils$.MODULE$.isTesting()) {
                File file = new File(uri.getPath());
                string = new File(targetDir, file.getName()).toURI().toString();
            } else {
                String fname = new Path(uri).getName();
                File localFile = Utils$.MODULE$.doFetchFile(uri.toString(), targetDir, fname, sparkConf, secMgr, hadoopConf);
                string = localFile.toURI().toString();
            }
        }
        return string;
    }

    public String resolveGlobPaths(String paths, Configuration hadoopConf) {
        Predef$.MODULE$.require(paths != null, (Function0 & Serializable & scala.Serializable)() -> "paths cannot be null.");
        return ((TraversableOnce)Utils$.MODULE$.stringToSeq(paths).flatMap((Function1 & Serializable & scala.Serializable)path -> new ArrayOps.ofRef(DependencyUtils$.$anonfun$resolveGlobPaths$2(hadoopConf, path)), Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public void addJarToClasspath(String localJar, MutableURLClassLoader loader) {
        URI uri = Utils$.MODULE$.resolveURI(localJar);
        String string = uri.getScheme();
        boolean bl = "file".equals(string) ? true : "local".equals(string);
        if (bl) {
            BoxedUnit boxedUnit;
            File file = new File(uri.getPath());
            if (file.exists()) {
                loader.addURL(file.toURI().toURL());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Local jar ").append(file).append(" does not exist, skipping.").toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Skip remote jar ").append(uri).append(".").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String mergeFileLists(Seq<String> lists) {
        Seq merged = (Seq)((TraversableLike)lists.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$mergeFileLists$1(x$1)))).flatMap((Function1 & Serializable & scala.Serializable)str -> Utils$.MODULE$.stringToSeq((String)str), Seq$.MODULE$.canBuildFrom());
        return merged.nonEmpty() ? merged.mkString(",") : null;
    }

    private Tuple2<URI, Option<String>> splitOnFragment(String path) {
        URI uri = Utils$.MODULE$.resolveURI(path);
        URI withoutFragment = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
        return new Tuple2((Object)withoutFragment, (Object)Option$.MODULE$.apply((Object)uri.getFragment()));
    }

    private String[] resolveGlobPath(URI uri, Configuration hadoopConf) {
        String[] stringArray;
        String string = uri.getScheme();
        boolean bl = "local".equals(string) ? true : ("http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string)));
        if (bl) {
            stringArray = (String[])((Object[])new String[]{uri.toString()});
        } else {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConf);
            stringArray = (String[])Option$.MODULE$.apply((Object)fs.globStatus(new Path(uri))).map((Function1 & Serializable & scala.Serializable)status -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])status)).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isFile())))).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getPath().toUri().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])((Object[])new String[]{uri.toString()}));
        }
        return stringArray;
    }

    public static final /* synthetic */ boolean $anonfun$resolveAndDownloadJars$3(String x$3) {
        String string = x$3;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Object[] $anonfun$resolveGlobPaths$2(Configuration hadoopConf$3, String path) {
        Tuple2<URI, Option<String>> tuple2 = MODULE$.splitOnFragment(path);
        if (tuple2 == null) throw new MatchError(tuple2);
        URI base = (URI)tuple2._1();
        Option fragment = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)base, (Object)fragment);
        Tuple2 tuple23 = tuple22;
        URI base2 = (URI)tuple23._1();
        Option fragment2 = (Option)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)MODULE$.resolveGlobPath(base2, hadoopConf$3), (Object)fragment2);
        if (tuple24 != null) {
            String[] resolved = (String[])tuple24._1();
            Option option = (Option)tuple24._2();
            if (option instanceof Some && resolved.length > 1) {
                throw new SparkException(new StringBuilder(41).append(base2.toString()).append(" resolves ambiguously to multiple files: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolved)).mkString(",")).toString());
            }
        }
        if (tuple24 != null) {
            String[] resolved = (String[])tuple24._1();
            Option option = (Option)tuple24._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String namedAs = (String)some.value();
                return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolved)).map((Function1 & Serializable & scala.Serializable)x$7 -> new StringBuilder(1).append((String)x$7).append("#").append(namedAs).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
        }
        if (tuple24 == null) throw new MatchError((Object)tuple24);
        String[] resolved = (String[])tuple24._1();
        return Predef$.MODULE$.refArrayOps((Object[])resolved);
    }

    public static final /* synthetic */ boolean $anonfun$mergeFileLists$1(CharSequence x$1) {
        return StringUtils.isBlank((CharSequence)x$1);
    }

    private DependencyUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

