/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hudi.avro.model.HoodieSliceInfo;

public class ClusteringOperation
implements Serializable {
    private String dataFilePath;
    private List<String> deltaFilePaths;
    private String fileId;
    private String partitionPath;
    private String bootstrapFilePath;
    private int version;

    public static ClusteringOperation create(HoodieSliceInfo sliceInfo) {
        return new ClusteringOperation(sliceInfo.getDataFilePath(), new ArrayList<String>(sliceInfo.getDeltaFilePaths()), sliceInfo.getFileId(), sliceInfo.getPartitionPath(), sliceInfo.getBootstrapFilePath(), sliceInfo.getVersion());
    }

    @Deprecated
    public ClusteringOperation() {
    }

    private ClusteringOperation(String dataFilePath, List<String> deltaFilePaths, String fileId, String partitionPath, String bootstrapFilePath, int version) {
        this.dataFilePath = dataFilePath;
        this.deltaFilePaths = deltaFilePaths;
        this.fileId = fileId;
        this.partitionPath = partitionPath;
        this.bootstrapFilePath = bootstrapFilePath;
        this.version = version;
    }

    public String getDataFilePath() {
        return this.dataFilePath;
    }

    public void setDataFilePath(String dataFilePath) {
        this.dataFilePath = dataFilePath;
    }

    public List<String> getDeltaFilePaths() {
        return this.deltaFilePaths;
    }

    public void setDeltaFilePaths(List<String> deltaFilePaths) {
        this.deltaFilePaths = deltaFilePaths;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    public String getBootstrapFilePath() {
        return this.bootstrapFilePath;
    }

    public void setBootstrapFilePath(String bootstrapFilePath) {
        this.bootstrapFilePath = bootstrapFilePath;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteringOperation that = (ClusteringOperation)o;
        return this.getVersion() == that.getVersion() && Objects.equals(this.getDataFilePath(), that.getDataFilePath()) && Objects.equals(this.getDeltaFilePaths(), that.getDeltaFilePaths()) && Objects.equals(this.getFileId(), that.getFileId()) && Objects.equals(this.getPartitionPath(), that.getPartitionPath()) && Objects.equals(this.getBootstrapFilePath(), that.getBootstrapFilePath());
    }

    public int hashCode() {
        return Objects.hash(this.getDataFilePath(), this.getDeltaFilePaths(), this.getFileId(), this.getPartitionPath(), this.getBootstrapFilePath(), this.getVersion());
    }
}

