/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.bloom.HashFunction;
import org.apache.hadoop.util.bloom.Key;

abstract class InternalFilter
implements Writable {
    private static final int VERSION = -1;
    protected int vectorSize;
    protected HashFunction hash;
    protected int nbHash;
    protected int hashType;

    protected InternalFilter() {
    }

    protected InternalFilter(int vectorSize, int nbHash, int hashType) {
        this.vectorSize = vectorSize;
        this.nbHash = nbHash;
        this.hashType = hashType;
        this.hash = new HashFunction(this.vectorSize, this.nbHash, this.hashType);
    }

    public abstract void add(Key var1);

    public abstract boolean membershipTest(Key var1);

    public abstract void and(InternalFilter var1);

    public abstract void or(InternalFilter var1);

    public abstract void xor(InternalFilter var1);

    public abstract void not();

    public void add(List<Key> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("ArrayList<Key> may not be null");
        }
        for (Key key : keys) {
            this.add(key);
        }
    }

    public void add(Collection<Key> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Collection<Key> may not be null");
        }
        for (Key key : keys) {
            this.add(key);
        }
    }

    public void add(Key[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Key[] may not be null");
        }
        for (Key key : keys) {
            this.add(key);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(-1);
        out.writeInt(this.nbHash);
        out.writeByte(this.hashType);
        out.writeInt(this.vectorSize);
    }

    public void readFields(DataInput in) throws IOException {
        int ver = in.readInt();
        if (ver > 0) {
            this.nbHash = ver;
            this.hashType = 0;
        } else if (ver == -1) {
            this.nbHash = in.readInt();
            this.hashType = in.readByte();
        } else {
            throw new IOException("Unsupported version: " + ver);
        }
        this.vectorSize = in.readInt();
        this.hash = new HashFunction(this.vectorSize, this.nbHash, this.hashType);
    }
}

