/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;

public class LeveldbUtils {
    public static boolean prefixMatches(byte[] prefix, int prefixlen, byte[] b) {
        if (b.length < prefixlen) {
            return false;
        }
        return WritableComparator.compareBytes((byte[])prefix, (int)0, (int)prefixlen, (byte[])b, (int)0, (int)prefixlen) == 0;
    }

    public static class KeyParser {
        private final byte[] b;
        private int offset;

        public KeyParser(byte[] b, int offset) {
            this.b = b;
            this.offset = offset;
        }

        public String getNextString() throws IOException {
            if (this.offset >= this.b.length) {
                throw new IOException("tried to read nonexistent string from byte array");
            }
            int i = 0;
            while (this.offset + i < this.b.length && this.b[this.offset + i] != 0) {
                ++i;
            }
            String s = new String(this.b, this.offset, i, Charset.forName("UTF-8"));
            this.offset = this.offset + i + 1;
            return s;
        }

        public long getNextLong() throws IOException {
            if (this.offset + 8 >= this.b.length) {
                throw new IOException("byte array ran out when trying to read long");
            }
            long l = GenericObjectMapper.readReverseOrderedLong(this.b, this.offset);
            this.offset += 8;
            return l;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class KeyBuilder {
        private static final int MAX_NUMBER_OF_KEY_ELEMENTS = 10;
        private byte[][] b;
        private boolean[] useSeparator;
        private int index;
        private int length;

        public KeyBuilder(int size) {
            this.b = new byte[size][];
            this.useSeparator = new boolean[size];
            this.index = 0;
            this.length = 0;
        }

        public static KeyBuilder newInstance() {
            return new KeyBuilder(10);
        }

        public KeyBuilder add(String s) {
            return this.add(s.getBytes(Charset.forName("UTF-8")), true);
        }

        public KeyBuilder add(byte[] t) {
            return this.add(t, false);
        }

        public KeyBuilder add(byte[] t, boolean sep) {
            this.b[this.index] = t;
            this.useSeparator[this.index] = sep;
            this.length += t.length;
            if (sep) {
                ++this.length;
            }
            ++this.index;
            return this;
        }

        public byte[] getBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.length);
            for (int i = 0; i < this.index; ++i) {
                baos.write(this.b[i]);
                if (i >= this.index - 1 || !this.useSeparator[i]) continue;
                baos.write(0);
            }
            return baos.toByteArray();
        }

        public byte[] getBytesForLookup() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.length);
            for (int i = 0; i < this.index; ++i) {
                baos.write(this.b[i]);
                if (!this.useSeparator[i]) continue;
                baos.write(0);
            }
            return baos.toByteArray();
        }
    }
}

