/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.unix.solaris.SolarisVirtualMemory;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;

    @Override
    public long getAvailable() {
        this.updateSystemPages();
        return this.memAvailable;
    }

    @Override
    public long getTotal() {
        if (this.memTotal < 0L) {
            this.updateSystemPages();
        }
        return this.memTotal;
    }

    @Override
    public long getPageSize() {
        if (this.pageSize < 0L) {
            this.pageSize = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);
        }
        return this.pageSize;
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        if (this.virtualMemory == null) {
            this.virtualMemory = new SolarisVirtualMemory();
        }
        return this.virtualMemory;
    }

    private void updateSystemPages() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup(null, -1, "system_pages");
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            this.memAvailable = KstatUtil.kstatDataLookupLong(ksp, "availrmem") * this.getPageSize();
            this.memTotal = KstatUtil.kstatDataLookupLong(ksp, "physmem") * this.getPageSize();
        }
    }
}

