/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.shims;

import com.aliyun.datalake.metastore.common.util.ProxyLogUtils;
import com.aliyun.datalake.metastore.hive.shims.ColStatsObjWithSourceInfo;
import com.aliyun.datalake.metastore.hive.shims.ColumnStatsAggregator;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive2CDHShims
implements IHiveShims {
    private static final String HIVE_VERSION = "2.";
    private static final Logger logger = LoggerFactory.getLogger(Hive2CDHShims.class);

    static boolean supportsVersion(String version) {
        return version.startsWith(HIVE_VERSION);
    }

    public <T> Class<? extends RawStore> getClass(String className, Class<? extends RawStore> clazz) throws MetaException {
        return MetaStoreUtils.getClass((String)className);
    }

    public <T> T newInstance(Class<T> theClass, Class<?>[] parameterTypes, Object[] initargs) {
        return (T)MetaStoreUtils.newInstance(theClass, (Class[])parameterTypes, (Object[])initargs);
    }

    public <T> List<ObjectPair<Integer, byte[]>> objectPairConvert(T partExprs) {
        ArrayList<ObjectPair<Integer, byte[]>> objectPairs = new ArrayList<ObjectPair<Integer, byte[]>>();
        for (ObjectPair part : (List)partExprs) {
            ObjectPair objectPair = ObjectPair.create((Object)((Integer)part.getFirst()), (Object)((byte[])part.getSecond()));
            objectPairs.add((ObjectPair<Integer, byte[]>)objectPair);
        }
        return objectPairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(Warehouse wh, Path f, boolean inheritPermCandidate, Boolean enableFsOperation) throws MetaException {
        long startTime = System.currentTimeMillis();
        boolean mkdir = false;
        try {
            mkdir = enableFsOperation != false ? wh.mkdirs(f, inheritPermCandidate) : true;
            boolean bl = mkdir;
            return bl;
        }
        finally {
            boolean mkdirFinal = mkdir;
            ProxyLogUtils.printLog(() -> logger.info("dlf.fs.{}.mkdir, result:{}, cost:{}ms, path : {}, candidate : {}", new Object[]{IHiveShims.realMessage((boolean)enableFsOperation), mkdirFinal, System.currentTimeMillis() - startTime, f, inheritPermCandidate}));
        }
    }

    public boolean deleteDir(Warehouse wh, Path f, boolean recursive, Boolean enableFsOperation) throws MetaException {
        return this.deleteDir(wh, f, recursive, false, false, enableFsOperation);
    }

    public boolean deleteDir(Warehouse wh, Path f, boolean recursive, Database db, Boolean enableFsOperation) throws MetaException {
        return this.deleteDir(wh, f, recursive, false, false, enableFsOperation);
    }

    public boolean deleteDir(Warehouse wh, Path f, boolean recursive, boolean ifPurge, Database db, Boolean enableFsOperation) throws MetaException {
        return this.deleteDir(wh, f, recursive, ifPurge, false, enableFsOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDir(Warehouse wh, Path f, boolean recursive, boolean ifPurge, boolean needCmRecycle, Boolean enableFsOperation) throws MetaException {
        long startTime = System.currentTimeMillis();
        boolean deleteDir = false;
        try {
            deleteDir = enableFsOperation != false ? wh.deleteDir(f, recursive, ifPurge) : true;
            boolean bl = deleteDir;
            return bl;
        }
        finally {
            boolean deleteDirFinal = deleteDir;
            ProxyLogUtils.printLog(() -> logger.info("dlf.fs.{}.deleteDir, result:{}, cost:{}ms, path : {}, recursive : {}, ifPurge : {}, needCm : {}", new Object[]{IHiveShims.realMessage((boolean)enableFsOperation), deleteDirFinal, System.currentTimeMillis() - startTime, f, recursive, ifPurge, needCmRecycle}));
        }
    }

    public void addCatalogForDb(Database db, String catalogId) {
    }

    public void updateTableStatsFast(Database db, Table tbl, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext) throws MetaException {
        MetaStoreUtils.updateTableStatsSlow((Database)db, (Table)tbl, (Warehouse)wh, (boolean)madeDir, (boolean)forceRecompute, (EnvironmentContext)environmentContext);
    }

    public boolean requireCalStats(Configuration conf, Partition oldPart, Partition newPart, Table tbl, EnvironmentContext environmentContext) {
        return MetaStoreUtils.requireCalStats((Configuration)conf, (Partition)oldPart, (Partition)newPart, (Table)tbl, (EnvironmentContext)environmentContext);
    }

    public boolean isFastStatsSame(Partition oldPart, Partition newPart) {
        if (oldPart != null && oldPart.getParameters() != null) {
            for (String stat : StatsSetupConst.FAST_STATS) {
                if (oldPart.getParameters().containsKey(stat)) {
                    Long oldStat = Long.parseLong((String)oldPart.getParameters().get(stat));
                    String newStat = (String)newPart.getParameters().get(stat);
                    if (newStat != null && oldStat.equals(Long.parseLong(newStat))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void updateBasicState(EnvironmentContext environmentContext, Map<String, String> params) {
        if (params == null) {
            return;
        }
        if (environmentContext != null && environmentContext.isSetProperties() && "TASK".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
            StatsSetupConst.setBasicStatsState(params, (String)"true");
        } else {
            StatsSetupConst.setBasicStatsState(params, (String)"false");
        }
    }

    public boolean isIndexTable(Table table) {
        return MetaStoreUtils.isIndexTable((Table)table);
    }

    public boolean filterPartitionsByExpr(PartitionExpressionProxy partitionExpressionProxy, List<FieldSchema> partColumns, byte[] expr, String defaultPartitionName, List<String> partitionNames) throws MetaException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> typeInfos = new ArrayList<PrimitiveTypeInfo>();
        for (FieldSchema fs : partColumns) {
            columnNames.add(fs.getName());
            typeInfos.add(TypeInfoFactory.getPrimitiveTypeInfo((String)fs.getType()));
        }
        return partitionExpressionProxy.filterPartitionsByExpr(columnNames, typeInfos, expr, defaultPartitionName, partitionNames);
    }

    public Deserializer getDeserializer(Configuration conf, Table table, boolean skipConfError) throws MetaException {
        return MetaStoreUtils.getDeserializer((Configuration)conf, (Table)table, (boolean)skipConfError);
    }

    public List<FieldSchema> getFieldsFromDeserializer(String tableName, Deserializer deserializer) throws SerDeException, MetaException {
        return MetaStoreUtils.getFieldsFromDeserializer((String)tableName, (Deserializer)deserializer);
    }

    public String validateSkewedColNames(List<String> cols) {
        return MetaStoreUtils.validateSkewedColNames(cols);
    }

    public String validateSkewedColNamesSubsetCol(List<String> skewedColNames, List<FieldSchema> cols) {
        return MetaStoreUtils.validateSkewedColNamesSubsetCol(skewedColNames, cols);
    }

    public String validateTblColumns(List<FieldSchema> cols) {
        return MetaStoreUtils.validateTblColumns(cols);
    }

    public boolean validateName(String name, Configuration conf) {
        return MetaStoreUtils.validateName((String)name, (Configuration)conf);
    }

    public void validatePartitionNameCharacters(List<String> partVals, Pattern partitionValidationPattern) throws MetaException {
        MetaStoreUtils.validatePartitionNameCharacters(partVals, (Pattern)partitionValidationPattern);
    }

    public boolean updatePartitionStatsFast(Partition part, Table table, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext, boolean isCreate) throws MetaException {
        return MetaStoreUtils.updatePartitionStatsFast((Partition)part, (Warehouse)wh, (boolean)madeDir, (boolean)forceRecompute, (EnvironmentContext)environmentContext);
    }

    public boolean isExternalTable(Table table) {
        return MetaStoreUtils.isExternalTable((Table)table);
    }

    public boolean isArchived(Partition part) {
        return MetaStoreUtils.isArchived((Partition)part);
    }

    public Path getOriginalLocation(Partition part) {
        return MetaStoreUtils.getOriginalLocation((Partition)part);
    }

    public ClassLoader addToClassPath(ClassLoader cloader, String[] newPaths) throws Exception {
        return MetaStoreUtils.addToClassPath((ClassLoader)cloader, (String[])newPaths);
    }

    public boolean isView(Table table) {
        return MetaStoreUtils.isView((Table)table);
    }

    public void getMergableCols(ColumnStatistics csNew, Map<String, String> parameters) {
    }

    public void mergeColStats(ColumnStatistics csNew, ColumnStatistics csOld) throws InvalidObjectException {
        MetaStoreUtils.mergeColStats((ColumnStatistics)csNew, (ColumnStatistics)csOld);
    }

    public boolean enableBitVector(Configuration conf) {
        return false;
    }

    public void setLongBitVector(LongColumnStatsData longColumnStatsData, byte[] bitVector) {
    }

    public void setDoubleBitVector(DoubleColumnStatsData doubleColumnStatsData, byte[] bitVector) {
    }

    public void setDecimalBitVector(DecimalColumnStatsData decimalColumnStatsData, byte[] bitVector) {
    }

    public void setDateBitVector(DateColumnStatsData dateColumnStatsData, byte[] bitVector) {
    }

    public void setStringBitVector(StringColumnStatsData stringColumnStatsData, byte[] bitVector) {
    }

    public byte[] getLongBitVector(LongColumnStatsData longColumnStatsData) {
        return null;
    }

    public byte[] getDoubleBitVector(DoubleColumnStatsData doubleColumnStatsData) {
        return null;
    }

    public byte[] getDecimalBitVector(DecimalColumnStatsData decimalColumnStatsData) {
        return null;
    }

    public byte[] getDateBitVector(DateColumnStatsData dateColumnStatsData) {
        return null;
    }

    public byte[] getStringBitVector(StringColumnStatsData stringColumnStatsData) {
        return null;
    }

    public Decimal createThriftDecimal(String s) {
        BigDecimal d = new BigDecimal(s);
        return new Decimal(ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)d.scale());
    }

    public String createJdoDecimalString(Decimal d) {
        return new BigDecimal(new BigInteger(d.getUnscaled()), d.getScale()).toString();
    }

    public boolean getDensityFunctionForNDVEstimation(Configuration conf) {
        return HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_METASTORE_STATS_NDV_DENSITY_FUNCTION);
    }

    public double getNdvTuner(Configuration conf) {
        return 0.0;
    }

    public int getMetastoreDirectSqlPartitionBatchSize(Configuration conf) {
        return HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_DIRECT_SQL_PARTITION_BATCH_SIZE);
    }

    public ColumnStatisticsObj getAggregate(ColumnStatsAggregator aggregator, List<ColStatsObjWithSourceInfo> colStatWithSourceInfos, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregator aggr = ColumnStatsAggregatorFactory.getColumnStatsAggregator((ColumnStatisticsData._Fields)aggregator.getType(), (int)aggregator.getNumBitVectors(), (boolean)aggregator.isUseDensityFunctionForNDVEstimation());
        ArrayList<ColumnStatistics> columnStatistics = new ArrayList<ColumnStatistics>();
        for (ColStatsObjWithSourceInfo colStatsObjWithSourceInfo : colStatWithSourceInfos) {
            ColumnStatistics columnStatistic = new ColumnStatistics();
            ArrayList<ColumnStatisticsObj> objs = new ArrayList<ColumnStatisticsObj>();
            objs.add(colStatsObjWithSourceInfo.getColStatsObj());
            columnStatistic.setStatsObj(objs);
            ColumnStatisticsDesc columnStatisticsDesc = new ColumnStatisticsDesc();
            columnStatisticsDesc.setPartName(colStatsObjWithSourceInfo.getPartName());
            columnStatisticsDesc.setDbName(colStatsObjWithSourceInfo.getDbName());
            columnStatisticsDesc.setTableName(colStatsObjWithSourceInfo.getTblName());
            columnStatisticsDesc.setIsTblLevel(false);
            columnStatistic.setStatsDesc(columnStatisticsDesc);
            columnStatistics.add(columnStatistic);
        }
        return aggr.aggregate(aggregator.getColName(), partNames, columnStatistics);
    }

    public int getNumBitVectors(Configuration conf) throws MetaException {
        try {
            return HiveStatsUtils.getNumBitVectorsForNDVEstimation((Configuration)conf);
        }
        catch (Exception e) {
            MetaException exception = new MetaException("exception in getNumBitVectorsForNDVEstimation " + e);
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    public void setColumnStatisticsDescCatalog(String catalogId, ColumnStatisticsDesc desc) {
    }

    public LongColumnStatsData getLongColumnStatsData(Long numNulls, Long numDVs, Long lowValue, Long highValue, byte[] bitVectors, boolean enableBitVector) {
        LongColumnStatsData longStats = new LongColumnStatsData();
        longStats.setNumNulls(numNulls.longValue());
        longStats.setNumDVs(numDVs.longValue());
        longStats.setLowValue(lowValue.longValue());
        longStats.setHighValue(highValue.longValue());
        if (enableBitVector) {
            this.setLongBitVector(longStats, bitVectors);
        }
        return longStats;
    }

    public StringColumnStatsData getStringColumnStatsData(Long numNulls, Long numDVs, double avglen, Long maxlen, byte[] bitVectors, boolean enableBitVector) {
        StringColumnStatsData stringStats = new StringColumnStatsData();
        stringStats.setNumNulls(numNulls.longValue());
        stringStats.setNumDVs(numDVs.longValue());
        stringStats.setMaxColLen(maxlen.longValue());
        stringStats.setAvgColLen(avglen);
        if (enableBitVector) {
            this.setStringBitVector(stringStats, bitVectors);
        }
        return stringStats;
    }

    public DoubleColumnStatsData getDoubleColumnStatsData(Long numNulls, Long numDVs, Double lowValue, Double highValue, byte[] bitVectors, boolean enableBitVector) {
        DoubleColumnStatsData doubleStats = new DoubleColumnStatsData();
        doubleStats.setNumNulls(numNulls.longValue());
        doubleStats.setNumDVs(numDVs.longValue());
        doubleStats.setLowValue(lowValue.doubleValue());
        doubleStats.setHighValue(highValue.doubleValue());
        if (enableBitVector) {
            this.setDoubleBitVector(doubleStats, bitVectors);
        }
        return doubleStats;
    }

    public DecimalColumnStatsData getDecimalColumnStatsData(Long numNulls, Long numDVs, Decimal lowValue, Decimal highValue, byte[] bitVectors, boolean enableBitVector) {
        DecimalColumnStatsData decimalStats = new DecimalColumnStatsData();
        decimalStats.setNumNulls(numNulls.longValue());
        decimalStats.setNumDVs(numDVs.longValue());
        decimalStats.setLowValue(lowValue);
        decimalStats.setHighValue(highValue);
        if (enableBitVector) {
            this.setDecimalBitVector(decimalStats, bitVectors);
        }
        return decimalStats;
    }

    public DateColumnStatsData getDateColumnStatsData(Long numNulls, Long numDVs, Date lowValue, Date highValue, byte[] bitVectors, boolean enableBitVector) {
        DateColumnStatsData dateStats = new DateColumnStatsData();
        dateStats.setNumNulls(numNulls.longValue());
        dateStats.setNumDVs(numDVs.longValue());
        dateStats.setLowValue(lowValue);
        dateStats.setHighValue(highValue);
        if (enableBitVector) {
            this.setDateBitVector(dateStats, bitVectors);
        }
        return dateStats;
    }

    public BooleanColumnStatsData getBooleanColumnStatsData(Long numFalses, Long numTrues, Long numNulls) {
        BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
        boolStats.setNumFalses(numFalses.longValue());
        boolStats.setNumTrues(numTrues.longValue());
        boolStats.setNumNulls(numNulls.longValue());
        return boolStats;
    }

    public BinaryColumnStatsData getBinaryColumnStatsData(Long numNulls, double avglen, Long maxlen) {
        BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
        binaryStats.setNumNulls(numNulls.longValue());
        binaryStats.setAvgColLen(avglen);
        binaryStats.setMaxColLen(maxlen.longValue());
        return binaryStats;
    }
}

