/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TBackend;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TCloneReq
implements TBase<TCloneReq, _Fields>,
Serializable,
Cloneable,
Comparable<TCloneReq> {
    private static final TStruct STRUCT_DESC = new TStruct("TCloneReq");
    private static final TField TABLET_ID_FIELD_DESC = new TField("tablet_id", 10, 1);
    private static final TField SCHEMA_HASH_FIELD_DESC = new TField("schema_hash", 8, 2);
    private static final TField SRC_BACKENDS_FIELD_DESC = new TField("src_backends", 15, 3);
    private static final TField STORAGE_MEDIUM_FIELD_DESC = new TField("storage_medium", 8, 4);
    private static final TField COMMITTED_VERSION_FIELD_DESC = new TField("committed_version", 10, 5);
    private static final TField COMMITTED_VERSION_HASH_FIELD_DESC = new TField("committed_version_hash", 10, 6);
    private static final TField TASK_VERSION_FIELD_DESC = new TField("task_version", 8, 7);
    private static final TField SRC_PATH_HASH_FIELD_DESC = new TField("src_path_hash", 10, 8);
    private static final TField DEST_PATH_HASH_FIELD_DESC = new TField("dest_path_hash", 10, 9);
    private static final TField TIMEOUT_S_FIELD_DESC = new TField("timeout_s", 8, 10);
    private static final TField REPLICA_ID_FIELD_DESC = new TField("replica_id", 10, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TCloneReqStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TCloneReqTupleSchemeFactory();
    public long tablet_id;
    public int schema_hash;
    @Nullable
    public List<TBackend> src_backends;
    @Nullable
    public TStorageMedium storage_medium;
    public long committed_version;
    public long committed_version_hash;
    public int task_version;
    public long src_path_hash;
    public long dest_path_hash;
    public int timeout_s;
    public long replica_id;
    private static final int __TABLET_ID_ISSET_ID = 0;
    private static final int __SCHEMA_HASH_ISSET_ID = 1;
    private static final int __COMMITTED_VERSION_ISSET_ID = 2;
    private static final int __COMMITTED_VERSION_HASH_ISSET_ID = 3;
    private static final int __TASK_VERSION_ISSET_ID = 4;
    private static final int __SRC_PATH_HASH_ISSET_ID = 5;
    private static final int __DEST_PATH_HASH_ISSET_ID = 6;
    private static final int __TIMEOUT_S_ISSET_ID = 7;
    private static final int __REPLICA_ID_ISSET_ID = 8;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.STORAGE_MEDIUM, _Fields.COMMITTED_VERSION, _Fields.COMMITTED_VERSION_HASH, _Fields.TASK_VERSION, _Fields.SRC_PATH_HASH, _Fields.DEST_PATH_HASH, _Fields.TIMEOUT_S, _Fields.REPLICA_ID};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TCloneReq() {
        this.replica_id = 0L;
    }

    public TCloneReq(long tablet_id, int schema_hash, List<TBackend> src_backends) {
        this();
        this.tablet_id = tablet_id;
        this.setTabletIdIsSet(true);
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
        this.src_backends = src_backends;
    }

    public TCloneReq(TCloneReq other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.tablet_id = other.tablet_id;
        this.schema_hash = other.schema_hash;
        if (other.isSetSrcBackends()) {
            ArrayList<TBackend> __this__src_backends = new ArrayList<TBackend>(other.src_backends.size());
            for (TBackend other_element : other.src_backends) {
                __this__src_backends.add(new TBackend(other_element));
            }
            this.src_backends = __this__src_backends;
        }
        if (other.isSetStorageMedium()) {
            this.storage_medium = other.storage_medium;
        }
        this.committed_version = other.committed_version;
        this.committed_version_hash = other.committed_version_hash;
        this.task_version = other.task_version;
        this.src_path_hash = other.src_path_hash;
        this.dest_path_hash = other.dest_path_hash;
        this.timeout_s = other.timeout_s;
        this.replica_id = other.replica_id;
    }

    public TCloneReq deepCopy() {
        return new TCloneReq(this);
    }

    public void clear() {
        this.setTabletIdIsSet(false);
        this.tablet_id = 0L;
        this.setSchemaHashIsSet(false);
        this.schema_hash = 0;
        this.src_backends = null;
        this.storage_medium = null;
        this.setCommittedVersionIsSet(false);
        this.committed_version = 0L;
        this.setCommittedVersionHashIsSet(false);
        this.committed_version_hash = 0L;
        this.setTaskVersionIsSet(false);
        this.task_version = 0;
        this.setSrcPathHashIsSet(false);
        this.src_path_hash = 0L;
        this.setDestPathHashIsSet(false);
        this.dest_path_hash = 0L;
        this.setTimeoutSIsSet(false);
        this.timeout_s = 0;
        this.replica_id = 0L;
    }

    public long getTabletId() {
        return this.tablet_id;
    }

    public TCloneReq setTabletId(long tablet_id) {
        this.tablet_id = tablet_id;
        this.setTabletIdIsSet(true);
        return this;
    }

    public void unsetTabletId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetTabletId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setTabletIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getSchemaHash() {
        return this.schema_hash;
    }

    public TCloneReq setSchemaHash(int schema_hash) {
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
        return this;
    }

    public void unsetSchemaHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetSchemaHash() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setSchemaHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getSrcBackendsSize() {
        return this.src_backends == null ? 0 : this.src_backends.size();
    }

    @Nullable
    public Iterator<TBackend> getSrcBackendsIterator() {
        return this.src_backends == null ? null : this.src_backends.iterator();
    }

    public void addToSrcBackends(TBackend elem) {
        if (this.src_backends == null) {
            this.src_backends = new ArrayList<TBackend>();
        }
        this.src_backends.add(elem);
    }

    @Nullable
    public List<TBackend> getSrcBackends() {
        return this.src_backends;
    }

    public TCloneReq setSrcBackends(@Nullable List<TBackend> src_backends) {
        this.src_backends = src_backends;
        return this;
    }

    public void unsetSrcBackends() {
        this.src_backends = null;
    }

    public boolean isSetSrcBackends() {
        return this.src_backends != null;
    }

    public void setSrcBackendsIsSet(boolean value) {
        if (!value) {
            this.src_backends = null;
        }
    }

    @Nullable
    public TStorageMedium getStorageMedium() {
        return this.storage_medium;
    }

    public TCloneReq setStorageMedium(@Nullable TStorageMedium storage_medium) {
        this.storage_medium = storage_medium;
        return this;
    }

    public void unsetStorageMedium() {
        this.storage_medium = null;
    }

    public boolean isSetStorageMedium() {
        return this.storage_medium != null;
    }

    public void setStorageMediumIsSet(boolean value) {
        if (!value) {
            this.storage_medium = null;
        }
    }

    public long getCommittedVersion() {
        return this.committed_version;
    }

    public TCloneReq setCommittedVersion(long committed_version) {
        this.committed_version = committed_version;
        this.setCommittedVersionIsSet(true);
        return this;
    }

    public void unsetCommittedVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetCommittedVersion() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setCommittedVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getCommittedVersionHash() {
        return this.committed_version_hash;
    }

    public TCloneReq setCommittedVersionHash(long committed_version_hash) {
        this.committed_version_hash = committed_version_hash;
        this.setCommittedVersionHashIsSet(true);
        return this;
    }

    public void unsetCommittedVersionHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetCommittedVersionHash() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setCommittedVersionHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public int getTaskVersion() {
        return this.task_version;
    }

    public TCloneReq setTaskVersion(int task_version) {
        this.task_version = task_version;
        this.setTaskVersionIsSet(true);
        return this;
    }

    public void unsetTaskVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetTaskVersion() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setTaskVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public long getSrcPathHash() {
        return this.src_path_hash;
    }

    public TCloneReq setSrcPathHash(long src_path_hash) {
        this.src_path_hash = src_path_hash;
        this.setSrcPathHashIsSet(true);
        return this;
    }

    public void unsetSrcPathHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetSrcPathHash() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setSrcPathHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public long getDestPathHash() {
        return this.dest_path_hash;
    }

    public TCloneReq setDestPathHash(long dest_path_hash) {
        this.dest_path_hash = dest_path_hash;
        this.setDestPathHashIsSet(true);
        return this;
    }

    public void unsetDestPathHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetDestPathHash() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setDestPathHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public int getTimeoutS() {
        return this.timeout_s;
    }

    public TCloneReq setTimeoutS(int timeout_s) {
        this.timeout_s = timeout_s;
        this.setTimeoutSIsSet(true);
        return this;
    }

    public void unsetTimeoutS() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetTimeoutS() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setTimeoutSIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public long getReplicaId() {
        return this.replica_id;
    }

    public TCloneReq setReplicaId(long replica_id) {
        this.replica_id = replica_id;
        this.setReplicaIdIsSet(true);
        return this;
    }

    public void unsetReplicaId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetReplicaId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setReplicaIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TABLET_ID: {
                if (value == null) {
                    this.unsetTabletId();
                    break;
                }
                this.setTabletId((Long)value);
                break;
            }
            case SCHEMA_HASH: {
                if (value == null) {
                    this.unsetSchemaHash();
                    break;
                }
                this.setSchemaHash((Integer)value);
                break;
            }
            case SRC_BACKENDS: {
                if (value == null) {
                    this.unsetSrcBackends();
                    break;
                }
                this.setSrcBackends((List)value);
                break;
            }
            case STORAGE_MEDIUM: {
                if (value == null) {
                    this.unsetStorageMedium();
                    break;
                }
                this.setStorageMedium((TStorageMedium)((Object)value));
                break;
            }
            case COMMITTED_VERSION: {
                if (value == null) {
                    this.unsetCommittedVersion();
                    break;
                }
                this.setCommittedVersion((Long)value);
                break;
            }
            case COMMITTED_VERSION_HASH: {
                if (value == null) {
                    this.unsetCommittedVersionHash();
                    break;
                }
                this.setCommittedVersionHash((Long)value);
                break;
            }
            case TASK_VERSION: {
                if (value == null) {
                    this.unsetTaskVersion();
                    break;
                }
                this.setTaskVersion((Integer)value);
                break;
            }
            case SRC_PATH_HASH: {
                if (value == null) {
                    this.unsetSrcPathHash();
                    break;
                }
                this.setSrcPathHash((Long)value);
                break;
            }
            case DEST_PATH_HASH: {
                if (value == null) {
                    this.unsetDestPathHash();
                    break;
                }
                this.setDestPathHash((Long)value);
                break;
            }
            case TIMEOUT_S: {
                if (value == null) {
                    this.unsetTimeoutS();
                    break;
                }
                this.setTimeoutS((Integer)value);
                break;
            }
            case REPLICA_ID: {
                if (value == null) {
                    this.unsetReplicaId();
                    break;
                }
                this.setReplicaId((Long)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLET_ID: {
                return this.getTabletId();
            }
            case SCHEMA_HASH: {
                return this.getSchemaHash();
            }
            case SRC_BACKENDS: {
                return this.getSrcBackends();
            }
            case STORAGE_MEDIUM: {
                return this.getStorageMedium();
            }
            case COMMITTED_VERSION: {
                return this.getCommittedVersion();
            }
            case COMMITTED_VERSION_HASH: {
                return this.getCommittedVersionHash();
            }
            case TASK_VERSION: {
                return this.getTaskVersion();
            }
            case SRC_PATH_HASH: {
                return this.getSrcPathHash();
            }
            case DEST_PATH_HASH: {
                return this.getDestPathHash();
            }
            case TIMEOUT_S: {
                return this.getTimeoutS();
            }
            case REPLICA_ID: {
                return this.getReplicaId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLET_ID: {
                return this.isSetTabletId();
            }
            case SCHEMA_HASH: {
                return this.isSetSchemaHash();
            }
            case SRC_BACKENDS: {
                return this.isSetSrcBackends();
            }
            case STORAGE_MEDIUM: {
                return this.isSetStorageMedium();
            }
            case COMMITTED_VERSION: {
                return this.isSetCommittedVersion();
            }
            case COMMITTED_VERSION_HASH: {
                return this.isSetCommittedVersionHash();
            }
            case TASK_VERSION: {
                return this.isSetTaskVersion();
            }
            case SRC_PATH_HASH: {
                return this.isSetSrcPathHash();
            }
            case DEST_PATH_HASH: {
                return this.isSetDestPathHash();
            }
            case TIMEOUT_S: {
                return this.isSetTimeoutS();
            }
            case REPLICA_ID: {
                return this.isSetReplicaId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TCloneReq) {
            return this.equals((TCloneReq)that);
        }
        return false;
    }

    public boolean equals(TCloneReq that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_tablet_id = true;
        boolean that_present_tablet_id = true;
        if (this_present_tablet_id || that_present_tablet_id) {
            if (!this_present_tablet_id || !that_present_tablet_id) {
                return false;
            }
            if (this.tablet_id != that.tablet_id) {
                return false;
            }
        }
        boolean this_present_schema_hash = true;
        boolean that_present_schema_hash = true;
        if (this_present_schema_hash || that_present_schema_hash) {
            if (!this_present_schema_hash || !that_present_schema_hash) {
                return false;
            }
            if (this.schema_hash != that.schema_hash) {
                return false;
            }
        }
        boolean this_present_src_backends = this.isSetSrcBackends();
        boolean that_present_src_backends = that.isSetSrcBackends();
        if (this_present_src_backends || that_present_src_backends) {
            if (!this_present_src_backends || !that_present_src_backends) {
                return false;
            }
            if (!this.src_backends.equals(that.src_backends)) {
                return false;
            }
        }
        boolean this_present_storage_medium = this.isSetStorageMedium();
        boolean that_present_storage_medium = that.isSetStorageMedium();
        if (this_present_storage_medium || that_present_storage_medium) {
            if (!this_present_storage_medium || !that_present_storage_medium) {
                return false;
            }
            if (!this.storage_medium.equals((Object)that.storage_medium)) {
                return false;
            }
        }
        boolean this_present_committed_version = this.isSetCommittedVersion();
        boolean that_present_committed_version = that.isSetCommittedVersion();
        if (this_present_committed_version || that_present_committed_version) {
            if (!this_present_committed_version || !that_present_committed_version) {
                return false;
            }
            if (this.committed_version != that.committed_version) {
                return false;
            }
        }
        boolean this_present_committed_version_hash = this.isSetCommittedVersionHash();
        boolean that_present_committed_version_hash = that.isSetCommittedVersionHash();
        if (this_present_committed_version_hash || that_present_committed_version_hash) {
            if (!this_present_committed_version_hash || !that_present_committed_version_hash) {
                return false;
            }
            if (this.committed_version_hash != that.committed_version_hash) {
                return false;
            }
        }
        boolean this_present_task_version = this.isSetTaskVersion();
        boolean that_present_task_version = that.isSetTaskVersion();
        if (this_present_task_version || that_present_task_version) {
            if (!this_present_task_version || !that_present_task_version) {
                return false;
            }
            if (this.task_version != that.task_version) {
                return false;
            }
        }
        boolean this_present_src_path_hash = this.isSetSrcPathHash();
        boolean that_present_src_path_hash = that.isSetSrcPathHash();
        if (this_present_src_path_hash || that_present_src_path_hash) {
            if (!this_present_src_path_hash || !that_present_src_path_hash) {
                return false;
            }
            if (this.src_path_hash != that.src_path_hash) {
                return false;
            }
        }
        boolean this_present_dest_path_hash = this.isSetDestPathHash();
        boolean that_present_dest_path_hash = that.isSetDestPathHash();
        if (this_present_dest_path_hash || that_present_dest_path_hash) {
            if (!this_present_dest_path_hash || !that_present_dest_path_hash) {
                return false;
            }
            if (this.dest_path_hash != that.dest_path_hash) {
                return false;
            }
        }
        boolean this_present_timeout_s = this.isSetTimeoutS();
        boolean that_present_timeout_s = that.isSetTimeoutS();
        if (this_present_timeout_s || that_present_timeout_s) {
            if (!this_present_timeout_s || !that_present_timeout_s) {
                return false;
            }
            if (this.timeout_s != that.timeout_s) {
                return false;
            }
        }
        boolean this_present_replica_id = this.isSetReplicaId();
        boolean that_present_replica_id = that.isSetReplicaId();
        if (this_present_replica_id || that_present_replica_id) {
            if (!this_present_replica_id || !that_present_replica_id) {
                return false;
            }
            if (this.replica_id != that.replica_id) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.tablet_id);
        hashCode = hashCode * 8191 + this.schema_hash;
        hashCode = hashCode * 8191 + (this.isSetSrcBackends() ? 131071 : 524287);
        if (this.isSetSrcBackends()) {
            hashCode = hashCode * 8191 + this.src_backends.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStorageMedium() ? 131071 : 524287);
        if (this.isSetStorageMedium()) {
            hashCode = hashCode * 8191 + this.storage_medium.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetCommittedVersion() ? 131071 : 524287);
        if (this.isSetCommittedVersion()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.committed_version);
        }
        hashCode = hashCode * 8191 + (this.isSetCommittedVersionHash() ? 131071 : 524287);
        if (this.isSetCommittedVersionHash()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.committed_version_hash);
        }
        hashCode = hashCode * 8191 + (this.isSetTaskVersion() ? 131071 : 524287);
        if (this.isSetTaskVersion()) {
            hashCode = hashCode * 8191 + this.task_version;
        }
        hashCode = hashCode * 8191 + (this.isSetSrcPathHash() ? 131071 : 524287);
        if (this.isSetSrcPathHash()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.src_path_hash);
        }
        hashCode = hashCode * 8191 + (this.isSetDestPathHash() ? 131071 : 524287);
        if (this.isSetDestPathHash()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.dest_path_hash);
        }
        hashCode = hashCode * 8191 + (this.isSetTimeoutS() ? 131071 : 524287);
        if (this.isSetTimeoutS()) {
            hashCode = hashCode * 8191 + this.timeout_s;
        }
        hashCode = hashCode * 8191 + (this.isSetReplicaId() ? 131071 : 524287);
        if (this.isSetReplicaId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.replica_id);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TCloneReq other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTabletId()).compareTo(other.isSetTabletId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletId() && (lastComparison = TBaseHelper.compareTo((long)this.tablet_id, (long)other.tablet_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchemaHash()).compareTo(other.isSetSchemaHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchemaHash() && (lastComparison = TBaseHelper.compareTo((int)this.schema_hash, (int)other.schema_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSrcBackends()).compareTo(other.isSetSrcBackends());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSrcBackends() && (lastComparison = TBaseHelper.compareTo(this.src_backends, other.src_backends)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStorageMedium()).compareTo(other.isSetStorageMedium());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStorageMedium() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.storage_medium), (Comparable)((Object)other.storage_medium))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCommittedVersion()).compareTo(other.isSetCommittedVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCommittedVersion() && (lastComparison = TBaseHelper.compareTo((long)this.committed_version, (long)other.committed_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCommittedVersionHash()).compareTo(other.isSetCommittedVersionHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCommittedVersionHash() && (lastComparison = TBaseHelper.compareTo((long)this.committed_version_hash, (long)other.committed_version_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskVersion()).compareTo(other.isSetTaskVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskVersion() && (lastComparison = TBaseHelper.compareTo((int)this.task_version, (int)other.task_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSrcPathHash()).compareTo(other.isSetSrcPathHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSrcPathHash() && (lastComparison = TBaseHelper.compareTo((long)this.src_path_hash, (long)other.src_path_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDestPathHash()).compareTo(other.isSetDestPathHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDestPathHash() && (lastComparison = TBaseHelper.compareTo((long)this.dest_path_hash, (long)other.dest_path_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTimeoutS()).compareTo(other.isSetTimeoutS());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeoutS() && (lastComparison = TBaseHelper.compareTo((int)this.timeout_s, (int)other.timeout_s)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicaId()).compareTo(other.isSetReplicaId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaId() && (lastComparison = TBaseHelper.compareTo((long)this.replica_id, (long)other.replica_id)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TCloneReq.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TCloneReq.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TCloneReq(");
        boolean first = true;
        sb.append("tablet_id:");
        sb.append(this.tablet_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("schema_hash:");
        sb.append(this.schema_hash);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("src_backends:");
        if (this.src_backends == null) {
            sb.append("null");
        } else {
            sb.append(this.src_backends);
        }
        first = false;
        if (this.isSetStorageMedium()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("storage_medium:");
            if (this.storage_medium == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.storage_medium);
            }
            first = false;
        }
        if (this.isSetCommittedVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("committed_version:");
            sb.append(this.committed_version);
            first = false;
        }
        if (this.isSetCommittedVersionHash()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("committed_version_hash:");
            sb.append(this.committed_version_hash);
            first = false;
        }
        if (this.isSetTaskVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("task_version:");
            sb.append(this.task_version);
            first = false;
        }
        if (this.isSetSrcPathHash()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("src_path_hash:");
            sb.append(this.src_path_hash);
            first = false;
        }
        if (this.isSetDestPathHash()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dest_path_hash:");
            sb.append(this.dest_path_hash);
            first = false;
        }
        if (this.isSetTimeoutS()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("timeout_s:");
            sb.append(this.timeout_s);
            first = false;
        }
        if (this.isSetReplicaId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replica_id:");
            sb.append(this.replica_id);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.src_backends == null) {
            throw new TProtocolException("Required field 'src_backends' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLET_ID, new FieldMetaData("tablet_id", 1, new FieldValueMetaData(10, "TTabletId")));
        tmpMap.put(_Fields.SCHEMA_HASH, new FieldMetaData("schema_hash", 1, new FieldValueMetaData(8, "TSchemaHash")));
        tmpMap.put(_Fields.SRC_BACKENDS, new FieldMetaData("src_backends", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TBackend.class))));
        tmpMap.put(_Fields.STORAGE_MEDIUM, new FieldMetaData("storage_medium", 2, (FieldValueMetaData)new EnumMetaData(16, TStorageMedium.class)));
        tmpMap.put(_Fields.COMMITTED_VERSION, new FieldMetaData("committed_version", 2, new FieldValueMetaData(10, "TVersion")));
        tmpMap.put(_Fields.COMMITTED_VERSION_HASH, new FieldMetaData("committed_version_hash", 2, new FieldValueMetaData(10, "TVersionHash")));
        tmpMap.put(_Fields.TASK_VERSION, new FieldMetaData("task_version", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SRC_PATH_HASH, new FieldMetaData("src_path_hash", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DEST_PATH_HASH, new FieldMetaData("dest_path_hash", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TIMEOUT_S, new FieldMetaData("timeout_s", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.REPLICA_ID, new FieldMetaData("replica_id", 2, new FieldValueMetaData(10, "TReplicaId")));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TCloneReq.class, metaDataMap);
    }

    private static class TCloneReqTupleScheme
    extends TupleScheme<TCloneReq> {
        private TCloneReqTupleScheme() {
        }

        public void write(TProtocol prot, TCloneReq struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.tablet_id);
            oprot.writeI32(struct.schema_hash);
            oprot.writeI32(struct.src_backends.size());
            for (TBackend _iter60 : struct.src_backends) {
                _iter60.write((TProtocol)oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetStorageMedium()) {
                optionals.set(0);
            }
            if (struct.isSetCommittedVersion()) {
                optionals.set(1);
            }
            if (struct.isSetCommittedVersionHash()) {
                optionals.set(2);
            }
            if (struct.isSetTaskVersion()) {
                optionals.set(3);
            }
            if (struct.isSetSrcPathHash()) {
                optionals.set(4);
            }
            if (struct.isSetDestPathHash()) {
                optionals.set(5);
            }
            if (struct.isSetTimeoutS()) {
                optionals.set(6);
            }
            if (struct.isSetReplicaId()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetStorageMedium()) {
                oprot.writeI32(struct.storage_medium.getValue());
            }
            if (struct.isSetCommittedVersion()) {
                oprot.writeI64(struct.committed_version);
            }
            if (struct.isSetCommittedVersionHash()) {
                oprot.writeI64(struct.committed_version_hash);
            }
            if (struct.isSetTaskVersion()) {
                oprot.writeI32(struct.task_version);
            }
            if (struct.isSetSrcPathHash()) {
                oprot.writeI64(struct.src_path_hash);
            }
            if (struct.isSetDestPathHash()) {
                oprot.writeI64(struct.dest_path_hash);
            }
            if (struct.isSetTimeoutS()) {
                oprot.writeI32(struct.timeout_s);
            }
            if (struct.isSetReplicaId()) {
                oprot.writeI64(struct.replica_id);
            }
        }

        public void read(TProtocol prot, TCloneReq struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.tablet_id = iprot.readI64();
            struct.setTabletIdIsSet(true);
            struct.schema_hash = iprot.readI32();
            struct.setSchemaHashIsSet(true);
            TList _list61 = new TList(12, iprot.readI32());
            struct.src_backends = new ArrayList<TBackend>(_list61.size);
            for (int _i63 = 0; _i63 < _list61.size; ++_i63) {
                TBackend _elem62 = new TBackend();
                _elem62.read((TProtocol)iprot);
                struct.src_backends.add(_elem62);
            }
            struct.setSrcBackendsIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.storage_medium = TStorageMedium.findByValue(iprot.readI32());
                struct.setStorageMediumIsSet(true);
            }
            if (incoming.get(1)) {
                struct.committed_version = iprot.readI64();
                struct.setCommittedVersionIsSet(true);
            }
            if (incoming.get(2)) {
                struct.committed_version_hash = iprot.readI64();
                struct.setCommittedVersionHashIsSet(true);
            }
            if (incoming.get(3)) {
                struct.task_version = iprot.readI32();
                struct.setTaskVersionIsSet(true);
            }
            if (incoming.get(4)) {
                struct.src_path_hash = iprot.readI64();
                struct.setSrcPathHashIsSet(true);
            }
            if (incoming.get(5)) {
                struct.dest_path_hash = iprot.readI64();
                struct.setDestPathHashIsSet(true);
            }
            if (incoming.get(6)) {
                struct.timeout_s = iprot.readI32();
                struct.setTimeoutSIsSet(true);
            }
            if (incoming.get(7)) {
                struct.replica_id = iprot.readI64();
                struct.setReplicaIdIsSet(true);
            }
        }
    }

    private static class TCloneReqTupleSchemeFactory
    implements SchemeFactory {
        private TCloneReqTupleSchemeFactory() {
        }

        public TCloneReqTupleScheme getScheme() {
            return new TCloneReqTupleScheme();
        }
    }

    private static class TCloneReqStandardScheme
    extends StandardScheme<TCloneReq> {
        private TCloneReqStandardScheme() {
        }

        public void read(TProtocol iprot, TCloneReq struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.tablet_id = iprot.readI64();
                            struct.setTabletIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.schema_hash = iprot.readI32();
                            struct.setSchemaHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list56 = iprot.readListBegin();
                            struct.src_backends = new ArrayList<TBackend>(_list56.size);
                            for (int _i58 = 0; _i58 < _list56.size; ++_i58) {
                                TBackend _elem57 = new TBackend();
                                _elem57.read(iprot);
                                struct.src_backends.add(_elem57);
                            }
                            iprot.readListEnd();
                            struct.setSrcBackendsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.storage_medium = TStorageMedium.findByValue(iprot.readI32());
                            struct.setStorageMediumIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.committed_version = iprot.readI64();
                            struct.setCommittedVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 10) {
                            struct.committed_version_hash = iprot.readI64();
                            struct.setCommittedVersionHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.task_version = iprot.readI32();
                            struct.setTaskVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.src_path_hash = iprot.readI64();
                            struct.setSrcPathHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.dest_path_hash = iprot.readI64();
                            struct.setDestPathHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.timeout_s = iprot.readI32();
                            struct.setTimeoutSIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.replica_id = iprot.readI64();
                            struct.setReplicaIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetTabletId()) {
                throw new TProtocolException("Required field 'tablet_id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetSchemaHash()) {
                throw new TProtocolException("Required field 'schema_hash' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TCloneReq struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(TABLET_ID_FIELD_DESC);
            oprot.writeI64(struct.tablet_id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(SCHEMA_HASH_FIELD_DESC);
            oprot.writeI32(struct.schema_hash);
            oprot.writeFieldEnd();
            if (struct.src_backends != null) {
                oprot.writeFieldBegin(SRC_BACKENDS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.src_backends.size()));
                for (TBackend _iter59 : struct.src_backends) {
                    _iter59.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.storage_medium != null && struct.isSetStorageMedium()) {
                oprot.writeFieldBegin(STORAGE_MEDIUM_FIELD_DESC);
                oprot.writeI32(struct.storage_medium.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetCommittedVersion()) {
                oprot.writeFieldBegin(COMMITTED_VERSION_FIELD_DESC);
                oprot.writeI64(struct.committed_version);
                oprot.writeFieldEnd();
            }
            if (struct.isSetCommittedVersionHash()) {
                oprot.writeFieldBegin(COMMITTED_VERSION_HASH_FIELD_DESC);
                oprot.writeI64(struct.committed_version_hash);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTaskVersion()) {
                oprot.writeFieldBegin(TASK_VERSION_FIELD_DESC);
                oprot.writeI32(struct.task_version);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSrcPathHash()) {
                oprot.writeFieldBegin(SRC_PATH_HASH_FIELD_DESC);
                oprot.writeI64(struct.src_path_hash);
                oprot.writeFieldEnd();
            }
            if (struct.isSetDestPathHash()) {
                oprot.writeFieldBegin(DEST_PATH_HASH_FIELD_DESC);
                oprot.writeI64(struct.dest_path_hash);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimeoutS()) {
                oprot.writeFieldBegin(TIMEOUT_S_FIELD_DESC);
                oprot.writeI32(struct.timeout_s);
                oprot.writeFieldEnd();
            }
            if (struct.isSetReplicaId()) {
                oprot.writeFieldBegin(REPLICA_ID_FIELD_DESC);
                oprot.writeI64(struct.replica_id);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TCloneReqStandardSchemeFactory
    implements SchemeFactory {
        private TCloneReqStandardSchemeFactory() {
        }

        public TCloneReqStandardScheme getScheme() {
            return new TCloneReqStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLET_ID(1, "tablet_id"),
        SCHEMA_HASH(2, "schema_hash"),
        SRC_BACKENDS(3, "src_backends"),
        STORAGE_MEDIUM(4, "storage_medium"),
        COMMITTED_VERSION(5, "committed_version"),
        COMMITTED_VERSION_HASH(6, "committed_version_hash"),
        TASK_VERSION(7, "task_version"),
        SRC_PATH_HASH(8, "src_path_hash"),
        DEST_PATH_HASH(9, "dest_path_hash"),
        TIMEOUT_S(10, "timeout_s"),
        REPLICA_ID(11, "replica_id");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLET_ID;
                }
                case 2: {
                    return SCHEMA_HASH;
                }
                case 3: {
                    return SRC_BACKENDS;
                }
                case 4: {
                    return STORAGE_MEDIUM;
                }
                case 5: {
                    return COMMITTED_VERSION;
                }
                case 6: {
                    return COMMITTED_VERSION_HASH;
                }
                case 7: {
                    return TASK_VERSION;
                }
                case 8: {
                    return SRC_PATH_HASH;
                }
                case 9: {
                    return DEST_PATH_HASH;
                }
                case 10: {
                    return TIMEOUT_S;
                }
                case 11: {
                    return REPLICA_ID;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

