/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.doris.common.io.Codec;
import org.roaringbitmap.BitmapDataProvider;
import org.roaringbitmap.BitmapDataProviderSupplier;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.InvalidRoaringFormat;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapSupplier;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongConsumer;
import org.roaringbitmap.longlong.LongIterator;

public class Roaring64Map {
    private NavigableMap<Integer, BitmapDataProvider> highToBitmap;
    private boolean signedLongs = false;
    private BitmapDataProviderSupplier supplier;
    private transient boolean doCacheCardinalities = true;
    private transient int firstHighNotValid = this.highestHigh() + 1;
    private transient boolean allValid = false;
    private transient long[] sortedCumulatedCardinality = new long[0];
    private transient int[] sortedHighs = new int[0];
    private transient Map.Entry<Integer, BitmapDataProvider> latestAddedHigh = null;
    private static final boolean DEFAULT_ORDER_IS_SIGNED = false;
    private static final boolean DEFAULT_CARDINALITIES_ARE_CACHED = true;
    private static final BigInteger TWO_64 = BigInteger.ONE.shiftLeft(64);

    public Roaring64Map() {
        this(false);
    }

    public Roaring64Map(boolean signedLongs) {
        this(signedLongs, true);
    }

    public Roaring64Map(boolean signedLongs, boolean cacheCardinalities) {
        this(signedLongs, cacheCardinalities, (BitmapDataProviderSupplier)new RoaringBitmapSupplier());
    }

    public Roaring64Map(BitmapDataProviderSupplier supplier) {
        this(false, true, supplier);
    }

    public Roaring64Map(boolean signedLongs, BitmapDataProviderSupplier supplier) {
        this(signedLongs, true, supplier);
    }

    public Roaring64Map(boolean signedLongs, boolean cacheCardinalities, BitmapDataProviderSupplier supplier) {
        this.signedLongs = signedLongs;
        this.supplier = supplier;
        this.highToBitmap = signedLongs ? new TreeMap<Integer, BitmapDataProvider>() : new TreeMap<Integer, BitmapDataProvider>(Roaring64Map.unsignedComparator());
        this.doCacheCardinalities = cacheCardinalities;
        this.resetPerfHelpers();
    }

    private void resetPerfHelpers() {
        this.firstHighNotValid = Roaring64Map.highestHigh(this.signedLongs) + 1;
        this.allValid = false;
        this.sortedCumulatedCardinality = new long[0];
        this.sortedHighs = new int[0];
        this.latestAddedHigh = null;
    }

    NavigableMap<Integer, BitmapDataProvider> getHighToBitmap() {
        return this.highToBitmap;
    }

    int getLowestInvalidHigh() {
        return this.firstHighNotValid;
    }

    long[] getSortedCumulatedCardinality() {
        return this.sortedCumulatedCardinality;
    }

    public void addLong(long x) {
        BitmapDataProvider bitmap;
        int high = Roaring64Map.high(x);
        int low = Roaring64Map.low(x);
        Map.Entry<Integer, BitmapDataProvider> local = this.latestAddedHigh;
        if (local != null && local.getKey() == high) {
            bitmap = local.getValue();
        } else {
            bitmap = (BitmapDataProvider)this.highToBitmap.get(high);
            if (bitmap == null) {
                bitmap = this.newRoaringBitmap();
                this.pushBitmapForHigh(high, bitmap);
            }
            this.latestAddedHigh = new AbstractMap.SimpleImmutableEntry<Integer, BitmapDataProvider>(high, bitmap);
        }
        bitmap.add(low);
        this.invalidateAboveHigh(high);
    }

    public void addInt(int x) {
        this.addLong(Util.toUnsignedLong((int)x));
    }

    private BitmapDataProvider newRoaringBitmap() {
        return this.supplier.newEmpty();
    }

    private void invalidateAboveHigh(int high) {
        if (this.compare(this.firstHighNotValid, high) > 0) {
            this.firstHighNotValid = high;
            int indexNotValid = this.binarySearch(this.sortedHighs, this.firstHighNotValid);
            int indexAfterWhichToReset = indexNotValid >= 0 ? indexNotValid : -indexNotValid - 1;
            Arrays.fill(this.sortedHighs, indexAfterWhichToReset, this.sortedHighs.length, this.highestHigh());
        }
        this.allValid = false;
    }

    private int compare(int x, int y) {
        if (this.signedLongs) {
            return Integer.compare(x, y);
        }
        return Roaring64Map.compareUnsigned(x, y);
    }

    private void pushBitmapForHigh(int high, BitmapDataProvider bitmap) {
        BitmapDataProvider previous = this.highToBitmap.put(high, bitmap);
        assert (previous == null) : "Should push only not-existing high";
    }

    public long getLongCardinality() {
        if (this.doCacheCardinalities) {
            if (this.highToBitmap.isEmpty()) {
                return 0L;
            }
            int indexOk = this.ensureCumulatives(this.highestHigh());
            if (this.highToBitmap.isEmpty()) {
                return 0L;
            }
            return this.sortedCumulatedCardinality[indexOk - 1];
        }
        long cardinality = 0L;
        for (BitmapDataProvider bitmap : this.highToBitmap.values()) {
            cardinality += bitmap.getLongCardinality();
        }
        return cardinality;
    }

    public int getIntCardinality() throws UnsupportedOperationException {
        long cardinality = this.getLongCardinality();
        if (cardinality > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Can not call .getIntCardinality as the cardinality is bigger than Integer.MAX_VALUE");
        }
        return (int)cardinality;
    }

    public long select(long j) throws IllegalArgumentException {
        long previousBucketCardinality;
        if (!this.doCacheCardinalities) {
            return this.selectNoCache(j);
        }
        int indexOk = this.ensureCumulatives(this.highestHigh());
        if (this.highToBitmap.isEmpty()) {
            return this.throwSelectInvalidIndex(j);
        }
        int position = Arrays.binarySearch(this.sortedCumulatedCardinality, 0, indexOk, j);
        if (position >= 0) {
            if (position == indexOk - 1) {
                return this.throwSelectInvalidIndex(j);
            }
            int high = this.sortedHighs[position + 1];
            BitmapDataProvider nextBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
            return Roaring64Map.pack(high, nextBitmap.select(0));
        }
        int insertionPoint = -position - 1;
        if (insertionPoint == 0) {
            previousBucketCardinality = 0L;
        } else {
            if (insertionPoint >= indexOk) {
                return this.throwSelectInvalidIndex(j);
            }
            previousBucketCardinality = this.sortedCumulatedCardinality[insertionPoint - 1];
        }
        int givenBitmapSelect = (int)(j - previousBucketCardinality);
        int high = this.sortedHighs[insertionPoint];
        BitmapDataProvider lowBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        int low = lowBitmap.select(givenBitmapSelect);
        return Roaring64Map.pack(high, low);
    }

    private long selectNoCache(long j) {
        long left = j;
        for (Map.Entry entry : this.highToBitmap.entrySet()) {
            long lowCardinality = ((BitmapDataProvider)entry.getValue()).getCardinality();
            if (left >= lowCardinality) {
                left -= lowCardinality;
                continue;
            }
            int leftAsUnsignedInt = (int)left;
            return Roaring64Map.pack((Integer)entry.getKey(), ((BitmapDataProvider)entry.getValue()).select(leftAsUnsignedInt));
        }
        return this.throwSelectInvalidIndex(j);
    }

    private long throwSelectInvalidIndex(long j) {
        throw new IllegalArgumentException("select " + j + " when the cardinality is " + this.getLongCardinality());
    }

    public Iterator<Long> iterator() {
        final LongIterator it = this.getLongIterator();
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Long next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void forEach(final LongConsumer lc) {
        for (final Map.Entry highEntry : this.highToBitmap.entrySet()) {
            ((BitmapDataProvider)highEntry.getValue()).forEach(new IntConsumer(){

                public void accept(int low) {
                    lc.accept(Roaring64Map.pack((Integer)highEntry.getKey(), low));
                }
            });
        }
    }

    public long rankLong(long id) {
        int high = Roaring64Map.high(id);
        int low = Roaring64Map.low(id);
        if (!this.doCacheCardinalities) {
            return this.rankLongNoCache(high, low);
        }
        int indexOk = this.ensureCumulatives(high);
        int highPosition = this.binarySearch(this.sortedHighs, 0, indexOk, high);
        if (highPosition >= 0) {
            long previousBucketCardinality = highPosition == 0 ? 0L : this.sortedCumulatedCardinality[highPosition - 1];
            BitmapDataProvider lowBitmap = (BitmapDataProvider)this.highToBitmap.get(this.sortedHighs[highPosition]);
            return previousBucketCardinality + lowBitmap.rankLong(low);
        }
        int insertionPoint = -highPosition - 1;
        if (insertionPoint == 0) {
            return 0L;
        }
        return this.sortedCumulatedCardinality[insertionPoint - 1];
    }

    private long rankLongNoCache(int high, int low) {
        long result = 0L;
        BitmapDataProvider lastBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        if (lastBitmap == null) {
            for (Map.Entry bitmap : this.highToBitmap.entrySet()) {
                if ((Integer)bitmap.getKey() > high) break;
                result += ((BitmapDataProvider)bitmap.getValue()).getLongCardinality();
            }
        } else {
            for (BitmapDataProvider bitmap : this.highToBitmap.values()) {
                if (bitmap == lastBitmap) {
                    result += bitmap.rankLong(low);
                    break;
                }
                result += bitmap.getLongCardinality();
            }
        }
        return result;
    }

    protected int ensureCumulatives(int high) {
        Map.Entry<Integer, BitmapDataProvider> e;
        int currentHigh;
        if (this.allValid) {
            return this.highToBitmap.size();
        }
        if (this.compare(high, this.firstHighNotValid) < 0) {
            int position = this.binarySearch(this.sortedHighs, high);
            if (position >= 0) {
                return position + 1;
            }
            int insertionPosition = -position - 1;
            return insertionPosition;
        }
        NavigableMap<Integer, BitmapDataProvider> tailMap = this.highToBitmap.tailMap(this.firstHighNotValid, true);
        int indexOk = this.highToBitmap.size() - tailMap.size();
        Iterator it = tailMap.entrySet().iterator();
        while (it.hasNext() && this.compare(currentHigh = ((Integer)(e = it.next()).getKey()).intValue(), high) <= 0) {
            if (((BitmapDataProvider)e.getValue()).isEmpty()) {
                if (this.latestAddedHigh != null && this.latestAddedHigh.getKey() == currentHigh) {
                    this.latestAddedHigh = null;
                }
                it.remove();
                continue;
            }
            this.ensureOne(e, currentHigh, indexOk);
            ++indexOk;
        }
        if (this.highToBitmap.isEmpty() || indexOk == this.highToBitmap.size()) {
            this.allValid = true;
        }
        return indexOk;
    }

    private int binarySearch(int[] array, int key) {
        if (this.signedLongs) {
            return Arrays.binarySearch(array, key);
        }
        return Roaring64Map.unsignedBinarySearch(array, 0, array.length, key, Roaring64Map.unsignedComparator());
    }

    private int binarySearch(int[] array, int from, int to, int key) {
        if (this.signedLongs) {
            return Arrays.binarySearch(array, from, to, key);
        }
        return Roaring64Map.unsignedBinarySearch(array, from, to, key, Roaring64Map.unsignedComparator());
    }

    private static int unsignedBinarySearch(int[] a, int fromIndex, int toIndex, int key, Comparator<? super Integer> c) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            int cmp = c.compare((Integer)midVal, (Integer)key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void ensureOne(Map.Entry<Integer, BitmapDataProvider> e, int currentHigh, int indexOk) {
        assert (indexOk <= this.sortedHighs.length) : indexOk + " is bigger than " + this.sortedHighs.length;
        int index = indexOk == 0 ? (this.sortedHighs.length == 0 ? -1 : -1) : (indexOk < this.sortedHighs.length ? -indexOk - 1 : -this.sortedHighs.length - 1);
        assert (index == this.binarySearch(this.sortedHighs, 0, indexOk, currentHigh)) : "Computed " + index + " differs from dummy binary-search index: " + this.binarySearch(this.sortedHighs, 0, indexOk, currentHigh);
        if (index >= 0) {
            throw new IllegalStateException("Unexpectedly found " + currentHigh + " in " + Arrays.toString(this.sortedHighs) + " strictly before index" + indexOk);
        }
        int insertionPosition = -index - 1;
        if (insertionPosition >= this.sortedHighs.length) {
            int previousSize = this.sortedHighs.length;
            int newSize = Math.min(Integer.MAX_VALUE, this.sortedHighs.length * 2 + 1);
            this.sortedHighs = Arrays.copyOf(this.sortedHighs, newSize);
            this.sortedCumulatedCardinality = Arrays.copyOf(this.sortedCumulatedCardinality, newSize);
            Arrays.fill(this.sortedHighs, previousSize, this.sortedHighs.length, this.highestHigh());
            Arrays.fill(this.sortedCumulatedCardinality, previousSize, this.sortedHighs.length, Long.MAX_VALUE);
        }
        this.sortedHighs[insertionPosition] = currentHigh;
        long previousCardinality = insertionPosition >= 1 ? this.sortedCumulatedCardinality[insertionPosition - 1] : 0L;
        this.sortedCumulatedCardinality[insertionPosition] = previousCardinality + e.getValue().getLongCardinality();
        this.firstHighNotValid = currentHigh == this.highestHigh() ? currentHigh : currentHigh + 1;
    }

    private int highestHigh() {
        return Roaring64Map.highestHigh(this.signedLongs);
    }

    public void or(Roaring64Map x2) {
        boolean firstBucket = true;
        for (Map.Entry e2 : x2.highToBitmap.entrySet()) {
            RoaringBitmap lowBitmap2Clone;
            Integer high = (Integer)e2.getKey();
            BitmapDataProvider lowBitmap1 = (BitmapDataProvider)this.highToBitmap.get(high);
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)e2.getValue();
            if ((lowBitmap1 == null || lowBitmap1 instanceof RoaringBitmap) && lowBitmap2 instanceof RoaringBitmap) {
                if (lowBitmap1 == null) {
                    lowBitmap2Clone = ((RoaringBitmap)lowBitmap2).clone();
                    this.pushBitmapForHigh(high, (BitmapDataProvider)lowBitmap2Clone);
                } else {
                    ((RoaringBitmap)lowBitmap1).or((RoaringBitmap)lowBitmap2);
                }
            } else if ((lowBitmap1 == null || lowBitmap1 instanceof MutableRoaringBitmap) && lowBitmap2 instanceof MutableRoaringBitmap) {
                if (lowBitmap1 == null) {
                    lowBitmap2Clone = ((MutableRoaringBitmap)lowBitmap2).clone();
                    this.pushBitmapForHigh(high, (BitmapDataProvider)lowBitmap2Clone);
                } else {
                    ((MutableRoaringBitmap)lowBitmap1).or((ImmutableRoaringBitmap)((MutableRoaringBitmap)lowBitmap2));
                }
            } else {
                throw new UnsupportedOperationException(".or is not between " + this.getClass() + " and " + lowBitmap2.getClass());
            }
            if (!firstBucket) continue;
            firstBucket = false;
            this.firstHighNotValid = Math.min(this.firstHighNotValid, high);
            this.allValid = false;
        }
    }

    public void xor(Roaring64Map x2) {
        boolean firstBucket = true;
        for (Map.Entry e2 : x2.highToBitmap.entrySet()) {
            RoaringBitmap lowBitmap2Clone;
            Integer high = (Integer)e2.getKey();
            BitmapDataProvider lowBitmap1 = (BitmapDataProvider)this.highToBitmap.get(high);
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)e2.getValue();
            if ((lowBitmap1 == null || lowBitmap1 instanceof RoaringBitmap) && lowBitmap2 instanceof RoaringBitmap) {
                if (lowBitmap1 == null) {
                    lowBitmap2Clone = ((RoaringBitmap)lowBitmap2).clone();
                    this.pushBitmapForHigh(high, (BitmapDataProvider)lowBitmap2Clone);
                } else {
                    ((RoaringBitmap)lowBitmap1).xor((RoaringBitmap)lowBitmap2);
                }
            } else if ((lowBitmap1 == null || lowBitmap1 instanceof MutableRoaringBitmap) && lowBitmap2 instanceof MutableRoaringBitmap) {
                if (lowBitmap1 == null) {
                    lowBitmap2Clone = ((MutableRoaringBitmap)lowBitmap2).clone();
                    this.pushBitmapForHigh(high, (BitmapDataProvider)lowBitmap2Clone);
                } else {
                    ((MutableRoaringBitmap)lowBitmap1).xor((ImmutableRoaringBitmap)((MutableRoaringBitmap)lowBitmap2));
                }
            } else {
                throw new UnsupportedOperationException(".or is not between " + this.getClass() + " and " + lowBitmap2.getClass());
            }
            if (!firstBucket) continue;
            firstBucket = false;
            this.firstHighNotValid = Math.min(this.firstHighNotValid, high);
            this.allValid = false;
        }
    }

    public void and(Roaring64Map x2) {
        boolean firstBucket = true;
        Iterator thisIterator = this.highToBitmap.entrySet().iterator();
        while (thisIterator.hasNext()) {
            Map.Entry e1 = thisIterator.next();
            Integer high = (Integer)e1.getKey();
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)x2.highToBitmap.get(high);
            if (lowBitmap2 == null) {
                thisIterator.remove();
            } else {
                BitmapDataProvider lowBitmap1 = (BitmapDataProvider)e1.getValue();
                if (lowBitmap2 instanceof RoaringBitmap && lowBitmap1 instanceof RoaringBitmap) {
                    ((RoaringBitmap)lowBitmap1).and((RoaringBitmap)lowBitmap2);
                } else if (lowBitmap2 instanceof MutableRoaringBitmap && lowBitmap1 instanceof MutableRoaringBitmap) {
                    ((MutableRoaringBitmap)lowBitmap1).and((ImmutableRoaringBitmap)((MutableRoaringBitmap)lowBitmap2));
                } else {
                    throw new UnsupportedOperationException(".and is not between " + this.getClass() + " and " + lowBitmap1.getClass());
                }
            }
            if (!firstBucket) continue;
            firstBucket = false;
            this.firstHighNotValid = Math.min(this.firstHighNotValid, high);
            this.allValid = false;
        }
    }

    public void andNot(Roaring64Map x2) {
        boolean firstBucket = true;
        for (Map.Entry e1 : this.highToBitmap.entrySet()) {
            Integer high = (Integer)e1.getKey();
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)x2.highToBitmap.get(high);
            if (lowBitmap2 != null) {
                BitmapDataProvider lowBitmap1 = (BitmapDataProvider)e1.getValue();
                if (lowBitmap2 instanceof RoaringBitmap && lowBitmap1 instanceof RoaringBitmap) {
                    ((RoaringBitmap)lowBitmap1).andNot((RoaringBitmap)lowBitmap2);
                } else if (lowBitmap2 instanceof MutableRoaringBitmap && lowBitmap1 instanceof MutableRoaringBitmap) {
                    ((MutableRoaringBitmap)lowBitmap1).andNot((ImmutableRoaringBitmap)((MutableRoaringBitmap)lowBitmap2));
                } else {
                    throw new UnsupportedOperationException(".and is not between " + this.getClass() + " and " + lowBitmap1.getClass());
                }
            }
            if (!firstBucket) continue;
            firstBucket = false;
            this.firstHighNotValid = Math.min(this.firstHighNotValid, high);
            this.allValid = false;
        }
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        LongIterator i = this.getLongIterator();
        answer.append("{");
        if (i.hasNext()) {
            if (this.signedLongs) {
                answer.append(i.next());
            } else {
                answer.append(Roaring64Map.toUnsignedString(i.next()));
            }
        }
        while (i.hasNext()) {
            answer.append(",");
            if (answer.length() > 524288) {
                answer.append("...");
                break;
            }
            if (this.signedLongs) {
                answer.append(i.next());
                continue;
            }
            answer.append(Roaring64Map.toUnsignedString(i.next()));
        }
        answer.append("}");
        return answer.toString();
    }

    public LongIterator getLongIterator() {
        Iterator<Map.Entry<Integer, BitmapDataProvider>> it = this.highToBitmap.entrySet().iterator();
        return this.toIterator(it, false);
    }

    protected LongIterator toIterator(final Iterator<Map.Entry<Integer, BitmapDataProvider>> it, final boolean reversed) {
        return new LongIterator(){
            protected int currentKey;
            protected IntIterator currentIt;

            public boolean hasNext() {
                if (this.currentIt == null && !this.moveToNextEntry(it)) {
                    return false;
                }
                do {
                    if (!this.currentIt.hasNext()) continue;
                    return true;
                } while (this.moveToNextEntry(it));
                return false;
            }

            private boolean moveToNextEntry(Iterator<Map.Entry<Integer, BitmapDataProvider>> it2) {
                if (it2.hasNext()) {
                    Map.Entry<Integer, BitmapDataProvider> next = it2.next();
                    this.currentKey = next.getKey();
                    this.currentIt = reversed ? next.getValue().getReverseIntIterator() : next.getValue().getIntIterator();
                    return true;
                }
                return false;
            }

            public long next() {
                if (this.hasNext()) {
                    return Roaring64Map.pack(this.currentKey, this.currentIt.next());
                }
                throw new IllegalStateException("empty");
            }

            public LongIterator clone() {
                throw new UnsupportedOperationException("TODO");
            }
        };
    }

    public boolean contains(long x) {
        int high = Roaring64Map.high(x);
        BitmapDataProvider lowBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        if (lowBitmap == null) {
            return false;
        }
        int low = Roaring64Map.low(x);
        return lowBitmap.contains(low);
    }

    public int getSizeInBytes() {
        return (int)this.getLongSizeInBytes();
    }

    public long getLongSizeInBytes() {
        long size = 8L;
        size += this.highToBitmap.values().stream().mapToLong(p -> p.getLongSizeInBytes()).sum();
        size += (long)(8 + 40 * this.highToBitmap.size());
        size += (long)(16 * this.highToBitmap.size());
        size += (long)(8 * this.sortedCumulatedCardinality.length);
        return size += (long)(4 * this.sortedHighs.length);
    }

    public boolean isEmpty() {
        return this.getLongCardinality() == 0L;
    }

    public ImmutableLongBitmapDataProvider limit(long x) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean runOptimize() {
        boolean hasChanged = false;
        for (BitmapDataProvider lowBitmap : this.highToBitmap.values()) {
            if (lowBitmap instanceof RoaringBitmap) {
                hasChanged |= ((RoaringBitmap)lowBitmap).runOptimize();
                continue;
            }
            if (!(lowBitmap instanceof MutableRoaringBitmap)) continue;
            hasChanged |= ((MutableRoaringBitmap)lowBitmap).runOptimize();
        }
        return hasChanged;
    }

    public long serializedSizeInBytes() {
        long nbBytes = 0L;
        ++nbBytes;
        nbBytes += 4L;
        for (Map.Entry entry : this.highToBitmap.entrySet()) {
            nbBytes += 4L;
            nbBytes += (long)((BitmapDataProvider)entry.getValue()).serializedSizeInBytes();
        }
        return nbBytes;
    }

    public void clear() {
        this.highToBitmap.clear();
        this.resetPerfHelpers();
    }

    public long[] toArray() {
        long cardinality = this.getLongCardinality();
        if (cardinality > Integer.MAX_VALUE) {
            throw new IllegalStateException("The cardinality does not fit in an array");
        }
        long[] array = new long[(int)cardinality];
        int pos = 0;
        LongIterator it = this.getLongIterator();
        while (it.hasNext()) {
            array[pos++] = it.next();
        }
        return array;
    }

    public static Roaring64Map bitmapOf(long ... dat) {
        Roaring64Map ans = new Roaring64Map();
        ans.add(dat);
        return ans;
    }

    public void add(long ... dat) {
        for (long oneLong : dat) {
            this.addLong(oneLong);
        }
    }

    public void add(long rangeStart, long rangeEnd) {
        int startHigh = Roaring64Map.high(rangeStart);
        int startLow = Roaring64Map.low(rangeStart);
        int endHigh = Roaring64Map.high(rangeEnd);
        int endLow = Roaring64Map.low(rangeEnd);
        for (int high = startHigh; high <= endHigh; ++high) {
            int currentStartLow;
            long startLowAsLong;
            long endLowAsLong = endHigh == high ? Util.toUnsignedLong((int)endLow) : Util.toUnsignedLong((int)-1) + 1L;
            if (endLowAsLong <= (startLowAsLong = Util.toUnsignedLong((int)(currentStartLow = startHigh == high ? startLow : 0)))) continue;
            BitmapDataProvider bitmap = (BitmapDataProvider)this.highToBitmap.get(high);
            if (bitmap == null) {
                bitmap = new MutableRoaringBitmap();
                this.pushBitmapForHigh(high, bitmap);
            }
            if (bitmap instanceof RoaringBitmap) {
                ((RoaringBitmap)bitmap).add(startLowAsLong, endLowAsLong);
                continue;
            }
            if (bitmap instanceof MutableRoaringBitmap) {
                ((MutableRoaringBitmap)bitmap).add(startLowAsLong, endLowAsLong);
                continue;
            }
            throw new UnsupportedOperationException("TODO. Not for " + bitmap.getClass());
        }
        this.invalidateAboveHigh(startHigh);
    }

    public LongIterator getReverseLongIterator() {
        return this.toIterator(this.highToBitmap.descendingMap().entrySet().iterator(), true);
    }

    public void removeLong(long x) {
        int high = Roaring64Map.high(x);
        BitmapDataProvider bitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        if (bitmap != null) {
            int low = Roaring64Map.low(x);
            bitmap.remove(low);
            this.invalidateAboveHigh(high);
        }
    }

    public void trim() {
        for (BitmapDataProvider bitmap : this.highToBitmap.values()) {
            bitmap.trim();
        }
    }

    public int hashCode() {
        return this.highToBitmap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Roaring64Map other = (Roaring64Map)obj;
        return Objects.equals(this.highToBitmap, other.highToBitmap);
    }

    public void flip(long x) {
        int high = Roaring64Map.high(x);
        BitmapDataProvider lowBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        if (lowBitmap == null) {
            this.addLong(x);
        } else {
            int low = Roaring64Map.low(x);
            if (lowBitmap instanceof RoaringBitmap) {
                ((RoaringBitmap)lowBitmap).flip(low);
            } else if (lowBitmap instanceof MutableRoaringBitmap) {
                ((MutableRoaringBitmap)lowBitmap).flip(low);
            } else if (lowBitmap.contains(low)) {
                lowBitmap.remove(low);
            } else {
                lowBitmap.add(low);
            }
        }
        this.invalidateAboveHigh(high);
    }

    public void serialize(DataOutput out) throws IOException {
        if (this.highToBitmap.size() == 0) {
            return;
        }
        if (this.is32BitsEnough()) {
            out.write(2);
            ((BitmapDataProvider)this.highToBitmap.get(0)).serialize(out);
            return;
        }
        out.write(4);
        Codec.encodeVarint64(this.highToBitmap.size(), out);
        for (Map.Entry entry : this.highToBitmap.entrySet()) {
            out.writeInt(Integer.reverseBytes((Integer)entry.getKey()));
            ((BitmapDataProvider)entry.getValue()).serialize(out);
        }
    }

    public void deserialize(DataInput in, int bitmapType) throws IOException {
        this.clear();
        this.highToBitmap = new TreeMap<Integer, BitmapDataProvider>();
        if (bitmapType == 2) {
            RoaringBitmap provider = new RoaringBitmap();
            provider.deserialize(in);
            this.highToBitmap.put(0, (BitmapDataProvider)provider);
            return;
        }
        if (bitmapType != 4) {
            throw new InvalidRoaringFormat("invalid bitmap type");
        }
        long nbHighs = Codec.decodeVarint64(in);
        int i = 0;
        while ((long)i < nbHighs) {
            int high = Integer.reverseBytes(in.readInt());
            RoaringBitmap provider = new RoaringBitmap();
            provider.deserialize(in);
            this.highToBitmap.put(high, (BitmapDataProvider)provider);
            ++i;
        }
        this.resetPerfHelpers();
    }

    public boolean is32BitsEnough() {
        return this.highToBitmap.size() == 1 && this.highToBitmap.get(0) != null;
    }

    public static int high(long id) {
        return (int)(id >> 32);
    }

    public static int low(long id) {
        return (int)id;
    }

    public static long pack(int high, int low) {
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    public static int highestHigh(boolean signedLongs) {
        if (signedLongs) {
            return Integer.MAX_VALUE;
        }
        return -1;
    }

    public static Comparator<Integer> unsignedComparator() {
        return new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Roaring64Map.compareUnsigned(o1, o2);
            }
        };
    }

    public static int compareUnsigned(int x, int y) {
        return Integer.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    static String toUnsignedString(long l) {
        BigInteger b = BigInteger.valueOf(l);
        if (b.signum() < 0) {
            b = b.add(TWO_64);
        }
        return b.toString();
    }
}

