/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.CommitToken;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbCleanup;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogParams;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.je.log.entry.AbortLogEntry;
import com.sleepycat.je.log.entry.CommitLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnChain;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.TxnPrepare;
import com.sleepycat.je.txn.UndoReader;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TinyHashSet;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;

public class Txn
extends Locker
implements VersionedWriteLoggable {
    private static final int LAST_FORMAT_CHANGE = 8;
    private final AtomicInteger cursors = new AtomicInteger();
    private byte txnFlags;
    private static final byte IS_PREPARED = 1;
    private static final byte XA_SUSPENDED = 2;
    private static final byte PAST_ROLLBACK = 4;
    private static final byte IMPORTUNATE = 8;
    private Transaction.State txnState;
    private OperationFailureException onlyAbortableCause;
    private Set<Long> readLocks;
    private Map<Long, WriteLockInfo> writeInfo;
    private TinyHashSet<BuddyLocker> buddyLockers;
    private static final int READ_LOCK_OVERHEAD = MemoryBudget.HASHSET_ENTRY_OVERHEAD;
    private static final int WRITE_LOCK_OVERHEAD = MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.WRITE_LOCKINFO_OVERHEAD;
    protected Set<DbCleanup> dbCleanupSet;
    protected Map<DatabaseId, DatabaseImpl> undoDatabases;
    protected Set<Database> openedDatabaseHandles;
    protected volatile long firstLoggedLsn = -1L;
    protected long lastLoggedLsn = -1L;
    protected long commitLsn = -1L;
    long abortLsn = -1L;
    private Durability defaultDurability;
    private Durability commitDurability;
    private boolean serializableIsolation;
    private boolean readCommittedIsolation;
    private int inMemorySize;
    private int accumulatedDelta = 0;
    private Set<DatabaseImpl> triggerDbs = null;
    private Transaction transaction;
    public static int ACCUMULATED_LIMIT = 10000;
    protected ReplicationContext repContext;
    private boolean explicitSyncConfigured = false;
    private boolean explicitDurabilityConfigured = false;
    private boolean isAutoCommit = false;
    private boolean readOnly;

    public Txn() {
        this.lastLoggedLsn = -1L;
    }

    protected Txn(EnvironmentImpl envImpl, TransactionConfig config, ReplicationContext repContext) {
        this(envImpl, config, repContext, 0L);
    }

    protected Txn(EnvironmentImpl envImpl, TransactionConfig config, ReplicationContext repContext, long mandatedId) throws DatabaseException {
        super(envImpl, config.getReadUncommitted(), config.getNoWait(), mandatedId);
        this.initTxn(config);
        this.repContext = repContext;
    }

    public static Txn createLocalTxn(EnvironmentImpl envImpl, TransactionConfig config) {
        return new Txn(envImpl, config, ReplicationContext.NO_REPLICATE);
    }

    public static Txn createLocalAutoTxn(EnvironmentImpl envImpl, TransactionConfig config) {
        Txn txn = Txn.createLocalTxn(envImpl, config);
        txn.isAutoCommit = true;
        return txn;
    }

    static Txn createUserTxn(EnvironmentImpl envImpl, TransactionConfig config) {
        Txn ret = null;
        try {
            ret = envImpl.isReplicated() ? envImpl.createRepUserTxn(config) : Txn.createLocalTxn(envImpl, config);
        }
        catch (DatabaseException DE) {
            if (ret != null) {
                ret.close(false);
            }
            throw DE;
        }
        return ret;
    }

    public static Txn createAutoTxn(EnvironmentImpl envImpl, TransactionConfig config, ReplicationContext repContext) throws DatabaseException {
        Txn ret = null;
        try {
            ret = envImpl.isReplicated() && repContext.inReplicationStream() ? envImpl.createRepUserTxn(config) : new Txn(envImpl, config, repContext);
            ret.isAutoCommit = true;
        }
        catch (DatabaseException DE) {
            if (ret != null) {
                ret.close(false);
            }
            throw DE;
        }
        return ret;
    }

    private void initTxn(TransactionConfig config) throws DatabaseException {
        this.serializableIsolation = config.getSerializableIsolation();
        this.readCommittedIsolation = config.getReadCommitted();
        this.defaultDurability = config.getDurability();
        if (this.defaultDurability == null) {
            this.explicitDurabilityConfigured = false;
            this.defaultDurability = config.getDurabilityFromSync(this.envImpl);
        } else {
            this.explicitDurabilityConfigured = true;
        }
        boolean bl = this.explicitSyncConfigured = config.getSync() || config.getNoSync() || config.getWriteNoSync();
        assert (!this.explicitDurabilityConfigured || !this.explicitSyncConfigured);
        this.readOnly = config.getReadOnly();
        long txnTimeout = config.getTxnTimeout(TimeUnit.MILLISECONDS);
        if (txnTimeout != -1L) {
            this.setTxnTimeout(txnTimeout);
        }
        this.lastLoggedLsn = -1L;
        this.firstLoggedLsn = -1L;
        this.txnFlags = 0;
        this.setState(Transaction.State.OPEN);
        if (this.envImpl.isReplicated()) {
            this.buddyLockers = new TinyHashSet();
        }
        this.txnBeginHook(config);
        this.updateMemoryUsage(MemoryBudget.TXN_OVERHEAD);
        if (this.registerImmediately()) {
            this.envImpl.getTxnManager().registerTxn(this);
        }
    }

    protected boolean registerImmediately() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addBuddy(BuddyLocker buddy) {
        if (this.buddyLockers != null) {
            TinyHashSet<BuddyLocker> tinyHashSet = this.buddyLockers;
            synchronized (tinyHashSet) {
                this.buddyLockers.add(buddy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeBuddy(BuddyLocker buddy) {
        if (this.buddyLockers != null) {
            TinyHashSet<BuddyLocker> tinyHashSet = this.buddyLockers;
            synchronized (tinyHashSet) {
                this.buddyLockers.remove(buddy);
            }
        }
    }

    @Override
    protected long generateId(TxnManager txnManager, long ignore) {
        return txnManager.getNextTxnId();
    }

    public long getLastLsn() {
        return this.lastLoggedLsn;
    }

    public Durability getCommitDurability() {
        return this.commitDurability;
    }

    public Durability getDefaultDurability() {
        return this.defaultDurability;
    }

    public boolean getPrepared() {
        return (this.txnFlags & 1) != 0;
    }

    public void setPrepared(boolean prepared) {
        this.txnFlags = prepared ? (byte)(this.txnFlags | 1) : (byte)(this.txnFlags & 0xFFFFFFFE);
    }

    public void setSuspended(boolean suspended) {
        this.txnFlags = suspended ? (byte)(this.txnFlags | 2) : (byte)(this.txnFlags & 0xFFFFFFFD);
    }

    public boolean isSuspended() {
        return (this.txnFlags & 2) != 0;
    }

    protected void setRollback() {
        this.txnFlags = (byte)(this.txnFlags | 4);
    }

    @Override
    public boolean isRolledBack() {
        return (this.txnFlags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LockResult lockInternal(long lsn, LockType lockType, boolean noWait, boolean jumpAheadOfWaiters, DatabaseImpl database) throws DatabaseException {
        long timeout = 0L;
        boolean useNoWait = noWait || this.defaultNoWait;
        Txn txn = this;
        synchronized (txn) {
            this.checkState(false);
            if (!useNoWait) {
                timeout = this.getLockTimeout();
            }
        }
        LockGrantType grant = this.lockManager.lock(lsn, this, lockType, timeout, useNoWait, jumpAheadOfWaiters, database);
        WriteLockInfo info = null;
        if (this.writeInfo != null && grant != LockGrantType.DENIED && lockType.isWriteLock()) {
            Txn txn2 = this;
            synchronized (txn2) {
                info = this.writeInfo.get(lsn);
                this.undoDatabases.put(database.getId(), database);
            }
        }
        return new LockResult(grant, info);
    }

    @Override
    public synchronized void preLogWithoutLock(DatabaseImpl database) {
        this.ensureWriteInfo();
        this.undoDatabases.put(database.getId(), database);
    }

    public synchronized int prepare(Xid xid) throws DatabaseException {
        if ((this.txnFlags & 1) != 0) {
            throw new IllegalStateException("prepare() has already been called for Transaction " + this.id + ".");
        }
        this.checkState(false);
        if (this.checkCursorsForClose()) {
            throw new IllegalStateException("Transaction " + this.id + " prepare failed because there were open cursors.");
        }
        this.setPrepared(true);
        this.envImpl.getTxnManager().notePrepare();
        if (this.writeInfo == null) {
            return 3;
        }
        SingleItemEntry<TxnPrepare> prepareEntry = SingleItemEntry.create(LogEntryType.LOG_TXN_PREPARE, new TxnPrepare(this.id, xid));
        LogManager logManager = this.envImpl.getLogManager();
        logManager.logForceFlush(prepareEntry, true, ReplicationContext.NO_REPLICATE);
        return 0;
    }

    public void commit(Xid xid) throws DatabaseException {
        this.commit(Durability.COMMIT_SYNC);
        this.envImpl.getTxnManager().unRegisterXATxn(xid, true);
    }

    public void abort(Xid xid) throws DatabaseException {
        this.abort(true);
        this.envImpl.getTxnManager().unRegisterXATxn(xid, false);
    }

    public long commit() throws DatabaseException {
        return this.commit(this.defaultDurability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commit(Durability durability) throws DatabaseException {
        this.checkIfFrozen(true);
        DatabaseException queuedPostCommitException = null;
        this.commitDurability = durability;
        try {
            Txn txn = this;
            synchronized (txn) {
                this.checkState(false);
                if (this.checkCursorsForClose()) {
                    throw new IllegalStateException("Transaction " + this.id + " commit failed because there were open cursors.");
                }
                if (this.updateLoggedForTxn()) {
                    this.preLogCommitHook();
                }
                int numReadLocks = this.clearReadLocks();
                int numWriteLocks = 0;
                Collection<WriteLockInfo> obsoleteLsns = null;
                if (this.writeInfo != null) {
                    numWriteLocks = this.writeInfo.size();
                    obsoleteLsns = this.getObsoleteLsnInfo();
                }
                if (this.updateLoggedForTxn()) {
                    LogItem commitItem = this.logCommitEntry(durability.getLocalSync(), obsoleteLsns);
                    this.commitLsn = commitItem.lsn;
                    try {
                        this.postLogCommitHook(commitItem);
                    }
                    catch (DatabaseException hookException) {
                        if (this.txnState == Transaction.State.MUST_ABORT) {
                            throw EnvironmentFailureException.unexpectedException("postLogCommitHook may not set MUST_ABORT", (Exception)hookException);
                        }
                        if (!this.propagatePostCommitException(hookException)) {
                            throw hookException;
                        }
                        queuedPostCommitException = hookException;
                    }
                }
                this.setDbCleanupState(true);
                if (numWriteLocks > 0) {
                    this.releaseWriteLocks();
                }
                this.writeInfo = null;
                if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
                    this.envImpl.addToCompressorQueue(this.deleteInfo.values());
                    this.deleteInfo.clear();
                }
                this.traceCommit(numWriteLocks, numReadLocks);
            }
            this.cleanupDatabaseImpls(true);
            this.close(true);
            if (queuedPostCommitException == null) {
                TriggerManager.runCommitTriggers(this);
                long l = this.commitLsn;
                return l;
            }
        }
        catch (Error e) {
            this.envImpl.invalidate(e);
            throw e;
        }
        catch (RuntimeException commitException) {
            if (!this.envImpl.isValid()) {
                throw commitException;
            }
            if (this.commitLsn != -1L) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INCOMPLETE, "Failed after commiting transaction " + this.id + " during post transaction cleanup.Original exception = " + commitException.getMessage(), commitException);
            }
            this.checkIfFrozen(true);
            this.throwPreCommitException(durability, commitException);
        }
        finally {
            if (this.txnState == Transaction.State.OPEN && this.commitLsn != -1L) {
                this.setState(Transaction.State.COMMITTED);
            }
        }
        throw queuedPostCommitException;
    }

    protected void releaseWriteLocks() throws DatabaseException {
        if (this.writeInfo == null) {
            return;
        }
        for (Long lsn : this.writeInfo.keySet()) {
            this.lockManager.release(lsn, this);
        }
        this.writeInfo = null;
    }

    private void throwPreCommitException(Durability durability, RuntimeException preCommitException) {
        try {
            this.abortInternal(durability.getLocalSync() == Durability.SyncPolicy.SYNC);
            LoggerUtils.traceAndLogException(this.envImpl, "Txn", "commit", "Commit of transaction " + this.id + " failed", preCommitException);
        }
        catch (Error e) {
            this.envImpl.invalidate(e);
            throw e;
        }
        catch (RuntimeException abortT2) {
            if (!this.envImpl.isValid()) {
                throw abortT2;
            }
            String message = "Failed while attempting to commit transaction " + this.id + ". The attempt to abort also failed. The original exception seen from commit = " + preCommitException.getMessage() + " The exception from the cleanup = " + abortT2.getMessage();
            if (this.writeInfo != null && this.abortLsn == -1L) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INCOMPLETE, message, preCommitException);
            }
            LoggerUtils.envLogMsg(Level.WARNING, this.envImpl, message);
        }
        this.postLogCommitAbortHook();
        if (preCommitException instanceof DatabaseException || preCommitException instanceof IllegalStateException) {
            throw preCommitException;
        }
        throw EnvironmentFailureException.unexpectedException("Failed while attempting to commit transaction " + this.id + ", aborted instead. Original exception = " + preCommitException.getMessage(), (Exception)preCommitException);
    }

    private LogItem logCommitEntry(Durability.SyncPolicy flushSyncBehavior, Collection<WriteLockInfo> obsoleteLsns) throws DatabaseException {
        LogManager logManager = this.envImpl.getLogManager();
        assert (this.checkForValidReplicatorNodeId());
        CommitLogEntry commitEntry = new CommitLogEntry(new TxnCommit(this.id, this.lastLoggedLsn, this.getReplicatorNodeId(), this.getDTVLSN()));
        LogParams params = new LogParams();
        params.entry = commitEntry;
        params.provisional = Provisional.NO;
        params.repContext = this.repContext;
        params.obsoleteWriteLockInfo = obsoleteLsns;
        switch (flushSyncBehavior) {
            case SYNC: {
                params.flushRequired = true;
                params.fsyncRequired = true;
                break;
            }
            case WRITE_NO_SYNC: {
                params.flushRequired = true;
                params.fsyncRequired = false;
                break;
            }
            default: {
                params.flushRequired = false;
                params.fsyncRequired = false;
            }
        }
        this.preLogCommitCheck();
        boolean logSuccess = false;
        try {
            LogItem item = logManager.log(params);
            logSuccess = true;
            LogItem logItem = item;
            return logItem;
        }
        catch (RuntimeException e) {
            if (this.envImpl.isValid()) {
                throw EnvironmentFailureException.unexpectedException(this.envImpl, "Unexpected non-fatal exception while logging commit", e);
            }
            throw e;
        }
        catch (Error e) {
            this.envImpl.invalidate(e);
            throw e;
        }
        finally {
            if (!logSuccess) {
                this.setState(Transaction.State.POSSIBLY_COMMITTED);
            }
        }
    }

    private void preLogCommitCheck() {
        if (Thread.interrupted()) {
            throw new ThreadInterruptedException(this.envImpl, "Thread interrupted prior to logging the commit");
        }
        this.envImpl.checkIfInvalid();
    }

    private boolean checkForValidReplicatorNodeId() {
        return !this.isReplicated() || this.getReplicatorNodeId() != 0;
    }

    private Collection<WriteLockInfo> getObsoleteLsnInfo() {
        HashMap<Long, WriteLockInfo> map = new HashMap<Long, WriteLockInfo>();
        for (WriteLockInfo info : this.writeInfo.values()) {
            this.maybeCountObsoleteLSN(map, info);
        }
        return map.values();
    }

    private void maybeCountObsoleteLSN(Map<Long, WriteLockInfo> obsoleteLsnSet, WriteLockInfo info) {
        if (info.getAbortLsn() == -1L || info.getAbortKnownDeleted()) {
            return;
        }
        if (info.getDb() != null && info.getDb().isLNImmediatelyObsolete()) {
            return;
        }
        if (info.getAbortData() != null) {
            return;
        }
        Long longLsn = info.getAbortLsn();
        if (!obsoleteLsnSet.containsKey(longLsn)) {
            obsoleteLsnSet.put(longLsn, info);
        }
    }

    public void abort() throws DatabaseException {
        if (this.isClosed()) {
            return;
        }
        this.abort(false);
    }

    public long abort(boolean forceFlush) throws DatabaseException {
        return this.abortInternal(forceFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long abortInternal(boolean forceFlush) throws DatabaseException {
        boolean hooked = false;
        this.checkIfFrozen(false);
        try {
            Txn txn;
            try {
                txn = this;
                synchronized (txn) {
                    this.checkState(true);
                    this.setState(Transaction.State.ABORTED);
                    if (this.updateLoggedForTxn()) {
                        this.preLogAbortHook();
                        hooked = true;
                        assert (this.checkForValidReplicatorNodeId());
                        assert (this.commitLsn == -1L && this.abortLsn == -1L);
                        AbortLogEntry abortEntry = new AbortLogEntry(new TxnAbort(this.id, this.lastLoggedLsn, this.getReplicatorNodeId(), this.getDTVLSN()));
                        this.abortLsn = forceFlush ? this.envImpl.getLogManager().logForceFlush(abortEntry, true, this.repContext) : this.envImpl.getLogManager().log(abortEntry, this.repContext);
                    }
                }
            }
            finally {
                if (hooked) {
                    this.postLogAbortHook();
                    hooked = false;
                }
                this.undo();
            }
            this.cleanupDatabaseImpls(false);
            txn = this;
            synchronized (txn) {
                boolean openCursors = this.checkCursorsForClose();
                Logger logger = this.envImpl.getLogger();
                if (logger.isLoggable(Level.FINE)) {
                    LoggerUtils.fine(logger, this.envImpl, "Abort: id = " + this.id + " openCursors= " + openCursors);
                }
                if (this.openedDatabaseHandles != null) {
                    for (Database handle : this.openedDatabaseHandles) {
                        DbInternal.invalidate(handle);
                    }
                }
                if (openCursors) {
                    this.envImpl.checkIfInvalid();
                    throw new IllegalStateException("Transaction " + this.id + " detected open cursors while aborting");
                }
            }
        }
        finally {
            this.close(false);
            if (this.abortLsn != -1L) {
                TriggerManager.runAbortTriggers(this);
            }
        }
        return this.abortLsn;
    }

    protected void undo() throws DatabaseException {
        HashSet<Long> alreadyUndoneLsns = new HashSet<Long>();
        TreeSet<TxnChain.CompareSlot> alreadyUndoneSlots = new TreeSet<TxnChain.CompareSlot>();
        TreeLocation location = new TreeLocation();
        long undoLsn = this.lastLoggedLsn;
        try {
            while (undoLsn != -1L) {
                UndoReader undo = UndoReader.create(this.envImpl, undoLsn, this.undoDatabases);
                if (this.firstInstance(alreadyUndoneLsns, alreadyUndoneSlots, undo)) {
                    RecoveryManager.abortUndo(this.envImpl.getLogger(), Level.FINER, location, undo.db, undo.logEntry, undoLsn);
                    this.countObsoleteExact(undoLsn, undo, this.isRolledBack());
                }
                undoLsn = undo.logEntry.getUserTxn().getLastLsn();
            }
        }
        catch (DatabaseException e) {
            String lsnMsg = "LSN=" + DbLsn.getNoFormatString(undoLsn);
            LoggerUtils.traceAndLogException(this.envImpl, "Txn", "undo", lsnMsg, e);
            e.addErrorMessage(lsnMsg);
            throw e;
        }
        catch (RuntimeException e) {
            throw EnvironmentFailureException.unexpectedException("Txn undo for LSN=" + DbLsn.getNoFormatString(undoLsn), (Exception)e);
        }
        if (this.readLocks != null) {
            this.clearReadLocks();
        }
        this.setDbCleanupState(false);
        Set<Long> empty = Collections.emptySet();
        this.clearWriteLocks(empty);
        this.deleteInfo = null;
    }

    private void countObsoleteExact(long undoLsn, UndoReader undo, boolean obsoleteDupsAllowed) {
        if (undo.logEntry.isImmediatelyObsolete(undo.db)) {
            return;
        }
        LogManager logManager = this.envImpl.getLogManager();
        if (obsoleteDupsAllowed) {
            logManager.countObsoleteNodeDupsAllowed(undoLsn, null, undo.logEntrySize);
        } else {
            logManager.countObsoleteNode(undoLsn, null, undo.logEntrySize, true);
        }
    }

    protected void clearWriteLocks(Set<Long> retainedNodes) throws DatabaseException {
        if (this.writeInfo == null) {
            return;
        }
        Iterator<Map.Entry<Long, WriteLockInfo>> iter = this.writeInfo.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, WriteLockInfo> entry = iter.next();
            Long lsn = entry.getKey();
            if (retainedNodes.contains(lsn)) continue;
            this.lockManager.release(lsn, this);
            iter.remove();
        }
        if (this.writeInfo.size() == 0) {
            this.writeInfo = null;
        }
    }

    protected int clearReadLocks() throws DatabaseException {
        int numReadLocks = 0;
        if (this.readLocks != null) {
            numReadLocks = this.readLocks.size();
            for (Long rLockNid : this.readLocks) {
                this.lockManager.release(rLockNid, this);
            }
            this.readLocks = null;
        }
        return numReadLocks;
    }

    public synchronized void addLogInfo(long lastLsn) {
        this.lastLoggedLsn = lastLsn;
        if (this.firstLoggedLsn == -1L) {
            this.firstLoggedLsn = lastLsn;
        }
    }

    public long getFirstActiveLsn() {
        return this.firstLoggedLsn;
    }

    protected boolean updateLoggedForTxn() {
        return this.lastLoggedLsn != -1L;
    }

    @Override
    public synchronized void addDbCleanup(DbCleanup cleanup) {
        int delta = 0;
        if (this.dbCleanupSet == null) {
            this.dbCleanupSet = new HashSet<DbCleanup>();
            delta += MemoryBudget.HASHSET_OVERHEAD;
        }
        this.dbCleanupSet.add(cleanup);
        this.updateMemoryUsage(delta += MemoryBudget.HASHSET_ENTRY_OVERHEAD + MemoryBudget.OBJECT_OVERHEAD);
    }

    public Set<DbCleanup> getDbCleanupSet() {
        return this.dbCleanupSet;
    }

    protected void setDbCleanupState(boolean isCommit) {
        if (this.dbCleanupSet != null) {
            for (DbCleanup cleanup : this.dbCleanupSet) {
                DbCleanup.setState(cleanup, isCommit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDatabaseImpls(boolean isCommit) throws DatabaseException {
        DbCleanup[] array;
        if (this.dbCleanupSet == null) {
            return;
        }
        Txn txn = this;
        synchronized (txn) {
            array = new DbCleanup[this.dbCleanupSet.size()];
            this.dbCleanupSet.toArray(array);
        }
        DbCleanup.execute(this.envImpl, array, isCommit);
        this.dbCleanupSet = null;
    }

    private synchronized void ensureWriteInfo() {
        if (this.writeInfo == null) {
            this.writeInfo = new HashMap<Long, WriteLockInfo>();
            this.undoDatabases = new HashMap<DatabaseId, DatabaseImpl>();
            this.updateMemoryUsage(MemoryBudget.TWOHASHMAPS_OVERHEAD);
        }
    }

    @Override
    protected synchronized void addLock(Long lsn, LockType type, LockGrantType grantStatus) {
        if (type.isWriteLock()) {
            this.ensureWriteInfo();
            this.writeInfo.put(lsn, new WriteLockInfo());
            int delta = WRITE_LOCK_OVERHEAD;
            if (grantStatus == LockGrantType.PROMOTION || grantStatus == LockGrantType.WAIT_PROMOTION) {
                this.readLocks.remove(lsn);
                delta -= READ_LOCK_OVERHEAD;
            }
            this.updateMemoryUsage(delta);
        } else {
            this.addReadLock(lsn);
        }
    }

    private void addReadLock(Long lsn) {
        int delta = 0;
        if (this.readLocks == null) {
            this.readLocks = new HashSet<Long>();
            delta = MemoryBudget.HASHSET_OVERHEAD;
        }
        this.readLocks.add(lsn);
        this.updateMemoryUsage(delta += READ_LOCK_OVERHEAD);
    }

    @Override
    protected synchronized void removeLock(long lsn) {
        if (this.readLocks != null && this.readLocks.remove(lsn)) {
            this.updateMemoryUsage(0 - READ_LOCK_OVERHEAD);
        } else if (this.writeInfo != null && this.writeInfo.remove(lsn) != null) {
            this.updateMemoryUsage(0 - WRITE_LOCK_OVERHEAD);
        }
    }

    @Override
    synchronized void moveWriteToReadLock(long lsn, Lock lock) {
        boolean found = false;
        if (this.writeInfo != null && this.writeInfo.remove(lsn) != null) {
            found = true;
            this.updateMemoryUsage(0 - WRITE_LOCK_OVERHEAD);
        }
        assert (found) : "Couldn't find lock for Node " + lsn + " in writeInfo Map.";
        this.addReadLock(lsn);
    }

    private void updateMemoryUsage(int delta) {
        this.inMemorySize += delta;
        this.accumulatedDelta += delta;
        if (this.accumulatedDelta > ACCUMULATED_LIMIT || this.accumulatedDelta < -ACCUMULATED_LIMIT) {
            this.envImpl.getMemoryBudget().updateTxnMemoryUsage(this.accumulatedDelta);
            this.accumulatedDelta = 0;
        }
    }

    int getBudgetedMemorySize() {
        return this.inMemorySize - this.accumulatedDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteLockInfo getWriteLockInfo(long lsn) {
        WriteLockInfo wli = null;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null) {
                wli = this.writeInfo.get(lsn);
            }
        }
        if (wli == null) {
            throw EnvironmentFailureException.unexpectedState("writeInfo is null in Txn.getWriteLockInfo");
        }
        return wli;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public boolean isAutoTxn() {
        return this.isAutoCommit;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isSerializableIsolation() {
        return this.serializableIsolation;
    }

    @Override
    public boolean isReadCommittedIsolation() {
        return this.readCommittedIsolation;
    }

    public boolean getExplicitSyncConfigured() {
        return this.explicitSyncConfigured;
    }

    public boolean getExplicitDurabilityConfigured() {
        return this.explicitDurabilityConfigured;
    }

    @Override
    public Txn getTxnLocker() {
        return this;
    }

    @Override
    public Locker newNonTxnLocker() {
        return this;
    }

    @Override
    public void releaseNonTxnLocks() {
    }

    @Override
    public void nonTxnOperationEnd() {
    }

    @Override
    public void operationEnd(boolean operationOK) throws DatabaseException {
        if (!this.isAutoCommit) {
            return;
        }
        if (operationOK) {
            this.commit();
        } else {
            this.abort(false);
        }
    }

    @Override
    public synchronized void addOpenedDatabase(Database dbHandle) {
        if (this.isAutoCommit) {
            return;
        }
        if (this.openedDatabaseHandles == null) {
            this.openedDatabaseHandles = new HashSet<Database>();
        }
        this.openedDatabaseHandles.add(dbHandle);
    }

    @Override
    public void registerCursor(CursorImpl cursor) {
        this.cursors.getAndIncrement();
    }

    @Override
    public void unRegisterCursor(CursorImpl cursor) {
        this.cursors.getAndDecrement();
    }

    @Override
    public boolean lockingRequired() {
        return true;
    }

    private boolean checkCursorsForClose() {
        return this.cursors.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatGroup collectStats() {
        StatGroup stats = new StatGroup("Transaction lock counts", "Read and write locks held by transaction " + this.id);
        IntStat statReadLocks = new IntStat(stats, LockStatDefinition.LOCK_READ_LOCKS);
        IntStat statWriteLocks = new IntStat(stats, LockStatDefinition.LOCK_WRITE_LOCKS);
        IntStat statTotalLocks = new IntStat(stats, LockStatDefinition.LOCK_TOTAL);
        Txn txn = this;
        synchronized (txn) {
            int nReadLocks = this.readLocks == null ? 0 : this.readLocks.size();
            statReadLocks.add(nReadLocks);
            int nWriteLocks = this.writeInfo == null ? 0 : this.writeInfo.size();
            statWriteLocks.add(nWriteLocks);
            statTotalLocks.add(nReadLocks + nWriteLocks);
        }
        return stats;
    }

    @Override
    public void setOnlyAbortable(OperationFailureException cause) {
        assert (cause != null);
        this.setState(Transaction.State.MUST_ABORT);
        this.onlyAbortableCause = cause;
    }

    @Override
    public void setImportunate(boolean importunate) {
        this.txnFlags = importunate ? (byte)(this.txnFlags | 8) : (byte)(this.txnFlags & 0xFFFFFFF7);
    }

    @Override
    public boolean getImportunate() {
        return (this.txnFlags & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPreempted(Locker allowPreemptedLocker) throws OperationFailureException {
        this.throwIfPreempted(allowPreemptedLocker);
        if (this.buddyLockers != null) {
            TinyHashSet<BuddyLocker> tinyHashSet = this.buddyLockers;
            synchronized (tinyHashSet) {
                for (BuddyLocker buddy : this.buddyLockers) {
                    buddy.throwIfPreempted(allowPreemptedLocker);
                }
            }
        }
    }

    @Override
    public void checkState(boolean calledByAbort) throws DatabaseException {
        switch (this.txnState) {
            case OPEN: {
                return;
            }
            case MUST_ABORT: {
                if (calledByAbort) {
                    return;
                }
                throw this.onlyAbortableCause.wrapSelf("Transaction " + this.id + " must be aborted, caused by: " + this.onlyAbortableCause);
            }
        }
        throw new IllegalStateException("Transaction " + this.id + " has been closed.");
    }

    public void close(boolean isCommit) {
        if (isCommit) {
            if (this.txnState == Transaction.State.OPEN) {
                this.setState(Transaction.State.COMMITTED);
            }
        } else {
            this.setState(Transaction.State.ABORTED);
        }
        this.envImpl.getTxnManager().unRegisterTxn(this, isCommit);
        this.close();
    }

    private synchronized void setState(Transaction.State state) {
        this.txnState = state;
    }

    public Transaction.State getState() {
        return this.txnState;
    }

    @Override
    public boolean isValid() {
        return this.txnState == Transaction.State.OPEN;
    }

    public boolean isClosed() {
        return this.txnState != Transaction.State.OPEN && this.txnState != Transaction.State.MUST_ABORT;
    }

    public boolean isOnlyAbortable() {
        return this.txnState == Transaction.State.MUST_ABORT;
    }

    protected int getReplicatorNodeId() {
        return 0;
    }

    protected long getDTVLSN() {
        return 0L;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        return Collections.emptyList();
    }

    @Override
    public int getLogSize() {
        return this.getLogSize(17, false);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.writeToLog(logBuffer, 17, false);
    }

    @Override
    public int getLogSize(int logVersion, boolean forReplication) {
        return LogUtils.getPackedLongLogSize(this.id) + LogUtils.getPackedLongLogSize(forReplication ? -1L : this.lastLoggedLsn);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int logVersion, boolean forReplication) {
        LogUtils.writePackedLong(logBuffer, this.id);
        LogUtils.writePackedLong(logBuffer, forReplication ? -1L : this.lastLoggedLsn);
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, int entryVersion) {
        this.id = LogUtils.readLong(logBuffer, entryVersion < 6);
        this.lastLoggedLsn = LogUtils.readLong(logBuffer, entryVersion < 6);
    }

    @Override
    public boolean hasReplicationFormat() {
        return false;
    }

    @Override
    public boolean isReplicationFormatWorthwhile(ByteBuffer logBuffer, int srcVersion, int destVersion) {
        return false;
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<txn id=\"");
        sb.append(this.getId());
        sb.append("\">");
        sb.append(DbLsn.toString(this.lastLoggedLsn));
        sb.append("</txn>");
    }

    @Override
    public long getTransactionId() {
        return this.getId();
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof Txn)) {
            return false;
        }
        return this.id == ((Txn)other).id;
    }

    private void traceCommit(int numWriteLocks, int numReadLocks) {
        Logger logger = this.envImpl.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(" Commit: id = ").append(this.id);
            sb.append(" numWriteLocks=").append(numWriteLocks);
            sb.append(" numReadLocks = ").append(numReadLocks);
            LoggerUtils.fine(logger, this.envImpl, sb.toString());
        }
    }

    protected void txnBeginHook(TransactionConfig config) throws DatabaseException {
    }

    protected void preLogCommitHook() throws DatabaseException {
    }

    protected void postLogCommitHook(LogItem commitItem) throws DatabaseException {
    }

    protected void preLogAbortHook() throws DatabaseException {
    }

    protected void postLogCommitAbortHook() {
    }

    protected void postLogAbortHook() {
    }

    public CommitToken getCommitToken() {
        return null;
    }

    protected boolean propagatePostCommitException(DatabaseException postCommitException) {
        return false;
    }

    private boolean firstInstance(Set<Long> seenLsns, Set<TxnChain.CompareSlot> seenSlots, UndoReader undo) {
        LNLogEntry<?> undoEntry = undo.logEntry;
        long abortLsn1 = undoEntry.getAbortLsn();
        if (abortLsn1 != -1L) {
            return seenLsns.add(abortLsn1);
        }
        TxnChain.CompareSlot slot = new TxnChain.CompareSlot(undo.db, undoEntry);
        return seenSlots.add(slot);
    }

    public void noteTriggerDb(DatabaseImpl dbImpl) {
        if (this.triggerDbs == null) {
            this.triggerDbs = Collections.synchronizedSet(new HashSet());
        }
        this.triggerDbs.add(dbImpl);
    }

    public Set<DatabaseImpl> getTriggerDbs() {
        return this.triggerDbs;
    }

    public Set<Long> getWriteLockIds() {
        if (this.writeInfo == null) {
            Set<Long> empty = Collections.emptySet();
            return empty;
        }
        return this.writeInfo.keySet();
    }

    public Set<Long> getReadLockIds() {
        if (this.readLocks == null) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(this.readLocks);
    }

    public EnvironmentImpl getEnvironmentImpl() {
        return this.envImpl;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction != null ? this.transaction : (this.transaction = new AutoTransaction(this));
    }

    public Map<DatabaseId, DatabaseImpl> getUndoDatabases() {
        return this.undoDatabases;
    }

    protected void checkIfFrozen(boolean isCommit) throws DatabaseException {
    }

    public boolean isMasterTxn() {
        return false;
    }

    private static class AutoTransaction
    extends Transaction {
        protected AutoTransaction(Txn txn) {
            super(txn.getEnvironmentImpl().getInternalEnvHandle(), txn);
        }

        @Override
        public synchronized void commit() throws DatabaseException {
            EnvironmentFailureException.unexpectedState("commit() not permitted on an auto transaction");
        }

        @Override
        public synchronized void commit(Durability durability) {
            EnvironmentFailureException.unexpectedState("commit() not permitted on an auto transaction");
        }

        @Override
        public synchronized void commitNoSync() throws DatabaseException {
            EnvironmentFailureException.unexpectedState("commit() not permitted on an auto transaction");
        }

        @Override
        public synchronized void commitWriteNoSync() throws DatabaseException {
            EnvironmentFailureException.unexpectedState("commit() not permitted on an auto transaction");
        }

        @Override
        public synchronized void abort() throws DatabaseException {
            EnvironmentFailureException.unexpectedState("abort() not permitted on an auto transaction");
        }
    }
}

