/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.vlsn;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.vlsn.GhostBucket;
import com.sleepycat.je.rep.vlsn.LogItemCache;
import com.sleepycat.je.rep.vlsn.VLSNBucket;
import com.sleepycat.je.rep.vlsn.VLSNIndexStatDefinition;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.rep.vlsn.VLSNRecoveryTracker;
import com.sleepycat.je.rep.vlsn.VLSNTracker;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VLSNIndex {
    public static int AWAIT_CONSISTENCY_MS = 60000;
    private final EnvironmentImpl envImpl;
    private VLSNAwaitLatch vlsnPutLatch = null;
    private VLSN putWaitVLSN = null;
    private final Object mappingSynchronizer = new Object();
    private final Object flushSynchronizer = new Object();
    private final Logger logger;
    private AtomicLong nextVLSNCounter;
    private volatile long replicaLatestVLSNSeq = -1L;
    private DatabaseImpl mappingDbImpl;
    private VLSNTracker tracker;
    private final LogItemCache logItemCache;
    private final StatGroup statistics;
    private final LongStat nHeadBucketsDeleted;
    private final LongStat nTailBucketsDeleted;
    private TestHook<?> searchGTEHook;

    public VLSNIndex(EnvironmentImpl envImpl, String mappingDbName, NameIdPair nameIdPair, int vlsnStride, int vlsnMaxMappings, int vlsnMaxDistance, RecoveryInfo recoveryInfo) throws DatabaseException {
        this.envImpl = envImpl;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.statistics = new StatGroup("VLSNIndex", "VLSN Index related stats.");
        this.nHeadBucketsDeleted = new LongStat(this.statistics, VLSNIndexStatDefinition.N_HEAD_BUCKETS_DELETED);
        this.nTailBucketsDeleted = new LongStat(this.statistics, VLSNIndexStatDefinition.N_TAIL_BUCKETS_DELETED);
        this.init(mappingDbName, vlsnStride, vlsnMaxMappings, vlsnMaxDistance, recoveryInfo);
        this.logItemCache = new LogItemCache(envImpl.getConfigManager().getInt(RepParams.VLSN_LOG_CACHE_SIZE), this.statistics);
    }

    public void initAsMaster() {
        VLSN last = this.tracker.getRange().getLast();
        if (last.equals(VLSN.NULL_VLSN)) {
            this.nextVLSNCounter = this.envImpl.needRepConvert() ? new AtomicLong(1L) : new AtomicLong(0L);
        } else {
            this.nextVLSNCounter = new AtomicLong(last.getSequence());
            this.replicaLatestVLSNSeq = -1L;
        }
    }

    public synchronized void initAsReplica() {
        if (this.vlsnPutLatch != null) {
            this.vlsnPutLatch.terminate();
            this.vlsnPutLatch = null;
        }
        this.putWaitVLSN = null;
        this.nextVLSNCounter = null;
        this.replicaLatestVLSNSeq = 0L;
    }

    public VLSN bump() {
        return new VLSN(this.nextVLSNCounter.incrementAndGet());
    }

    public long getLatestAllocatedVal() {
        if (this.nextVLSNCounter != null) {
            return this.nextVLSNCounter.get();
        }
        return this.replicaLatestVLSNSeq;
    }

    public void setReplicaLatestVLSNSeq(long seq) {
        this.replicaLatestVLSNSeq = seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(LogItem logItem) {
        VLSN vlsn = logItem.header.getVLSN();
        long lsn = logItem.lsn;
        byte entryType = logItem.header.getType();
        this.logItemCache.put(vlsn, logItem);
        VLSNIndex vLSNIndex = this;
        synchronized (vLSNIndex) {
            this.tracker.track(vlsn, lsn, entryType);
            Object object = this.mappingSynchronizer;
            synchronized (object) {
                if (this.vlsnPutLatch != null && vlsn.compareTo(this.putWaitVLSN) >= 0) {
                    this.vlsnPutLatch.setLogItem(logItem);
                    this.vlsnPutLatch.countDown();
                    this.vlsnPutLatch = null;
                    this.putWaitVLSN = null;
                }
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.envImpl, "vlsnIndex put " + vlsn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogItem waitForVLSN(VLSN vlsn, int waitTime) throws InterruptedException, WaitTimeOutException {
        VLSNRange useRange = this.tracker.getRange();
        if (useRange.getLast().compareTo(vlsn) >= 0) {
            return this.logItemCache.get(vlsn);
        }
        VLSNAwaitLatch waitLatch = null;
        VLSNIndex vLSNIndex = this;
        synchronized (vLSNIndex) {
            useRange = this.tracker.getRange();
            if (useRange.getLast().compareTo(vlsn) >= 0) {
                return this.logItemCache.get(vlsn);
            }
            Object object = this.mappingSynchronizer;
            synchronized (object) {
                this.setupWait(vlsn);
                waitLatch = this.vlsnPutLatch;
            }
        }
        if (!waitLatch.await(waitTime, TimeUnit.MILLISECONDS) || waitLatch.isTerminated()) {
            throw new WaitTimeOutException();
        }
        if (this.tracker.getRange().getLast().compareTo(vlsn) < 0) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Waited for vlsn:" + vlsn + " should be greater than last in range:" + this.tracker.getRange().getLast());
        }
        LogItem logItem = waitLatch.getLogItem();
        return logItem.header.getVLSN().equals(vlsn) ? logItem : null;
    }

    synchronized VLSN getPutWaitVLSN() {
        return this.putWaitVLSN;
    }

    private void setupWait(VLSN vlsn) {
        if (this.vlsnPutLatch == null) {
            this.putWaitVLSN = vlsn;
            this.vlsnPutLatch = new VLSNAwaitLatch();
        } else if (!vlsn.equals(this.putWaitVLSN)) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "unexpected get for VLSN: " + vlsn + " already waiting for VLSN: " + this.putWaitVLSN + " current range=" + this.getRange());
        }
    }

    public FileProtector.ProtectedFileSet protectRangeHead(String lockerName) {
        return this.tracker.protectRangeHead(lockerName);
    }

    public long getProtectedRangeStartFile() {
        return this.tracker.getProtectedRangeStartFile();
    }

    public synchronized boolean tryTruncateFromHead(long bytesNeeded) {
        Pair<VLSN, Long> truncateInfo = this.tracker.tryTruncateFromHead(bytesNeeded, this.logItemCache);
        if (truncateInfo == null) {
            return false;
        }
        this.truncateDatabaseFromHead(truncateInfo.first(), truncateInfo.second());
        return true;
    }

    public synchronized boolean tryTruncateFromHead(VLSN deleteEnd, long deleteFileNum) {
        if (!this.tracker.tryTruncateFromHead(deleteEnd, deleteFileNum, this.logItemCache)) {
            return false;
        }
        this.truncateDatabaseFromHead(deleteEnd, deleteFileNum);
        return true;
    }

    public synchronized void truncateFromHead(VLSN deleteEnd, long deleteFileNum) {
        LoggerUtils.fine(this.logger, this.envImpl, "head truncate with " + deleteEnd + " delete file#:" + deleteFileNum);
        if (!this.tracker.truncateFromHead(deleteEnd, deleteFileNum, this.logItemCache)) {
            return;
        }
        this.truncateDatabaseFromHead(deleteEnd, deleteFileNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void truncateDatabaseFromHead(VLSN deleteEnd, long deleteFileNum) {
        TransactionConfig config = new TransactionConfig();
        config.setDurability(Durability.COMMIT_NO_SYNC);
        Txn txn = Txn.createLocalTxn(this.envImpl, config);
        boolean success = false;
        try {
            Object object = this.flushSynchronizer;
            synchronized (object) {
                this.pruneDatabaseHead(deleteEnd, deleteFileNum, txn);
                this.flushToDatabase(txn);
            }
            txn.commit();
            this.envImpl.flushLog(true);
            success = true;
        }
        finally {
            if (!success) {
                txn.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void truncateFromTail(VLSN deleteStart, long lastLsn) throws DatabaseException {
        this.logItemCache.clear();
        VLSNRange currentRange = this.tracker.getRange();
        if (currentRange.getLast().getNext().equals(deleteStart)) {
            return;
        }
        this.tracker.truncateFromTail(deleteStart, lastLsn);
        TransactionConfig config = new TransactionConfig();
        config.setDurability(Durability.COMMIT_SYNC);
        Txn txn = Txn.createLocalTxn(this.envImpl, config);
        boolean success = false;
        try {
            VLSN lastOnDisk = this.pruneDatabaseTail(deleteStart, lastLsn, txn);
            this.tracker.setLastOnDiskVLSN(lastOnDisk);
            this.tracker.ensureRangeEndIsMapped(deleteStart.getPrev(), lastLsn);
            this.flushToDatabase(txn);
            txn.commit();
            success = true;
        }
        finally {
            if (!success) {
                txn.abort();
            }
        }
    }

    public VLSNRange getRange() {
        return this.tracker.getRange();
    }

    public StatGroup getStats(StatsConfig config) {
        return this.statistics.cloneGroup(config.getClear());
    }

    public long getLTEFileNumber(VLSN vlsn) throws DatabaseException {
        VLSNBucket bucket = this.getLTEBucket(vlsn);
        return bucket.getLTEFileNumber();
    }

    public long getGTEFileNumber(VLSN vlsn) throws DatabaseException {
        VLSNBucket bucket = this.getGTEBucket(vlsn, null);
        return bucket.getGTEFileNumber();
    }

    public long getGTELsn(VLSN vlsn) {
        VLSNBucket bucket = this.getGTEBucket(vlsn, null);
        return bucket.getGTELsn(vlsn);
    }

    public VLSNBucket getGTEBucket(VLSN vlsn, VLSNBucket currentBucketInUse) throws DatabaseException {
        VLSNBucket bucket = this.tracker.getGTEBucket(vlsn);
        if (bucket == null) {
            return this.getGTEBucketFromDatabase(vlsn, currentBucketInUse);
        }
        return bucket;
    }

    VLSNBucket getLTEBucket(VLSN vlsn) throws DatabaseException {
        VLSNBucket bucket = this.tracker.getLTEBucket(vlsn);
        if (bucket == null) {
            return this.getLTEBucketFromDatabase(vlsn);
        }
        return bucket;
    }

    private boolean isValidBucket(OperationStatus status, DatabaseEntry key) {
        return status == OperationStatus.SUCCESS && LongBinding.entryToLong(key) != -1L;
    }

    public VLSNBucket getLTEBucketFromDatabase(VLSN vlsn) throws DatabaseException {
        Cursor cursor = null;
        BasicLocker locker = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try {
            locker = BasicLocker.createBasicLocker(this.envImpl);
            cursor = this.makeCursor(locker);
            if (this.positionBeforeOrEqual(cursor, vlsn, key, data)) {
                VLSNBucket vLSNBucket = VLSNBucket.readFromDatabase(data);
                return vLSNBucket;
            }
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't find bucket for LTE VLSN " + vlsn + " in database. tracker=" + this.tracker);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd(true);
            }
        }
    }

    private VLSNBucket getGTEBucketFromDatabase(VLSN target, VLSNBucket currentBucketInUse) throws DatabaseException {
        Cursor cursor = null;
        BasicLocker locker = null;
        try {
            locker = BasicLocker.createBasicLocker(this.envImpl);
            cursor = this.makeCursor(locker);
            VLSNBucket bucket = this.examineGTEBucket(target, cursor);
            if (bucket != null) {
                VLSNBucket vLSNBucket = bucket;
                return vLSNBucket;
            }
            assert (TestHookExecute.doHookIfSet(this.searchGTEHook));
            VLSNBucket endBucket = null;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
            if (this.isValidBucket(status, key)) {
                endBucket = VLSNBucket.readFromDatabase(data);
                if (endBucket.owns(target)) {
                    VLSNBucket vLSNBucket = endBucket;
                    return vLSNBucket;
                }
                if (endBucket.follows(target) && (bucket = this.examineGTEBucket(target, cursor)) != null) {
                    VLSNBucket vLSNBucket = bucket;
                    return vLSNBucket;
                }
            }
            int count = 0;
            StringBuilder sb = new StringBuilder();
            status = cursor.getFirst(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                Long keyValue = LongBinding.entryToLong(key);
                sb.append("key => " + keyValue + "\n");
                if (count == 0) {
                    VLSNRange range = VLSNRange.readFromDatabase(data);
                    sb.append("range =>" + range + "\n");
                } else {
                    bucket = VLSNBucket.readFromDatabase(data);
                    sb.append("bucket => " + bucket + "\n");
                }
                ++count;
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
            LoggerUtils.severe(this.logger, this.envImpl, "VLSNIndex Dump: " + sb.toString());
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't find bucket for GTE VLSN " + target + " in database. EndBucket=" + endBucket + "currentBucket=" + currentBucketInUse + " tracker = " + this.tracker);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd(true);
            }
        }
    }

    private VLSNBucket examineGTEBucket(VLSN target, Cursor cursor) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        LongBinding.longToEntry(target.getSequence(), key);
        OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            VLSNBucket prevBucket;
            VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
            if (bucket.owns(target)) {
                return bucket;
            }
            status = cursor.getPrev(key, data, LockMode.DEFAULT);
            if (this.isValidBucket(status, key) && (prevBucket = VLSNBucket.readFromDatabase(data)).owns(target)) {
                return prevBucket;
            }
            return bucket;
        }
        return null;
    }

    private boolean positionBeforeOrEqual(Cursor cursor, VLSN vlsn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        LongBinding.longToEntry(vlsn.getSequence(), key);
        VLSNBucket bucket = null;
        OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            bucket = VLSNBucket.readFromDatabase(data);
            if (bucket.owns(vlsn)) {
                return true;
            }
            status = cursor.getPrev(key, data, LockMode.DEFAULT);
            return this.isValidBucket(status, key);
        }
        status = cursor.getLast(key, data, LockMode.DEFAULT);
        return this.isValidBucket(status, key);
    }

    private boolean positionAfterOrEqual(Cursor cursor, VLSN vlsn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        LongBinding.longToEntry(vlsn.getSequence(), key);
        VLSNBucket bucket = null;
        OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            bucket = VLSNBucket.readFromDatabase(data);
            if (bucket.owns(vlsn)) {
                return true;
            }
            status = cursor.getPrev(key, data, LockMode.DEFAULT);
            assert (status == OperationStatus.SUCCESS);
            if (this.isValidBucket(status, key) && (bucket = VLSNBucket.readFromDatabase(data)).owns(vlsn)) {
                return true;
            }
            status = cursor.getNext(key, data, LockMode.DEFAULT);
            return true;
        }
        status = cursor.getLast(key, data, LockMode.DEFAULT);
        return this.isValidBucket(status, key) && (bucket = VLSNBucket.readFromDatabase(data)).owns(vlsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneDatabaseHead(VLSN deleteEnd, long deleteFileNum, Txn txn) throws DatabaseException {
        try (Cursor cursor = null;){
            long keyValue;
            cursor = this.makeCursor(txn);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            if (!this.positionBeforeOrEqual(cursor, deleteEnd, key, data)) {
                return;
            }
            DatabaseEntry noData = new DatabaseEntry();
            noData.setPartial(0, 0, true);
            int deleteCount = 0;
            while ((keyValue = LongBinding.entryToLong(key)) != -1L) {
                OperationStatus status = cursor.delete();
                ++deleteCount;
                if (status != OperationStatus.SUCCESS) {
                    throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't delete, got status of " + (Object)((Object)status) + " for delete of bucket " + keyValue + " deleteEnd=" + deleteEnd);
                }
                if (cursor.getPrev(key, noData, LockMode.DEFAULT) == OperationStatus.SUCCESS) continue;
            }
            this.nHeadBucketsDeleted.add(deleteCount);
            VLSN newStart = deleteEnd.getNext();
            LongBinding.longToEntry(1L, key);
            OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                return;
            }
            VLSNBucket firstBucket = VLSNBucket.readFromDatabase(data);
            if (firstBucket.getFirst().equals(newStart)) {
                return;
            }
            if (firstBucket.getFirst().compareTo(newStart) < 0) {
                throw EnvironmentFailureException.unexpectedState(this.envImpl, "newStart " + newStart + " should be < first bucket:" + firstBucket);
            }
            long nextFile = this.envImpl.getFileManager().getFollowingFileNum(deleteFileNum, true);
            long lastPossibleLsn = firstBucket.getLsn(firstBucket.getFirst());
            GhostBucket placeholder = new GhostBucket(newStart, DbLsn.makeLsn(nextFile, 0), lastPossibleLsn);
            placeholder.writeToDatabase(this.envImpl, cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VLSN pruneDatabaseTail(VLSN deleteStart, long lastLsn, Txn txn) throws DatabaseException {
        VLSN lastOnDiskVLSN = this.tracker.getLastOnDisk();
        try (Cursor cursor = null;){
            OperationStatus status;
            cursor = this.makeCursor(txn);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            if (!this.positionAfterOrEqual(cursor, deleteStart, key, data)) {
                VLSN vLSN = lastOnDiskVLSN;
                return vLSN;
            }
            VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
            if (bucket.getFirst().compareTo(deleteStart) < 0) {
                bucket.removeFromTail(deleteStart, lastLsn);
                lastOnDiskVLSN = bucket.getLast();
                bucket.fillDataEntry(data);
                OperationStatus status2 = cursor.putCurrent(data);
                if (status2 != OperationStatus.SUCCESS) {
                    throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't update " + bucket);
                }
                status2 = cursor.getNext(key, data, LockMode.DEFAULT);
                if (status2 != OperationStatus.SUCCESS) {
                    VLSN vLSN = lastOnDiskVLSN;
                    return vLSN;
                }
            }
            DatabaseEntry noData = new DatabaseEntry();
            noData.setPartial(0, 0, true);
            int deleteCount = 0;
            do {
                if ((status = cursor.delete()) != OperationStatus.SUCCESS) {
                    throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't delete after vlsn " + deleteStart + " status=" + (Object)((Object)status));
                }
                ++deleteCount;
            } while (cursor.getNext(key, noData, LockMode.DEFAULT) == OperationStatus.SUCCESS);
            this.nTailBucketsDeleted.add(deleteCount);
            status = cursor.getLast(key, data, LockMode.DEFAULT);
            if (this.isValidBucket(status, key)) {
                bucket = VLSNBucket.readFromDatabase(data);
                lastOnDiskVLSN = bucket.getLast();
            } else {
                lastOnDiskVLSN = VLSN.NULL_VLSN;
            }
        }
        return lastOnDiskVLSN;
    }

    private void init(String mappingDbName, int vlsnStride, int vlsnMaxMappings, int vlsnMaxDistance, RecoveryInfo recoveryInfo) throws DatabaseException {
        this.openMappingDatabase(mappingDbName);
        this.tracker = new VLSNTracker(this.envImpl, this.mappingDbImpl, vlsnStride, vlsnMaxMappings, vlsnMaxDistance, this.statistics);
        this.merge((VLSNRecoveryTracker)recoveryInfo.vlsnProxy);
        VLSNRange range = this.tracker.getRange();
        if (!range.isEmpty()) {
            long firstFile = this.getLTEFileNumber(range.getFirst());
            this.tracker.initProtectedFileRange(firstFile);
        }
        if (!recoveryInfo.lastMissingFileVLSN.isNull()) {
            this.truncateFromHead(recoveryInfo.lastMissingFileVLSN, recoveryInfo.lastMissingFileNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(VLSNRecoveryTracker recoveryTracker) {
        if (recoveryTracker == null) {
            this.flushToDatabase(Durability.COMMIT_SYNC);
            return;
        }
        if (recoveryTracker.isEmpty()) {
            VLSN lastMatchpointVLSN = recoveryTracker.getLastMatchpointVLSN();
            if (lastMatchpointVLSN.isNull()) {
                return;
            }
            recoveryTracker.track(lastMatchpointVLSN, recoveryTracker.getLastMatchpointLsn(), LogEntryType.LOG_MATCHPOINT.getTypeNum());
        }
        VLSN persistentLast = this.tracker.getRange().getLast();
        VLSN recoveryFirst = recoveryTracker.getRange().getFirst();
        if (!(this.envImpl.isRepConverted() && persistentLast.isNull() && this.envImpl.isRepConverted() || recoveryFirst.compareTo(persistentLast.getNext()) <= 0)) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "recoveryTracker should overlap or follow on disk last VLSN of " + persistentLast + " recoveryFirst= " + recoveryFirst);
        }
        VLSNRange currentRange = this.tracker.getRange();
        if (currentRange.getLast().getNext().equals(recoveryFirst)) {
            this.tracker.append(recoveryTracker);
            this.flushToDatabase(Durability.COMMIT_SYNC);
            return;
        }
        TransactionConfig config = new TransactionConfig();
        config.setDurability(Durability.COMMIT_SYNC);
        Txn txn = Txn.createLocalTxn(this.envImpl, config);
        boolean success = false;
        try {
            VLSN lastOnDiskVLSN = this.pruneDatabaseTail(recoveryFirst, -1L, txn);
            this.tracker.merge(lastOnDiskVLSN, recoveryTracker);
            this.flushToDatabase(txn);
            txn.commit();
            success = true;
        }
        finally {
            if (!success) {
                txn.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMappingDatabase(String mappingDbName) throws DatabaseException {
        Txn locker = Txn.createLocalAutoTxn(this.envImpl, new TransactionConfig());
        try {
            DbTree dbTree = this.envImpl.getDbTree();
            DatabaseImpl db = dbTree.getDb(locker, mappingDbName, null, false);
            if (db == null) {
                if (this.envImpl.isReadOnly()) {
                    throw EnvironmentFailureException.unexpectedState("A replicated environment can't be opened read only.");
                }
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setReplicated(false);
                db = dbTree.createInternalDb(locker, mappingDbName, dbConfig);
            }
            this.mappingDbImpl = db;
        }
        finally {
            ((Locker)locker).operationEnd(true);
        }
    }

    public synchronized void close() {
        this.close(true);
    }

    public synchronized void abnormalClose() {
        this.close(false);
    }

    public void close(boolean doFlush) throws DatabaseException {
        try {
            if (doFlush) {
                this.flushToDatabase(Durability.COMMIT_SYNC);
            }
            if (this.vlsnPutLatch != null) {
                this.vlsnPutLatch.terminate();
                LoggerUtils.fine(this.logger, this.envImpl, "Outstanding VLSN put latch cleared at close");
            }
        }
        finally {
            if (this.mappingDbImpl != null) {
                this.envImpl.getDbTree().releaseDb(this.mappingDbImpl);
                this.mappingDbImpl = null;
            }
            this.tracker.close();
        }
    }

    public DatabaseImpl getDatabaseImpl() {
        return this.mappingDbImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushToDatabase(Durability useDurability) {
        TransactionConfig config = new TransactionConfig();
        config.setDurability(useDurability);
        Txn txn = Txn.createLocalTxn(this.envImpl, config);
        boolean success = false;
        try {
            this.flushToDatabase(txn);
            txn.commit();
            success = true;
        }
        finally {
            if (!success) {
                txn.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushToDatabase(Txn txn) throws DatabaseException {
        Object object = this.flushSynchronizer;
        synchronized (object) {
            this.tracker.flushToDatabase(this.mappingDbImpl, txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<VLSN, Long> dumpDb(boolean display) {
        Cursor cursor = null;
        BasicLocker locker = null;
        if (display) {
            System.out.println(this.tracker);
        }
        HashMap<VLSN, Long> mappings = new HashMap<VLSN, Long>();
        try {
            locker = BasicLocker.createBasicLocker(this.envImpl);
            cursor = this.makeCursor(locker);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            int count = 0;
            while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                Long keyValue = LongBinding.entryToLong(key);
                if (display) {
                    System.out.println("key => " + keyValue);
                }
                if (count == 0) {
                    VLSNRange range = VLSNRange.readFromDatabase(data);
                    if (display) {
                        System.out.println("range =>");
                        System.out.println(range);
                    }
                } else {
                    VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
                    for (long i = bucket.getFirst().getSequence(); i <= bucket.getLast().getSequence(); ++i) {
                        VLSN v = new VLSN(i);
                        long lsn = bucket.getLsn(v);
                        if (lsn == -1L) continue;
                        mappings.put(v, lsn);
                    }
                    if (display) {
                        System.out.println("bucket =>");
                        bucket.dump(System.out);
                    }
                }
                ++count;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd(true);
            }
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyDb(Environment env, PrintStream out, boolean verbose) throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(true);
        Database db = env.openDatabase(null, DbType.VLSN_MAP.getInternalName(), dbConfig);
        Cursor cursor = null;
        try {
            if (verbose) {
                System.out.println("Verifying VLSN index");
            }
            cursor = db.openCursor(null, CursorConfig.READ_COMMITTED);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            int count = 0;
            VLSNRange range = null;
            VLSNBucket lastBucket = null;
            Long lastKey = null;
            VLSN firstVLSNSeen = VLSN.NULL_VLSN;
            VLSN lastVLSNSeen = VLSN.NULL_VLSN;
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Long keyValue = LongBinding.entryToLong(key);
                if (count == 0) {
                    if (keyValue != -1L) {
                        out.println("Wrong key value for range! " + range);
                    }
                    range = VLSNRange.readFromDatabase(data);
                    if (verbose) {
                        out.println("range=>" + range);
                    }
                } else {
                    VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
                    if (verbose) {
                        out.print("key=> " + keyValue);
                        out.println(" bucket=>" + bucket);
                    }
                    if (lastBucket != null && lastBucket.getLast().compareTo(bucket.getFirst()) >= 0) {
                        out.println("Buckets out of order.");
                        out.println("Last = " + lastKey + "/" + lastBucket);
                        out.println("Current = " + keyValue + "/" + bucket);
                    }
                    lastBucket = bucket;
                    lastKey = keyValue;
                    if (firstVLSNSeen != null && firstVLSNSeen.isNull()) {
                        firstVLSNSeen = bucket.getFirst();
                    }
                    lastVLSNSeen = bucket.getLast();
                }
                ++count;
            }
            if (count == 0) {
                out.println("VLSNIndex not on disk");
                return;
            }
            if (firstVLSNSeen.compareTo(range.getFirst()) != 0) {
                out.println("First VLSN in bucket = " + firstVLSNSeen + " and doesn't match range " + range.getFirst());
            }
            if (lastVLSNSeen.compareTo(range.getLast()) != 0) {
                out.println("Last VLSN in bucket = " + lastVLSNSeen + " and doesn't match range " + range.getLast());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean verify(boolean verbose) throws DatabaseException {
        if (!this.tracker.verify(verbose)) {
            return false;
        }
        VLSNRange dbRange = null;
        ArrayList<VLSN> firstVLSN = new ArrayList<VLSN>();
        ArrayList<VLSN> lastVLSN = new ArrayList<VLSN>();
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl);
        Cursor cursor = null;
        Object object = this.flushSynchronizer;
        synchronized (object) {
            try {
                cursor = this.makeCursor(locker);
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    VLSNRange.VLSNRangeBinding rangeBinding = new VLSNRange.VLSNRangeBinding();
                    dbRange = (VLSNRange)rangeBinding.entryToObject(data);
                    while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                        VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
                        Long keyValue = LongBinding.entryToLong(key);
                        if (bucket.getFirst().getSequence() != keyValue.longValue()) {
                            boolean bl = false;
                            return bl;
                        }
                        firstVLSN.add(bucket.getFirst());
                        lastVLSN.add(bucket.getLast());
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                ((Locker)locker).operationEnd(true);
            }
            VLSNRange trackerRange = this.tracker.getRange();
            if (!trackerRange.verifySubset(verbose, dbRange)) {
                return false;
            }
        }
        VLSN firstTracked = this.tracker.getFirstTracked();
        VLSN firstOnDisk = null;
        VLSN lastOnDisk = null;
        if (firstVLSN.size() <= 0) return true;
        lastOnDisk = (VLSN)lastVLSN.get(lastVLSN.size() - 1);
        firstOnDisk = (VLSN)firstVLSN.get(0);
        if (!VLSNTracker.verifyBucketBoundaries(firstVLSN, lastVLSN)) {
            return false;
        }
        if (dbRange.getFirst().compareTo(firstOnDisk) != 0) {
            this.dumpMsg(verbose, "Range doesn't match buckets " + dbRange + " firstOnDisk = " + firstOnDisk);
            return false;
        }
        if (!lastOnDisk.equals(this.tracker.getLastOnDisk())) {
            this.dumpMsg(verbose, "lastOnDisk=" + lastOnDisk + " tracker=" + this.tracker.getLastOnDisk());
            return false;
        }
        if (!firstTracked.equals(VLSN.NULL_VLSN) && firstTracked.compareTo(lastOnDisk.getNext()) < 0) {
            this.dumpMsg(verbose, "lastOnDisk=" + lastOnDisk + " firstTracked=" + firstTracked);
            return false;
        }
        return true;
    }

    private void dumpMsg(boolean verbose, String msg) {
        if (verbose) {
            System.out.println(msg);
        }
    }

    public boolean isFlushedToDisk() {
        return this.tracker.isFlushedToDisk();
    }

    public void awaitConsistency() {
        if (this.nextVLSNCounter == null && this.replicaLatestVLSNSeq == -1L) {
            return;
        }
        VLSN vlsnAllocatedBeforeCkpt = null;
        while (true) {
            if (vlsnAllocatedBeforeCkpt == null) {
                vlsnAllocatedBeforeCkpt = new VLSN(this.getLatestAllocatedVal());
            } else {
                VLSN latestAllocated = new VLSN(this.getLatestAllocatedVal());
                if (latestAllocated.compareTo(vlsnAllocatedBeforeCkpt) < 0) {
                    LoggerUtils.info(this.logger, this.envImpl, "Reducing awaitConsistency VLSN from " + vlsnAllocatedBeforeCkpt + " to " + latestAllocated);
                    vlsnAllocatedBeforeCkpt = latestAllocated;
                }
            }
            VLSN endOfRangePlusOne = this.tracker.getRange().getLast().getNext();
            if (vlsnAllocatedBeforeCkpt.compareTo(endOfRangePlusOne) < 0) break;
            if (this.logger.isLoggable(Level.FINE)) {
                LoggerUtils.fine(this.logger, this.envImpl, "awaitConsistency target=" + endOfRangePlusOne + " allocatedBeforeCkpt=" + vlsnAllocatedBeforeCkpt);
            }
            try {
                this.waitForVLSN(endOfRangePlusOne, AWAIT_CONSISTENCY_MS);
                if (endOfRangePlusOne.compareTo(vlsnAllocatedBeforeCkpt) >= 0) {
                    break;
                }
            }
            catch (WaitTimeOutException e) {
                LoggerUtils.severe(this.logger, this.envImpl, "Retrying for vlsn index consistency  before checkpoint, awaiting vlsn " + endOfRangePlusOne + " with ckpt consistency target of " + vlsnAllocatedBeforeCkpt);
            }
            catch (InterruptedException e) {
                LoggerUtils.severe(this.logger, this.envImpl, "Interrupted while awaiting vlsn index consistency before checkpoint, awaiting vlsn " + endOfRangePlusOne + " with ckpt consistency target of " + vlsnAllocatedBeforeCkpt + ", will retry");
            }
            this.envImpl.checkIfInvalid();
        }
    }

    void setGTEHook(TestHook<?> hook) {
        this.searchGTEHook = hook;
    }

    private Cursor makeCursor(Locker locker) {
        Cursor cursor = DbInternal.makeCursor(this.mappingDbImpl, locker, CursorConfig.DEFAULT);
        DbInternal.getCursorImpl(cursor).setAllowEviction(false);
        return cursor;
    }

    public static class WaitTimeOutException
    extends Exception {
        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class VLSNAwaitLatch
    extends CountDownLatch {
        private LogItem logItem = null;
        private boolean terminated = false;

        public VLSNAwaitLatch() {
            super(1);
        }

        public long getTriggerLSN() {
            return this.logItem.lsn;
        }

        public VLSN getTriggerVLSN() {
            return this.logItem.header.getVLSN();
        }

        public void setLogItem(LogItem logItem) {
            this.logItem = logItem;
        }

        public LogItem getLogItem() {
            return this.logItem;
        }

        public void terminate() {
            this.terminated = true;
            this.countDown();
        }

        public boolean isTerminated() {
            return this.terminated;
        }
    }

    public static class ForwardVLSNScanner
    extends VLSNScanner {
        public ForwardVLSNScanner(VLSNIndex vlsnIndex) {
            super(vlsnIndex);
        }

        @Override
        public long getStartingLsn(VLSN vlsn) {
            ++this.startingLsnInvocations;
            this.currentBucket = this.vlsnIndex.getLTEBucket(vlsn);
            return this.currentBucket.getLTELsn(vlsn);
        }

        @Override
        public long getPreciseLsn(VLSN vlsn) {
            return this.getLsn(vlsn, false);
        }

        public long getApproximateLsn(VLSN vlsn) {
            return this.getLsn(vlsn, true);
        }

        private long getLsn(VLSN vlsn, boolean approximate) {
            assert (this.startingLsnInvocations == 1) : "startingLsns() called " + this.startingLsnInvocations + " times";
            VLSNBucket debugBucket = this.currentBucket;
            if (this.currentBucket != null && !this.currentBucket.owns(vlsn)) {
                if (this.currentBucket.follows(vlsn)) {
                    return approximate ? this.findPrevLsn(vlsn) : -1L;
                }
                this.currentBucket = null;
            }
            if (this.currentBucket == null) {
                this.currentBucket = this.vlsnIndex.getGTEBucket(vlsn, debugBucket);
                if (!this.currentBucket.owns(vlsn)) {
                    return approximate ? this.findPrevLsn(vlsn) : -1L;
                }
            }
            assert (this.currentBucket.owns(vlsn)) : "vlsn = " + vlsn + " currentBucket=" + this.currentBucket;
            if (approximate) {
                return this.currentBucket.getLTELsn(vlsn);
            }
            return this.currentBucket.getLsn(vlsn);
        }

        private long findPrevLsn(VLSN target) {
            VLSNBucket prevBucket = this.vlsnIndex.getLTEBucket(target);
            assert (!prevBucket.owns(target)) : "target=" + target + "prevBucket=" + prevBucket + " currentBucket=" + this.currentBucket;
            return prevBucket.getLastLsn();
        }
    }

    public static class BackwardVLSNScanner
    extends VLSNScanner {
        public BackwardVLSNScanner(VLSNIndex vlsnIndex) {
            super(vlsnIndex);
        }

        @Override
        public long getStartingLsn(VLSN vlsn) {
            ++this.startingLsnInvocations;
            this.currentBucket = this.vlsnIndex.getGTEBucket(vlsn, null);
            return this.currentBucket.getGTELsn(vlsn);
        }

        @Override
        public long getPreciseLsn(VLSN vlsn) {
            assert (this.startingLsnInvocations == 1) : "startingLsns() called " + this.startingLsnInvocations + " times";
            if (this.currentBucket != null && !this.currentBucket.owns(vlsn)) {
                if (this.currentBucket.precedes(vlsn)) {
                    return -1L;
                }
                this.currentBucket = null;
            }
            if (this.currentBucket == null) {
                this.currentBucket = this.vlsnIndex.getLTEBucket(vlsn);
                if (!this.currentBucket.owns(vlsn)) {
                    return -1L;
                }
            }
            assert (this.currentBucket.owns(vlsn)) : "vlsn = " + vlsn + " currentBucket=" + this.currentBucket;
            return this.currentBucket.getLsn(vlsn);
        }
    }

    private static abstract class VLSNScanner {
        VLSNBucket currentBucket;
        final VLSNIndex vlsnIndex;
        int startingLsnInvocations;

        VLSNScanner(VLSNIndex vlsnIndex) {
            this.vlsnIndex = vlsnIndex;
            this.startingLsnInvocations = 0;
        }

        public abstract long getStartingLsn(VLSN var1);

        public abstract long getPreciseLsn(VLSN var1);
    }
}

