/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class FreePortLocator {
    private static final boolean debug = Boolean.getBoolean("test.debugFreePortLocator");
    private final String hostname;
    private final int portStart;
    private final int portEnd;
    private int currPort;

    public FreePortLocator(String hostname, int portStart, int portEnd) {
        assert (portStart < portEnd);
        if (portStart > Short.MAX_VALUE || portEnd > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid port range:" + portStart + " - " + portEnd + ". The port range must not extend past:" + Short.MAX_VALUE + " since the allocated ports could then overlap with dynamically assigned ports used by other services. ");
        }
        this.hostname = hostname;
        this.portStart = portStart;
        this.portEnd = portEnd;
        this.currPort = portStart;
    }

    public int getPortStart() {
        return this.portStart;
    }

    public int getPortEnd() {
        return this.portEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int next() {
        while (++this.currPort < this.portEnd) {
            block36: {
                Socket s = null;
                try {
                    s = new Socket(this.hostname, this.currPort);
                    if (!debug) continue;
                    System.err.println("FreePortLocator: " + this.currPort + " busy - socket");
                    Thread.dumpStack();
                    continue;
                }
                catch (IOException e) {
                    if (s == null) break block36;
                    try {
                        s.close();
                    }
                    catch (IOException e2) {
                        if (!debug) continue;
                        System.err.println("FreePortLocator: " + this.currPort + " busy - socket close: " + e2);
                        e2.printStackTrace();
                        continue;
                    }
                }
                finally {
                    if (s == null) continue;
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        if (!debug) continue;
                        System.err.println("FreePortLocator: " + this.currPort + " busy - socket close: " + e);
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            ServerSocket ss = null;
            DatagramSocket ds = null;
            try {
                ss = new ServerSocket(this.currPort);
                ss.setReuseAddress(true);
                ds = new DatagramSocket(this.currPort);
                ds.setReuseAddress(true);
            }
            catch (IOException e) {
                if (!debug) continue;
                System.err.println("FreePortLocator: " + this.currPort + " busy - server, datagram: " + e);
                e.printStackTrace();
                continue;
            }
            finally {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) continue;
                try {
                    ss.close();
                }
                catch (IOException e) {
                    if (!debug) continue;
                    System.err.println("FreePortLocator: " + this.currPort + " busy - server close: " + e);
                    e.printStackTrace();
                }
                continue;
            }
            ss = null;
            ds = null;
            InetSocketAddress sa = new InetSocketAddress(this.hostname, this.currPort);
            try {
                ss = new ServerSocket();
                ss.setReuseAddress(true);
                ss.bind(sa);
                ds = new DatagramSocket(sa);
                ds.setReuseAddress(true);
            }
            catch (IOException e) {
                if (!debug) continue;
                System.err.println("FreePortLocator: " + this.currPort + " busy - server, datagram hostname: " + e);
                e.printStackTrace();
                continue;
            }
            finally {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) continue;
                try {
                    ss.close();
                }
                catch (IOException e) {
                    if (!debug) continue;
                    System.err.println("FreePortLocator: " + this.currPort + " busy - server hostname close: " + e);
                    e.printStackTrace();
                }
                continue;
            }
            if (debug) {
                System.err.println("FreePortLocator: " + this.currPort + " free");
            }
            return this.currPort;
        }
        throw new IllegalStateException("No more ports available in the range: " + this.portStart + " - " + this.portEnd);
    }

    public void skip(int num) {
        this.currPort += num;
    }
}

