/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.subscription;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.rep.subscription.SubscriptionStatDefinition;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;

public class SubscriptionStat {
    private VLSN startVLSN = VLSN.NULL_VLSN;
    private VLSN highVLSN;
    private DatabaseId partGenDBId = null;
    private final LongStat nReplayQueueOverflow;
    private final LongStat nMsgReceived;
    private final LongStat maxPendingInput;
    private final LongStat nMsgResponded;
    private final LongStat nOpsProcessed;
    private final LongStat nTxnAborted;
    private final LongStat nTxnCommitted;

    SubscriptionStat() {
        StatGroup stats = new StatGroup("subscription", "subscription statistics");
        this.nReplayQueueOverflow = new LongStat(stats, SubscriptionStatDefinition.SUB_N_REPLAY_QUEUE_OVERFLOW, 0L);
        this.nMsgReceived = new LongStat(stats, SubscriptionStatDefinition.SUB_MSG_RECEIVED, 0L);
        this.nMsgResponded = new LongStat(stats, SubscriptionStatDefinition.SUB_MSG_RESPONDED, 0L);
        this.maxPendingInput = new LongStat(stats, SubscriptionStatDefinition.SUB_MAX_PENDING_INPUT, 0L);
        this.nOpsProcessed = new LongStat(stats, SubscriptionStatDefinition.SUB_OPS_PROCESSED, 0L);
        this.nTxnAborted = new LongStat(stats, SubscriptionStatDefinition.SUB_TXN_ABORTED, 0L);
        this.nTxnCommitted = new LongStat(stats, SubscriptionStatDefinition.SUB_TXN_COMMITTED, 0L);
    }

    public synchronized LongStat getNumReplayQueueOverflow() {
        return this.nReplayQueueOverflow;
    }

    public synchronized LongStat getMaxPendingInput() {
        return this.maxPendingInput;
    }

    public synchronized LongStat getNumMsgResponded() {
        return this.nMsgResponded;
    }

    public synchronized LongStat getNumMsgReceived() {
        return this.nMsgReceived;
    }

    public synchronized LongStat getNumOpsProcessed() {
        return this.nOpsProcessed;
    }

    public synchronized LongStat getNumTxnAborted() {
        return this.nTxnAborted;
    }

    public synchronized LongStat getNumTxnCommitted() {
        return this.nTxnCommitted;
    }

    public synchronized VLSN getStartVLSN() {
        return this.startVLSN;
    }

    public synchronized VLSN getHighVLSN() {
        return this.highVLSN;
    }

    public synchronized DatabaseId getPartGenDBId() {
        return this.partGenDBId;
    }

    public synchronized void setStartVLSN(VLSN vlsn) {
        this.startVLSN = vlsn;
    }

    public synchronized void setHighVLSN(VLSN vlsn) {
        this.highVLSN = vlsn;
    }

    public synchronized void setPartGenDBId(DatabaseId dbId) {
        this.partGenDBId = dbId;
    }
}

