/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jca.ra;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.XAEnvironment;
import com.sleepycat.je.jca.ra.JEConnection;
import com.sleepycat.je.jca.ra.JEConnectionMetaData;
import com.sleepycat.je.jca.ra.JELocalTransaction;
import com.sleepycat.je.jca.ra.JERequestInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class JEManagedConnection
implements ManagedConnection {
    private final ArrayList<ConnectionEventListener> listeners;
    private JEConnection conn;
    private XAEnvironment env;
    private JELocalTransaction savedLT;
    private TransactionConfig savedTransConfig;
    private final Map<String, Database> rwDatabaseHandleCache;
    private final Map<String, Database> roDatabaseHandleCache;
    private final Map<String, Database> rwSecondaryDatabaseHandleCache;
    private final Map<String, Database> roSecondaryDatabaseHandleCache;

    JEManagedConnection(Subject subject, JERequestInfo jeInfo) throws ResourceException {
        try {
            this.savedTransConfig = jeInfo.getTransactionConfig();
            this.env = new XAEnvironment(jeInfo.getJERootDir(), jeInfo.getEnvConfig());
        }
        catch (DatabaseException DE) {
            throw new ResourceException(DE.toString());
        }
        this.listeners = new ArrayList();
        this.savedLT = null;
        this.rwDatabaseHandleCache = new HashMap<String, Database>();
        this.roDatabaseHandleCache = new HashMap<String, Database>();
        this.rwSecondaryDatabaseHandleCache = new HashMap<String, Database>();
        this.roSecondaryDatabaseHandleCache = new HashMap<String, Database>();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) {
        if (this.conn == null) {
            this.conn = new JEConnection(this);
        }
        return this.conn;
    }

    protected XAEnvironment getEnvironment() {
        return this.env;
    }

    public LocalTransaction getLocalTransaction() {
        if (this.conn == null) {
            this.savedLT = new JELocalTransaction(this.env, this.savedTransConfig, this);
            return this.savedLT;
        }
        JELocalTransaction lt = this.conn.getLocalTransaction();
        if (lt == null) {
            lt = this.savedLT == null ? new JELocalTransaction(this.env, this.savedTransConfig, this) : this.savedLT;
            this.conn.setLocalTransaction(lt);
            this.savedLT = null;
        }
        return lt;
    }

    public XAResource getXAResource() {
        return this.env;
    }

    public void associateConnection(Object connection) {
        this.conn = (JEConnection)connection;
        this.conn.setManagedConnection(this, this.savedLT);
        this.savedLT = null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public ManagedConnectionMetaData getMetaData() {
        return new JEConnectionMetaData();
    }

    public void setLogWriter(PrintWriter out) {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    protected void close() {
        ConnectionEvent connEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connEvent.setConnectionHandle((Object)this.conn);
        this.sendConnectionEvent(connEvent);
    }

    protected void sendConnectionEvent(ConnectionEvent connEvent) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ConnectionEventListener listener = this.listeners.get(i);
            if (connEvent.getId() == 1) {
                listener.connectionClosed(connEvent);
                continue;
            }
            if (connEvent.getId() == 5) {
                listener.connectionErrorOccurred(connEvent);
                continue;
            }
            if (connEvent.getId() == 2) {
                listener.localTransactionStarted(connEvent);
                continue;
            }
            if (connEvent.getId() == 3) {
                listener.localTransactionCommitted(connEvent);
                continue;
            }
            if (connEvent.getId() != 4) continue;
            listener.localTransactionRolledback(connEvent);
        }
    }

    public void destroy() throws ResourceException {
        try {
            this.cleanupDatabaseHandleCache(this.roDatabaseHandleCache);
            this.cleanupDatabaseHandleCache(this.rwDatabaseHandleCache);
            this.cleanupDatabaseHandleCache(this.roSecondaryDatabaseHandleCache);
            this.cleanupDatabaseHandleCache(this.rwSecondaryDatabaseHandleCache);
            this.env.close();
        }
        catch (DatabaseException DE) {
            throw new ResourceException(DE.toString());
        }
    }

    public void cleanup() {
    }

    void removeDatabase(String dbName) throws DatabaseException {
        this.removeDatabaseFromCache(this.roDatabaseHandleCache, dbName);
        this.removeDatabaseFromCache(this.rwDatabaseHandleCache, dbName);
        this.removeDatabaseFromCache(this.roSecondaryDatabaseHandleCache, dbName);
        this.removeDatabaseFromCache(this.rwSecondaryDatabaseHandleCache, dbName);
        this.env.removeDatabase(null, dbName);
    }

    long truncateDatabase(String dbName, boolean returnCount) throws DatabaseException {
        this.removeDatabaseFromCache(this.roDatabaseHandleCache, dbName);
        this.removeDatabaseFromCache(this.rwDatabaseHandleCache, dbName);
        this.removeDatabaseFromCache(this.roSecondaryDatabaseHandleCache, dbName);
        this.removeDatabaseFromCache(this.rwSecondaryDatabaseHandleCache, dbName);
        return this.env.truncateDatabase(null, dbName, returnCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Database openDatabase(String dbName, DatabaseConfig config) throws DatabaseException {
        if (config.getReadOnly()) {
            Map<String, Database> map = this.roDatabaseHandleCache;
            synchronized (map) {
                return this.openDatabaseInternal(this.roDatabaseHandleCache, dbName, config);
            }
        }
        Map<String, Database> map = this.rwDatabaseHandleCache;
        synchronized (map) {
            return this.openDatabaseInternal(this.rwDatabaseHandleCache, dbName, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecondaryDatabase openSecondaryDatabase(String dbName, Database primaryDatabase, SecondaryConfig config) throws DatabaseException {
        if (config.getReadOnly()) {
            Map<String, Database> map = this.roSecondaryDatabaseHandleCache;
            synchronized (map) {
                return this.openSecondaryDatabaseInternal(this.roSecondaryDatabaseHandleCache, dbName, primaryDatabase, config);
            }
        }
        Map<String, Database> map = this.rwSecondaryDatabaseHandleCache;
        synchronized (map) {
            return this.openSecondaryDatabaseInternal(this.rwSecondaryDatabaseHandleCache, dbName, primaryDatabase, config);
        }
    }

    private Database openDatabaseInternal(Map<String, Database> databaseHandleCache, String dbName, DatabaseConfig config) throws DatabaseException {
        Database db;
        if (config.getExclusiveCreate()) {
            db = this.env.openDatabase(null, dbName, config);
            databaseHandleCache.put(dbName, db);
        } else {
            db = databaseHandleCache.get(dbName);
            if (db == null) {
                db = this.env.openDatabase(null, dbName, config);
                databaseHandleCache.put(dbName, db);
            } else {
                DbInternal.validate(config, db.getConfig());
            }
        }
        return db;
    }

    private SecondaryDatabase openSecondaryDatabaseInternal(Map<String, Database> databaseHandleCache, String dbName, Database primaryDatabase, SecondaryConfig config) throws DatabaseException {
        SecondaryDatabase db;
        if (config.getExclusiveCreate()) {
            db = this.env.openSecondaryDatabase(null, dbName, primaryDatabase, config);
            databaseHandleCache.put(dbName, db);
        } else {
            db = (SecondaryDatabase)databaseHandleCache.get(dbName);
            if (db == null) {
                db = this.env.openSecondaryDatabase(null, dbName, primaryDatabase, config);
                databaseHandleCache.put(dbName, db);
            } else {
                DbInternal.validate(config, db.getConfig());
            }
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatabaseFromCache(Map<String, Database> cache, String dbName) throws DatabaseException {
        Map<String, Database> map = cache;
        synchronized (map) {
            Database db = cache.get(dbName);
            if (db == null) {
                return;
            }
            db.close();
            cache.remove(dbName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDatabaseHandleCache(Map<String, Database> cache) throws DatabaseException {
        Map<String, Database> map = cache;
        synchronized (map) {
            for (Database db : cache.values()) {
                db.close();
            }
        }
    }
}

