/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jca.ra;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.XAEnvironment;
import com.sleepycat.je.jca.ra.JEManagedConnection;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;

public class JELocalTransaction
implements javax.resource.cci.LocalTransaction,
LocalTransaction {
    private static boolean DEBUG = false;
    private transient XAEnvironment env;
    private transient TransactionConfig transConfig;
    private transient JEManagedConnection mgdConn;

    JELocalTransaction(XAEnvironment env, TransactionConfig transConfig, JEManagedConnection mgdConn) {
        this.env = env;
        this.transConfig = transConfig;
        this.mgdConn = mgdConn;
    }

    public Transaction getTransaction() throws DatabaseException {
        return this.env.getThreadTransaction();
    }

    protected XAEnvironment getEnv() {
        return this.env;
    }

    private void checkEnv(String methodName) throws ResourceException {
        if (this.env == null) {
            throw new ResourceException("env is null in " + methodName);
        }
    }

    public void begin() throws ResourceException {
        this.checkEnv("begin");
        long id = -1L;
        try {
            Transaction txn = this.env.beginTransaction(null, this.transConfig);
            this.env.setThreadTransaction(txn);
            id = txn.getId();
        }
        catch (DatabaseException DE) {
            throw new ResourceException("During begin: " + DE.toString());
        }
        ConnectionEvent connEvent = new ConnectionEvent((ManagedConnection)this.mgdConn, 2);
        connEvent.setConnectionHandle((Object)this.mgdConn);
        this.mgdConn.sendConnectionEvent(connEvent);
        if (DEBUG) {
            System.out.println("JELocalTransaction.begin " + id);
        }
    }

    public void commit() throws ResourceException {
        this.checkEnv("commit");
        try {
            this.env.getThreadTransaction().commit();
        }
        catch (DatabaseException DE) {
            ResourceException ret = new ResourceException(DE.toString());
            ret.initCause((Throwable)DE);
            throw ret;
        }
        finally {
            this.env.setThreadTransaction(null);
        }
        ConnectionEvent connEvent = new ConnectionEvent((ManagedConnection)this.mgdConn, 3);
        connEvent.setConnectionHandle((Object)this.mgdConn);
        this.mgdConn.sendConnectionEvent(connEvent);
        if (DEBUG) {
            System.out.println("JELocalTransaction.commit");
        }
    }

    public void rollback() throws ResourceException {
        this.checkEnv("rollback");
        try {
            this.env.getThreadTransaction().abort();
        }
        catch (DatabaseException DE) {
            ResourceException ret = new ResourceException(DE.toString());
            ret.initCause((Throwable)DE);
            throw ret;
        }
        finally {
            this.env.setThreadTransaction(null);
        }
        ConnectionEvent connEvent = new ConnectionEvent((ManagedConnection)this.mgdConn, 4);
        connEvent.setConnectionHandle((Object)this.mgdConn);
        this.mgdConn.sendConnectionEvent(connEvent);
        if (DEBUG) {
            System.out.println("JELocalTransaction.rollback");
        }
    }
}

