/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jca.ra;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.jca.ra.JEConnection;
import com.sleepycat.je.jca.ra.JEConnectionFactory;
import com.sleepycat.je.jca.ra.JEException;
import com.sleepycat.je.jca.ra.JERequestInfo;
import java.io.File;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class JEConnectionFactoryImpl
implements JEConnectionFactory {
    private static final long serialVersionUID = 410682596L;
    private final ConnectionManager manager;
    private final ManagedConnectionFactory factory;
    private Reference reference;

    public JEConnectionFactoryImpl(ConnectionManager manager, ManagedConnectionFactory factory) {
        this.manager = manager;
        this.factory = factory;
    }

    @Override
    public JEConnection getConnection(String jeRootDir, EnvironmentConfig envConfig) throws JEException {
        return this.getConnection(jeRootDir, envConfig, null);
    }

    @Override
    public JEConnection getConnection(String jeRootDir, EnvironmentConfig envConfig, TransactionConfig transConfig) throws JEException {
        JEConnection dc = null;
        JERequestInfo jeInfo = new JERequestInfo(new File(jeRootDir), envConfig, transConfig);
        try {
            dc = (JEConnection)this.manager.allocateConnection(this.factory, (ConnectionRequestInfo)jeInfo);
        }
        catch (ResourceException e) {
            throw new JEException("Unable to get Connection: " + (Object)((Object)e));
        }
        return dc;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }
}

