/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jca.ra;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.jca.ra.JELocalTransaction;
import com.sleepycat.je.jca.ra.JEManagedConnection;
import java.io.Closeable;
import javax.resource.ResourceException;

public class JEConnection
implements Closeable {
    private JEManagedConnection mc;
    private JELocalTransaction txn;

    public JEConnection(JEManagedConnection mc) {
        this.mc = mc;
    }

    protected void setManagedConnection(JEManagedConnection mc, JELocalTransaction lt) {
        this.mc = mc;
        if (this.txn == null) {
            this.txn = lt;
        }
    }

    JELocalTransaction getLocalTransaction() {
        return this.txn;
    }

    void setLocalTransaction(JELocalTransaction txn) {
        this.txn = txn;
    }

    public Environment getEnvironment() {
        return this.mc.getEnvironment();
    }

    public Database openDatabase(String name, DatabaseConfig config) throws DatabaseException {
        return this.mc.openDatabase(name, config);
    }

    public SecondaryDatabase openSecondaryDatabase(String name, Database primaryDatabase, SecondaryConfig config) throws DatabaseException {
        return this.mc.openSecondaryDatabase(name, primaryDatabase, config);
    }

    public void removeDatabase(String databaseName) throws DatabaseException {
        this.mc.removeDatabase(databaseName);
    }

    public long truncateDatabase(String databaseName, boolean returnCount) throws DatabaseException {
        return this.mc.truncateDatabase(databaseName, returnCount);
    }

    public Transaction getTransaction() throws ResourceException {
        if (this.txn == null) {
            return null;
        }
        try {
            return this.txn.getTransaction();
        }
        catch (DatabaseException DE) {
            ResourceException ret = new ResourceException(DE.toString());
            ret.initCause((Throwable)DE);
            throw ret;
        }
    }

    @Override
    public void close() {
        this.mc.close();
    }
}

