/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroCustomOrderSchemaVisitor;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class BuildAvroProjection
extends AvroCustomOrderSchemaVisitor<org.apache.avro.Schema, Schema.Field> {
    private final Map<String, String> renames;
    private Type current = null;

    BuildAvroProjection(Schema expectedSchema, Map<String, String> renames) {
        this.renames = renames;
        this.current = expectedSchema.asStruct();
    }

    @Override
    public org.apache.avro.Schema record(org.apache.avro.Schema record, List<String> names, Iterable<Schema.Field> schemaIterable) {
        Preconditions.checkArgument((this.current.isNestedType() && this.current.asNestedType().isStructType() ? 1 : 0) != 0, (String)"Cannot project non-struct: %s", (Object)this.current);
        Types.StructType struct = this.current.asNestedType().asStructType();
        boolean hasChange = false;
        List fields = record.getFields();
        ArrayList fieldResults = Lists.newArrayList(schemaIterable);
        HashMap updateMap = Maps.newHashMap();
        for (int i = 0; i < fields.size(); ++i) {
            Schema.Field field = (Schema.Field)fields.get(i);
            Schema.Field updatedField = (Schema.Field)fieldResults.get(i);
            if (updatedField != null) {
                updateMap.put(updatedField.name(), updatedField);
                if (updatedField.schema().equals((Object)field.schema()) && updatedField.name().equals(field.name())) continue;
                hasChange = true;
                continue;
            }
            hasChange = true;
        }
        ArrayList updatedFields = Lists.newArrayListWithExpectedSize((int)struct.fields().size());
        List expectedFields = struct.fields();
        for (int i = 0; i < expectedFields.size(); ++i) {
            Schema.Field avroField;
            Types.NestedField field = (Types.NestedField)expectedFields.get(i);
            if (i < fields.size() && !field.name().equals(((Schema.Field)fields.get(i)).name())) {
                hasChange = true;
            }
            if ((avroField = (Schema.Field)updateMap.get(AvroSchemaUtil.makeCompatibleName(field.name()))) != null) {
                updatedFields.add(avroField);
                continue;
            }
            Preconditions.checkArgument((field.isOptional() || MetadataColumns.metadataFieldIds().contains(field.fieldId()) ? 1 : 0) != 0, (String)"Missing required field: %s", (Object)field.name());
            Schema.Field newField = new Schema.Field(field.name() + "_r" + field.fieldId(), AvroSchemaUtil.toOption(AvroSchemaUtil.convert(field.type())), null, (Object)JsonProperties.NULL_VALUE);
            newField.addProp("field-id", (Object)field.fieldId());
            updatedFields.add(newField);
            hasChange = true;
        }
        if (hasChange || this.renames.containsKey(record.getFullName())) {
            return AvroSchemaUtil.copyRecord(record, updatedFields, this.renames.get(record.getFullName()));
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema.Field field(Schema.Field field, Supplier<org.apache.avro.Schema> fieldResult) {
        int fieldId;
        Types.StructType struct = this.current.asNestedType().asStructType();
        Types.NestedField expectedField = struct.field(fieldId = AvroSchemaUtil.getFieldId(field));
        if (expectedField == null) {
            return null;
        }
        String expectedName = expectedField.name();
        this.current = expectedField.type();
        try {
            org.apache.avro.Schema schema = fieldResult.get();
            if (!Objects.equals(schema, field.schema()) || !expectedName.equals(field.name())) {
                Schema.Field field2 = AvroSchemaUtil.copyField(field, schema, AvroSchemaUtil.makeCompatibleName(expectedName));
                return field2;
            }
            Schema.Field field3 = AvroSchemaUtil.copyField(field, field.schema(), field.name());
            return field3;
        }
        finally {
            this.current = struct;
        }
    }

    @Override
    public org.apache.avro.Schema union(org.apache.avro.Schema union, Iterable<org.apache.avro.Schema> options) {
        Preconditions.checkState((boolean)AvroSchemaUtil.isOptionSchema(union), (String)"Invalid schema: non-option unions are not supported: %s", (Object)union);
        org.apache.avro.Schema nonNullOriginal = AvroSchemaUtil.fromOption(union);
        org.apache.avro.Schema nonNullResult = AvroSchemaUtil.fromOptions(Lists.newArrayList(options));
        if (!Objects.equals(nonNullOriginal, nonNullResult)) {
            return AvroSchemaUtil.toOption(nonNullResult);
        }
        return union;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.apache.avro.Schema array(org.apache.avro.Schema array, Supplier<org.apache.avro.Schema> element) {
        if (array.getLogicalType() instanceof LogicalMap || this.current.isMapType() && AvroSchemaUtil.isKeyValueSchema(array.getElementType())) {
            Preconditions.checkArgument((boolean)this.current.isMapType(), (String)"Incompatible projected type: %s", (Object)this.current);
            Types.MapType asMapType = this.current.asNestedType().asMapType();
            this.current = Types.StructType.of((List)asMapType.fields());
            try {
                org.apache.avro.Schema keyValueSchema = array.getElementType();
                Schema.Field keyField = (Schema.Field)keyValueSchema.getFields().get(0);
                Schema.Field valueField = (Schema.Field)keyValueSchema.getFields().get(1);
                Schema.Field valueProjection = element.get().getField("value");
                if (!Objects.equals(valueProjection.schema(), valueField.schema())) {
                    org.apache.avro.Schema schema = AvroSchemaUtil.createProjectionMap(keyValueSchema.getFullName(), AvroSchemaUtil.getFieldId(keyField), keyField.name(), keyField.schema(), AvroSchemaUtil.getFieldId(valueField), valueField.name(), valueProjection.schema());
                    return schema;
                }
                if (!(array.getLogicalType() instanceof LogicalMap)) {
                    org.apache.avro.Schema schema = AvroSchemaUtil.createProjectionMap(keyValueSchema.getFullName(), AvroSchemaUtil.getFieldId(keyField), keyField.name(), keyField.schema(), AvroSchemaUtil.getFieldId(valueField), valueField.name(), valueField.schema());
                    return schema;
                }
                org.apache.avro.Schema schema = array;
                return schema;
            }
            finally {
                this.current = asMapType;
            }
        }
        Preconditions.checkArgument((boolean)this.current.isListType(), (String)"Incompatible projected type: %s", (Object)this.current);
        Types.ListType list = this.current.asNestedType().asListType();
        this.current = list.elementType();
        try {
            org.apache.avro.Schema elementSchema = element.get();
            if (!Objects.equals(elementSchema, array.getElementType())) {
                org.apache.avro.Schema schema = org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementSchema);
                return schema;
            }
            org.apache.avro.Schema schema = array;
            return schema;
        }
        finally {
            this.current = list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.apache.avro.Schema map(org.apache.avro.Schema map, Supplier<org.apache.avro.Schema> value) {
        Preconditions.checkArgument((this.current.isNestedType() && this.current.asNestedType().isMapType() ? 1 : 0) != 0, (String)"Incompatible projected type: %s", (Object)this.current);
        Types.MapType asMapType = this.current.asNestedType().asMapType();
        Preconditions.checkArgument((asMapType.keyType() == Types.StringType.get() ? 1 : 0) != 0, (String)"Incompatible projected type: key type %s is not string", (Object)asMapType.keyType());
        this.current = asMapType.valueType();
        try {
            org.apache.avro.Schema valueSchema = value.get();
            if (!Objects.equals(valueSchema, map.getValueType())) {
                org.apache.avro.Schema schema = org.apache.avro.Schema.createMap((org.apache.avro.Schema)valueSchema);
                return schema;
            }
            org.apache.avro.Schema schema = map;
            return schema;
        }
        finally {
            this.current = asMapType;
        }
    }

    @Override
    public org.apache.avro.Schema primitive(org.apache.avro.Schema primitive) {
        switch (primitive.getType()) {
            case INT: {
                if (this.current.typeId() == Type.TypeID.LONG) {
                    return org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG);
                }
                return primitive;
            }
            case FLOAT: {
                if (this.current.typeId() == Type.TypeID.DOUBLE) {
                    return org.apache.avro.Schema.create((Schema.Type)Schema.Type.DOUBLE);
                }
                return primitive;
            }
        }
        return primitive;
    }
}

