/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.ListMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.iceberg.util.Tasks;

class DeleteFileIndex {
    private final Map<Integer, PartitionSpec> specsById;
    private final Map<Integer, Types.StructType> partitionTypeById;
    private final Map<Integer, ThreadLocal<StructLikeWrapper>> wrapperById;
    private final long[] globalSeqs;
    private final DeleteFile[] globalDeletes;
    private final Map<Pair<Integer, StructLikeWrapper>, Pair<long[], DeleteFile[]>> sortedDeletesByPartition;

    DeleteFileIndex(Map<Integer, PartitionSpec> specsById, long[] globalSeqs, DeleteFile[] globalDeletes, Map<Pair<Integer, StructLikeWrapper>, Pair<long[], DeleteFile[]>> sortedDeletesByPartition) {
        this.specsById = specsById;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        specsById.forEach((specId, spec) -> builder.put(specId, (Object)spec.partitionType()));
        this.partitionTypeById = builder.build();
        this.wrapperById = Maps.newConcurrentMap();
        this.globalSeqs = globalSeqs;
        this.globalDeletes = globalDeletes;
        this.sortedDeletesByPartition = sortedDeletesByPartition;
    }

    public boolean isEmpty() {
        return (this.globalDeletes == null || this.globalDeletes.length == 0) && this.sortedDeletesByPartition.isEmpty();
    }

    private StructLikeWrapper newWrapper(int specId) {
        return StructLikeWrapper.forType(this.partitionTypeById.get(specId));
    }

    private Pair<Integer, StructLikeWrapper> partition(int specId, StructLike struct) {
        ThreadLocal wrapper = this.wrapperById.computeIfAbsent(specId, id -> ThreadLocal.withInitial(() -> this.newWrapper((int)id)));
        return Pair.of(specId, ((StructLikeWrapper)wrapper.get()).set(struct));
    }

    DeleteFile[] forEntry(ManifestEntry<DataFile> entry) {
        return this.forDataFile(entry.sequenceNumber(), entry.file());
    }

    DeleteFile[] forDataFile(long sequenceNumber, DataFile file) {
        Pair<Integer, StructLikeWrapper> partition = this.partition(file.specId(), file.partition());
        Pair<long[], DeleteFile[]> partitionDeletes = this.sortedDeletesByPartition.get(partition);
        Stream<DeleteFile> matchingDeletes = partitionDeletes == null ? DeleteFileIndex.limitBySequenceNumber(sequenceNumber, this.globalSeqs, this.globalDeletes) : (this.globalDeletes == null ? DeleteFileIndex.limitBySequenceNumber(sequenceNumber, partitionDeletes.first(), partitionDeletes.second()) : Stream.concat(DeleteFileIndex.limitBySequenceNumber(sequenceNumber, this.globalSeqs, this.globalDeletes), DeleteFileIndex.limitBySequenceNumber(sequenceNumber, partitionDeletes.first(), partitionDeletes.second())));
        return (DeleteFile[])matchingDeletes.filter(deleteFile -> DeleteFileIndex.canContainDeletesForFile(file, deleteFile, this.specsById.get(file.specId()).schema())).toArray(DeleteFile[]::new);
    }

    private static boolean canContainDeletesForFile(DataFile dataFile, DeleteFile deleteFile, Schema schema) {
        switch (deleteFile.content()) {
            case POSITION_DELETES: {
                return DeleteFileIndex.canContainPosDeletesForFile(dataFile, deleteFile);
            }
            case EQUALITY_DELETES: {
                return DeleteFileIndex.canContainEqDeletesForFile(dataFile, deleteFile, schema);
            }
        }
        return true;
    }

    private static boolean canContainPosDeletesForFile(DataFile dataFile, DeleteFile deleteFile) {
        Map lowers = deleteFile.lowerBounds();
        Map uppers = deleteFile.upperBounds();
        if (lowers == null || uppers == null) {
            return true;
        }
        Type pathType = MetadataColumns.DELETE_FILE_PATH.type();
        int pathId = MetadataColumns.DELETE_FILE_PATH.fieldId();
        Comparator comparator = Comparators.charSequences();
        ByteBuffer lower = (ByteBuffer)lowers.get(pathId);
        if (lower != null && comparator.compare(dataFile.path(), (CharSequence)Conversions.fromByteBuffer((Type)pathType, (ByteBuffer)lower)) < 0) {
            return false;
        }
        ByteBuffer upper = (ByteBuffer)uppers.get(pathId);
        return upper == null || comparator.compare(dataFile.path(), (CharSequence)Conversions.fromByteBuffer((Type)pathType, (ByteBuffer)upper)) <= 0;
    }

    private static boolean canContainEqDeletesForFile(DataFile dataFile, DeleteFile deleteFile, Schema schema) {
        boolean checkRanges = dataFile.lowerBounds() != null && dataFile.upperBounds() != null && deleteFile.lowerBounds() != null && deleteFile.upperBounds() != null;
        Map dataLowers = dataFile.lowerBounds();
        Map dataUppers = dataFile.upperBounds();
        Map deleteLowers = deleteFile.lowerBounds();
        Map deleteUppers = deleteFile.upperBounds();
        Map dataNullCounts = dataFile.nullValueCounts();
        Map dataValueCounts = dataFile.valueCounts();
        Map deleteNullCounts = deleteFile.nullValueCounts();
        Map deleteValueCounts = deleteFile.valueCounts();
        Iterator iterator = deleteFile.equalityFieldIds().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            Types.NestedField field = schema.findField(id);
            if (!field.type().isPrimitiveType() || DeleteFileIndex.containsNull(dataNullCounts, field) && DeleteFileIndex.containsNull(deleteNullCounts, field)) continue;
            if (DeleteFileIndex.allNull(dataNullCounts, dataValueCounts, field) && DeleteFileIndex.allNonNull(deleteNullCounts, field)) {
                return false;
            }
            if (DeleteFileIndex.allNull(deleteNullCounts, deleteValueCounts, field) && DeleteFileIndex.allNonNull(dataNullCounts, field)) {
                return false;
            }
            if (!checkRanges) continue;
            ByteBuffer dataLower = (ByteBuffer)dataLowers.get(id);
            ByteBuffer dataUpper = (ByteBuffer)dataUppers.get(id);
            ByteBuffer deleteLower = (ByteBuffer)deleteLowers.get(id);
            ByteBuffer deleteUpper = (ByteBuffer)deleteUppers.get(id);
            if (dataLower == null || dataUpper == null || deleteLower == null || deleteUpper == null || DeleteFileIndex.rangesOverlap(field.type().asPrimitiveType(), dataLower, dataUpper, deleteLower, deleteUpper)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean rangesOverlap(Type.PrimitiveType type, ByteBuffer dataLowerBuf, ByteBuffer dataUpperBuf, ByteBuffer deleteLowerBuf, ByteBuffer deleteUpperBuf) {
        Comparator comparator = Comparators.forType((Type.PrimitiveType)type);
        Object dataLower = Conversions.fromByteBuffer((Type)type, (ByteBuffer)dataLowerBuf);
        Object dataUpper = Conversions.fromByteBuffer((Type)type, (ByteBuffer)dataUpperBuf);
        Object deleteLower = Conversions.fromByteBuffer((Type)type, (ByteBuffer)deleteLowerBuf);
        Object deleteUpper = Conversions.fromByteBuffer((Type)type, (ByteBuffer)deleteUpperBuf);
        return comparator.compare(deleteLower, dataUpper) <= 0 && comparator.compare(dataLower, deleteUpper) <= 0;
    }

    private static boolean allNonNull(Map<Integer, Long> nullValueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return true;
        }
        if (nullValueCounts == null) {
            return false;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        if (nullValueCount == null) {
            return false;
        }
        return nullValueCount <= 0L;
    }

    private static boolean allNull(Map<Integer, Long> nullValueCounts, Map<Integer, Long> valueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return false;
        }
        if (nullValueCounts == null || valueCounts == null) {
            return false;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        Long valueCount = valueCounts.get(field.fieldId());
        if (nullValueCount == null || valueCount == null) {
            return false;
        }
        return nullValueCount.equals(valueCount);
    }

    private static boolean containsNull(Map<Integer, Long> nullValueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return false;
        }
        if (nullValueCounts == null) {
            return true;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        if (nullValueCount == null) {
            return true;
        }
        return nullValueCount > 0L;
    }

    private static Stream<DeleteFile> limitBySequenceNumber(long sequenceNumber, long[] seqs, DeleteFile[] files) {
        int start;
        if (files == null) {
            return Stream.empty();
        }
        int pos = Arrays.binarySearch(seqs, sequenceNumber);
        if (pos < 0) {
            start = -(pos + 1);
        } else {
            for (start = pos; start > 0 && seqs[start - 1] >= sequenceNumber; --start) {
            }
        }
        return Arrays.stream(files, start, files.length);
    }

    static Builder builderFor(FileIO io, Iterable<ManifestFile> deleteManifests) {
        return new Builder(io, Sets.newHashSet(deleteManifests));
    }

    static class Builder {
        private final FileIO io;
        private final Set<ManifestFile> deleteManifests;
        private long minSequenceNumber = 0L;
        private Map<Integer, PartitionSpec> specsById = null;
        private Expression dataFilter = Expressions.alwaysTrue();
        private Expression partitionFilter = Expressions.alwaysTrue();
        private boolean caseSensitive = true;
        private ExecutorService executorService = null;

        Builder(FileIO io, Set<ManifestFile> deleteManifests) {
            this.io = io;
            this.deleteManifests = Sets.newHashSet(deleteManifests);
        }

        Builder afterSequenceNumber(long seq) {
            this.minSequenceNumber = seq;
            return this;
        }

        Builder specsById(Map<Integer, PartitionSpec> newSpecsById) {
            this.specsById = newSpecsById;
            return this;
        }

        Builder filterData(Expression newDataFilter) {
            this.dataFilter = Expressions.and((Expression)this.dataFilter, (Expression)newDataFilter);
            return this;
        }

        Builder filterPartitions(Expression newPartitionFilter) {
            this.partitionFilter = Expressions.and((Expression)this.partitionFilter, (Expression)newPartitionFilter);
            return this;
        }

        Builder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        Builder planWith(ExecutorService newExecutorService) {
            this.executorService = newExecutorService;
            return this;
        }

        DeleteFileIndex build() {
            ConcurrentLinkedQueue deleteEntries = new ConcurrentLinkedQueue();
            Tasks.foreach(this.deleteManifestReaders()).stopOnFailure().throwFailureWhenFinished().executeWith(this.executorService).run(deleteFile -> {
                try (CloseableIterable reader = deleteFile;){
                    for (ManifestEntry entry : reader) {
                        if (entry.sequenceNumber() <= this.minSequenceNumber) continue;
                        deleteEntries.add(entry.copy());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close", new Object[0]);
                }
            });
            ListMultimap deleteFilesByPartition = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
            for (ManifestEntry entry2 : deleteEntries) {
                int specId = ((DeleteFile)entry2.file()).specId();
                StructLikeWrapper wrapper = StructLikeWrapper.forType(this.specsById.get(specId).partitionType()).set(((DeleteFile)entry2.file()).partition());
                deleteFilesByPartition.put(Pair.of(specId, wrapper), (Object)entry2);
            }
            HashMap sortedDeletesByPartition = Maps.newHashMap();
            long[] globalApplySeqs = null;
            DeleteFile[] globalDeletes = null;
            for (Pair partition : deleteFilesByPartition.keySet()) {
                if (this.specsById.get(partition.first()).isUnpartitioned()) {
                    Preconditions.checkState((globalDeletes == null ? 1 : 0) != 0, (Object)"Detected multiple partition specs with no partitions");
                    List eqFilesSortedBySeq = deleteFilesByPartition.get((Object)partition).stream().filter(entry -> ((DeleteFile)entry.file()).content() == FileContent.EQUALITY_DELETES).map(entry -> Pair.of(entry.sequenceNumber() - 1L, (DeleteFile)entry.file())).sorted(Comparator.comparingLong(Pair::first)).collect(Collectors.toList());
                    globalApplySeqs = eqFilesSortedBySeq.stream().mapToLong(Pair::first).toArray();
                    globalDeletes = (DeleteFile[])eqFilesSortedBySeq.stream().map(Pair::second).toArray(DeleteFile[]::new);
                    List posFilesSortedBySeq = deleteFilesByPartition.get((Object)partition).stream().filter(entry -> ((DeleteFile)entry.file()).content() == FileContent.POSITION_DELETES).map(entry -> Pair.of(entry.sequenceNumber(), (DeleteFile)entry.file())).sorted(Comparator.comparingLong(Pair::first)).collect(Collectors.toList());
                    long[] seqs = posFilesSortedBySeq.stream().mapToLong(Pair::first).toArray();
                    DeleteFile[] files = (DeleteFile[])posFilesSortedBySeq.stream().map(Pair::second).toArray(DeleteFile[]::new);
                    sortedDeletesByPartition.put(partition, Pair.of(seqs, files));
                    continue;
                }
                List filesSortedBySeq = deleteFilesByPartition.get((Object)partition).stream().map(entry -> {
                    long applySeq = entry.sequenceNumber() - (long)(((DeleteFile)entry.file()).content() == FileContent.EQUALITY_DELETES ? 1 : 0);
                    return Pair.of(applySeq, (DeleteFile)entry.file());
                }).sorted(Comparator.comparingLong(Pair::first)).collect(Collectors.toList());
                long[] seqs = filesSortedBySeq.stream().mapToLong(Pair::first).toArray();
                DeleteFile[] files = (DeleteFile[])filesSortedBySeq.stream().map(Pair::second).toArray(DeleteFile[]::new);
                sortedDeletesByPartition.put(partition, Pair.of(seqs, files));
            }
            return new DeleteFileIndex(this.specsById, globalApplySeqs, globalDeletes, sortedDeletesByPartition);
        }

        private Iterable<CloseableIterable<ManifestEntry<DeleteFile>>> deleteManifestReaders() {
            LoadingCache evalCache = this.specsById == null ? null : Caffeine.newBuilder().build(specId -> {
                PartitionSpec spec = this.specsById.get(specId);
                return ManifestEvaluator.forPartitionFilter((Expression)Expressions.and((Expression)this.partitionFilter, (Expression)Projections.inclusive((PartitionSpec)spec, (boolean)this.caseSensitive).project(this.dataFilter)), (PartitionSpec)spec, (boolean)this.caseSensitive);
            });
            Set<ManifestFile> matchingManifests = evalCache == null ? this.deleteManifests : Iterables.filter(this.deleteManifests, manifest -> manifest.content() == ManifestContent.DELETES && (manifest.hasAddedFiles() || manifest.hasDeletedFiles()) && ((ManifestEvaluator)evalCache.get((Object)manifest.partitionSpecId())).eval(manifest));
            return Iterables.transform(matchingManifests, manifest -> ManifestFiles.readDeleteManifest(manifest, this.io, this.specsById).filterRows(this.dataFilter).filterPartitions(this.partitionFilter).caseSensitive(this.caseSensitive).liveEntries());
        }
    }
}

