/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.BaseStreamingSink;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.sources.v2.StreamWriteSupport;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u0011#\u00015B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0007\u007f\u0001!\t\u0001\n!\t\u0011\u0011\u0003!\u0019!C\u0001I\u0015Caa\u0014\u0001!\u0002\u00131\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u0007-\u0002\u0001\u000b\u0011\u0002*\t\u000f]\u0003!\u0019!C\u00051\"1A\u000e\u0001Q\u0001\neCqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002?\t\u0011\u0005\u001d\u0001A1A\u0005\nmDq!!\u0003\u0001A\u0003%A\u0010C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003\u0002\u000e!I\u0011q\u0002\u0001A\u0002\u0013%\u0011\u0011\u0003\u0005\b\u0003;\u0001\u0001\u0015)\u0003j\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002.\u0001!\t!!\u000e\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011q\n\u0001\u0005\u0002\u0005]\u0005bBA[\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fD\u0001\"a3\u0001\t\u0003!\u0013Q\u001a\u0005\t\u0003#\u0004A\u0011\u0001\u0013\u0002T\"9\u0011q\u001d\u0001\u0005\n\u0005%\b\u0002\u0003B/\u0001\u0011\u0005AEa\u0018\t\u0015\tU\u0004!%A\u0005\u0002\u0011\u00129\b\u0003\u0006\u0003\f\u0002\t\n\u0011\"\u0001%\u0005oB!B!$\u0001#\u0003%\t\u0001\nBH\u0011)\u0011\u0019\nAI\u0001\n\u0003!#Q\u0013\u0005\t\u00053\u0003A\u0011\u0001\u0013\u0003\u001c\n)2\u000b\u001e:fC6LgnZ)vKJLX*\u00198bO\u0016\u0014(BA\u0012%\u0003%\u0019HO]3b[&twM\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b9\u001b\u00051$BA\u001c'\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001d7\u0005\u001daunZ4j]\u001e\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001P\u001f\u000e\u0003\u0011J!A\u0010\u0013\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\t\t5\t\u0005\u0002C\u00015\t!\u0005C\u0003;\u0005\u0001\u00071(A\u000bti\u0006$Xm\u0015;pe\u0016\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003\u0019\u0003\"aR'\u000e\u0003!S!!\u0013&\u0002\u000bM$\u0018\r^3\u000b\u0005\rZ%B\u0001'%\u0003%)\u00070Z2vi&|g.\u0003\u0002O\u0011\nA2\u000b^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014(+\u001a4\u0002-M$\u0018\r^3Ti>\u0014XmQ8pe\u0012Lg.\u0019;pe\u0002\n1\u0002\\5ti\u0016tWM\u001d\"vgV\t!\u000b\u0005\u0002T)6\t!*\u0003\u0002V\u0015\nI2\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'OQ;t\u00031a\u0017n\u001d;f]\u0016\u0014()^:!\u00035\t7\r^5wKF+XM]5fgV\t\u0011\f\u0005\u0003[?\u0006LW\"A.\u000b\u0005qk\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003=B\n!bY8mY\u0016\u001cG/[8o\u0013\t\u00017LA\u0004ICNDW*\u00199\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017\u0001B;uS2T\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iG\n!Q+V%E!\t\u0011%.\u0003\u0002lE\tq1\u000b\u001e:fC6LgnZ)vKJL\u0018AD1di&4X-U;fe&,7\u000f\t\u0015\u0005\u00119D\u0018\u0010\u0005\u0002pm6\t\u0001O\u0003\u0002re\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005M$\u0018AC1o]>$\u0018\r^5p]*\tQ/A\u0003kCZ\f\u00070\u0003\u0002xa\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0002u\u0006\t\u0012m\u0019;jm\u0016\fV/\u001a:jKNdunY6\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@f\u0003\u0011a\u0017M\\4\n\u0007\u0005\raP\u0001\u0004PE*,7\r^\u0001\u0013C\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:M_\u000e\\\u0007%\u0001\u000bbo\u0006LG\u000fV3s[&t\u0017\r^5p]2{7m[\u0001\u0016C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:dunY6!\u0003Ma\u0017m\u001d;UKJl\u0017N\\1uK\u0012\fV/\u001a:z+\u0005I\u0017a\u00067bgR$VM]7j]\u0006$X\rZ)vKJLx\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007=\n)\"C\u0002\u0002\u0018A\u0012A!\u00168ji\"A\u00111\u0004\b\u0002\u0002\u0003\u0007\u0011.A\u0002yIE\nA\u0003\\1tiR+'/\\5oCR,G-U;fef\u0004\u0003&B\boq\u0006\u0005\u0012EAA\u0004\u0003\u0019\t7\r^5wKV\u0011\u0011q\u0005\t\u0005_\u0005%\u0012.C\u0002\u0002,A\u0012Q!\u0011:sCf\f1aZ3u)\rI\u0017\u0011\u0007\u0005\u0007\u0003g\t\u0002\u0019A1\u0002\u0005%$GcA5\u00028!9\u00111\u0007\nA\u0002\u0005e\u0002\u0003BA\u001e\u0003\u0013rA!!\u0010\u0002FA\u0019\u0011q\b\u0019\u000e\u0005\u0005\u0005#bAA\"Y\u00051AH]8pizJ1!a\u00121\u0003\u0019\u0001&/\u001a3fM&!\u00111JA'\u0005\u0019\u0019FO]5oO*\u0019\u0011q\t\u0019\u0002'\u0005<\u0018-\u001b;B]f$VM]7j]\u0006$\u0018n\u001c8\u0015\u0005\u0005M\u0001&B\n\u0002V\u0005\u0005\u0004#B\u0018\u0002X\u0005m\u0013bAA-a\t1A\u000f\u001b:poN\u00042AQA/\u0013\r\tyF\t\u0002\u0018'R\u0014X-Y7j]\u001e\fV/\u001a:z\u000bb\u001cW\r\u001d;j_:\ftAHA\u001d\u0003G\n)*M\u0005$\u0003K\ni'a#\u0002pU!\u0011qMA5+\t\tI\u0004B\u0004\u0002l1\u0012\r!!\u001e\u0003\u0003QKA!a\u001c\u0002r\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!a\u001d1\u0003\u0019!\bN]8xgF!\u0011qOA?!\ry\u0013\u0011P\u0005\u0004\u0003w\u0002$a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u007f\n)ID\u00020\u0003\u0003K1!a!1\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\"\u0002\n\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u0007\u0003\u0014'C\u0012\u0002\u000e\u0006=\u0015\u0011SA:\u001d\ry\u0013qR\u0005\u0004\u0003g\u0002\u0014'\u0002\u00120a\u0005M%!B:dC2\f\u0017g\u0001\u0014\u0002\\Q!\u0011\u0011TAP!\ry\u00131T\u0005\u0004\u0003;\u0003$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003C#\u0002\u0019AAR\u0003%!\u0018.\\3pkRl5\u000fE\u00020\u0003KK1!a*1\u0005\u0011auN\\4)\u000bQ\t)&a+2\u000fy\tI$!,\u00024FJ1%!\u001a\u0002n\u0005=\u0016qN\u0019\nG\u00055\u0015qRAY\u0003g\nTAI\u00181\u0003'\u000b4AJA.\u0003=\u0011Xm]3u)\u0016\u0014X.\u001b8bi\u0016$\u0017aC1eI2K7\u000f^3oKJ$B!a\u0005\u0002<\"9\u0011Q\u0018\fA\u0002\u0005}\u0016\u0001\u00037jgR,g.\u001a:\u0011\u0007\t\u000b\t-C\u0002\u0002D\n\u0012ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0001\u000fe\u0016lwN^3MSN$XM\\3s)\u0011\t\u0019\"!3\t\u000f\u0005uv\u00031\u0001\u0002@\u0006iA.[:u\u0019&\u001cH/\u001a8feN$\"!a4\u0011\u000b=\nI#a0\u0002#A|7\u000f\u001e'jgR,g.\u001a:Fm\u0016tG\u000f\u0006\u0003\u0002\u0014\u0005U\u0007bBAl3\u0001\u0007\u0011\u0011\\\u0001\u0006KZ,g\u000e\u001e\t\u0005\u00037\f\tOD\u0002C\u0003;L1!a8#\u0003Y\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014\u0018\u0002BAr\u0003K\u0014Q!\u0012<f]RT1!a8#\u0003-\u0019'/Z1uKF+XM]=\u0015-\u0005-\u0018\u0011_A~\u0003\u007f\u0014yB!\u000b\u00034\tu\"\u0011\tB#\u0005\u001f\u00022aUAw\u0013\r\tyO\u0013\u0002\u0016'R\u0014X-Y7j]\u001e\fV/\u001a:z/J\f\u0007\u000f]3s\u0011\u001d\t\u0019P\u0007a\u0001\u0003k\f\u0011#^:feN\u0003XmY5gS\u0016$g*Y7f!\u0015y\u0013q_A\u001d\u0013\r\tI\u0010\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005u(\u00041\u0001\u0002v\u0006yRo]3s'B,7-\u001b4jK\u0012\u001c\u0005.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u000f\t\u0005!\u00041\u0001\u0003\u0004\u0005\u0011AM\u001a\t\u0005\u0005\u000b\u0011IB\u0004\u0003\u0003\b\t]a\u0002\u0002B\u0005\u0005+qAAa\u0003\u0003\u00149!!Q\u0002B\t\u001d\u0011\tyDa\u0004\n\u0003-J!!\u000b\u0016\n\u0005\u001dB\u0013BA\u0013'\u0013\r\t\u0019\tJ\u0005\u0005\u00057\u0011iBA\u0005ECR\fgI]1nK*\u0019\u00111\u0011\u0013\t\u000f\t\u0005\"\u00041\u0001\u0003$\u0005aQ\r\u001f;sC>\u0003H/[8ogBA\u00111\bB\u0013\u0003s\tI$\u0003\u0003\u0003(\u00055#aA'ba\"9!1\u0006\u000eA\u0002\t5\u0012\u0001B:j].\u00042a\u0015B\u0018\u0013\r\u0011\tD\u0013\u0002\u0012\u0005\u0006\u001cXm\u0015;sK\u0006l\u0017N\\4TS:\\\u0007b\u0002B\u001b5\u0001\u0007!qG\u0001\u000b_V$\b/\u001e;N_\u0012,\u0007c\u0001\"\u0003:%\u0019!1\b\u0012\u0003\u0015=+H\u000f];u\u001b>$W\rC\u0004\u0003@i\u0001\r!!'\u00023U\u001cX\rV3na\u000eCWmY6q_&tG\u000fT8dCRLwN\u001c\u0005\b\u0005\u0007R\u0002\u0019AAM\u0003u\u0011XmY8wKJ4%o\\7DQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007b\u0002B$5\u0001\u0007!\u0011J\u0001\biJLwmZ3s!\r\u0011%1J\u0005\u0004\u0005\u001b\u0012#a\u0002+sS\u001e<WM\u001d\u0005\b\u0005#R\u0002\u0019\u0001B*\u00031!(/[4hKJ\u001cEn\\2l!\u0011\u0011)F!\u0017\u000e\u0005\t]#B\u00013'\u0013\u0011\u0011YFa\u0016\u0003\u000b\rcwnY6\u0002\u0015M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010F\u000bj\u0005C\u0012\u0019G!\u001a\u0003h\t%$1\u000eB7\u0005_\u0012\tHa\u001d\t\u000f\u0005M8\u00041\u0001\u0002v\"9\u0011Q`\u000eA\u0002\u0005U\bb\u0002B\u00017\u0001\u0007!1\u0001\u0005\b\u0005CY\u0002\u0019\u0001B\u0012\u0011\u001d\u0011Yc\u0007a\u0001\u0005[AqA!\u000e\u001c\u0001\u0004\u00119\u0004C\u0005\u0003@m\u0001\n\u00111\u0001\u0002\u001a\"I!1I\u000e\u0011\u0002\u0003\u0007\u0011\u0011\u0014\u0005\n\u0005\u000fZ\u0002\u0013!a\u0001\u0005\u0013B\u0011B!\u0015\u001c!\u0003\u0005\rAa\u0015\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011IH\u000b\u0003\u0002\u001a\nm4F\u0001B?!\u0011\u0011yHa\"\u000e\u0005\t\u0005%\u0002\u0002BB\u0005\u000b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005M\u0004\u0014\u0002\u0002BE\u0005\u0003\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u0005!2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIe*\"A!%+\t\t%#1P\u0001\u0016gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000fJ\u00191+\t\u00119J\u000b\u0003\u0003T\tm\u0014A\u00068pi&4\u00170U;fef$VM]7j]\u0006$\u0018n\u001c8\u0015\t\u0005M!Q\u0014\u0005\u0007\u0005?\u0003\u0003\u0019A5\u0002\u001fQ,'/\\5oCR,G-U;fefD3\u0001\u0001BR!\u0011\u0011)Ka,\u000f\t\t\u001d&1V\u0007\u0003\u0005SS!a\u001d\u0014\n\t\t5&\u0011V\u0001\u0013\u0013:$XM\u001d4bG\u0016\u001cF/\u00192jY&$\u00180\u0003\u0003\u00032\nM&\u0001C#w_24\u0018N\\4\u000b\t\t5&\u0011\u0016")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private StreamingQuery lastTerminatedQuery;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesLock() {
        return this.activeQueriesLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private StreamingQuery lastTerminatedQuery() {
        return this.lastTerminatedQuery;
    }

    private void lastTerminatedQuery_$eq(StreamingQuery x$1) {
        this.lastTerminatedQuery = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.currentTimeMillis();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            bl = this.lastTerminatedQuery() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQuery_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.listenerBus().listeners()).asScala()).toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, BaseStreamingSink sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        Tuple2 tuple2;
        Path checkpointPath;
        FileSystem fs;
        BooleanRef deleteCheckpointOnStop = BooleanRef.create((boolean)false);
        String checkpointLocation = (String)userSpecifiedCheckpointLocation.map((Function1 & Serializable & scala.Serializable)userSpecified -> new Path(userSpecified).toUri().toString()).orElse((Function0 & Serializable & scala.Serializable)() -> df.sparkSession().sessionState().conf().checkpointLocation().map((Function1 & Serializable & scala.Serializable)location -> new Path(location, (String)userSpecifiedName.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())).toUri().toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (!useTempCheckpointLocation) {
                throw new AnalysisException(new StringBuilder(119).append("checkpointLocation must be specified either through option(\"checkpointLocation\", ...) or ").append("SparkSession.conf.set(\"").append(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).append("\", ...)").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            deleteCheckpointOnStop$1.elem = true;
            String x$1 = "temporary";
            String x$2 = Utils$.MODULE$.createTempDir$default$1();
            return Utils$.MODULE$.createTempDir(x$2, x$1).getCanonicalPath();
        });
        if (!recoverFromCheckpointLocation && (fs = (checkpointPath = new Path(checkpointLocation, "offsets")).getFileSystem(df.sparkSession().sessionState().newHadoopConf())).exists(checkpointPath)) {
            throw new AnalysisException(new StringBuilder(87).append("This query does not support recovering from checkpoint location. ").append("Delete ").append(checkpointPath).append(" to start over.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        if (this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled()) {
            UnsupportedOperationChecker$.MODULE$.checkForStreaming(analyzedPlan, outputMode);
        }
        if (this.sparkSession.sessionState().conf().adaptiveExecutionEnabled()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()).append(" ").append("is not supported in streaming DataFrames/Datasets and will be disabled.").toString());
        }
        if ((tuple2 = new Tuple2((Object)sink, (Object)trigger)) == null) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        BaseStreamingSink v2Sink = (BaseStreamingSink)tuple2._1();
        Trigger trigger2 = (Trigger)tuple2._2();
        if (!(v2Sink instanceof StreamWriteSupport)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        StreamWriteSupport streamWriteSupport = (StreamWriteSupport)v2Sink;
        if (!(trigger2 instanceof ContinuousTrigger)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
        if (!this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled()) return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, streamWriteSupport, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        UnsupportedOperationChecker$.MODULE$.checkForContinuous(analyzedPlan, outputMode);
        return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, streamWriteSupport, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
    }

    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, BaseStreamingSink sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock);
        Object object = this.activeQueriesLock();
        synchronized (object) {
            userSpecifiedName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            if (this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$3(query, x$2)))) {
                throw new IllegalStateException(new StringBuilder(162).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active.").toString());
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
        }
        catch (Throwable e) {
            Object object2 = this.activeQueriesLock();
            synchronized (object2) {
                this.activeQueries().$minus$eq((Object)query.id());
            }
            throw e;
        }
        return query;
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return new ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
        Object object2 = this.awaitTerminationLock();
        synchronized (object2) {
            if (this.lastTerminatedQuery() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQuery_$eq(terminatedQuery);
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    public static final /* synthetic */ void $anonfun$new$2(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$new$1(StreamingQueryManager $this, Seq classNames) {
        Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, $this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            StreamingQueryManager.$anonfun$new$2($this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.currentTimeMillis() - startTime$1 >= timeoutMs$1;
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot start query with name ").append(name).append(" as a query with that name is already active").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$3(StreamingQueryWrapper query$1, StreamingQuery x$2) {
        UUID uUID = x$2.id();
        UUID uUID2 = query$1.id();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus(sparkSession.sparkContext().listenerBus());
        this.activeQueries = new HashMap();
        this.activeQueriesLock = new Object();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQuery = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable & scala.Serializable)classNames -> {
                StreamingQueryManager.$anonfun$new$1(this, classNames);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new SparkException("Exception when registering StreamingQueryListener", (Throwable)e);
        }
    }
}

