/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor$;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0010!\u00016B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\r\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005U\u0001\tE\t\u0015!\u0003O\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0018\u0001!\u0002\u0013a\u0006\"\u00021\u0001\t\u0003\n\u0007\"B7\u0001\t\u0003q\u0007\"B9\u0001\t\u0003\u0011\bbB;\u0001\u0003\u0003%\tA\u001e\u0005\bs\u0002\t\n\u0011\"\u0001{\u0011%\tY\u0001AI\u0001\n\u0003\ti\u0001C\u0005\u0002\u0012\u0001\t\t\u0011\"\u0011\u0002\u0014!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003_\u0001\u0011\u0011!C\u0001\u0003cA\u0011\"!\u0010\u0001\u0003\u0003%\t%a\u0010\t\u0013\u00055\u0003!!A\u0005\u0002\u0005=\u0003\"CA*\u0001\u0005\u0005I\u0011IA+\u0011%\t9\u0006AA\u0001\n\u0003\nI\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0011\u0002^\u001dI\u0011\u0011\r\u0011\u0002\u0002#\u0005\u00111\r\u0004\t?\u0001\n\t\u0011#\u0001\u0002f!1Qk\u0006C\u0001\u0003gB\u0011\"a\u0016\u0018\u0003\u0003%)%!\u0017\t\u0013\u0005Ut#!A\u0005\u0002\u0006]\u0004\"CA?/E\u0005I\u0011AA\u0007\u0011%\tyhFA\u0001\n\u0003\u000b\t\tC\u0005\u0002\u0014^\t\n\u0011\"\u0001\u0002\u000e!I\u0011QS\f\u0002\u0002\u0013%\u0011q\u0013\u0002\u0017!J|7-Z:tS:<G+[7f\u000bb,7-\u001e;pe*\u0011\u0011EI\u0001\ngR\u0014X-Y7j]\u001eT!a\t\u0013\u0002\u0013\u0015DXmY;uS>t'BA\u0013'\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003O!\nQa\u001d9be.T!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sO\u000e\u00011C\u0002\u0001/iar\u0014\t\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kYj\u0011\u0001I\u0005\u0003o\u0001\u0012q\u0002\u0016:jO\u001e,'/\u0012=fGV$xN\u001d\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0019\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003{i\u0012q\u0001T8hO&tw\r\u0005\u00020\u007f%\u0011\u0001\t\r\u0002\b!J|G-^2u!\ty#)\u0003\u0002Da\ta1+\u001a:jC2L'0\u00192mK\u0006q\u0001O]8dKN\u001c\u0018N\\4US6,W#\u0001$\u0011\u0005\u001dKU\"\u0001%\u000b\u0005\u0005\"\u0013B\u0001&I\u00059\u0001&o\\2fgNLgn\u001a+j[\u0016\fq\u0002\u001d:pG\u0016\u001c8/\u001b8h)&lW\rI\u0001\u0006G2|7m[\u000b\u0002\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011KJ\u0001\u0005kRLG.\u0003\u0002T!\n)1\t\\8dW\u000611\r\\8dW\u0002\na\u0001P5oSRtDcA,Y3B\u0011Q\u0007\u0001\u0005\u0006\t\u0016\u0001\rA\u0012\u0005\b\u0019\u0016\u0001\n\u00111\u0001O\u0003)Ig\u000e^3sm\u0006dWj]\u000b\u00029B\u0011q&X\u0005\u0003=B\u0012A\u0001T8oO\u0006Y\u0011N\u001c;feZ\fG.T:!\u0003\u001d)\u00070Z2vi\u0016$\"AY3\u0011\u0005=\u001a\u0017B\u000131\u0005\u0011)f.\u001b;\t\u000b\u0019D\u0001\u0019A4\u0002\u001dQ\u0014\u0018nZ4fe\"\u000bg\u000e\u001a7feB\u0019q\u0006\u001b6\n\u0005%\u0004$!\u0003$v]\u000e$\u0018n\u001c81!\ty3.\u0003\u0002ma\t9!i\\8mK\u0006t\u0017\u0001\u00078pi&4\u0017PQ1uG\"4\u0015\r\u001c7j]\u001e\u0014U\r[5oIR\u0011!m\u001c\u0005\u0006a&\u0001\r\u0001X\u0001\u0012e\u0016\fG.\u00127baN,G\rV5nK6\u001b\u0018!\u00048fqR\u0014\u0015\r^2i)&lW\r\u0006\u0002]g\")AO\u0003a\u00019\u0006\u0019an\\<\u0002\t\r|\u0007/\u001f\u000b\u0004/^D\bb\u0002#\f!\u0003\u0005\rA\u0012\u0005\b\u0019.\u0001\n\u00111\u0001O\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001f\u0016\u0003\rr\\\u0013! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00021\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0013y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\bU\tqE0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0003mC:<'BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0002cA\u0018\u0002,%\u0019\u0011Q\u0006\u0019\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005M\u0012\u0011\b\t\u0004_\u0005U\u0012bAA\u001ca\t\u0019\u0011I\\=\t\u0013\u0005m\u0002#!AA\u0002\u0005%\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002BA1\u00111IA%\u0003gi!!!\u0012\u000b\u0007\u0005\u001d\u0003'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0013\u0002F\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rQ\u0017\u0011\u000b\u0005\n\u0003w\u0011\u0012\u0011!a\u0001\u0003g\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003S\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\ta!Z9vC2\u001cHc\u00016\u0002`!I\u00111H\u000b\u0002\u0002\u0003\u0007\u00111G\u0001\u0017!J|7-Z:tS:<G+[7f\u000bb,7-\u001e;peB\u0011QgF\n\u0005/\u0005\u001d\u0014\tE\u0004\u0002j\u0005=dIT,\u000e\u0005\u0005-$bAA7a\u00059!/\u001e8uS6,\u0017\u0002BA9\u0003W\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t\u0019'A\u0003baBd\u0017\u0010F\u0003X\u0003s\nY\bC\u0003E5\u0001\u0007a\tC\u0004M5A\u0005\t\u0019\u0001(\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0004\u0006=\u0005#B\u0018\u0002\u0006\u0006%\u0015bAADa\t1q\n\u001d;j_:\u0004RaLAF\r:K1!!$1\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u0013\u000f\u0002\u0002\u0003\u0007q+A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!'\u0011\t\u0005]\u00111T\u0005\u0005\u0003;\u000bIB\u0001\u0004PE*,7\r\u001e")
public class ProcessingTimeExecutor
implements TriggerExecutor,
Logging,
Product,
scala.Serializable {
    private final ProcessingTime processingTime;
    private final Clock clock;
    private final long intervalMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$2() {
        return ProcessingTimeExecutor$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<ProcessingTime, Clock>> unapply(ProcessingTimeExecutor processingTimeExecutor) {
        return ProcessingTimeExecutor$.MODULE$.unapply(processingTimeExecutor);
    }

    public static Clock apply$default$2() {
        return ProcessingTimeExecutor$.MODULE$.apply$default$2();
    }

    public static ProcessingTimeExecutor apply(ProcessingTime processingTime, Clock clock) {
        return ProcessingTimeExecutor$.MODULE$.apply(processingTime, clock);
    }

    public static Function1<Tuple2<ProcessingTime, Clock>, ProcessingTimeExecutor> tupled() {
        return ProcessingTimeExecutor$.MODULE$.tupled();
    }

    public static Function1<ProcessingTime, Function1<Clock, ProcessingTimeExecutor>> curried() {
        return ProcessingTimeExecutor$.MODULE$.curried();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ProcessingTime processingTime() {
        return this.processingTime;
    }

    public Clock clock() {
        return this.clock;
    }

    private long intervalMs() {
        return this.intervalMs;
    }

    @Override
    public void execute(Function0<Object> triggerHandler) {
        while (true) {
            Object object;
            boolean terminated;
            long triggerTimeMs = this.clock().getTimeMillis();
            long nextTriggerTimeMs = this.nextBatchTime(triggerTimeMs);
            boolean bl = terminated = !triggerHandler.apply$mcZ$sp();
            if (this.intervalMs() > 0L) {
                long batchElapsedTimeMs = this.clock().getTimeMillis() - triggerTimeMs;
                if (batchElapsedTimeMs > this.intervalMs()) {
                    this.notifyBatchFallingBehind(batchElapsedTimeMs);
                }
                if (terminated) {
                    return;
                }
                object = BoxesRunTime.boxToLong((long)this.clock().waitTillTime(nextTriggerTimeMs));
                continue;
            }
            if (terminated) {
                return;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void notifyBatchFallingBehind(long realElapsedTimeMs) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Current batch is falling behind. The trigger interval is ").append(this.intervalMs()).append(" milliseconds, but spent ").append(realElapsedTimeMs).append(" milliseconds").toString());
    }

    public long nextBatchTime(long now) {
        return this.intervalMs() == 0L ? now : now / this.intervalMs() * this.intervalMs() + this.intervalMs();
    }

    public ProcessingTimeExecutor copy(ProcessingTime processingTime, Clock clock) {
        return new ProcessingTimeExecutor(processingTime, clock);
    }

    public ProcessingTime copy$default$1() {
        return this.processingTime();
    }

    public Clock copy$default$2() {
        return this.clock();
    }

    public String productPrefix() {
        return "ProcessingTimeExecutor";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        ProcessingTime processingTime;
        int n = x$1;
        switch (n) {
            case 0: {
                processingTime = this.processingTime();
                break;
            }
            case 1: {
                processingTime = this.clock();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return processingTime;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcessingTimeExecutor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ProcessingTimeExecutor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ProcessingTimeExecutor processingTimeExecutor = (ProcessingTimeExecutor)x$1;
        ProcessingTime processingTime = this.processingTime();
        ProcessingTime processingTime2 = processingTimeExecutor.processingTime();
        if (processingTime == null) {
            if (processingTime2 != null) {
                return false;
            }
        } else if (!((Object)processingTime).equals(processingTime2)) return false;
        Clock clock = this.clock();
        Clock clock2 = processingTimeExecutor.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!clock.equals(clock2)) return false;
        if (!processingTimeExecutor.canEqual(this)) return false;
        return true;
    }

    public ProcessingTimeExecutor(ProcessingTime processingTime, Clock clock) {
        this.processingTime = processingTime;
        this.clock = clock;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.intervalMs = processingTime.intervalMs();
        Predef$.MODULE$.require(this.intervalMs() >= 0L);
    }
}

