/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;

public final class VectorizedRleValuesReader
extends ValuesReader
implements VectorizedValuesReader {
    private ByteBufferInputStream in;
    private int bitWidth;
    private int bytesWidth;
    private BytePacker packer;
    private MODE mode;
    private int currentCount;
    private int currentValue;
    private int[] currentBuffer = new int[16];
    private int currentBufferIdx = 0;
    private final boolean fixedWidth;
    private final boolean readLength;

    public VectorizedRleValuesReader() {
        this.fixedWidth = false;
        this.readLength = false;
    }

    public VectorizedRleValuesReader(int bitWidth) {
        this.fixedWidth = true;
        this.readLength = bitWidth != 0;
        this.init(bitWidth);
    }

    public VectorizedRleValuesReader(int bitWidth, boolean readLength) {
        this.fixedWidth = true;
        this.readLength = readLength;
        this.init(bitWidth);
    }

    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.in = in;
        if (this.fixedWidth) {
            if (this.readLength) {
                int length = this.readIntLittleEndian();
                this.in = in.sliceStream((long)length);
            }
        } else if (in.available() > 0) {
            this.init(in.read());
        }
        if (this.bitWidth == 0) {
            this.mode = MODE.RLE;
            this.currentCount = valueCount;
            this.currentValue = 0;
        } else {
            this.currentCount = 0;
        }
    }

    private void init(int bitWidth) {
        Preconditions.checkArgument((bitWidth >= 0 && bitWidth <= 32 ? 1 : 0) != 0, (String)"bitWidth must be >= 0 and <= 32");
        this.bitWidth = bitWidth;
        this.bytesWidth = BytesUtils.paddedByteCountFromBits((int)bitWidth);
        this.packer = Packer.LITTLE_ENDIAN.newBytePacker(bitWidth);
    }

    @Override
    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    public void skip() {
        this.readInteger();
    }

    public int readValueDictionaryId() {
        return this.readInteger();
    }

    @Override
    public int readInteger() {
        if (this.currentCount == 0) {
            this.readNextGroup();
        }
        --this.currentCount;
        switch (this.mode) {
            case RLE: {
                return this.currentValue;
            }
            case PACKED: {
                return this.currentBuffer[this.currentBufferIdx++];
            }
        }
        throw new RuntimeException("Unreachable");
    }

    public void readIntegers(int total, WritableColumnVector c, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readIntegers(n, c, rowId);
                        break;
                    }
                    c.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.putInt(rowId + i, data.readInteger());
                            continue;
                        }
                        c.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readBooleans(int total, WritableColumnVector c, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readBooleans(n, c, rowId);
                        break;
                    }
                    c.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.putBoolean(rowId + i, data.readBoolean());
                            continue;
                        }
                        c.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readBytes(int total, WritableColumnVector c, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readBytes(n, c, rowId);
                        break;
                    }
                    c.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.putByte(rowId + i, data.readByte());
                            continue;
                        }
                        c.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readShorts(int total, WritableColumnVector c, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    int i;
                    if (this.currentValue == level) {
                        for (i = 0; i < n; ++i) {
                            c.putShort(rowId + i, (short)data.readInteger());
                        }
                        break;
                    }
                    c.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    int i;
                    for (i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.putShort(rowId + i, (short)data.readInteger());
                            continue;
                        }
                        c.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readLongs(int total, WritableColumnVector c, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readLongs(n, c, rowId);
                        break;
                    }
                    c.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.putLong(rowId + i, data.readLong());
                            continue;
                        }
                        c.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readFloats(int total, WritableColumnVector c, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readFloats(n, c, rowId);
                        break;
                    }
                    c.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.putFloat(rowId + i, data.readFloat());
                            continue;
                        }
                        c.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readDoubles(int total, WritableColumnVector c, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readDoubles(n, c, rowId);
                        break;
                    }
                    c.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.putDouble(rowId + i, data.readDouble());
                            continue;
                        }
                        c.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readBinarys(int total, WritableColumnVector c, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readBinary(n, c, rowId);
                        break;
                    }
                    c.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            data.readBinary(1, c, rowId + i);
                            continue;
                        }
                        c.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readIntegers(int total, WritableColumnVector values, WritableColumnVector nulls, int rowId, int level, VectorizedValuesReader data) throws IOException {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readIntegers(n, values, rowId);
                        break;
                    }
                    nulls.putNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            values.putInt(rowId + i, data.readInteger());
                            continue;
                        }
                        nulls.putNull(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    @Override
    public void readIntegers(int total, WritableColumnVector c, int rowId) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    c.putInts(rowId, n, this.currentValue);
                    break;
                }
                case PACKED: {
                    c.putInts(rowId, n, this.currentBuffer, this.currentBufferIdx);
                    this.currentBufferIdx += n;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    @Override
    public byte readByte() {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBytes(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readLongs(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBinary(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBooleans(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readFloats(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readDoubles(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public Binary readBinary(int len) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    private int readUnsignedVarInt() throws IOException {
        int b;
        int value = 0;
        int shift = 0;
        do {
            b = this.in.read();
            value |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return value;
    }

    private int readIntLittleEndian() throws IOException {
        int ch4 = this.in.read();
        int ch3 = this.in.read();
        int ch2 = this.in.read();
        int ch1 = this.in.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private int readIntLittleEndianPaddedOnBitWidth() throws IOException {
        switch (this.bytesWidth) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.in.read();
            }
            case 2: {
                int ch2 = this.in.read();
                int ch1 = this.in.read();
                return (ch1 << 8) + ch2;
            }
            case 3: {
                int ch3 = this.in.read();
                int ch2 = this.in.read();
                int ch1 = this.in.read();
                return (ch1 << 16) + (ch2 << 8) + (ch3 << 0);
            }
            case 4: {
                return this.readIntLittleEndian();
            }
        }
        throw new RuntimeException("Unreachable");
    }

    private int ceil8(int value) {
        return (value + 7) / 8;
    }

    private void readNextGroup() {
        try {
            int header = this.readUnsignedVarInt();
            this.mode = (header & 1) == 0 ? MODE.RLE : MODE.PACKED;
            switch (this.mode) {
                case RLE: {
                    this.currentCount = header >>> 1;
                    this.currentValue = this.readIntLittleEndianPaddedOnBitWidth();
                    return;
                }
                case PACKED: {
                    int numGroups = header >>> 1;
                    this.currentCount = numGroups * 8;
                    if (this.currentBuffer.length < this.currentCount) {
                        this.currentBuffer = new int[this.currentCount];
                    }
                    this.currentBufferIdx = 0;
                    for (int valueIndex = 0; valueIndex < this.currentCount; valueIndex += 8) {
                        ByteBuffer buffer = this.in.slice(this.bitWidth);
                        this.packer.unpack8Values(buffer, buffer.position(), this.currentBuffer, valueIndex);
                    }
                    return;
                }
            }
            throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read from input stream", (Throwable)e);
        }
    }

    private static enum MODE {
        RLE,
        PACKED;

    }
}

