/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.thrift.TException;

public class CachedClientPool
implements ClientPool<HiveMetaStoreClient, TException> {
    private static Cache<String, HiveClientPool> clientPoolCache;
    private final Configuration conf;
    private final String metastoreUri;
    private final int clientPoolSize;
    private final long evictionInterval;

    CachedClientPool(Configuration conf, Map<String, String> properties) {
        this.conf = conf;
        this.metastoreUri = conf.get(HiveConf.ConfVars.METASTOREURIS.varname, "");
        this.clientPoolSize = PropertyUtil.propertyAsInt(properties, (String)"clients", (int)2);
        this.evictionInterval = PropertyUtil.propertyAsLong(properties, (String)"client.pool.cache.eviction-interval-ms", (long)CatalogProperties.CLIENT_POOL_CACHE_EVICTION_INTERVAL_MS_DEFAULT);
        this.init();
    }

    @VisibleForTesting
    HiveClientPool clientPool() {
        return (HiveClientPool)((Object)clientPoolCache.get((Object)this.metastoreUri, k -> new HiveClientPool(this.clientPoolSize, this.conf)));
    }

    private synchronized void init() {
        if (clientPoolCache == null) {
            clientPoolCache = Caffeine.newBuilder().expireAfterAccess(this.evictionInterval, TimeUnit.MILLISECONDS).removalListener((key, value, cause) -> ((HiveClientPool)((Object)((Object)value))).close()).build();
        }
    }

    @VisibleForTesting
    static Cache<String, HiveClientPool> clientPoolCache() {
        return clientPoolCache;
    }

    public <R> R run(ClientPool.Action<R, HiveMetaStoreClient, TException> action) throws TException, InterruptedException {
        return (R)this.clientPool().run(action);
    }
}

