/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.utils;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static String readFileFromOffset(String filename, int l, String charset) {
        return FileUtils.readFileFromOffset(filename, l, charset, 0x400000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileFromOffset(String filename, int l, String charset, int maxSize) {
        RandomAccessFile rf = null;
        StringBuilder res = new StringBuilder();
        try {
            rf = new RandomAccessFile(filename, "r");
            long fileLength = rf.length();
            long start = rf.getFilePointer();
            long readIndex = start + fileLength - 1L;
            long minIndex = readIndex - (long)maxSize;
            if (minIndex < 0L) {
                minIndex = 0L;
            }
            if (readIndex < 0L) {
                readIndex = 0L;
            }
            rf.seek(readIndex);
            int k = 0;
            int c = -1;
            String line = null;
            while (readIndex > start) {
                if (k == l) {
                    break;
                }
                c = rf.read();
                String readText = null;
                if (c == 10 || c == 13) {
                    line = rf.readLine();
                    if (line != null) {
                        readText = new String(line.getBytes(StandardCharsets.ISO_8859_1), charset);
                    } else {
                        if (k != 0) {
                            res.insert(0, "\n");
                        }
                        res.insert(0, "");
                        ++k;
                    }
                    --readIndex;
                }
                if (--readIndex < minIndex) {
                    break;
                }
                rf.seek(readIndex);
                if (readIndex == 0L) {
                    readText = rf.readLine();
                }
                if (readText == null) continue;
                if (k != 0) {
                    res.insert(0, "\n");
                }
                res.insert(0, readText);
                ++k;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (rf != null) {
                try {
                    rf.close();
                }
                catch (IOException iOException) {}
                rf = null;
            }
        }
        return res.toString();
    }

    public static void main(String[] args) {
        String res = FileUtils.readFileFromOffset("test2.txt", 2, "UTF-8");
        System.out.println(res);
    }
}

