/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.common;

import com.aliyun.datalake.metastore.common.IDataLakeMetaStore;
import com.aliyun.datalake.metastore.common.api.DataLakeAPIException;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake.metastore.hive.common.converters.CatalogToHiveConverter;
import com.aliyun.datalake.metastore.hive.common.converters.HiveToCatalogConverter;
import com.aliyun.datalake.metastore.hive.common.utils.ConfigUtils;
import com.aliyun.datalake.metastore.hive.common.utils.Utils;
import com.aliyun.datalake.metastore.hive.shims.ColStatsObjWithSourceInfo;
import com.aliyun.datalake.metastore.hive.shims.ColumnStatsAggregator;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import com.aliyun.datalake20200710.models.ColumnStatisticsDesc;
import com.aliyun.datalake20200710.models.UpdateTablePartitionColumnStatisticsRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonMetaStoreClientDelegate {
    private static final Logger logger = LoggerFactory.getLogger(CommonMetaStoreClientDelegate.class);
    private static final int NO_BATCHING = -1;
    private static final int DETECT_BATCHING = 0;
    private final IDataLakeMetaStore dataLakeMetaStore;
    private final IHiveShims hiveShims;
    private final Configuration conf;
    private int batchSize;
    private int batchSizeForGetPartititon;

    public CommonMetaStoreClientDelegate(IDataLakeMetaStore dataLakeMetaStore, IHiveShims hiveShims, Configuration conf) {
        this.dataLakeMetaStore = dataLakeMetaStore;
        this.hiveShims = hiveShims;
        this.conf = conf;
        this.batchSize = hiveShims.getMetastoreDirectSqlPartitionBatchSize(this.conf);
        if (this.batchSize == 0) {
            this.batchSize = -1;
        }
        this.batchSizeForGetPartititon = ConfigUtils.getColStatsPageSize(conf);
    }

    public List<ColumnStatisticsObj> getTableColumnStatisticsObjs(String catalogId, String dbName, String tableName, List<String> colNames) throws UnsupportedOperationException, TException {
        try {
            List results = this.dataLakeMetaStore.getTableColumnStatistics(catalogId, dbName, tableName, colNames);
            return CatalogToHiveConverter.toHiveColumnStatsObjs(results, this.hiveShims.enableBitVector(this.conf), this.hiveShims);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get table column statistics: " + catalogId + "." + dbName + "." + tableName;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public ColumnStatistics getTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> colNames) throws UnsupportedOperationException, TException {
        try {
            List results = this.dataLakeMetaStore.getTableColumnStatistics(catalogId, dbName, tableName, colNames);
            ColumnStatistics columnStatistics = new ColumnStatistics();
            org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc desc = new org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc();
            desc.setDbName(dbName);
            desc.setTableName(tableName);
            desc.setIsTblLevel(true);
            columnStatistics.setStatsObj(CatalogToHiveConverter.toHiveColumnStatsObjs(results, this.hiveShims.enableBitVector(this.conf), this.hiveShims));
            columnStatistics.setStatsDesc(desc);
            return columnStatistics;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get table column statistics: " + catalogId + "." + dbName + "." + tableName;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public boolean deletePartitionColumnStatistics(String catalogId, String dbName, String tableName, String partName, String colName) throws TException {
        try {
            ArrayList<String> partNames = new ArrayList<String>();
            partNames.add(partName);
            List<String> colNames = new ArrayList<String>();
            if (colName != null) {
                colNames.add(colName);
            } else {
                com.aliyun.datalake20200710.models.Table table = this.dataLakeMetaStore.getTable(catalogId, dbName, tableName);
                if (table != null && table.getSd() != null && table.getSd().getCols() != null && table.getSd().getCols().size() > 0) {
                    colNames = table.getSd().getCols().stream().map(t -> t.getName()).collect(Collectors.toList());
                }
            }
            return this.dataLakeMetaStore.deletePartitionColumnStatistics(catalogId, dbName, tableName, partNames, colNames);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to delete table column partition statistics: " + catalogId + "." + dbName + "." + tableName;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public boolean deleteTableColumnStatistics(String catalogId, String dbName, String tableName, String colName) throws UnsupportedOperationException, TException {
        List<String> cols = new ArrayList<String>();
        try {
            if (colName != null) {
                cols.add(colName);
            } else {
                com.aliyun.datalake20200710.models.Table table = this.dataLakeMetaStore.getTable(catalogId, dbName, tableName);
                if (table != null && table.getSd() != null && table.getSd().getCols() != null && table.getSd().getCols().size() > 0) {
                    cols = table.getSd().getCols().stream().map(t -> t.getName()).collect(Collectors.toList());
                }
            }
            return this.dataLakeMetaStore.deleteTableColumnStatistics(catalogId, dbName, tableName, cols);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to delete table column statistics: " + catalogId + "." + dbName + "." + tableName + "." + colName;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public boolean updatePartitionColumnStatistics(String catalogId, Table tbl, ColumnStatistics columnStatistics) throws TException {
        try {
            String partName = Utils.lowerCaseConvertPartName(columnStatistics.getStatsDesc().getPartName());
            this.getPartValsFromName(tbl, partName);
            UpdateTablePartitionColumnStatisticsRequest request = new UpdateTablePartitionColumnStatisticsRequest();
            request.setCatalogId(catalogId);
            request.setDatabaseName(columnStatistics.getStatsDesc().getDbName());
            request.setTableName(columnStatistics.getStatsDesc().getTableName());
            columnStatistics.getStatsDesc().setPartName(partName);
            com.aliyun.datalake20200710.models.ColumnStatistics catalogColumnStats = HiveToCatalogConverter.toCatalogColumnStats(this.hiveShims, columnStatistics);
            ArrayList<com.aliyun.datalake20200710.models.ColumnStatistics> catalogColumnStatsList = new ArrayList<com.aliyun.datalake20200710.models.ColumnStatistics>();
            catalogColumnStatsList.add(catalogColumnStats);
            request.setColumnStatisticsList(catalogColumnStatsList);
            return this.dataLakeMetaStore.updatePartitionColumnStatistics(request);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to update table column partition statistics: " + catalogId;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public boolean updateTableColumnStatistics(String catalogId, ColumnStatistics columnStatistics) throws TException {
        try {
            org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc columnStatisticsDesc = columnStatistics.getStatsDesc();
            UpdateTablePartitionColumnStatisticsRequest request = new UpdateTablePartitionColumnStatisticsRequest();
            String dbNameLowercase = columnStatisticsDesc.getDbName();
            String tableNameLowercase = columnStatisticsDesc.getTableName();
            request.setCatalogId(catalogId);
            request.setDatabaseName(dbNameLowercase);
            request.setTableName(tableNameLowercase);
            com.aliyun.datalake20200710.models.ColumnStatistics catalogColumnStats = HiveToCatalogConverter.toCatalogColumnStats(this.hiveShims, columnStatistics);
            ArrayList<com.aliyun.datalake20200710.models.ColumnStatistics> catalogColumnStatsList = new ArrayList<com.aliyun.datalake20200710.models.ColumnStatistics>();
            catalogColumnStatsList.add(catalogColumnStats);
            request.setColumnStatisticsList(catalogColumnStatsList);
            com.aliyun.datalake20200710.models.Table tbl = this.dataLakeMetaStore.getTable(catalogId, dbNameLowercase, tableNameLowercase);
            Map params = tbl.getParameters();
            List colNames = catalogColumnStats.getColumnStatisticsObjList().stream().map(obj -> obj.getColumnName()).collect(Collectors.toList());
            StatsSetupConst.setColumnStatsState((Map)tbl.getParameters(), colNames);
            tbl.setParameters(params);
            this.dataLakeMetaStore.alterTable(catalogId, dbNameLowercase, tableNameLowercase, HiveToCatalogConverter.toCatalogTableInput(CatalogToHiveConverter.toHiveTable(tbl)));
            return this.dataLakeMetaStore.updateTableColumnStatistics(request);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to update table column statistics: " + catalogId;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatisticsObj(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        try {
            Map results = this.dataLakeMetaStore.batchGetPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, columnNames);
            Map<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> newResults = results.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (newResults.size() == 0) {
                return new HashMap<String, List<ColumnStatisticsObj>>();
            }
            return CatalogToHiveConverter.toHiveColumnStatsObjMaps(newResults, this.hiveShims.enableBitVector(this.conf), this.hiveShims);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get table column partiton statistics: " + catalogId + "." + dbName + "." + tableName;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public Map<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> getPartitionColumnStatisticsObjOrigin(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        try {
            Map results = this.dataLakeMetaStore.batchGetPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, columnNames);
            Map<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> newResults = results.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (newResults.size() == 0) {
                return new HashMap<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>>();
            }
            return newResults;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get table column partiton statistics: " + catalogId + "." + dbName + "." + tableName;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public Map<String, ColumnStatistics> getPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        try {
            Map results = this.dataLakeMetaStore.batchGetPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, columnNames);
            Map<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> newResults = results.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (newResults.size() == 0) {
                return new HashMap<String, ColumnStatistics>();
            }
            Map<String, ColumnStatistics> hivestats = CatalogToHiveConverter.toHiveColumnStatsMaps(catalogId, dbName, tableName, newResults, false, this.hiveShims.enableBitVector(this.conf), this.hiveShims);
            return hivestats;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException(e.getResult(), e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get table column partiton statistics: " + catalogId + "." + dbName + "." + tableName;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public boolean setPartitionColumnStatistics(String catalogId, SetPartitionsStatsRequest request, Table t, List<Partition> partitions) throws TException {
        boolean ret = true;
        List csNews = request.getColStats();
        if (csNews == null || csNews.isEmpty()) {
            return ret;
        }
        ColumnStatistics firstColStats = (ColumnStatistics)csNews.get(0);
        org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc statsDesc = firstColStats.getStatsDesc();
        String dbName = statsDesc.getDbName();
        String tableName = statsDesc.getTableName();
        ArrayList<String> colNames = new ArrayList<String>();
        for (Object obj : firstColStats.getStatsObj()) {
            colNames.add(obj.getColName());
        }
        if (statsDesc.isIsTblLevel()) {
            if (request.getColStatsSize() != 1) {
                throw new MetaException("Expecting only 1 ColumnStatistics for table's column stats, but find " + request.getColStatsSize());
            }
            if (request.isSetNeedMerge() && request.isNeedMerge()) {
                ColumnStatistics csOld = this.getTableColumnStatistics(catalogId, dbName, tableName, colNames);
                this.hiveShims.getMergableCols(firstColStats, t.getParameters());
                if (csOld != null && csOld.getStatsObjSize() != 0 && !firstColStats.getStatsObj().isEmpty()) {
                    this.hiveShims.mergeColStats(firstColStats, csOld);
                }
                if (!firstColStats.getStatsObj().isEmpty()) {
                    return this.updateTableColumnStatistics(catalogId, firstColStats);
                }
                logger.debug("All the column stats are not accurate to merge.");
                return true;
            }
            return this.updateTableColumnStatistics(catalogId, firstColStats);
        }
        HashMap<String, ColumnStatistics> newStatsMap = new HashMap<String, ColumnStatistics>();
        for (ColumnStatistics csNew : csNews) {
            String partName = csNew.getStatsDesc().getPartName();
            if (newStatsMap.containsKey(partName)) {
                this.hiveShims.mergeColStats(csNew, (ColumnStatistics)newStatsMap.get(partName));
            }
            newStatsMap.put(partName, csNew);
        }
        Map<Object, Object> oldStatsMap = new HashMap();
        HashMap<String, Partition> mapToPart = new HashMap<String, Partition>();
        if (request.isSetNeedMerge() && request.isNeedMerge()) {
            ArrayList<String> partitionNames = new ArrayList<String>();
            partitionNames.addAll(newStatsMap.keySet());
            oldStatsMap = this.getPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, colNames);
            if (newStatsMap.values().size() != oldStatsMap.values().size()) {
                logger.debug("Some of the partitions miss stats.");
            }
            for (int index = 0; index < partitionNames.size(); ++index) {
                mapToPart.put((String)partitionNames.get(index), partitions.get(index));
            }
        }
        for (Map.Entry entry : newStatsMap.entrySet()) {
            ColumnStatistics csNew = (ColumnStatistics)entry.getValue();
            ColumnStatistics csOld = (ColumnStatistics)oldStatsMap.get(entry.getKey());
            if (request.isSetNeedMerge() && request.isNeedMerge()) {
                this.hiveShims.getMergableCols(csNew, ((Partition)mapToPart.get(entry.getKey())).getParameters());
                if (csOld != null && csOld.getStatsObjSize() != 0 && !csNew.getStatsObj().isEmpty()) {
                    this.hiveShims.mergeColStats(csNew, csOld);
                }
                if (!csNew.getStatsObj().isEmpty()) {
                    ret = ret && this.updatePartitionColumnStatistics(catalogId, t, csNew);
                    continue;
                }
                logger.debug("All the column stats " + csNew.getStatsDesc().getPartName() + " are not accurate to merge.");
                continue;
            }
            ret = ret && this.updatePartitionColumnStatistics(catalogId, t, csNew);
        }
        return ret;
    }

    public AggrStats getAggrStatsFor(String catalogId, PartitionsStatsRequest request) throws TException {
        String dbName = request.getDbName();
        String tblName = request.getTblName();
        if (request.getColNames().isEmpty() || request.getPartNames().isEmpty()) {
            return new AggrStats(new ArrayList(), 0L);
        }
        List lowerCaseColNames = request.getColNames();
        List lowerCasePartNames = request.getPartNames();
        long partsFound = 0L;
        partsFound = this.partsFoundForPartitions(catalogId, dbName, tblName, lowerCasePartNames, lowerCaseColNames);
        List<ColumnStatisticsObj> colStatsList = this.columnStatisticsObjForPartitions(catalogId, dbName, tblName, lowerCasePartNames, lowerCaseColNames, partsFound, this.hiveShims.getDensityFunctionForNDVEstimation(this.conf), this.hiveShims.getNdvTuner(this.conf));
        return new AggrStats(colStatsList, partsFound);
    }

    private List<String> getPartValsFromName(Table t, String partName) throws MetaException, InvalidObjectException {
        Preconditions.checkArgument((t != null ? 1 : 0) != 0, (Object)"Table can not be null");
        LinkedHashMap hm = Warehouse.makeSpecFromName((String)partName);
        ArrayList<String> partVals = new ArrayList<String>();
        for (FieldSchema field : t.getPartitionKeys()) {
            String key = field.getName();
            String val = (String)hm.get(key);
            if (val == null) {
                throw new InvalidObjectException("incomplete partition name - missing " + key);
            }
            partVals.add(val);
        }
        return partVals;
    }

    public long partsFoundForPartitions(final String catalogId, final String dbName, final String tableName, final List<String> partNames, List<String> colNames) throws TException {
        long start = System.currentTimeMillis();
        assert (!colNames.isEmpty() && !partNames.isEmpty());
        List<Long> allCounts = this.runBatchedGetPartitions(colNames, new Batchable<String, Long>(){

            @Override
            public List<Long> run(final List<String> inputColName) throws TException {
                return CommonMetaStoreClientDelegate.this.runBatchedGetPartitions(partNames, new Batchable<String, Long>(){

                    @Override
                    public List<Long> run(List<String> inputPartNames) throws TException {
                        long partsFound = 0L;
                        Map<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> statsObjs = CommonMetaStoreClientDelegate.this.getPartitionColumnStatisticsObjOrigin(catalogId, dbName, tableName, inputPartNames, inputColName);
                        for (Map.Entry<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> entry : statsObjs.entrySet()) {
                            if (entry.getValue().size() != inputColName.size()) continue;
                            ++partsFound;
                        }
                        return Lists.newArrayList((Object[])new Long[]{partsFound});
                    }
                });
            }
        });
        long partsFound = 0L;
        for (Long val : allCounts) {
            partsFound += val.longValue();
        }
        logger.debug("partsFoundForPartitions time: " + catalogId + "." + dbName + "." + tableName + ":" + (System.currentTimeMillis() - start) + "ms");
        return partsFound;
    }

    public List<ColumnStatisticsObj> columnStatisticsObjForPartitions(final String catalogId, final String dbName, final String tableName, final List<String> partNames, List<String> colNames, long partsFound, final boolean useDensityFunctionForNDVEstimation, final double ndvTuner) throws TException {
        final boolean areAllPartsFound = partsFound == (long)partNames.size();
        long start = System.currentTimeMillis();
        List<ColumnStatisticsObj> columnsObjs = this.runBatched(colNames, new Batchable<String, ColumnStatisticsObj>(){

            @Override
            public List<ColumnStatisticsObj> run(final List<String> inputColNames) throws TException {
                return CommonMetaStoreClientDelegate.this.runBatched(partNames, new Batchable<String, ColumnStatisticsObj>(){

                    @Override
                    public List<ColumnStatisticsObj> run(List<String> inputPartNames) throws TException {
                        return CommonMetaStoreClientDelegate.this.columnStatisticsObjForPartitionsBatch(catalogId, dbName, tableName, inputPartNames, inputColNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
                    }
                });
            }
        });
        logger.debug("columnStatisticsObjForPartitions time: " + catalogId + "." + dbName + "." + tableName + ":" + (System.currentTimeMillis() - start) + "ms");
        return columnsObjs;
    }

    private <I, R> List<R> runBatched(List<I> input, Batchable<I, R> runnable) throws TException {
        if (this.batchSize == -1 || this.batchSize >= input.size()) {
            return runnable.run(input);
        }
        ArrayList<R> result = new ArrayList<R>(input.size());
        int fromIndex = 0;
        int toIndex = 0;
        while (toIndex < input.size()) {
            toIndex = Math.min(fromIndex + this.batchSize, input.size());
            List<I> batchedInput = input.subList(fromIndex, toIndex);
            List<R> batchedOutput = runnable.run(batchedInput);
            if (batchedOutput != null) {
                result.addAll(batchedOutput);
            }
            fromIndex = toIndex;
        }
        return result;
    }

    private <I, R> List<R> runBatchedGetPartitions(List<I> input, Batchable<I, R> runnable) throws TException {
        if (this.batchSizeForGetPartititon == -1 || this.batchSizeForGetPartititon >= input.size()) {
            return runnable.run(input);
        }
        ArrayList<R> result = new ArrayList<R>(input.size());
        int fromIndex = 0;
        int toIndex = 0;
        while (toIndex < input.size()) {
            toIndex = Math.min(fromIndex + this.batchSizeForGetPartititon, input.size());
            List<I> batchedInput = input.subList(fromIndex, toIndex);
            List<R> batchedOutput = runnable.run(batchedInput);
            if (batchedOutput != null) {
                result.addAll(batchedOutput);
            }
            fromIndex = toIndex;
        }
        return result;
    }

    private List<ColumnStatisticsObj> columnStatisticsObjForPartitionsBatch(String catalogId, String dbName, String tableName, List<String> partNames, List<String> colNames, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws TException {
        Map<String, List<ColumnStatisticsObj>> partStatsObjs = this.getPartitionStats(catalogId, dbName, tableName, partNames, colNames, this.hiveShims.enableBitVector(this.conf));
        return this.aggrPartitionStats(partStatsObjs, catalogId, dbName, tableName, partNames, colNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
    }

    public List<ColumnStatisticsObj> aggrPartitionStats(Map<String, List<ColumnStatisticsObj>> partStats, String catalogId, String dbName, String tableName, List<String> partNames, List<String> colNames, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        HashMap<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> colStatsMap = new HashMap<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>>();
        HashMap<String, ColumnStatsAggregator> aliasToAggregator = new HashMap<String, ColumnStatsAggregator>();
        for (String partName : partStats.keySet()) {
            List<ColumnStatisticsObj> objs = partStats.get(partName);
            for (ColumnStatisticsObj obj : objs) {
                if (aliasToAggregator.get(obj.getColName()) == null) {
                    aliasToAggregator.put(obj.getColName(), new ColumnStatsAggregator((ColumnStatisticsData._Fields)obj.getStatsData().getSetField(), this.hiveShims.getNumBitVectors(this.conf), useDensityFunctionForNDVEstimation, ndvTuner, obj.getColName()));
                    colStatsMap.put((ColumnStatsAggregator)aliasToAggregator.get(obj.getColName()), new ArrayList());
                }
                ((List)colStatsMap.get(aliasToAggregator.get(obj.getColName()))).add(new ColStatsObjWithSourceInfo(obj, catalogId, dbName, tableName, partName));
            }
        }
        if (colStatsMap.size() < 1) {
            return new ArrayList<ColumnStatisticsObj>();
        }
        return this.aggrPartitionStats(colStatsMap, partNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
    }

    public List<ColumnStatisticsObj> aggrPartitionStats(Map<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> colStatsMap, final List<String> partNames, final boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        ArrayList<ColumnStatisticsObj> aggrColStatObjs = new ArrayList<ColumnStatisticsObj>();
        int numProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(Math.min(colStatsMap.size(), numProcessors), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("aggr-col-stats-%d").build());
        LinkedList futures = Lists.newLinkedList();
        logger.debug("Aggregating column stats. Threads used: {}" + Math.min(colStatsMap.size(), numProcessors));
        long start = System.currentTimeMillis();
        for (final Map.Entry<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> entry : colStatsMap.entrySet()) {
            futures.add(pool.submit(new Callable<ColumnStatisticsObj>(){

                @Override
                public ColumnStatisticsObj call() throws MetaException {
                    List colStatWithSourceInfo = (List)entry.getValue();
                    ColumnStatsAggregator aggregator = (ColumnStatsAggregator)entry.getKey();
                    try {
                        ColumnStatisticsObj statsObj = CommonMetaStoreClientDelegate.this.hiveShims.getAggregate(aggregator, colStatWithSourceInfo, partNames, areAllPartsFound);
                        return statsObj;
                    }
                    catch (MetaException e) {
                        logger.debug(e.getMessage());
                        throw e;
                    }
                }
            }));
        }
        pool.shutdown();
        if (!futures.isEmpty()) {
            for (Future future : futures) {
                try {
                    if (future.get() == null) continue;
                    aggrColStatObjs.add((ColumnStatisticsObj)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.debug(e.getMessage());
                    pool.shutdownNow();
                    throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(e.toString()), (Exception)e);
                }
            }
        }
        logger.debug("Time for aggr col stats in seconds: {} Threads used: {}" + ((double)System.currentTimeMillis() - (double)start) / 1000.0 + Math.min(colStatsMap.size(), numProcessors));
        return aggrColStatObjs;
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionStats(final String catalogid, final String dbName, final String tableName, final List<String> partNames, List<String> colNames, boolean enableBitVector) throws TException {
        if (colNames.isEmpty() || partNames.isEmpty()) {
            return new HashMap<String, List<ColumnStatisticsObj>>();
        }
        Batchable<String, com.aliyun.datalake20200710.models.ColumnStatistics> b = new Batchable<String, com.aliyun.datalake20200710.models.ColumnStatistics>(){

            @Override
            public List<com.aliyun.datalake20200710.models.ColumnStatistics> run(final List<String> inputColNames) throws TException {
                Batchable<String, com.aliyun.datalake20200710.models.ColumnStatistics> b2 = new Batchable<String, com.aliyun.datalake20200710.models.ColumnStatistics>(){

                    @Override
                    public List<com.aliyun.datalake20200710.models.ColumnStatistics> run(List<String> inputPartNames) throws TException {
                        ArrayList<com.aliyun.datalake20200710.models.ColumnStatistics> statistics = new ArrayList<com.aliyun.datalake20200710.models.ColumnStatistics>();
                        Map<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> objs = CommonMetaStoreClientDelegate.this.getPartitionColumnStatisticsObjOrigin(catalogid, dbName, tableName, inputPartNames, inputColNames);
                        for (Map.Entry<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> entry : objs.entrySet()) {
                            ColumnStatisticsDesc desc = new ColumnStatisticsDesc();
                            desc.setPartitionName(entry.getKey());
                            com.aliyun.datalake20200710.models.ColumnStatistics stat = new com.aliyun.datalake20200710.models.ColumnStatistics();
                            stat.setColumnStatisticsDesc(desc);
                            stat.setColumnStatisticsObjList(entry.getValue());
                            statistics.add(stat);
                        }
                        return statistics;
                    }
                };
                return CommonMetaStoreClientDelegate.this.runBatchedGetPartitions(partNames, b2);
            }
        };
        List<com.aliyun.datalake20200710.models.ColumnStatistics> columnStatisticsList = this.runBatchedGetPartitions(colNames, b);
        HashMap<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> objMap = new HashMap<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>>();
        for (com.aliyun.datalake20200710.models.ColumnStatistics columnStatistics : columnStatisticsList) {
            if (objMap.get(columnStatistics.getColumnStatisticsDesc().getPartitionName()) != null) {
                ((List)objMap.get(columnStatistics.getColumnStatisticsDesc().getPartitionName())).addAll(columnStatistics.getColumnStatisticsObjList());
                continue;
            }
            ArrayList objs = new ArrayList();
            objs.addAll(columnStatistics.getColumnStatisticsObjList());
            objMap.put(columnStatistics.getColumnStatisticsDesc().getPartitionName(), objs);
        }
        try {
            return CatalogToHiveConverter.toHiveColumnStatsObjMaps(objMap, this.hiveShims.enableBitVector(this.conf), this.hiveShims);
        }
        catch (IOException e) {
            throw new TException("catalog to HiveColumnStatsObjMaps error " + e, (Throwable)e);
        }
    }

    private static abstract class Batchable<I, R> {
        private Batchable() {
        }

        public abstract List<R> run(List<I> var1) throws TException;
    }
}

