/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.shims;

import com.aliyun.datalake.metastore.common.util.ProxyLogUtils;
import com.aliyun.datalake.metastore.hive.shims.ColStatsObjWithSourceInfo;
import com.aliyun.datalake.metastore.hive.shims.ColumnStatsAggregator;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive3Shims
implements IHiveShims {
    private static final String HIVE_VERSION = "3.";
    private static final Logger logger = LoggerFactory.getLogger(Hive3Shims.class);

    static boolean supportsVersion(String version) {
        return version.startsWith(HIVE_VERSION);
    }

    public <T> Class<? extends RawStore> getClass(String className, Class<? extends RawStore> clazz) throws MetaException {
        return JavaUtils.getClass((String)className, clazz);
    }

    public <T> T newInstance(Class<T> theClass, Class<?>[] parameterTypes, Object[] initargs) {
        return (T)JavaUtils.newInstance(theClass, (Class[])parameterTypes, (Object[])initargs);
    }

    public <T> List<ObjectPair<Integer, byte[]>> objectPairConvert(T partExprs) {
        ArrayList<ObjectPair<Integer, byte[]>> objectPairs = new ArrayList<ObjectPair<Integer, byte[]>>();
        for (org.apache.hadoop.hive.metastore.utils.ObjectPair part : (List)partExprs) {
            ObjectPair objectPair = ObjectPair.create((Object)((Integer)part.getFirst()), (Object)((byte[])part.getSecond()));
            objectPairs.add((ObjectPair<Integer, byte[]>)objectPair);
        }
        return objectPairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(Warehouse wh, Path f, boolean inheritPermCandidate, Boolean enableFsOperation) throws MetaException {
        long startTime = System.currentTimeMillis();
        boolean mkdir = false;
        try {
            mkdir = enableFsOperation != false ? wh.mkdirs(f) : true;
            boolean bl = mkdir;
            return bl;
        }
        finally {
            boolean mkdirFinal = mkdir;
            ProxyLogUtils.printLog(() -> logger.info("dlf.fs.{}.mkdir, result:{}, cost:{}ms, path : {}, candidate : {}", new Object[]{IHiveShims.realMessage((boolean)enableFsOperation), mkdirFinal, System.currentTimeMillis() - startTime, f, inheritPermCandidate}));
        }
    }

    public boolean deleteDir(Warehouse wh, Path f, boolean recursive, Boolean enableFsOperation) throws MetaException {
        return this.deleteDir(wh, f, recursive, false, false, enableFsOperation);
    }

    public boolean deleteDir(Warehouse wh, Path f, boolean recursive, Database db, Boolean enableFsOperation) throws MetaException {
        return this.deleteDir(wh, f, recursive, false, db, enableFsOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDir(Warehouse wh, Path f, boolean recursive, boolean ifPurge, Database db, Boolean enableFsOperation) throws MetaException {
        long startTime = System.currentTimeMillis();
        boolean deleteDir = false;
        try {
            deleteDir = enableFsOperation != false ? wh.deleteDir(f, recursive, db) : true;
            boolean bl = deleteDir;
            return bl;
        }
        finally {
            boolean deleteDirFinal = deleteDir;
            ProxyLogUtils.printLog(() -> logger.info("dlf.fs.{}.deleteDir, result:{}, cost:{}ms, path : {}, db : {}, recursive : {}", new Object[]{IHiveShims.realMessage((boolean)enableFsOperation), deleteDirFinal, System.currentTimeMillis() - startTime, f, ReplChangeManager.isSourceOfReplication((Database)db), recursive}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDir(Warehouse wh, Path f, boolean recursive, boolean ifPurge, boolean needCmRecycle, Boolean enableFsOperation) throws MetaException {
        long startTime = System.currentTimeMillis();
        boolean deleteDir = false;
        try {
            deleteDir = enableFsOperation != false ? wh.deleteDir(f, recursive, ifPurge, needCmRecycle) : true;
            boolean bl = deleteDir;
            return bl;
        }
        finally {
            boolean deleteDirFinal = deleteDir;
            ProxyLogUtils.printLog(() -> logger.info("dlf.fs.{}.deleteDir, result:{}, cost:{}ms, path : {}, recursive : {}, ifPurge : {}, needCm : {}", new Object[]{IHiveShims.realMessage((boolean)enableFsOperation), deleteDirFinal, System.currentTimeMillis() - startTime, f, recursive, ifPurge, needCmRecycle}));
        }
    }

    public void addCatalogForDb(Database db, String catalogId) {
        db.setCatalogName(catalogId);
    }

    public void updateTableStatsFast(Database db, Table tbl, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext) throws MetaException {
        MetaStoreUtils.updateTableStatsSlow((Database)db, (Table)tbl, (Warehouse)wh, (boolean)madeDir, (boolean)forceRecompute, (EnvironmentContext)environmentContext);
    }

    public boolean requireCalStats(Configuration conf, Partition oldPart, Partition newPart, Table tbl, EnvironmentContext environmentContext) {
        return MetaStoreUtils.requireCalStats((Partition)oldPart, (Partition)newPart, (Table)tbl, (EnvironmentContext)environmentContext);
    }

    public boolean isIndexTable(Table table) {
        return false;
    }

    public boolean filterPartitionsByExpr(PartitionExpressionProxy partitionExpressionProxy, List<FieldSchema> partColumns, byte[] expr, String defaultPartitionName, List<String> partitionNames) throws MetaException {
        return partitionExpressionProxy.filterPartitionsByExpr(partColumns, expr, defaultPartitionName, partitionNames);
    }

    public Deserializer getDeserializer(Configuration conf, Table table, boolean skipConfError) throws MetaException {
        return HiveMetaStoreUtils.getDeserializer((Configuration)conf, (Table)table, (boolean)skipConfError);
    }

    public List<FieldSchema> getFieldsFromDeserializer(String tableName, Deserializer deserializer) throws SerDeException, MetaException {
        return HiveMetaStoreUtils.getFieldsFromDeserializer((String)tableName, (Deserializer)deserializer);
    }

    public String validateSkewedColNames(List<String> cols) {
        return MetaStoreUtils.validateSkewedColNames(cols);
    }

    public String validateSkewedColNamesSubsetCol(List<String> skewedColNames, List<FieldSchema> cols) {
        return MetaStoreUtils.validateSkewedColNamesSubsetCol(skewedColNames, cols);
    }

    public String validateTblColumns(List<FieldSchema> cols) {
        return MetaStoreUtils.validateTblColumns(cols);
    }

    public boolean validateName(String name, Configuration conf) {
        return MetaStoreUtils.validateName((String)name, (Configuration)conf);
    }

    public void validatePartitionNameCharacters(List<String> partVals, Pattern partitionValidationPattern) throws MetaException {
        MetaStoreUtils.validatePartitionNameCharacters(partVals, (Pattern)partitionValidationPattern);
    }

    public boolean updatePartitionStatsFast(Partition part, Table table, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext, boolean isCreate) throws MetaException {
        return MetaStoreUtils.updatePartitionStatsFast((Partition)part, (Table)table, (Warehouse)wh, (boolean)madeDir, (boolean)forceRecompute, (EnvironmentContext)environmentContext, (boolean)isCreate);
    }

    public boolean isFastStatsSame(Partition oldPart, Partition newPart) {
        return MetaStoreUtils.isFastStatsSame((Partition)oldPart, (Partition)newPart);
    }

    public void updateBasicState(EnvironmentContext environmentContext, Map<String, String> params) {
        MetaStoreUtils.updateBasicState((EnvironmentContext)environmentContext, params);
    }

    public boolean isExternalTable(Table table) {
        return MetaStoreUtils.isExternalTable((Table)table);
    }

    public boolean isArchived(Partition part) {
        return MetaStoreUtils.isArchived((Partition)part);
    }

    public Path getOriginalLocation(Partition part) {
        return MetaStoreUtils.getOriginalLocation((Partition)part);
    }

    public ClassLoader addToClassPath(ClassLoader cloader, String[] newPaths) throws Exception {
        return MetaStoreUtils.addToClassPath((ClassLoader)cloader, (String[])newPaths);
    }

    public boolean isView(Table table) {
        return MetaStoreUtils.isView((Table)table);
    }

    public void getMergableCols(ColumnStatistics csNew, Map<String, String> parameters) {
        MetaStoreUtils.getMergableCols((ColumnStatistics)csNew, parameters);
    }

    public void mergeColStats(ColumnStatistics csNew, ColumnStatistics csOld) throws InvalidObjectException {
        MetaStoreUtils.mergeColStats((ColumnStatistics)csNew, (ColumnStatistics)csOld);
    }

    public boolean enableBitVector(Configuration conf) {
        return MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_FETCH_BITVECTOR);
    }

    public void setLongBitVector(LongColumnStatsData longColumnStatsData, byte[] bitVector) {
        longColumnStatsData.setBitVectors(bitVector);
    }

    public void setDoubleBitVector(DoubleColumnStatsData doubleColumnStatsData, byte[] bitVector) {
        doubleColumnStatsData.setBitVectors(bitVector);
    }

    public void setDecimalBitVector(DecimalColumnStatsData decimalColumnStatsData, byte[] bitVector) {
        decimalColumnStatsData.setBitVectors(bitVector);
    }

    public void setDateBitVector(DateColumnStatsData dateColumnStatsData, byte[] bitVector) {
        dateColumnStatsData.setBitVectors(bitVector);
    }

    public void setStringBitVector(StringColumnStatsData stringColumnStatsData, byte[] bitVector) {
        stringColumnStatsData.setBitVectors(bitVector);
    }

    public byte[] getLongBitVector(LongColumnStatsData longColumnStatsData) {
        return longColumnStatsData.isSetBitVectors() ? longColumnStatsData.getBitVectors() : null;
    }

    public byte[] getDoubleBitVector(DoubleColumnStatsData doubleColumnStatsData) {
        return doubleColumnStatsData.isSetBitVectors() ? doubleColumnStatsData.getBitVectors() : null;
    }

    public byte[] getDecimalBitVector(DecimalColumnStatsData decimalColumnStatsData) {
        return decimalColumnStatsData.isSetBitVectors() ? decimalColumnStatsData.getBitVectors() : null;
    }

    public byte[] getDateBitVector(DateColumnStatsData dateColumnStatsData) {
        return dateColumnStatsData.isSetBitVectors() ? dateColumnStatsData.getBitVectors() : null;
    }

    public byte[] getStringBitVector(StringColumnStatsData stringColumnStatsData) {
        return stringColumnStatsData.isSetBitVectors() ? stringColumnStatsData.getBitVectors() : null;
    }

    public Decimal createThriftDecimal(String s) {
        BigDecimal d = new BigDecimal(s);
        return new Decimal((short)d.scale(), ByteBuffer.wrap(d.unscaledValue().toByteArray()));
    }

    public String createJdoDecimalString(Decimal d) {
        return new BigDecimal(new BigInteger(d.getUnscaled()), d.getScale()).toString();
    }

    public boolean getDensityFunctionForNDVEstimation(Configuration conf) {
        return MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_NDV_DENSITY_FUNCTION);
    }

    public double getNdvTuner(Configuration conf) {
        return MetastoreConf.getDoubleVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_NDV_TUNER);
    }

    public int getMetastoreDirectSqlPartitionBatchSize(Configuration conf) {
        return MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_PARTITION_BATCH_SIZE);
    }

    public ColumnStatisticsObj getAggregate(ColumnStatsAggregator aggregator, List<ColStatsObjWithSourceInfo> colStatWithSourceInfos, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator aggr = ColumnStatsAggregatorFactory.getColumnStatsAggregator((ColumnStatisticsData._Fields)aggregator.getType(), (boolean)aggregator.isUseDensityFunctionForNDVEstimation(), (double)aggregator.getNdvTuner());
        ArrayList colStatWithSourceInfoHives = new ArrayList();
        colStatWithSourceInfos.stream().forEach(stat -> colStatWithSourceInfoHives.add(new MetaStoreUtils.ColStatsObjWithSourceInfo(stat.getColStatsObj(), stat.getCatName(), stat.getDbName(), stat.getTblName(), stat.getPartName())));
        return aggr.aggregate(colStatWithSourceInfoHives, partNames, areAllPartsFound);
    }

    public int getNumBitVectors(Configuration conf) throws MetaException {
        return 0;
    }

    public void setColumnStatisticsDescCatalog(String catalogId, ColumnStatisticsDesc desc) {
        desc.setCatName(catalogId);
    }

    public LongColumnStatsData getLongColumnStatsData(Long numNulls, Long numDVs, Long lowValue, Long highValue, byte[] bitVectors, boolean enableBitVector) {
        LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
        longStats.setNumNulls(numNulls.longValue());
        if (highValue != null) {
            longStats.setHighValue(highValue.longValue());
        }
        if (lowValue != null) {
            longStats.setLowValue(lowValue.longValue());
        }
        longStats.setNumDVs(numDVs.longValue());
        if (enableBitVector) {
            longStats.setBitVectors(bitVectors);
        }
        return longStats;
    }

    public StringColumnStatsData getStringColumnStatsData(Long numNulls, Long numDVs, double avglen, Long maxlen, byte[] bitVectors, boolean enableBitVector) {
        StringColumnStatsDataInspector stringStats = new StringColumnStatsDataInspector();
        stringStats.setNumNulls(numNulls.longValue());
        stringStats.setAvgColLen(avglen);
        stringStats.setMaxColLen(maxlen.longValue());
        stringStats.setNumDVs(numDVs.longValue());
        if (enableBitVector) {
            stringStats.setBitVectors(bitVectors);
        }
        return stringStats;
    }

    public DoubleColumnStatsData getDoubleColumnStatsData(Long numNulls, Long numDVs, Double lowValue, Double highValue, byte[] bitVectors, boolean enableBitVector) {
        DoubleColumnStatsDataInspector doubleStats = new DoubleColumnStatsDataInspector();
        doubleStats.setNumNulls(numNulls.longValue());
        if (highValue != null) {
            doubleStats.setHighValue(highValue.doubleValue());
        }
        if (lowValue != null) {
            doubleStats.setLowValue(lowValue.doubleValue());
        }
        doubleStats.setNumDVs(numDVs.longValue());
        if (enableBitVector) {
            doubleStats.setBitVectors(bitVectors);
        }
        return doubleStats;
    }

    public DecimalColumnStatsData getDecimalColumnStatsData(Long numNulls, Long numDVs, Decimal lowValue, Decimal highValue, byte[] bitVectors, boolean enableBitVector) {
        DecimalColumnStatsDataInspector decimalStats = new DecimalColumnStatsDataInspector();
        decimalStats.setNumNulls(numNulls.longValue());
        if (highValue != null) {
            decimalStats.setHighValue(highValue);
        }
        if (lowValue != null) {
            decimalStats.setLowValue(lowValue);
        }
        decimalStats.setNumDVs(numDVs.longValue());
        if (enableBitVector) {
            decimalStats.setBitVectors(bitVectors);
        }
        return decimalStats;
    }

    public DateColumnStatsData getDateColumnStatsData(Long numNulls, Long numDVs, Date lowValue, Date highValue, byte[] bitVectors, boolean enableBitVector) {
        DateColumnStatsDataInspector dateStats = new DateColumnStatsDataInspector();
        dateStats.setNumNulls(numNulls.longValue());
        if (highValue != null) {
            dateStats.setHighValue(highValue);
        }
        if (lowValue != null) {
            dateStats.setLowValue(lowValue);
        }
        dateStats.setNumDVs(numDVs.longValue());
        if (enableBitVector) {
            dateStats.setBitVectors(bitVectors);
        }
        return dateStats;
    }

    public BooleanColumnStatsData getBooleanColumnStatsData(Long numFalses, Long numTrues, Long numNulls) {
        BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
        boolStats.setNumFalses(numFalses.longValue());
        boolStats.setNumTrues(numTrues.longValue());
        boolStats.setNumNulls(numNulls.longValue());
        return boolStats;
    }

    public BinaryColumnStatsData getBinaryColumnStatsData(Long numNulls, double avglen, Long maxlen) {
        BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
        binaryStats.setNumNulls(numNulls.longValue());
        binaryStats.setAvgColLen(avglen);
        binaryStats.setMaxColLen(maxlen.longValue());
        return binaryStats;
    }
}

