/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive2;

import com.aliyun.datalake.metastore.common.ProxyMode;
import com.aliyun.datalake.metastore.common.functional.FunctionalUtils;
import com.aliyun.datalake.metastore.common.functional.ThrowingConsumer;
import com.aliyun.datalake.metastore.common.functional.ThrowingFunction;
import com.aliyun.datalake.metastore.common.functional.ThrowingRunnable;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake.metastore.common.util.ProxyLogUtils;
import com.aliyun.datalake.metastore.hive.common.utils.ClientUtils;
import com.aliyun.datalake.metastore.hive.common.utils.ConfigUtils;
import com.aliyun.datalake.metastore.hive2.DlfSessionMetaStoreClient;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyMetaStoreClient
implements IMetaStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(ProxyMetaStoreClient.class);
    private static final String HIVE_FACTORY_CLASS = "org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClientFactory";
    private final ProxyMode proxyMode;
    private IMetaStoreClient dlfSessionMetaStoreClient;
    private IMetaStoreClient hiveSessionMetaStoreClient;
    private IMetaStoreClient readWriteClient;
    private Optional<IMetaStoreClient> extraClient;
    private boolean allowFailure = false;
    private HiveConf hiveConf;
    private final String readWriteClientType;

    public ProxyMetaStoreClient(HiveConf hiveConf) throws MetaException {
        this(hiveConf, null, false);
    }

    public ProxyMetaStoreClient(HiveConf hiveConf, HiveMetaHookLoader hiveMetaHookLoader, Boolean allowEmbedded) throws MetaException {
        long startTime = System.currentTimeMillis();
        logger.info("ProxyMetaStoreClient start, datalake-metastore-client-version:{}", (Object)"0.2.14");
        this.hiveConf = new HiveConf(hiveConf);
        this.proxyMode = ConfigUtils.getProxyMode((Configuration)hiveConf);
        ProxyLogUtils.initLogUtils((ProxyMode)this.proxyMode, (String)hiveConf.get("dlf.catalog.proxyLogStore", ConfigUtils.getUserId((Configuration)hiveConf)), (boolean)hiveConf.getBoolean("dlf.catalog.action.log.enabled", false), (boolean)hiveConf.getBoolean("dlf.catalog.log.enabled", true));
        this.createClient(true, (ThrowingRunnable<MetaException>)((ThrowingRunnable)() -> this.initDlfClient(hiveConf, hiveMetaHookLoader, allowEmbedded, new ConcurrentHashMap<String, Long>())));
        this.createClient(false, (ThrowingRunnable<MetaException>)((ThrowingRunnable)() -> this.initHiveClient(hiveConf, hiveMetaHookLoader, allowEmbedded, new ConcurrentHashMap<String, Long>())));
        this.initClientByProxyMode();
        this.readWriteClientType = this.readWriteClient instanceof DlfSessionMetaStoreClient ? "dlf" : "hive";
        logger.info("ProxyMetaStoreClient end, cost:{}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void createClient(boolean isDlf, ThrowingRunnable<MetaException> createClient) throws MetaException {
        try {
            createClient.run();
        }
        catch (Exception e) {
            if (isDlf && this.proxyMode == ProxyMode.METASTORE_DLF_FAILURE) {
                this.dlfSessionMetaStoreClient = null;
            }
            if (!isDlf && this.proxyMode == ProxyMode.DLF_METASTORE_FAILURE) {
                this.hiveSessionMetaStoreClient = null;
            }
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(e.getMessage()), (Exception)e);
        }
    }

    public static Map<String, org.apache.hadoop.hive.ql.metadata.Table> getTempTablesForDatabase(String dbName) {
        return ProxyMetaStoreClient.getTempTables().get(dbName);
    }

    public static Map<String, Map<String, org.apache.hadoop.hive.ql.metadata.Table>> getTempTables() {
        SessionState ss = SessionState.get();
        if (ss == null) {
            return Collections.emptyMap();
        }
        return ss.getTempTables();
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public void initClientByProxyMode() throws MetaException {
        switch (this.proxyMode) {
            case METASTORE_ONLY: {
                this.readWriteClient = this.hiveSessionMetaStoreClient;
                this.extraClient = Optional.empty();
                break;
            }
            case METASTORE_DLF_FAILURE: {
                this.allowFailure = true;
                this.readWriteClient = this.hiveSessionMetaStoreClient;
                this.extraClient = Optional.ofNullable(this.dlfSessionMetaStoreClient);
                break;
            }
            case METASTORE_DLF_SUCCESS: {
                this.readWriteClient = this.hiveSessionMetaStoreClient;
                this.extraClient = Optional.of(this.dlfSessionMetaStoreClient);
                break;
            }
            case DLF_METASTORE_SUCCESS: {
                this.readWriteClient = this.dlfSessionMetaStoreClient;
                this.extraClient = Optional.of(this.hiveSessionMetaStoreClient);
                break;
            }
            case DLF_METASTORE_FAILURE: {
                this.allowFailure = true;
                this.readWriteClient = this.dlfSessionMetaStoreClient;
                this.extraClient = Optional.ofNullable(this.hiveSessionMetaStoreClient);
                break;
            }
            case DLF_ONLY: {
                this.readWriteClient = this.dlfSessionMetaStoreClient;
                this.extraClient = Optional.empty();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.proxyMode);
            }
        }
    }

    public void initHiveClient(HiveConf hiveConf, HiveMetaHookLoader hiveMetaHookLoader, boolean allowEmbedded, ConcurrentHashMap<String, Long> metaCallTimeMap) throws MetaException {
        switch (this.proxyMode) {
            case METASTORE_ONLY: 
            case METASTORE_DLF_FAILURE: 
            case METASTORE_DLF_SUCCESS: 
            case DLF_METASTORE_SUCCESS: 
            case DLF_METASTORE_FAILURE: {
                this.hiveSessionMetaStoreClient = ClientUtils.createMetaStoreClient((String)HIVE_FACTORY_CLASS, (HiveConf)hiveConf, (HiveMetaHookLoader)hiveMetaHookLoader, (boolean)allowEmbedded, metaCallTimeMap);
                break;
            }
            case DLF_ONLY: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.proxyMode);
            }
        }
    }

    public void initDlfClient(HiveConf hiveConf, HiveMetaHookLoader hiveMetaHookLoader, boolean allowEmbedded, ConcurrentHashMap<String, Long> metaCallTimeMap) throws MetaException {
        switch (this.proxyMode) {
            case METASTORE_ONLY: {
                break;
            }
            case METASTORE_DLF_FAILURE: 
            case METASTORE_DLF_SUCCESS: 
            case DLF_METASTORE_SUCCESS: 
            case DLF_METASTORE_FAILURE: 
            case DLF_ONLY: {
                this.dlfSessionMetaStoreClient = new DlfSessionMetaStoreClient(hiveConf, hiveMetaHookLoader, allowEmbedded);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.proxyMode);
            }
        }
    }

    public boolean isCompatibleWith(HiveConf hiveConf) {
        try {
            return (Boolean)this.call(this.readWriteClient, client -> client.isCompatibleWith(hiveConf), "isCompatibleWith", hiveConf);
        }
        catch (TException e) {
            logger.error("failed to isCompatibleWith:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void setHiveAddedJars(String s) {
        try {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.setHiveAddedJars(s)), "setHiveAddedJars", s);
        }
        catch (TException e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isLocalMetaStore() {
        return !this.extraClient.isPresent() && this.readWriteClient.isLocalMetaStore();
    }

    public void reconnect() throws MetaException {
        if (this.hiveSessionMetaStoreClient != null) {
            this.hiveSessionMetaStoreClient.reconnect();
        }
    }

    public void close() {
        if (this.hiveSessionMetaStoreClient != null) {
            this.hiveSessionMetaStoreClient.close();
        }
    }

    public void createDatabase(Database database) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.createDatabase(database)), "createDatabase", database);
    }

    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return (Database)this.call(this.readWriteClient, client -> client.getDatabase(name), "getDatabase", name);
    }

    public List<String> getDatabases(String pattern) throws MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.getDatabases(pattern), "getDatabases", pattern);
    }

    public List<String> getAllDatabases() throws MetaException, TException {
        return this.getDatabases(".*");
    }

    public void alterDatabase(String databaseName, Database database) throws NoSuchObjectException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alterDatabase(databaseName, database)), "alterDatabase", databaseName, database);
    }

    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropDatabase(name, deleteData, ignoreUnknownDb, cascade)), "dropDatabase", name, deleteData, ignoreUnknownDb, cascade);
    }

    public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return (Partition)this.call(client -> client.add_partition(partition), "add_partition", partition);
    }

    public int add_partitions(List<Partition> partitions) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return (Integer)this.call(client -> client.add_partitions(partitions), "add_partitions", partitions);
    }

    public List<Partition> add_partitions(List<Partition> partitions, boolean ifNotExists, boolean needResult) throws TException {
        return (List)this.call(client -> client.add_partitions(partitions, ifNotExists, needResult), "add_partitions", partitions, ifNotExists, needResult);
    }

    public int add_partitions_pspec(PartitionSpecProxy pSpec) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return (Integer)this.call(client -> client.add_partitions_pspec(pSpec), "add_partitions_pspec", pSpec);
    }

    public void alterFunction(String dbName, String functionName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alterFunction(dbName, functionName, newFunction)), "alterFunction", dbName, functionName, newFunction);
    }

    public void alter_index(String dbName, String tblName, String indexName, Index index) throws InvalidOperationException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_index(dbName, tblName, indexName, index)), "alter_index", dbName, tblName, indexName, index);
    }

    public void alter_partition(String dbName, String tblName, Partition partition) throws InvalidOperationException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_partition(dbName, tblName, partition)), "alter_partition", dbName, tblName, partition);
    }

    public void alter_partition(String dbName, String tblName, Partition partition, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_partition(dbName, tblName, partition, environmentContext)), "alter_partition", dbName, tblName, partition, environmentContext);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> partitions) throws InvalidOperationException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_partitions(dbName, tblName, partitions)), "alter_partitions", dbName, tblName, partitions);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> partitions, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_partitions(dbName, tblName, partitions, environmentContext)), "alter_partitions", dbName, tblName, partitions, environmentContext);
    }

    public void alter_table(String dbName, String tblName, Table table) throws InvalidOperationException, MetaException, TException {
        if (table.isTemporary()) {
            this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_table(dbName, tblName, table)), "alter_table", dbName, tblName, table);
        } else {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_table(dbName, tblName, table)), "alter_table", dbName, tblName, table);
        }
    }

    @Deprecated
    public void alter_table(String dbName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        if (table.isTemporary()) {
            this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_table(dbName, tblName, table, cascade)), "alter_table", dbName, tblName, table, cascade);
        } else {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_table(dbName, tblName, table, cascade)), "alter_table", dbName, tblName, table, cascade);
        }
    }

    public void alter_table_with_environmentContext(String dbName, String tblName, Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        if (table.isTemporary()) {
            this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_table_with_environmentContext(dbName, tblName, table, environmentContext)), "alter_table_with_environmentContext", dbName, tblName, table, environmentContext);
        } else {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.alter_table_with_environmentContext(dbName, tblName, table, environmentContext)), "alter_table_with_environmentContext", dbName, tblName, table, environmentContext);
        }
    }

    public Partition appendPartition(String dbName, String tblName, List<String> values) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return (Partition)this.call(client -> client.appendPartition(dbName, tblName, values), "appendPartition", dbName, tblName, values);
    }

    public Partition appendPartition(String dbName, String tblName, String partitionName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return (Partition)this.call(client -> client.appendPartition(dbName, tblName, partitionName), "appendPartition", dbName, tblName, partitionName);
    }

    public boolean create_role(Role role) throws MetaException, TException {
        return (Boolean)this.call(client -> client.create_role(role), "create_role", role);
    }

    public boolean drop_role(String roleName) throws MetaException, TException {
        return (Boolean)this.call(client -> client.drop_role(roleName), "drop_role", roleName);
    }

    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.list_roles(principalName, principalType), "list_roles", principalName, principalType);
    }

    public List<String> listRoleNames() throws MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.listRoleNames(), "listRoleNames", new Object[0]);
    }

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request) throws MetaException, TException {
        return (GetPrincipalsInRoleResponse)this.call(this.readWriteClient, client -> client.get_principals_in_role(request), "get_principals_in_role", request);
    }

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request) throws MetaException, TException {
        return (GetRoleGrantsForPrincipalResponse)this.call(this.readWriteClient, client -> client.get_role_grants_for_principal(request), "get_role_grants_for_principal", request);
    }

    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        return (Boolean)this.call(client -> client.grant_role(roleName, userName, principalType, grantor, grantorType, grantOption), "grant_role", roleName, userName, principalType, grantor, grantorType, grantOption);
    }

    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        return (Boolean)this.call(client -> client.revoke_role(roleName, userName, principalType, grantOption), "revoke_role", roleName, userName, principalType, grantOption);
    }

    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.cancelDelegationToken(tokenStrForm)), "cancelDelegationToken", tokenStrForm);
    }

    public String getTokenStrForm() throws IOException {
        try {
            return (String)this.call(this.readWriteClient, client -> {
                try {
                    return client.getTokenStrForm();
                }
                catch (IOException e) {
                    throw new TException(e.getMessage(), (Throwable)e);
                }
            }, "getTokenStrForm", new Object[0]);
        }
        catch (TException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        return (Boolean)this.call(client -> client.addToken(tokenIdentifier, delegationToken), "addToken", tokenIdentifier, delegationToken);
    }

    public boolean removeToken(String tokenIdentifier) throws TException {
        return (Boolean)this.call(client -> client.removeToken(tokenIdentifier), "removeToken", tokenIdentifier);
    }

    public String getToken(String tokenIdentifier) throws TException {
        return (String)this.call(this.readWriteClient, client -> client.getToken(tokenIdentifier), "getToken", tokenIdentifier);
    }

    public List<String> getAllTokenIdentifiers() throws TException {
        return (List)this.call(this.readWriteClient, client -> client.getAllTokenIdentifiers(), "getAllTokenIdentifiers", new Object[0]);
    }

    public int addMasterKey(String key) throws MetaException, TException {
        return (Integer)this.call(client -> client.addMasterKey(key), "addMasterKey", key);
    }

    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.updateMasterKey(seqNo, key)), "updateMasterKey", key);
    }

    public boolean removeMasterKey(Integer keySeq) throws TException {
        return (Boolean)this.call(client -> client.removeMasterKey(keySeq), "removeMasterKey", keySeq);
    }

    public String[] getMasterKeys() throws TException {
        return (String[])this.call(this.readWriteClient, client -> client.getMasterKeys(), "getMasterKeys", new Object[0]);
    }

    public LockResponse checkLock(long lockId) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return (LockResponse)this.call(this.readWriteClient, client -> client.checkLock(lockId), "checkLock", lockId);
    }

    public void commitTxn(long txnId) throws NoSuchTxnException, TxnAbortedException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.commitTxn(txnId)), "commitTxn", txnId);
    }

    public void abortTxns(List<Long> txnIds) throws TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.abortTxns(txnIds)), "abortTxns", txnIds);
    }

    @Deprecated
    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType) throws TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.compact(dbName, tblName, partitionName, compactionType)), "compact", dbName, tblName, partitionName, compactionType);
    }

    @Deprecated
    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.compact(dbName, tblName, partitionName, compactionType, tblProperties)), "compact", dbName, tblName, partitionName, compactionType, tblProperties);
    }

    public CompactionResponse compact2(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        return (CompactionResponse)this.call(client -> client.compact2(dbName, tblName, partitionName, compactionType, tblProperties), "compact2", dbName, tblName, partitionName, compactionType, tblProperties);
    }

    public void createFunction(Function function) throws InvalidObjectException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.createFunction(function)), "createFunction", function);
    }

    public void createIndex(Index index, Table indexTable) throws InvalidObjectException, MetaException, NoSuchObjectException, TException, AlreadyExistsException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.createIndex(index, indexTable)), "createIndex", index, indexTable);
    }

    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.createTable(tbl, null);
    }

    public void createTable(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        if (tbl.isTemporary()) {
            this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.createTable(tbl)), "createTable", tbl);
        } else {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.createTable(tbl)), "createTable", tbl);
        }
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return (Boolean)this.call(client -> client.deletePartitionColumnStatistics(dbName, tableName, partName, colName), "deletePartitionColumnStatistics", dbName, tableName, partName, colName);
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return (Boolean)this.call(client -> client.deleteTableColumnStatistics(dbName, tableName, colName), "deleteTableColumnStatistics", dbName, tableName, colName);
    }

    public void dropFunction(String dbName, String functionName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropFunction(dbName, functionName)), "dropFunction", dbName, functionName);
    }

    public boolean dropIndex(String dbName, String tblName, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return (Boolean)this.call(client -> client.dropIndex(dbName, tblName, name, deleteData), "dropIndex", dbName, tblName, name, deleteData);
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return (Boolean)this.call(client -> client.dropPartition(dbName, tblName, values, deleteData), "dropPartition", dbName, tblName, values, deleteData);
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, PartitionDropOptions options) throws TException {
        return (Boolean)this.call(client -> client.dropPartition(dbName, tblName, values, options), "dropPartition", dbName, tblName, values, options);
    }

    public boolean dropPartition(String dbName, String tblName, String partitionName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return (Boolean)this.call(client -> client.dropPartition(dbName, tblName, partitionName, deleteData), "dropPartition", dbName, tblName, partitionName, deleteData);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return (List)this.call(client -> client.dropPartitions(dbName, tblName, partExprs, deleteData, ifExists), "dropPartitions", dbName, tblName, partExprs, deleteData, ifExists);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResults) throws NoSuchObjectException, MetaException, TException {
        return (List)this.call(client -> client.dropPartitions(dbName, tblName, partExprs, deleteData, false, needResults), "dropPartitions", dbName, tblName, partExprs, deleteData, ifExists, needResults);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        return (List)this.call(client -> client.dropPartitions(dbName, tblName, partExprs, options), "dropPartitions", dbName, tblName, partExprs, options);
    }

    @Deprecated
    public void dropTable(String tableName, boolean deleteData) throws MetaException, UnknownTableException, TException, NoSuchObjectException {
        Table table = this.getTempTable("default", tableName);
        if (table != null) {
            this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropTable(tableName, deleteData)), "dropTable", tableName, deleteData);
        } else {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropTable(tableName, deleteData)), "dropTable", tableName, deleteData);
        }
    }

    private Table getTempTable(String dbName, String tableName) {
        org.apache.hadoop.hive.ql.metadata.Table table;
        Map<String, org.apache.hadoop.hive.ql.metadata.Table> tables = ProxyMetaStoreClient.getTempTablesForDatabase(dbName.toLowerCase());
        if (tables != null && (table = tables.get(tableName.toLowerCase())) != null) {
            return table.getTTable();
        }
        return null;
    }

    public void dropTable(String dbname, String tableName) throws MetaException, TException, NoSuchObjectException {
        Table table = this.getTempTable(dbname, tableName);
        if (table != null) {
            this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropTable(dbname, tableName)), "dropTable", dbname, tableName);
        } else {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropTable(dbname, tableName)), "dropTable", dbname, tableName);
        }
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException {
        Table table = this.getTempTable(dbname, tableName);
        if (table != null) {
            this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropTable(dbname, tableName, deleteData, ignoreUnknownTab)), "dropTable", dbname, tableName, deleteData, ignoreUnknownTab);
        } else {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropTable(dbname, tableName, deleteData, ignoreUnknownTab)), "dropTable", dbname, tableName, deleteData, ignoreUnknownTab);
        }
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTable, boolean ifPurge) throws MetaException, TException, NoSuchObjectException {
        Table table = this.getTempTable(dbname, tableName);
        if (table != null) {
            this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropTable(dbname, tableName, deleteData, ignoreUnknownTable, ifPurge)), "dropTable", dbname, tableName, deleteData, ignoreUnknownTable, ifPurge);
        } else {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropTable(dbname, tableName, deleteData, ignoreUnknownTable, ifPurge)), "dropTable", dbname, tableName, deleteData, ignoreUnknownTable, ifPurge);
        }
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String srcDb, String srcTbl, String dstDb, String dstTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return (Partition)this.call(client -> client.exchange_partition(partitionSpecs, srcDb, srcTbl, dstDb, dstTbl), "exchange_partition", partitionSpecs, srcDb, srcTbl, dstDb, dstTbl);
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTbl, String destDb, String destTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return (List)this.call(client -> client.exchange_partitions(partitionSpecs, sourceDb, sourceTbl, destDb, destTbl), "exchange_partitions", partitionSpecs, sourceDb, sourceTbl, destDb, destTbl);
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) throws NoSuchObjectException, MetaException, TException {
        return (AggrStats)this.call(this.readWriteClient, client -> client.getAggrColStatsFor(dbName, tblName, colNames, partName), "getAggrColStatsFor", dbName, tblName, colNames, partName);
    }

    public List<String> getAllTables(String dbname) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbname, ".*");
    }

    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return (String)this.call(this.readWriteClient, client -> client.getConfigValue(name, defaultValue), "getConfigValue", name, defaultValue);
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        return (String)this.call(this.readWriteClient, client -> client.getDelegationToken(owner, renewerKerberosPrincipalName), "getDelegationToken", owner, renewerKerberosPrincipalName);
    }

    public List<FieldSchema> getFields(String db, String tableName) throws TException {
        return (List)this.call(this.readWriteClient, client -> client.getFields(db, tableName), "getFields", db, tableName);
    }

    public Function getFunction(String dbName, String functionName) throws MetaException, TException {
        return (Function)this.call(this.readWriteClient, client -> client.getFunction(dbName, functionName), "getFunction", dbName, functionName);
    }

    public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.getFunctions(dbName, pattern), "getFunctions", dbName, pattern);
    }

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return (GetAllFunctionsResponse)this.call(this.readWriteClient, client -> client.getAllFunctions(), "getAllFunctions", new Object[0]);
    }

    public Index getIndex(String dbName, String tblName, String indexName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return (Index)this.call(this.readWriteClient, client -> client.getIndex(dbName, tblName, indexName), "getIndex", dbName, tblName, indexName);
    }

    public String getMetaConf(String key) throws MetaException, TException {
        return (String)this.call(this.readWriteClient, client -> client.getMetaConf(key), "getMetaConf", key);
    }

    public Partition getPartition(String dbName, String tblName, List<String> values) throws NoSuchObjectException, MetaException, TException {
        return (Partition)this.call(this.readWriteClient, client -> client.getPartition(dbName, tblName, values), "getPartition", dbName, tblName, values);
    }

    public Partition getPartition(String dbName, String tblName, String partitionName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return (Partition)this.call(this.readWriteClient, client -> client.getPartition(dbName, tblName, partitionName), "getPartition", dbName, tblName, partitionName);
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws NoSuchObjectException, MetaException, TException {
        return (Map)this.call(this.readWriteClient, client -> client.getPartitionColumnStatistics(dbName, tableName, partitionNames, columnNames), "getPartitionColumnStatistics", dbName, tableName, partitionNames, columnNames);
    }

    public Partition getPartitionWithAuthInfo(String databaseName, String tableName, List<String> values, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return (Partition)this.call(this.readWriteClient, client -> client.getPartitionWithAuthInfo(databaseName, tableName, values, userName, groupNames), "getPartitionWithAuthInfo", databaseName, tableName, values, userName, groupNames);
    }

    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException, MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.getPartitionsByNames(databaseName, tableName, partitionNames), "getPartitionsByNames", databaseName, tableName, partitionNames);
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws TException {
        return (List)this.call(this.readWriteClient, client -> client.getSchema(db, tableName), "getSchema", db, tableName);
    }

    @Deprecated
    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        return (Table)this.call(this.readWriteClient, client -> client.getTable(tableName), "getTable", tableName);
    }

    public Table getTable(String dbName, String tableName) throws MetaException, TException, NoSuchObjectException {
        return (Table)this.call(this.readWriteClient, client -> client.getTable(dbName, tableName), "getTable", dbName, tableName);
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.getTableColumnStatistics(dbName, tableName, colNames), "getTableColumnStatistics", dbName, tableName, colNames);
    }

    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        return (List)this.call(this.readWriteClient, client -> client.getTableObjectsByName(dbName, tableNames), "getTableObjectsByName", dbName, tableNames);
    }

    public List<String> getTables(String dbname, String tablePattern) throws MetaException, TException, UnknownDBException {
        return (List)this.call(this.readWriteClient, client -> client.getTables(dbname, tablePattern), "getTables", dbname, tablePattern);
    }

    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        return (List)this.call(this.readWriteClient, client -> client.getTables(dbname, tablePattern, tableType), "getTables", dbname, tablePattern, tableType);
    }

    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException, UnsupportedOperationException {
        return (List)this.call(this.readWriteClient, client -> client.getTableMeta(dbPatterns, tablePatterns, tableTypes), "getTableMeta", dbPatterns, tablePatterns, tableTypes);
    }

    public ValidTxnList getValidTxns() throws TException {
        return (ValidTxnList)this.call(this.readWriteClient, client -> client.getValidTxns(), "getValidTxns", new Object[0]);
    }

    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        return (ValidTxnList)this.call(this.readWriteClient, client -> client.getValidTxns(currentTxn), "getValidTxns", currentTxn);
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef obj, String user, List<String> groups) throws MetaException, TException {
        return (PrincipalPrivilegeSet)this.call(this.readWriteClient, client -> client.get_privilege_set(obj, user, groups), "get_privilege_set", obj, user, groups);
    }

    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        return (Boolean)this.call(client -> client.grant_privileges(privileges), "grant_privileges", privileges);
    }

    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        return (Boolean)this.call(client -> client.revoke_privileges(privileges, grantOption), "revoke_privileges", privileges, grantOption);
    }

    public void heartbeat(long txnId, long lockId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.heartbeat(txnId, lockId)), "heartbeat", txnId, lockId);
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws TException {
        return (HeartbeatTxnRangeResponse)this.call(client -> client.heartbeatTxnRange(min, max), "heartbeatTxnRange", min, max);
    }

    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        return (Boolean)this.call(this.readWriteClient, client -> client.isPartitionMarkedForEvent(dbName, tblName, partKVs, eventType), "isPartitionMarkedForEvent", dbName, tblName, partKVs, eventType);
    }

    public List<String> listIndexNames(String dbName, String tblName, short max) throws MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.listIndexNames(dbName, tblName, max), "listIndexNames", dbName, tblName, max);
    }

    public List<Index> listIndexes(String db_name, String tbl_name, short max) throws TException {
        return (List)this.call(this.readWriteClient, client -> client.listIndexes(db_name, tbl_name, max), "listIndexes", db_name, tbl_name, max);
    }

    public List<String> listPartitionNames(String dbName, String tblName, short max) throws MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.listPartitionNames(dbName, tblName, max), "listPartitionNames", dbName, tblName, max);
    }

    public List<String> listPartitionNames(String databaseName, String tableName, List<String> values, short max) throws MetaException, TException, NoSuchObjectException {
        return (List)this.call(this.readWriteClient, client -> client.listPartitionNames(databaseName, tableName, values, max), "listPartitionNames", databaseName, tableName, values, max);
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest partitionValuesRequest) throws MetaException, TException, NoSuchObjectException {
        return (PartitionValuesResponse)this.call(this.readWriteClient, client -> client.listPartitionValues(partitionValuesRequest), "listPartitionValues", partitionValuesRequest);
    }

    public int getNumPartitionsByFilter(String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        return (Integer)this.call(this.readWriteClient, client -> client.getNumPartitionsByFilter(dbName, tableName, filter), "getNumPartitionsByFilter", dbName, tableName, filter);
    }

    public PartitionSpecProxy listPartitionSpecs(String dbName, String tblName, int max) throws TException {
        return (PartitionSpecProxy)this.call(this.readWriteClient, client -> client.listPartitionSpecs(dbName, tblName, max), "listPartitionSpecs", dbName, tblName, max);
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String dbName, String tblName, String filter, int max) throws MetaException, NoSuchObjectException, TException {
        return (PartitionSpecProxy)this.call(this.readWriteClient, client -> client.listPartitionSpecsByFilter(dbName, tblName, filter, max), "listPartitionSpecsByFilter", dbName, tblName, filter, max);
    }

    public List<Partition> listPartitions(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.listPartitions(dbName, tblName, max), "listPartitions", dbName, tblName, max);
    }

    public List<Partition> listPartitions(String databaseName, String tableName, List<String> values, short max) throws NoSuchObjectException, MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.listPartitions(databaseName, tableName, values, max), "listPartitions", databaseName, tableName, values, max);
    }

    public boolean listPartitionsByExpr(String databaseName, String tableName, byte[] expr, String defaultPartitionName, short max, List<Partition> result) throws TException {
        return (Boolean)this.call(this.readWriteClient, client -> client.listPartitionsByExpr(databaseName, tableName, expr, defaultPartitionName, max, result), "listPartitionsByExpr", databaseName, tableName, expr, defaultPartitionName, max, result);
    }

    public List<Partition> listPartitionsByFilter(String databaseName, String tableName, String filter, short max) throws MetaException, NoSuchObjectException, TException {
        return (List)this.call(this.readWriteClient, client -> client.listPartitionsByFilter(databaseName, tableName, filter, max), "listPartitionsByFilter", databaseName, tableName, filter, max);
    }

    public List<Partition> listPartitionsWithAuthInfo(String database, String table, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        return (List)this.call(this.readWriteClient, client -> client.listPartitionsWithAuthInfo(database, table, maxParts, user, groups), "listPartitionsWithAuthInfo", database, table, maxParts, user, groups);
    }

    public List<Partition> listPartitionsWithAuthInfo(String database, String table, List<String> partVals, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        return (List)this.call(this.readWriteClient, client -> client.listPartitionsWithAuthInfo(database, table, partVals, maxParts, user, groups), "listPartitionsWithAuthInfo", database, table, partVals, maxParts, user, groups);
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException, UnsupportedOperationException {
        return (List)this.call(this.readWriteClient, client -> client.listTableNamesByFilter(dbName, filter, maxTables), "listTableNamesByFilter", dbName, filter, maxTables);
    }

    public List<HiveObjectPrivilege> list_privileges(String principal, PrincipalType principalType, HiveObjectRef objectRef) throws MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.list_privileges(principal, principalType, objectRef), "list_privileges", principal, principalType, objectRef);
    }

    public LockResponse lock(LockRequest lockRequest) throws NoSuchTxnException, TxnAbortedException, TException {
        return (LockResponse)this.call(client -> client.lock(lockRequest), "lock", lockRequest);
    }

    public void markPartitionForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.markPartitionForEvent(dbName, tblName, partKVs, eventType)), "markPartitionForEvent", dbName, tblName, partKVs, eventType);
    }

    public long openTxn(String user) throws TException {
        return (Long)this.call(client -> client.openTxn(user), "openTxn", user);
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        return (OpenTxnsResponse)this.call(client -> client.openTxns(user, numTxns), "openTxns", user, numTxns);
    }

    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        return (Map)this.call(this.readWriteClient, client -> client.partitionNameToSpec(name), "partitionNameToSpec", name);
    }

    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return (List)this.call(this.readWriteClient, client -> client.partitionNameToVals(name), "partitionNameToVals", name);
    }

    public void renamePartition(String dbName, String tblName, List<String> partitionValues, Partition newPartition) throws InvalidOperationException, MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.renamePartition(dbName, tblName, partitionValues, newPartition)), "renamePartition", dbName, tblName, partitionValues, newPartition);
    }

    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        return (Long)this.call(client -> client.renewDelegationToken(tokenStrForm), "renewDelegationToken", tokenStrForm);
    }

    public void rollbackTxn(long txnId) throws NoSuchTxnException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.rollbackTxn(txnId)), "rollbackTxn", txnId);
    }

    public void setMetaConf(String key, String value) throws MetaException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.setMetaConf(key, value)), "setMetaConf", key, value);
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        boolean result;
        block3: {
            SetPartitionsStatsRequest deepCopy = request.deepCopy();
            result = this.readWriteClient.setPartitionColumnStatistics(deepCopy);
            if (this.extraClient.isPresent()) {
                try {
                    this.extraClient.get().setPartitionColumnStatistics(request);
                }
                catch (Exception e) {
                    FunctionalUtils.collectLogs((Exception)e, (String)"setPartitionColumnStatistics", (Object[])new Object[]{request});
                    if (this.allowFailure) break block3;
                    throw e;
                }
            }
        }
        return result;
    }

    public void flushCache() {
        try {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.flushCache()), "flushCache", new Object[0]);
        }
        catch (TException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws TException {
        return (Iterable)this.call(this.readWriteClient, client -> client.getFileMetadata(fileIds), "getFileMetadata", fileIds);
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws TException {
        return (Iterable)this.call(this.readWriteClient, client -> client.getFileMetadataBySarg(fileIds, sarg, doGetFooters), "getFileMetadataBySarg", fileIds, sarg, doGetFooters);
    }

    public void clearFileMetadata(List<Long> fileIds) throws TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.clearFileMetadata(fileIds)), "clearFileMetadata", fileIds);
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.putFileMetadata(fileIds, metadata)), "putFileMetadata", fileIds, metadata);
    }

    public boolean isSameConfObj(HiveConf hiveConf) {
        try {
            return (Boolean)this.call(this.readWriteClient, client -> client.isSameConfObj(hiveConf), "isSameConfObj", hiveConf);
        }
        catch (TException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean cacheFileMetadata(String dbName, String tblName, String partName, boolean allParts) throws TException {
        return (Boolean)this.call(client -> client.cacheFileMetadata(dbName, tblName, partName, allParts), "cacheFileMetadata", dbName, tblName, partName, allParts);
    }

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest primaryKeysRequest) throws MetaException, NoSuchObjectException, TException {
        return (List)this.call(this.readWriteClient, client -> client.getPrimaryKeys(primaryKeysRequest), "getPrimaryKeys", primaryKeysRequest);
    }

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest foreignKeysRequest) throws MetaException, NoSuchObjectException, TException {
        return (List)this.call(this.readWriteClient, client -> client.getForeignKeys(foreignKeysRequest), "getForeignKeys", foreignKeysRequest);
    }

    public void createTableWithConstraints(Table table, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.createTableWithConstraints(table, primaryKeys, foreignKeys)), "createTableWithConstraints", table, primaryKeys, foreignKeys);
    }

    public void dropConstraint(String dbName, String tblName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.dropConstraint(dbName, tblName, constraintName)), "dropConstraint", dbName, tblName, constraintName);
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws MetaException, NoSuchObjectException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.addPrimaryKey(primaryKeyCols)), "addPrimaryKey", primaryKeyCols);
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws MetaException, NoSuchObjectException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.addForeignKey(foreignKeyCols)), "addForeignKey", foreignKeyCols);
    }

    public ShowCompactResponse showCompactions() throws TException {
        return (ShowCompactResponse)this.call(this.readWriteClient, client -> client.showCompactions(), "showCompactions", new Object[0]);
    }

    @Deprecated
    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames) throws TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.addDynamicPartitions(txnId, dbName, tblName, partNames)), "addDynamicPartitions", txnId, dbName, tblName, partNames);
    }

    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames, DataOperationType operationType) throws TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.addDynamicPartitions(txnId, dbName, tblName, partNames, operationType)), "addDynamicPartitions", txnId, dbName, tblName, partNames, operationType);
    }

    public void insertTable(Table table, boolean overwrite) throws MetaException {
        try {
            this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.insertTable(table, overwrite)), "insertTable", table, overwrite);
        }
        catch (TException e) {
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException("failed to insertTable:" + e.getMessage()), (Exception)((Object)e));
        }
    }

    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter notificationFilter) throws TException {
        return (NotificationEventResponse)this.call(this.readWriteClient, client -> client.getNextNotification(lastEventId, maxEvents, notificationFilter), "getNextNotification", lastEventId, maxEvents, notificationFilter);
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return (CurrentNotificationEventId)this.call(this.readWriteClient, client -> client.getCurrentNotificationEventId(), "getCurrentNotificationEventId", new Object[0]);
    }

    public FireEventResponse fireListenerEvent(FireEventRequest fireEventRequest) throws TException {
        return (FireEventResponse)this.call(this.readWriteClient, client -> client.fireListenerEvent(fireEventRequest), "fireListenerEvent", fireEventRequest);
    }

    @Deprecated
    public ShowLocksResponse showLocks() throws TException {
        return (ShowLocksResponse)this.call(this.readWriteClient, client -> client.showLocks(), "showLocks", new Object[0]);
    }

    public ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) throws TException {
        return (ShowLocksResponse)this.call(this.readWriteClient, client -> client.showLocks(showLocksRequest), "showLocks", showLocksRequest);
    }

    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return (GetOpenTxnsInfoResponse)this.call(this.readWriteClient, client -> client.showTxns(), "showTxns", new Object[0]);
    }

    @Deprecated
    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        return (Boolean)this.call(this.readWriteClient, client -> client.tableExists(tableName), "tableExists", tableName);
    }

    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        return (Boolean)this.call(this.readWriteClient, client -> client.tableExists(databaseName, tableName), "tableExists", databaseName, tableName);
    }

    public void unlock(long lockId) throws NoSuchLockException, TxnOpenException, TException {
        this.run((ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.unlock(lockId)), "unlock", lockId);
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return (Boolean)this.call(client -> client.updatePartitionColumnStatistics(columnStatistics), "updatePartitionColumnStatistics", columnStatistics);
    }

    public boolean updateTableColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return (Boolean)this.call(client -> client.updateTableColumnStatistics(columnStatistics), "updateTableColumnStatistics", columnStatistics);
    }

    public void validatePartitionNameCharacters(List<String> part_vals) throws TException, MetaException {
        this.run(this.readWriteClient, (ThrowingConsumer<IMetaStoreClient, TException>)((ThrowingConsumer)client -> client.validatePartitionNameCharacters(part_vals)), "validatePartitionNameCharacters", part_vals);
    }

    @VisibleForTesting
    public IMetaStoreClient getDlfSessionMetaStoreClient() {
        return this.dlfSessionMetaStoreClient;
    }

    @VisibleForTesting
    public IMetaStoreClient getHiveSessionMetaStoreClient() {
        return this.hiveSessionMetaStoreClient;
    }

    @VisibleForTesting
    boolean isAllowFailure() {
        return this.allowFailure;
    }

    public void run(ThrowingConsumer<IMetaStoreClient, TException> consumer, String actionName, Object ... parameters) throws TException {
        FunctionalUtils.run((Object)this.readWriteClient, this.extraClient, (boolean)this.allowFailure, consumer, (String)this.readWriteClientType, (String)actionName, (Object[])parameters);
    }

    public void run(IMetaStoreClient client, ThrowingConsumer<IMetaStoreClient, TException> consumer, String actionName, Object ... parameters) throws TException {
        FunctionalUtils.run((Object)client, Optional.empty(), (boolean)this.allowFailure, consumer, (String)this.readWriteClientType, (String)actionName, (Object[])parameters);
    }

    public <R> R call(ThrowingFunction<IMetaStoreClient, R, TException> consumer, String actionName, Object ... parameters) throws TException {
        return (R)FunctionalUtils.call((Object)this.readWriteClient, this.extraClient, (boolean)this.allowFailure, consumer, (String)this.readWriteClientType, (String)actionName, (Object[])parameters);
    }

    public <R> R call(IMetaStoreClient client, ThrowingFunction<IMetaStoreClient, R, TException> consumer, String actionName, Object ... parameters) throws TException {
        return (R)FunctionalUtils.call((Object)client, Optional.empty(), (boolean)this.allowFailure, consumer, (String)this.readWriteClientType, (String)actionName, (Object[])parameters);
    }
}

