/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive2;

import com.aliyun.datalake.metastore.hive.common.utils.SessionClientUtils;
import com.aliyun.datalake.metastore.hive.shims.ShimsLoader;
import com.aliyun.datalake.metastore.hive2.DlfMetaStoreClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlfSessionMetaStoreClient
extends DlfMetaStoreClient
implements IMetaStoreClient {
    private static final Logger LOG = LoggerFactory.getLogger(DlfSessionMetaStoreClient.class);
    private Warehouse wh = null;

    public DlfSessionMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        super(conf, hookLoader);
    }

    public DlfSessionMetaStoreClient(HiveConf hiveConf, HiveMetaHookLoader hiveMetaHookLoader) throws MetaException {
        this(hiveConf, hiveMetaHookLoader, null);
    }

    private static boolean haveTableColumnsChanged(org.apache.hadoop.hive.metastore.api.Table oldt, org.apache.hadoop.hive.metastore.api.Table newt) {
        List oldCols = oldt.getSd().getCols();
        List newCols = newt.getSd().getCols();
        if (oldCols.size() != newCols.size()) {
            return true;
        }
        Iterator oldColsIter = oldCols.iterator();
        Iterator newColsIter = newCols.iterator();
        while (oldColsIter.hasNext()) {
            if (DlfSessionMetaStoreClient.fieldSchemaEqualsIgnoreComment((FieldSchema)oldColsIter.next(), (FieldSchema)newColsIter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean fieldSchemaEqualsIgnoreComment(FieldSchema left, FieldSchema right) {
        if (!left.getName().equals(right.getName())) {
            return true;
        }
        return !left.getType().equals(right.getType());
    }

    public static Map<String, Table> getTempTablesForDatabase(String dbName) {
        return DlfSessionMetaStoreClient.getTempTables().get(dbName);
    }

    public static Map<String, Map<String, Table>> getTempTables() {
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.debug("No current SessionState, skipping temp tables");
            return Collections.emptyMap();
        }
        return ss.getTempTables();
    }

    private static void mergeColumnStats(Map<String, ColumnStatisticsObj> oldStats, ColumnStatistics newStats) {
        List newColList = newStats.getStatsObj();
        if (newColList != null) {
            for (ColumnStatisticsObj colStat : newColList) {
                oldStats.put(colStat.getColName().toLowerCase(), colStat);
            }
        }
    }

    private Warehouse getWh() throws MetaException {
        if (this.wh == null) {
            this.wh = new Warehouse((Configuration)this.conf);
        }
        return this.wh;
    }

    @Override
    protected void create_table_with_environment_context(org.apache.hadoop.hive.metastore.api.Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        if (tbl.isTemporary()) {
            this.createTempTable(tbl, envContext);
            return;
        }
        super.create_table_with_environment_context(tbl, envContext);
    }

    @Override
    protected void drop_table_with_environment_context(String dbname, String name, boolean deleteData, boolean ignoreUnknownTable, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbname, name);
        if (table != null) {
            try {
                this.deleteTempTableColumnStatsForTable(dbname, name);
            }
            catch (NoSuchObjectException err) {
                LOG.info("Object not found in metastore", (Throwable)err);
            }
            this.dropTempTable(table, deleteData, envContext);
            return;
        }
        super.drop_table_with_environment_context(dbname, name, deleteData, ignoreUnknownTable, envContext);
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbname, name);
        if (table != null) {
            return SessionClientUtils.deepCopy((org.apache.hadoop.hive.metastore.api.Table)table);
        }
        return super.getTable(dbname, name);
    }

    @Override
    public List<String> getAllTables(String dbName) throws TException {
        List<String> tableNames = super.getAllTables(dbName);
        Map<String, Table> tables = DlfSessionMetaStoreClient.getTempTablesForDatabase(dbName);
        if (tables == null || tables.size() == 0) {
            return tableNames;
        }
        return SessionClientUtils.mergeSortList(tableNames, tables.keySet());
    }

    @Override
    public List<String> getTables(String dbName, String tablePattern) throws TException {
        List<String> tableNames = super.getTables(dbName, tablePattern);
        dbName = dbName.toLowerCase();
        tablePattern = tablePattern.toLowerCase();
        Map<String, Table> tables = DlfSessionMetaStoreClient.getTempTablesForDatabase(dbName);
        if (tables == null || tables.size() == 0) {
            return tableNames;
        }
        return SessionClientUtils.mergeSortListWithPattern(tableNames, tables.keySet(), (String)tablePattern);
    }

    @Override
    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException {
        List<TableMeta> tableMetas = super.getTableMeta(dbPatterns, tablePatterns, tableTypes);
        Map<String, Map<String, Table>> tmpTables = DlfSessionMetaStoreClient.getTempTables();
        if (tmpTables.isEmpty()) {
            return tableMetas;
        }
        SessionClientUtils.mergeTableMeta((String)dbPatterns, (String)tablePatterns, tableTypes, tableMetas, tmpTables);
        return tableMetas;
    }

    @Override
    public List<org.apache.hadoop.hive.metastore.api.Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        dbName = dbName.toLowerCase();
        if (SessionState.get() == null || SessionState.get().getTempTables().size() == 0) {
            return super.getTableObjectsByName(dbName, tableNames);
        }
        ArrayList<org.apache.hadoop.hive.metastore.api.Table> tables = new ArrayList<org.apache.hadoop.hive.metastore.api.Table>();
        for (String tableName : tableNames) {
            try {
                org.apache.hadoop.hive.metastore.api.Table table = this.getTable(dbName, tableName);
                if (table == null) continue;
                tables.add(table);
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        }
        return tables;
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(databaseName, tableName);
        if (table != null) {
            return true;
        }
        return super.tableExists(databaseName, tableName);
    }

    @Override
    public List<FieldSchema> getSchema(String dbName, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table != null) {
            return SessionClientUtils.deepCopyFieldSchemas((List)table.getSd().getCols());
        }
        return super.getSchema(dbName, tableName);
    }

    @Override
    @Deprecated
    public void alter_table(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl, boolean cascade) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, null);
            return;
        }
        super.alter_table(dbname, tbl_name, new_tbl, cascade);
    }

    @Override
    public void alter_table(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, null);
            return;
        }
        super.alter_table(dbname, tbl_name, new_tbl);
    }

    @Override
    public void alter_table_with_environmentContext(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, envContext);
            return;
        }
        super.alter_table_with_environmentContext(dbname, tbl_name, new_tbl, envContext);
    }

    @Override
    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (hiveObject.getObjectType() == HiveObjectType.TABLE && (table = this.getTempTable(hiveObject.getDbName(), hiveObject.getObjectName())) != null) {
            return SessionClientUtils.deepCopy((PrincipalPrivilegeSet)table.getPrivileges());
        }
        return super.get_privilege_set(hiveObject, userName, groupNames);
    }

    @Override
    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        String tableName;
        ColumnStatistics colStats;
        ColumnStatisticsDesc desc;
        String dbName;
        if (request.getColStatsSize() == 1 && this.getTempTable(dbName = (desc = (colStats = (ColumnStatistics)request.getColStatsIterator().next()).getStatsDesc()).getDbName().toLowerCase(), tableName = desc.getTableName().toLowerCase()) != null) {
            return this.updateTempTableColumnStats(dbName, tableName, colStats);
        }
        return super.setPartitionColumnStatistics(request);
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException, InvalidInputException, InvalidObjectException {
        if (this.getTempTable(dbName, tableName) != null) {
            return this.getTempTableColumnStats(dbName, tableName, colNames);
        }
        return super.getTableColumnStatistics(dbName, tableName, colNames);
    }

    @Override
    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        if (this.getTempTable(dbName, tableName) != null) {
            return this.deleteTempTableColumnStats(dbName, tableName, colName);
        }
        return super.deleteTableColumnStatistics(dbName, tableName, colName);
    }

    private void createTempTable(org.apache.hadoop.hive.metastore.api.Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        SessionState ss = SessionState.get();
        if (ss == null) {
            throw new MetaException("No current SessionState, cannot create temporary table" + tbl.getDbName() + "." + tbl.getTableName());
        }
        tbl = this.deepCopyAndLowerCaseTable(tbl);
        String dbName = tbl.getDbName();
        String tblName = tbl.getTableName();
        Map<String, Table> tables = DlfSessionMetaStoreClient.getTempTablesForDatabase(dbName);
        if (tables != null && tables.containsKey(tblName)) {
            throw new MetaException("Temporary table " + dbName + "." + tblName + " already exists");
        }
        SessionClientUtils.createTempTableDir((SessionState)ss, (Warehouse)this.getWh(), (org.apache.hadoop.hive.metastore.api.Table)tbl, (String)dbName, (String)tblName, tables, (Boolean)this.getEnableFsOperation());
    }

    private org.apache.hadoop.hive.metastore.api.Table getTempTable(String dbName, String tableName) {
        Table table;
        Map<String, Table> tables = DlfSessionMetaStoreClient.getTempTablesForDatabase(dbName.toLowerCase());
        if (tables != null && (table = tables.get(tableName.toLowerCase())) != null) {
            return table.getTTable();
        }
        return null;
    }

    private void alterTempTable(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table oldt, org.apache.hadoop.hive.metastore.api.Table newt, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        dbname = dbname.toLowerCase();
        tbl_name = tbl_name.toLowerCase();
        boolean shouldDeleteColStats = false;
        if (!newt.getSd().getLocation().equals(oldt.getSd().getLocation())) {
            throw new MetaException("Temp table location cannot be changed");
        }
        org.apache.hadoop.hive.metastore.api.Table newtCopy = this.deepCopyAndLowerCaseTable(newt);
        if (ShimsLoader.containsUpdateTableStatsFast()) {
            MetaStoreUtils.updateTableStatsFast((org.apache.hadoop.hive.metastore.api.Table)newtCopy, (FileStatus[])this.getWh().getFileStatusesForSD(newtCopy.getSd()), (boolean)false, (boolean)true, (EnvironmentContext)envContext);
        }
        Table newTable = new Table(newtCopy);
        String newDbName = newTable.getDbName();
        String newTableName = newTable.getTableName();
        if (!newDbName.equals(oldt.getDbName()) || !newTableName.equals(oldt.getTableName())) {
            if (this.getTempTable(newDbName, newTableName) != null) {
                throw new MetaException("Cannot rename temporary table to " + newTableName + " - temporary table already exists with the same name");
            }
            Map<String, Table> tables = DlfSessionMetaStoreClient.getTempTablesForDatabase(dbname);
            if (tables == null || tables.remove(tbl_name) == null) {
                throw new MetaException("Could not find temp table entry for " + dbname + "." + tbl_name);
            }
            shouldDeleteColStats = true;
            tables = DlfSessionMetaStoreClient.getTempTablesForDatabase(newDbName);
            if (tables == null) {
                tables = new HashMap<String, Table>();
                SessionState.get().getTempTables().put(newDbName, tables);
            }
            tables.put(newTableName, newTable);
        } else {
            if (DlfSessionMetaStoreClient.haveTableColumnsChanged(oldt, newt)) {
                shouldDeleteColStats = true;
            }
            DlfSessionMetaStoreClient.getTempTablesForDatabase(dbname).put(tbl_name, newTable);
        }
        if (shouldDeleteColStats) {
            try {
                this.deleteTempTableColumnStatsForTable(dbname, tbl_name);
            }
            catch (NoSuchObjectException err) {
                LOG.info("Object not found in metastore", (Throwable)err);
            }
        }
    }

    private void dropTempTable(org.apache.hadoop.hive.metastore.api.Table table, boolean deleteData, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        String dbName = table.getDbName().toLowerCase();
        String tableName = table.getTableName().toLowerCase();
        Path tablePath = SessionClientUtils.isExistsTempLocation((org.apache.hadoop.hive.metastore.api.Table)table, (Warehouse)this.getWh(), (HiveConf)this.conf);
        Map<String, Table> tables = DlfSessionMetaStoreClient.getTempTablesForDatabase(dbName);
        if (tables == null || tables.remove(tableName) == null) {
            throw new MetaException("Could not find temp table entry for " + dbName + "." + tableName);
        }
        SessionClientUtils.dropTempDir((org.apache.hadoop.hive.metastore.api.Table)table, (Path)tablePath, (Warehouse)this.getWh(), (boolean)deleteData, (EnvironmentContext)envContext, (Boolean)this.getEnableFsOperation());
    }

    private org.apache.hadoop.hive.metastore.api.Table deepCopyAndLowerCaseTable(org.apache.hadoop.hive.metastore.api.Table tbl) {
        org.apache.hadoop.hive.metastore.api.Table newCopy = SessionClientUtils.deepCopy((org.apache.hadoop.hive.metastore.api.Table)tbl);
        newCopy.setDbName(newCopy.getDbName().toLowerCase());
        newCopy.setTableName(newCopy.getTableName().toLowerCase());
        return newCopy;
    }

    private Map<String, ColumnStatisticsObj> getTempTableColumnStatsForTable(String dbName, String tableName) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.debug("No current SessionState, skipping temp tables");
            return null;
        }
        String lookupName = StatsUtils.getFullyQualifiedTableName((String)dbName.toLowerCase(), (String)tableName.toLowerCase());
        return (Map)ss.getTempTableColStats().get(lookupName);
    }

    private List<ColumnStatisticsObj> getTempTableColumnStats(String dbName, String tableName, List<String> colNames) {
        Map<String, ColumnStatisticsObj> tableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        ArrayList<ColumnStatisticsObj> retval = new ArrayList<ColumnStatisticsObj>();
        if (tableColStats != null) {
            for (String colName : colNames) {
                if (!tableColStats.containsKey(colName = colName.toLowerCase())) continue;
                retval.add(new ColumnStatisticsObj(tableColStats.get(colName)));
            }
        }
        return retval;
    }

    private boolean updateTempTableColumnStats(String dbName, String tableName, ColumnStatistics colStats) throws MetaException {
        SessionState ss = SessionState.get();
        if (ss == null) {
            throw new MetaException("No current SessionState, cannot update temporary table stats for " + dbName + "." + tableName);
        }
        Map<String, ColumnStatisticsObj> ssTableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (ssTableColStats == null) {
            ssTableColStats = new HashMap<String, ColumnStatisticsObj>();
            ss.getTempTableColStats().put(StatsUtils.getFullyQualifiedTableName((String)dbName, (String)tableName), ssTableColStats);
        }
        DlfSessionMetaStoreClient.mergeColumnStats(ssTableColStats, colStats);
        return true;
    }

    private boolean deleteTempTableColumnStatsForTable(String dbName, String tableName) throws NoSuchObjectException {
        Map<String, ColumnStatisticsObj> deletedEntry = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (deletedEntry == null) {
            throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " temp table=" + tableName);
        }
        SessionState.get().getTempTableColStats().remove(StatsUtils.getFullyQualifiedTableName((String)dbName, (String)tableName));
        return true;
    }

    private boolean deleteTempTableColumnStats(String dbName, String tableName, String columnName) throws NoSuchObjectException {
        ColumnStatisticsObj deletedEntry = null;
        Map<String, ColumnStatisticsObj> ssTableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (ssTableColStats != null) {
            deletedEntry = ssTableColStats.remove(columnName.toLowerCase());
        }
        if (deletedEntry == null) {
            throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " temp table=" + tableName);
        }
        return true;
    }
}

