/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive2;

import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake.metastore.hive.common.converters.CatalogToHiveConverter;
import com.aliyun.datalake.metastore.hive.common.converters.HiveToCatalogConverter;
import com.aliyun.datalake.metastore.hive.common.utils.ConfigUtils;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import com.aliyun.datalake.metastore.hive.shims.ShimsLoader;
import com.aliyun.datalake.metastore.hive2.DlfMetaStoreClientDelegate;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlfMetaStoreClient
implements IMetaStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(DlfMetaStoreClient.class);
    private static final String INDEX_PREFIX = "meta_index_prefix";
    private static volatile Boolean isCreatedDefaultDatabase;
    protected final HiveConf conf;
    private final Warehouse warehouse;
    private final DlfMetaStoreClientDelegate clientDelegate;
    private final String catalogId;
    private final IHiveShims hiveShims = ShimsLoader.getHiveShims();
    private final Boolean enableFsOperation;
    private Map<String, String> currentMetaVars;
    private final MetaStoreFilterHook filterHook;

    public DlfMetaStoreClient(HiveConf conf) throws MetaException {
        this(conf, null);
    }

    public DlfMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader) throws MetaException {
        long startTime = System.currentTimeMillis();
        logger.info("DlfMetaStoreClient start");
        this.conf = new HiveConf(conf);
        this.catalogId = ConfigUtils.getCatalogId((Configuration)this.conf);
        this.warehouse = new Warehouse((Configuration)this.conf);
        this.snapshotActiveConf();
        this.filterHook = this.loadFilterHooks();
        this.clientDelegate = new DlfMetaStoreClientDelegate(this.conf, this.warehouse, hookLoader);
        boolean createDefaultDatabase = conf.getBoolean("dlf.catalog.createDefaultDBIfNotExist", true);
        this.createDefaultCatalogAndDatabase(createDefaultDatabase);
        this.enableFsOperation = this.clientDelegate.getEnableFsOperation();
        logger.info("DlfMetaStoreClient end, cost:{}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private MetaStoreFilterHook loadFilterHooks() throws IllegalStateException {
        Class authProviderClass = this.conf.getClass(HiveConf.ConfVars.METASTORE_FILTER_HOOK.varname, DefaultMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        String msg = "Unable to create instance of " + authProviderClass.getName() + ": ";
        try {
            Constructor constructor = authProviderClass.getConstructor(HiveConf.class);
            return (MetaStoreFilterHook)constructor.newInstance(this.conf);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
    }

    public Boolean getEnableFsOperation() {
        return this.enableFsOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createDefaultCatalogAndDatabase(boolean ifCreateDefaultDatabase) throws MetaException {
        if (!ifCreateDefaultDatabase || isCreatedDefaultDatabase != null && isCreatedDefaultDatabase.booleanValue()) return;
        Class<DlfMetaStoreClient> clazz = DlfMetaStoreClient.class;
        synchronized (DlfMetaStoreClient.class) {
            if (isCreatedDefaultDatabase != null && isCreatedDefaultDatabase.booleanValue()) return;
            logger.info("dlf metastoreclient create default database ");
            this.createDefaultDatabaseIfNotExists();
            isCreatedDefaultDatabase = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public DlfMetaStoreClientDelegate getClientDelegate() {
        return this.clientDelegate;
    }

    private void createDefaultDatabaseIfNotExists() throws MetaException {
        try {
            this.clientDelegate.getDatabase(this.catalogId, "default");
        }
        catch (NoSuchObjectException noObjectEx) {
            Database defaultDB = this.getDefaultDatabaseObj();
            try {
                this.createDatabase(defaultDB);
            }
            catch (AlreadyExistsException ignoreException) {
                logger.warn("database - default already exists. Ignoring..");
            }
            catch (Exception e) {
                logger.error("Unable to create default database", (Throwable)e);
            }
        }
        catch (Exception ex) {
            logger.error("getDefaultDb exception");
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(ex.getMessage()), (Exception)ex);
        }
    }

    private Database getDefaultDatabaseObj() throws MetaException {
        Database defaultDB = new Database();
        defaultDB.setName("default");
        defaultDB.setDescription("Default Hive database");
        defaultDB.setParameters(Collections.EMPTY_MAP);
        defaultDB.setLocationUri(this.warehouse.getDefaultDatabasePath("default").toString());
        defaultDB.setOwnerType(PrincipalType.USER);
        try {
            defaultDB.setOwnerName(UserGroupInformation.getCurrentUser().getUserName());
        }
        catch (IOException e) {
            defaultDB.setOwnerName("root");
        }
        PrincipalPrivilegeSet principalPrivilegeSet = new PrincipalPrivilegeSet();
        principalPrivilegeSet.setRolePrivileges((Map)Maps.newHashMap());
        principalPrivilegeSet.setGroupPrivileges((Map)Maps.newHashMap());
        principalPrivilegeSet.setUserPrivileges((Map)Maps.newHashMap());
        defaultDB.setPrivileges(principalPrivilegeSet);
        return defaultDB;
    }

    public void createDatabase(Database database) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        this.clientDelegate.createDatabase(this.catalogId, database);
    }

    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterDatabase(this.clientDelegate.getDatabase(this.catalogId, name));
    }

    public List<String> getDatabases(String pattern) throws MetaException, TException {
        return this.filterHook.filterDatabases(this.clientDelegate.getDatabases(this.catalogId, pattern));
    }

    public List<String> getAllDatabases() throws MetaException, TException {
        return this.getDatabases(".*");
    }

    public void alterDatabase(String databaseName, Database database) throws NoSuchObjectException, MetaException, TException {
        this.clientDelegate.alterDatabase(this.catalogId, databaseName, database);
    }

    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.clientDelegate.dropDatabase(this.catalogId, name, deleteData, ignoreUnknownDb, cascade);
    }

    public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        List<Partition> partitions = this.clientDelegate.addPartitions(this.catalogId, Lists.newArrayList((Object[])new Partition[]{partition}), false, true);
        return partitions != null ? partitions.get(0) : null;
    }

    public int add_partitions(List<Partition> partitions) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.add_partitions(partitions, false, true).size();
    }

    public List<Partition> add_partitions(List<Partition> partitions, boolean ifNotExists, boolean needResult) throws TException {
        return this.filterHook.filterPartitions(this.clientDelegate.addPartitions(this.catalogId, partitions, ifNotExists, needResult));
    }

    public int add_partitions_pspec(PartitionSpecProxy pSpec) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.clientDelegate.addPartitionsSpecProxy(this.catalogId, pSpec);
    }

    public void alterFunction(String dbName, String functionName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        this.clientDelegate.alterFunction(this.catalogId, dbName, functionName, newFunction);
    }

    public void alter_index(String dbName, String tblName, String indexName, Index index) throws InvalidOperationException, MetaException, TException {
        this.alterIndex(this.catalogId, dbName, tblName, indexName, index);
    }

    public void alter_partition(String dbName, String tblName, Partition partition) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(this.catalogId, dbName, tblName, Lists.newArrayList((Object[])new Partition[]{partition}), null);
    }

    public void alter_partition(String dbName, String tblName, Partition partition, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(this.catalogId, dbName, tblName, Lists.newArrayList((Object[])new Partition[]{partition}), environmentContext);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> partitions) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(this.catalogId, dbName, tblName, partitions, null);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> partitions, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(this.catalogId, dbName, tblName, partitions, environmentContext);
    }

    public void alter_table(String dbName, String tblName, Table table) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterTable(this.catalogId, dbName, tblName, table, null);
    }

    @Deprecated
    public void alter_table(String dbName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        EnvironmentContext environmentContext = new EnvironmentContext();
        if (cascade) {
            environmentContext.putToProperties("CASCADE", "true");
        }
        this.clientDelegate.alterTable(this.catalogId, dbName, tblName, table, environmentContext);
    }

    public void alter_table_with_environmentContext(String dbName, String tblName, Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterTable(this.catalogId, dbName, tblName, table, environmentContext);
    }

    public Partition appendPartition(String dbName, String tblName, List<String> values) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.clientDelegate.appendPartition(this.catalogId, dbName, tblName, values);
    }

    public Partition appendPartition(String dbName, String tblName, String partitionName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.clientDelegate.appendPartition(this.catalogId, dbName, tblName, partitionName);
    }

    public boolean create_role(Role role) throws MetaException, TException {
        return this.clientDelegate.createRole(role);
    }

    public boolean drop_role(String roleName) throws MetaException, TException {
        return this.clientDelegate.dropRole(roleName);
    }

    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.clientDelegate.listRoles(principalName, principalType);
    }

    public List<String> listRoleNames() throws MetaException, TException {
        return this.clientDelegate.listRoleNames();
    }

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request) throws MetaException, TException {
        return this.clientDelegate.getPrincipalsInRole(request);
    }

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request) throws MetaException, TException {
        return this.clientDelegate.getRoleGrantsForPrincipal(request);
    }

    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        return this.clientDelegate.grantRole(roleName, userName, principalType, grantor, grantorType, grantOption);
    }

    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        return this.clientDelegate.revokeRole(roleName, userName, principalType, grantOption);
    }

    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        this.clientDelegate.cancelDelegationToken(tokenStrForm);
    }

    public String getTokenStrForm() throws IOException {
        return this.clientDelegate.getTokenStrForm();
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        return this.clientDelegate.addToken(tokenIdentifier, delegationToken);
    }

    public boolean removeToken(String tokenIdentifier) throws TException {
        return this.clientDelegate.removeToken(tokenIdentifier);
    }

    public String getToken(String tokenIdentifier) throws TException {
        return this.clientDelegate.getToken(tokenIdentifier);
    }

    public List<String> getAllTokenIdentifiers() throws TException {
        return this.clientDelegate.getAllTokenIdentifiers();
    }

    public int addMasterKey(String key) throws MetaException, TException {
        return this.clientDelegate.addMasterKey(key);
    }

    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
        this.clientDelegate.updateMasterKey(seqNo, key);
    }

    public boolean removeMasterKey(Integer keySeq) throws TException {
        return this.clientDelegate.removeMasterKey(keySeq);
    }

    public String[] getMasterKeys() throws TException {
        return this.clientDelegate.getMasterKeys();
    }

    public LockResponse checkLock(long lockId) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return this.clientDelegate.checkLock(lockId);
    }

    public void close() {
        this.currentMetaVars = null;
    }

    public void commitTxn(long txnId) throws NoSuchTxnException, TxnAbortedException, TException {
        this.clientDelegate.commitTxn(txnId);
    }

    public void abortTxns(List<Long> txnIds) throws TException {
        this.clientDelegate.abortTxns(txnIds);
    }

    @Deprecated
    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType) throws TException {
        this.clientDelegate.compact(dbName, tblName, partitionName, compactionType);
    }

    @Deprecated
    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        this.clientDelegate.compact(dbName, tblName, partitionName, compactionType, tblProperties);
    }

    public CompactionResponse compact2(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        return this.clientDelegate.compact2(dbName, tblName, partitionName, compactionType, tblProperties);
    }

    public void createFunction(Function function) throws InvalidObjectException, MetaException, TException {
        this.clientDelegate.createFunction(this.catalogId, function);
    }

    public void createIndex(Index index, Table indexTable) throws InvalidObjectException, MetaException, NoSuchObjectException, TException, AlreadyExistsException {
        this.createIndex(this.catalogId, index, indexTable);
    }

    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.createTable(tbl, null);
    }

    public void createTable(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.create_table_with_environment_context(tbl, envContext);
    }

    protected void create_table_with_environment_context(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.clientDelegate.createTable(this.catalogId, tbl, envContext);
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return this.clientDelegate.deletePartitionColumnStatistics(this.catalogId, dbName, tableName, partName, colName);
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return this.clientDelegate.deleteTableColumnStatistics(this.catalogId, dbName, tableName, colName);
    }

    public void dropFunction(String dbName, String functionName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.clientDelegate.dropFunction(this.catalogId, dbName, functionName);
    }

    public boolean dropIndex(String dbName, String tblName, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropIndex(this.catalogId, dbName, tblName, name, deleteData);
    }

    private void deleteParentRecursive(Path parent, int depth, boolean mustPurge) throws IOException, MetaException {
        if (depth > 0 && parent != null && this.warehouse.isWritable(parent) && this.warehouse.isEmpty(parent)) {
            this.warehouse.deleteDir(parent, true, mustPurge);
            this.deleteParentRecursive(parent.getParent(), depth - 1, mustPurge);
        }
    }

    private boolean isMustPurge(Table table, boolean ifPurge) {
        return ifPurge || "true".equalsIgnoreCase((String)table.getParameters().get("auto.purge"));
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartition(this.catalogId, dbName, tblName, values, false, deleteData, false);
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, PartitionDropOptions options) throws TException {
        return this.clientDelegate.dropPartition(this.catalogId, dbName, tblName, values, options.ifExists, options.deleteData, options.purgeData);
    }

    public boolean dropPartition(String dbName, String tblName, String partitionName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        List<String> values = this.partitionNameToVals(partitionName);
        return this.clientDelegate.dropPartition(this.catalogId, dbName, tblName, values, false, deleteData, false);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartitions(this.catalogId, dbName, tblName, this.hiveShims.objectPairConvert(partExprs), deleteData, false, true);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResults) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartitions(this.catalogId, dbName, tblName, this.hiveShims.objectPairConvert(partExprs), deleteData, false, needResults);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        return this.clientDelegate.dropPartitions(this.catalogId, dbName, tblName, this.hiveShims.objectPairConvert(partExprs), options.deleteData, options.purgeData, options.returnResults);
    }

    public void createIndex(String catalogId, Index index, Table indexTable) throws TException {
        boolean dirCreated = this.clientDelegate.validateNewTableAndCreateDirectory(catalogId, indexTable);
        boolean indexTableCreated = false;
        String dbName = index.getDbName();
        String indexTableName = index.getIndexTableName();
        String originTableName = index.getOrigTableName();
        Path indexTablePath = this.clientDelegate.getTablePath(catalogId, indexTable);
        String indexTableObjectName = INDEX_PREFIX + index.getIndexName();
        try {
            Table originTable = this.clientDelegate.getTable(catalogId, dbName, originTableName);
            Map parameters = originTable.getParameters();
            if (parameters.containsKey(indexTableObjectName)) {
                throw new AlreadyExistsException("Index: " + index.getIndexName() + " already exist");
            }
            this.clientDelegate.createTable(catalogId, indexTable, null);
            indexTableCreated = true;
            String indexInString = this.toIndexString(index);
            originTable.getParameters().put(indexTableObjectName, indexInString);
            this.clientDelegate.alterTable(catalogId, dbName, originTableName, originTable, null);
        }
        catch (Exception e) {
            if (dirCreated) {
                this.hiveShims.deleteDir(this.warehouse, indexTablePath, true, this.enableFsOperation);
            }
            if (indexTableCreated) {
                EnvironmentContext environmentContext = new EnvironmentContext();
                environmentContext.putToProperties("isIndexDelete", "true");
                this.clientDelegate.dropTable(catalogId, dbName, indexTableName, true, true, environmentContext);
            }
            String msg = "Unable to create index: ";
            if (e instanceof TException) {
                throw e;
            }
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private String toIndexString(Index index) throws MetaException {
        com.aliyun.datalake20200710.models.Table catalogIndexTableObject = HiveToCatalogConverter.convertIndexToCatalogTableObject((Index)index);
        return this.catalogTableToString(catalogIndexTableObject);
    }

    public void alterIndex(String catalogId, String dbName, String tblName, String indexName, Index index) throws TException {
        com.aliyun.datalake20200710.models.Table catalogIndexTableObject = HiveToCatalogConverter.convertIndexToCatalogTableObject((Index)index);
        Table originTable = this.clientDelegate.getTable(catalogId, dbName, tblName);
        String indexTableObjectName = INDEX_PREFIX + indexName;
        if (!originTable.getParameters().containsKey(indexTableObjectName)) {
            throw new NoSuchObjectException("can not find index: " + indexName);
        }
        String indexInString = this.catalogTableToString(catalogIndexTableObject);
        originTable.getParameters().put(indexTableObjectName, indexInString);
        this.clientDelegate.alterTable(catalogId, dbName, tblName, originTable, null);
    }

    public Index getIndex(String catalogId, String dbName, String tblName, String indexName) throws TException {
        String indexTableName;
        Table originTable = this.clientDelegate.getTable(catalogId, dbName, tblName);
        Map map = originTable.getParameters();
        if (!map.containsKey(indexTableName = INDEX_PREFIX + indexName)) {
            throw new NoSuchObjectException("can not find index: " + indexName);
        }
        com.aliyun.datalake20200710.models.Table indexTableObject = null;
        try {
            indexTableObject = this.clientDelegate.stringToCatalogTable((String)map.get(indexTableName));
        }
        catch (IOException e) {
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException("get index failed in conversion json to index object" + e.getMessage()), (Exception)e);
        }
        return this.filterHook.filterIndex(CatalogToHiveConverter.ToHiveIndex((com.aliyun.datalake20200710.models.Table)indexTableObject));
    }

    public boolean dropIndex(String catalogId, String dbName, String tblName, String indexName, boolean deleteData) throws TException {
        String indexTableObjectName;
        Index indexToDrop = this.getIndex(catalogId, dbName, tblName, indexName);
        String indexTableName = indexToDrop.getIndexTableName();
        Table originTable = this.clientDelegate.getTable(catalogId, dbName, tblName);
        Map parameters = originTable.getParameters();
        if (!parameters.containsKey(indexTableObjectName = INDEX_PREFIX + indexName)) {
            throw new NoSuchObjectException("can not find Index: " + indexName);
        }
        parameters.remove(indexTableObjectName);
        this.clientDelegate.alterTable(catalogId, dbName, tblName, originTable, null);
        if (indexTableName != null && indexTableName.length() > 0) {
            EnvironmentContext environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("isIndexDelete", "true");
            this.clientDelegate.dropTable(catalogId, dbName, indexTableName, deleteData, true, environmentContext);
        }
        return true;
    }

    private String catalogTableToString(com.aliyun.datalake20200710.models.Table catalogIndexTableObject) throws MetaException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)catalogIndexTableObject);
        }
        catch (JsonProcessingException e) {
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(e.getMessage()), (Exception)((Object)e));
        }
    }

    public List<Index> listIndexes(String catalogId, String dbName, String tblName) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tblName), (Object)"tblName cannot be null or empty");
        Table originTable = this.clientDelegate.getTable(catalogId, dbName, tblName);
        return this.clientDelegate.getIndicesInTable(originTable);
    }

    @Deprecated
    public void dropTable(String tableName, boolean deleteData) throws MetaException, UnknownTableException, TException, NoSuchObjectException {
        this.clientDelegate.dropTable(this.catalogId, "default", tableName, deleteData, false, null);
    }

    public void dropTable(String dbname, String tableName) throws MetaException, TException, NoSuchObjectException {
        this.clientDelegate.dropTable(this.catalogId, dbname, tableName, true, true, null);
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException {
        this.clientDelegate.dropTable(this.catalogId, dbname, tableName, deleteData, ignoreUnknownTab, null);
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTable, boolean ifPurge) throws MetaException, TException, NoSuchObjectException {
        EnvironmentContext envContext = null;
        if (ifPurge) {
            HashMap<String, String> warehouseOptions = null;
            warehouseOptions = new HashMap<String, String>();
            warehouseOptions.put("ifPurge", "TRUE");
            envContext = new EnvironmentContext(warehouseOptions);
        }
        this.clientDelegate.dropTable(this.catalogId, dbname, tableName, deleteData, ignoreUnknownTable, envContext);
    }

    protected void drop_table_with_environment_context(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTable, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        this.clientDelegate.dropTable(this.catalogId, dbname, tableName, deleteData, ignoreUnknownTable, envContext);
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String srcDb, String srcTbl, String dstDb, String dstTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.clientDelegate.exchangePartition(partitionSpecs, this.catalogId, srcDb, srcTbl, this.catalogId, dstDb, dstTbl);
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTbl, String destDb, String destTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.clientDelegate.exchangePartitions(partitionSpecs, this.catalogId, sourceDb, sourceTbl, this.catalogId, destDb, destTbl);
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getAggrColStatsFor(this.catalogId, dbName, tblName, colNames, partName);
    }

    public List<String> getAllTables(String dbname) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbname, ".*");
    }

    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        if (name == null) {
            return defaultValue;
        }
        if (!Pattern.matches("(hive|hdfs|mapred).*", name)) {
            throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
        }
        return this.conf.get(name, defaultValue);
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        return this.clientDelegate.getDelegationToken(owner, renewerKerberosPrincipalName);
    }

    public List<FieldSchema> getFields(String db, String tableName) throws TException {
        return this.clientDelegate.getFields(this.catalogId, db, tableName);
    }

    public Function getFunction(String dbName, String functionName) throws MetaException, TException {
        try {
            return this.clientDelegate.getFunction(this.catalogId, dbName, functionName);
        }
        catch (NoSuchObjectException e) {
            if (e.getMessage().contains("Function not found")) {
                e.setMessage(String.format("Function %s.%s does not exist", dbName, functionName));
            }
            throw e;
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        return this.clientDelegate.getFunctions(this.catalogId, dbName, pattern);
    }

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return this.clientDelegate.getAllFunctions(this.catalogId);
    }

    public Index getIndex(String dbName, String tblName, String indexName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.getIndex(this.catalogId, dbName, tblName, indexName);
    }

    public String getMetaConf(String key) throws MetaException, TException {
        HiveConf.ConfVars metaConfVar = HiveConf.getMetaConf((String)key);
        if (metaConfVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        return this.conf.get(key, metaConfVar.getDefaultValue());
    }

    public Partition getPartition(String dbName, String tblName, List<String> values) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterPartition(this.clientDelegate.getPartition(this.catalogId, dbName, tblName, values));
    }

    public Partition getPartition(String dbName, String tblName, String partitionName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.filterHook.filterPartition(this.clientDelegate.getPartition(this.catalogId, dbName, tblName, partitionName));
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getPartitionColumnStatisticsObj(this.catalogId, dbName, tableName, partitionNames, columnNames);
    }

    public Partition getPartitionWithAuthInfo(String databaseName, String tableName, List<String> values, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        Partition partition = this.getPartition(databaseName, tableName, values);
        Table table = this.getTable(databaseName, tableName);
        if ("TRUE".equalsIgnoreCase((String)table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(databaseName);
            obj.setObjectName(tableName);
            obj.setPartValues(values);
            PrincipalPrivilegeSet privilegeSet = this.get_privilege_set(obj, userName, groupNames);
            partition.setPrivileges(privilegeSet);
        }
        return this.filterHook.filterPartition(partition);
    }

    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterPartitions(this.clientDelegate.getPartitionsByNames(this.catalogId, databaseName, tableName, partitionNames));
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws TException {
        EnvironmentContext envCxt = null;
        String addedJars = this.conf.getVar(HiveConf.ConfVars.HIVEADDEDJARS);
        if (StringUtils.isNotBlank((CharSequence)addedJars)) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HiveConf.ConfVars.HIVEADDEDJARS.varname, addedJars);
            envCxt = new EnvironmentContext(props);
        }
        return this.clientDelegate.getSchemaWithEnvironmentContext(this.catalogId, db, tableName, envCxt);
    }

    @Deprecated
    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.getTable("default", tableName);
    }

    public Table getTable(String dbName, String tableName) throws MetaException, TException, NoSuchObjectException {
        try {
            return this.filterHook.filterTable(this.clientDelegate.getTable(this.catalogId, dbName, tableName));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("Invalid resource: acs:dlf")) {
                throw new NoSuchObjectException(e.getMessage());
            }
            throw e;
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getTableColumnStatisticsObjs(this.catalogId, dbName, tableName, colNames);
    }

    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        ArrayList hiveTables = Lists.newArrayList();
        if (dbName == null || dbName.isEmpty()) {
            throw new UnknownDBException("DB name is null or empty");
        }
        if (tableNames == null) {
            throw new InvalidOperationException(dbName + " cannot find null tables");
        }
        try {
            this.getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            throw new UnknownDBException("Could not find database " + dbName);
        }
        HashSet<String> tables = new HashSet<String>(tableNames);
        try {
            return this.clientDelegate.getTableObjects(this.catalogId, dbName, new ArrayList<String>(tables));
        }
        catch (NoSuchObjectException e) {
            logger.warn("Try to get a non exist table: " + e.getMessage());
            return this.filterHook.filterTables((List)hiveTables);
        }
    }

    public List<String> getTables(String dbname, String tablePattern) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbname, tablePattern, null);
    }

    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        return this.filterHook.filterTableNames(dbname, this.clientDelegate.getTables(this.catalogId, dbname, tablePattern, tableType));
    }

    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException, UnsupportedOperationException {
        return this.filterNames(this.clientDelegate.getTableMeta(this.catalogId, dbPatterns, tablePatterns, tableTypes));
    }

    private List<TableMeta> filterNames(List<TableMeta> metas) throws MetaException {
        LinkedHashMap<String, TableMeta> sources = new LinkedHashMap<String, TableMeta>();
        LinkedHashMap<String, List> dbTables = new LinkedHashMap<String, List>();
        for (TableMeta meta : metas) {
            sources.put(meta.getDbName() + "." + meta.getTableName(), meta);
            List tables = dbTables.computeIfAbsent(meta.getDbName(), k -> new ArrayList());
            tables.add(meta.getTableName());
        }
        ArrayList<TableMeta> filtered = new ArrayList<TableMeta>();
        for (Map.Entry entry : dbTables.entrySet()) {
            for (String table : this.filterHook.filterTableNames((String)entry.getKey(), (List)entry.getValue())) {
                filtered.add((TableMeta)sources.get((String)entry.getKey() + "." + table));
            }
        }
        return filtered;
    }

    public ValidTxnList getValidTxns() throws TException {
        return this.clientDelegate.getValidTxns();
    }

    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        return this.clientDelegate.getValidTxns(currentTxn);
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef obj, String user, List<String> groups) throws MetaException, TException {
        return this.clientDelegate.getPrivilegeSet(obj, user, groups);
    }

    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        return this.clientDelegate.grantPrivileges(privileges);
    }

    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        return this.clientDelegate.revokePrivileges(privileges, grantOption);
    }

    public void heartbeat(long txnId, long lockId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        this.clientDelegate.heartbeat(txnId, lockId);
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws TException {
        return this.clientDelegate.heartbeatTxnRange(min, max);
    }

    public boolean isCompatibleWith(HiveConf conf) {
        if (this.currentMetaVars == null) {
            return false;
        }
        boolean compatible = true;
        for (HiveConf.ConfVars oneVar : HiveConf.metaVars) {
            String oldVar = this.currentMetaVars.get(oneVar.varname);
            String newVar = conf.get(oneVar.varname, "");
            if (oldVar != null && !(oneVar.isCaseSensitive() ? !oldVar.equals(newVar) : !oldVar.equalsIgnoreCase(newVar))) continue;
            logger.info("Mestastore configuration " + oneVar.varname + " changed from " + oldVar + " to " + newVar);
            compatible = false;
        }
        return compatible;
    }

    public void setHiveAddedJars(String addedJars) {
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDJARS, (String)addedJars);
    }

    public boolean isLocalMetaStore() {
        return false;
    }

    private void snapshotActiveConf() {
        this.currentMetaVars = new HashMap<String, String>(HiveConf.metaVars.length);
        for (HiveConf.ConfVars oneVar : HiveConf.metaVars) {
            this.currentMetaVars.put(oneVar.varname, this.conf.get(oneVar.varname, ""));
        }
    }

    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        return this.clientDelegate.isPartitionMarkedForEvent(dbName, tblName, partKVs, eventType);
    }

    public List<String> listIndexNames(String dbName, String tblName, short max) throws MetaException, TException {
        List<Index> indexes = this.listIndexes(dbName, tblName, max);
        ArrayList indexNames = Lists.newArrayList();
        for (Index index : indexes) {
            indexNames.add(index.getIndexName());
        }
        return this.filterHook.filterIndexNames(dbName, tblName, (List)indexNames);
    }

    public List<Index> listIndexes(String db_name, String tbl_name, short max) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterIndexes(this.listIndexes(this.catalogId, db_name, tbl_name));
    }

    public List<String> listPartitionNames(String dbName, String tblName, short max) throws MetaException, TException {
        try {
            return this.listPartitionNames(dbName, tblName, Lists.newArrayList(), max);
        }
        catch (NoSuchObjectException e) {
            return Collections.emptyList();
        }
    }

    public List<String> listPartitionNames(String databaseName, String tableName, List<String> values, short max) throws MetaException, TException, NoSuchObjectException {
        return this.filterHook.filterPartitionNames(databaseName, tableName, this.clientDelegate.listPartitionNames(this.catalogId, databaseName, tableName, values, max));
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest partitionValuesRequest) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("listPartitionValues unsupported");
    }

    public int getNumPartitionsByFilter(String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        return this.clientDelegate.getNumPartitionsByFilter(this.catalogId, dbName, tableName, filter);
    }

    public PartitionSpecProxy listPartitionSpecs(String dbName, String tblName, int max) throws TException {
        return PartitionSpecProxy.Factory.get((List)this.filterHook.filterPartitionSpecs(this.clientDelegate.listPartitionSpecs(this.catalogId, dbName, tblName, max)));
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String dbName, String tblName, String filter, int max) throws MetaException, NoSuchObjectException, TException {
        return PartitionSpecProxy.Factory.get((List)this.filterHook.filterPartitionSpecs(this.clientDelegate.listPartitionSpecsByFilter(this.catalogId, dbName, tblName, filter, max)));
    }

    public List<Partition> listPartitions(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitions(dbName, tblName, Lists.newArrayList(), max);
    }

    public List<Partition> listPartitions(String databaseName, String tableName, List<String> values, short max) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterPartitions(this.clientDelegate.listPartitions(this.catalogId, databaseName, tableName, values, max));
    }

    public boolean listPartitionsByExpr(String databaseName, String tableName, byte[] expr, String defaultPartitionName, short max, List<Partition> result) throws TException {
        Preconditions.checkNotNull(result, (Object)"The result argument cannot be null.");
        ArrayList tmpResult = Lists.newArrayListWithExpectedSize((int)result.size());
        boolean hasUnknownPartitions = this.clientDelegate.listPartitionsByExpr(this.catalogId, databaseName, tableName, expr, defaultPartitionName, max, tmpResult);
        result.addAll(this.filterHook.filterPartitions((List)tmpResult));
        return hasUnknownPartitions;
    }

    public List<Partition> listPartitionsByFilter(String databaseName, String tableName, String filter, short max) throws MetaException, NoSuchObjectException, TException {
        return this.filterHook.filterPartitions(this.clientDelegate.listPartitionsByFilter(this.catalogId, databaseName, tableName, filter, max));
    }

    public List<Partition> listPartitionsWithAuthInfo(String database, String table, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<Partition> partitions = this.listPartitions(database, table, maxParts);
        for (Partition p : partitions) {
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            PrincipalPrivilegeSet set = this.get_privilege_set(obj, user, groups);
            p.setPrivileges(set);
        }
        return this.filterHook.filterPartitions(partitions);
    }

    public List<Partition> listPartitionsWithAuthInfo(String database, String table, List<String> partVals, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<Partition> partitions = this.listPartitions(database, table, partVals, maxParts);
        for (Partition p : partitions) {
            PrincipalPrivilegeSet set;
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            try {
                set = this.get_privilege_set(obj, user, groups);
            }
            catch (MetaException e) {
                String msg = String.format("No privileges found for user: %s, groups: %s", user, String.join((CharSequence)",", groups));
                logger.error(msg, (Throwable)e);
                set = new PrincipalPrivilegeSet();
            }
            p.setPrivileges(set);
        }
        return this.filterHook.filterPartitions(partitions);
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException, UnsupportedOperationException {
        return this.filterHook.filterTableNames(dbName, this.clientDelegate.listTableNamesByFilter(this.catalogId, dbName, filter, maxTables));
    }

    public List<HiveObjectPrivilege> list_privileges(String principal, PrincipalType principalType, HiveObjectRef objectRef) throws MetaException, TException {
        return this.clientDelegate.listPrivileges(principal, principalType, objectRef);
    }

    public LockResponse lock(LockRequest lockRequest) throws NoSuchTxnException, TxnAbortedException, TException {
        return this.clientDelegate.lock(this.catalogId, lockRequest);
    }

    public void markPartitionForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        this.clientDelegate.markPartitionForEvent(dbName, tblName, partKVs, eventType);
    }

    public long openTxn(String user) throws TException {
        return this.clientDelegate.openTxn(user);
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        return this.clientDelegate.openTxns(user, numTxns);
    }

    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        if (name.length() == 0) {
            return new HashMap<String, String>();
        }
        return Warehouse.makeSpecFromName((String)name);
    }

    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.clientDelegate.partitionNameToVals(name);
    }

    public void reconnect() throws MetaException {
        this.snapshotActiveConf();
    }

    public void renamePartition(String dbName, String tblName, List<String> partitionValues, Partition newPartition) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.renamePartition(this.catalogId, dbName, tblName, partitionValues, newPartition);
    }

    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        return this.clientDelegate.renewDelegationToken(tokenStrForm);
    }

    public void rollbackTxn(long txnId) throws NoSuchTxnException, TException {
        this.clientDelegate.rollbackTxn(txnId);
    }

    public void setMetaConf(String key, String value) throws MetaException, TException {
        HiveConf.ConfVars confVar = HiveConf.getMetaConf((String)key);
        if (confVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        String validate = confVar.validate(value);
        if (validate != null) {
            throw new MetaException("Invalid configuration value " + value + " for key " + key + " by " + validate);
        }
        this.conf.set(key, value);
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.clientDelegate.setPartitionColumnStatistics(this.catalogId, request);
    }

    public void flushCache() {
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws TException {
        return this.clientDelegate.getFileMetadata(fileIds);
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws TException {
        return this.clientDelegate.getFileMetadataBySarg(fileIds, sarg, doGetFooters);
    }

    public void clearFileMetadata(List<Long> fileIds) throws TException {
        this.clientDelegate.clearFileMetadata(fileIds);
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        this.clientDelegate.putFileMetadata(fileIds, metadata);
    }

    public boolean isSameConfObj(HiveConf hiveConf) {
        return this.conf == hiveConf;
    }

    public boolean cacheFileMetadata(String dbName, String tblName, String partName, boolean allParts) throws TException {
        return this.clientDelegate.cacheFileMetadata(dbName, tblName, partName, allParts);
    }

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest primaryKeysRequest) throws MetaException, NoSuchObjectException, TException {
        return new ArrayList<SQLPrimaryKey>();
    }

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest foreignKeysRequest) throws MetaException, NoSuchObjectException, TException {
        return new ArrayList<SQLForeignKey>();
    }

    public void createTableWithConstraints(Table table, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.clientDelegate.createTableWithConstraints(table, primaryKeys, foreignKeys);
    }

    public void dropConstraint(String dbName, String tblName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        this.clientDelegate.dropConstraint(dbName, tblName, constraintName);
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws MetaException, NoSuchObjectException, TException {
        this.clientDelegate.addPrimaryKey(primaryKeyCols);
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws MetaException, NoSuchObjectException, TException {
        this.clientDelegate.addForeignKey(foreignKeyCols);
    }

    public ShowCompactResponse showCompactions() throws TException {
        return this.clientDelegate.showCompactions();
    }

    @Deprecated
    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames) throws TException {
        this.clientDelegate.addDynamicPartitions(txnId, dbName, tblName, partNames, null);
    }

    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames, DataOperationType operationType) throws TException {
        this.clientDelegate.addDynamicPartitions(txnId, dbName, tblName, partNames, operationType);
    }

    public void insertTable(Table table, boolean overwrite) throws MetaException {
        this.clientDelegate.insertTable(table, overwrite);
    }

    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter notificationFilter) throws TException {
        return this.clientDelegate.getNextNotification(lastEventId, maxEvents, notificationFilter);
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return this.clientDelegate.getCurrentNotificationEventId();
    }

    public FireEventResponse fireListenerEvent(FireEventRequest fireEventRequest) throws TException {
        return this.clientDelegate.fireListenerEvent(fireEventRequest);
    }

    @Deprecated
    public ShowLocksResponse showLocks() throws TException {
        return this.clientDelegate.showLocks();
    }

    public ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) throws TException {
        return this.clientDelegate.showLocks(showLocksRequest);
    }

    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return this.clientDelegate.showTxns();
    }

    @Deprecated
    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists("default", tableName);
    }

    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)this.catalogId);
        Preconditions.checkNotNull((Object)databaseName);
        try {
            Table result = this.getTable(databaseName, tableName);
            return result != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public void unlock(long lockId) throws NoSuchLockException, TxnOpenException, TException {
        this.clientDelegate.unlock(lockId);
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.clientDelegate.updatePartitionColumnStatistics(this.catalogId, columnStatistics);
    }

    public boolean updateTableColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.clientDelegate.updateTableColumnStatistics(this.catalogId, columnStatistics);
    }

    public void validatePartitionNameCharacters(List<String> part_vals) throws TException, MetaException {
        try {
            String partitionValidationRegex = this.conf.getVar(HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN);
            Pattern partitionValidationPattern = Strings.isNullOrEmpty((String)partitionValidationRegex) ? null : Pattern.compile(partitionValidationRegex);
            MetaStoreUtils.validatePartitionNameCharacters(part_vals, (Pattern)partitionValidationPattern);
        }
        catch (Exception e) {
            if (e instanceof MetaException) {
                throw (MetaException)((Object)e);
            }
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(e.getMessage()), (Exception)e);
        }
    }
}

