/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mortbay.log.Log;
import org.mortbay.util.IO;
import org.mortbay.util.Loader;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.TypeUtil;

public class JSON {
    private static JSON __default = new JSON();
    private Map _convertors = new HashMap();
    private int _stringBufferSize = 256;
    static /* synthetic */ Class class$java$lang$Object;

    public int getStringBufferSize() {
        return this._stringBufferSize;
    }

    public void setStringBufferSize(int stringBufferSize) {
        this._stringBufferSize = stringBufferSize;
    }

    public static void registerConvertor(Class forClass, Convertor convertor) {
        __default.addConvertor(forClass, convertor);
    }

    public static JSON getDefault() {
        return __default;
    }

    public static void setDefault(JSON json) {
        __default = json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object object) {
        StringBuffer buffer;
        StringBuffer stringBuffer = buffer = new StringBuffer(__default.getStringBufferSize());
        synchronized (stringBuffer) {
            __default.append(buffer, object);
            return buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Map object) {
        StringBuffer buffer;
        StringBuffer stringBuffer = buffer = new StringBuffer(__default.getStringBufferSize());
        synchronized (stringBuffer) {
            __default.appendMap(buffer, object);
            return buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object[] array) {
        StringBuffer buffer;
        StringBuffer stringBuffer = buffer = new StringBuffer(__default.getStringBufferSize());
        synchronized (stringBuffer) {
            __default.appendArray(buffer, array);
            return buffer.toString();
        }
    }

    public static Object parse(String s2) {
        return __default.parse(new StringSource(s2), false);
    }

    public static Object parse(String s2, boolean stripOuterComment) {
        return __default.parse(new StringSource(s2), stripOuterComment);
    }

    public static Object parse(Reader in) throws IOException {
        return __default.parse(new ReaderSource(in), false);
    }

    public static Object parse(Reader in, boolean stripOuterComment) throws IOException {
        return __default.parse(new ReaderSource(in), stripOuterComment);
    }

    public static Object parse(InputStream in) throws IOException {
        return __default.parse(new StringSource(IO.toString(in)), false);
    }

    public static Object parse(InputStream in, boolean stripOuterComment) throws IOException {
        return __default.parse(new StringSource(IO.toString(in)), stripOuterComment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSON(Object object) {
        StringBuffer buffer;
        StringBuffer stringBuffer = buffer = new StringBuffer(this.getStringBufferSize());
        synchronized (stringBuffer) {
            this.append(buffer, object);
            return buffer.toString();
        }
    }

    public Object fromJSON(String json) {
        StringSource source2 = new StringSource(json);
        return this.parse(source2);
    }

    public void append(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append("null");
        } else if (object instanceof Convertible) {
            this.appendJSON(buffer, (Convertible)object);
        } else if (object instanceof Generator) {
            this.appendJSON(buffer, (Generator)object);
        } else if (object instanceof Map) {
            this.appendMap(buffer, (Map)object);
        } else if (object instanceof Collection) {
            this.appendArray(buffer, (Collection)object);
        } else if (object.getClass().isArray()) {
            this.appendArray(buffer, object);
        } else if (object instanceof Number) {
            this.appendNumber(buffer, (Number)object);
        } else if (object instanceof Boolean) {
            this.appendBoolean(buffer, (Boolean)object);
        } else if (object instanceof String) {
            this.appendString(buffer, (String)object);
        } else {
            Convertor convertor = this.getConvertor(object.getClass());
            if (convertor != null) {
                this.appendJSON(buffer, convertor, object);
            } else {
                this.appendString(buffer, object.toString());
            }
        }
    }

    public void appendNull(StringBuffer buffer) {
        buffer.append("null");
    }

    public void appendJSON(StringBuffer buffer, final Convertor convertor, final Object object) {
        this.appendJSON(buffer, new Convertible(){

            public void fromJSON(Map object2) {
            }

            public void toJSON(Output out) {
                convertor.toJSON(object, out);
            }
        });
    }

    public void appendJSON(final StringBuffer buffer, Convertible converter) {
        final char[] c = new char[]{'{'};
        converter.toJSON(new Output(){

            public void add(Object obj) {
                if (c[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                JSON.this.append(buffer, obj);
                c[0] = '\u0000';
            }

            public void addClass(Class type) {
                if (c[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                buffer.append(c);
                buffer.append("\"class\":");
                JSON.this.append(buffer, type.getName());
                c[0] = 44;
            }

            public void add(String name, Object value) {
                if (c[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                buffer.append(c);
                QuotedStringTokenizer.quote(buffer, name);
                buffer.append(':');
                JSON.this.append(buffer, value);
                c[0] = 44;
            }

            public void add(String name, double value) {
                if (c[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                buffer.append(c);
                QuotedStringTokenizer.quote(buffer, name);
                buffer.append(':');
                JSON.this.appendNumber(buffer, new Double(value));
                c[0] = 44;
            }

            public void add(String name, long value) {
                if (c[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                buffer.append(c);
                QuotedStringTokenizer.quote(buffer, name);
                buffer.append(':');
                JSON.this.appendNumber(buffer, TypeUtil.newLong(value));
                c[0] = 44;
            }

            public void add(String name, boolean value) {
                if (c[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                buffer.append(c);
                QuotedStringTokenizer.quote(buffer, name);
                buffer.append(':');
                JSON.this.appendBoolean(buffer, value ? Boolean.TRUE : Boolean.FALSE);
                c[0] = 44;
            }
        });
        if (c[0] == '{') {
            buffer.append("{}");
        } else if (c[0] != '\u0000') {
            buffer.append("}");
        }
    }

    public void appendJSON(StringBuffer buffer, Generator generator) {
        generator.addJSON(buffer);
    }

    public void appendMap(StringBuffer buffer, Map object) {
        if (object == null) {
            this.appendNull(buffer);
            return;
        }
        buffer.append('{');
        Iterator iter = object.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            QuotedStringTokenizer.quote(buffer, entry.getKey().toString());
            buffer.append(':');
            this.append(buffer, entry.getValue());
            if (!iter.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append('}');
    }

    public void appendArray(StringBuffer buffer, Collection collection) {
        if (collection == null) {
            this.appendNull(buffer);
            return;
        }
        buffer.append('[');
        Iterator iter = collection.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                buffer.append(',');
            }
            first = false;
            this.append(buffer, iter.next());
        }
        buffer.append(']');
    }

    public void appendArray(StringBuffer buffer, Object array) {
        if (array == null) {
            this.appendNull(buffer);
            return;
        }
        buffer.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            this.append(buffer, Array.get(array, i));
        }
        buffer.append(']');
    }

    public void appendBoolean(StringBuffer buffer, Boolean b) {
        if (b == null) {
            this.appendNull(buffer);
            return;
        }
        buffer.append(b != false ? "true" : "false");
    }

    public void appendNumber(StringBuffer buffer, Number number) {
        if (number == null) {
            this.appendNull(buffer);
            return;
        }
        buffer.append(number);
    }

    public void appendString(StringBuffer buffer, String string) {
        if (string == null) {
            this.appendNull(buffer);
            return;
        }
        QuotedStringTokenizer.quote(buffer, string);
    }

    protected String toString(char[] buffer, int offset, int length) {
        return new String(buffer, offset, length);
    }

    protected Map newMap() {
        return new HashMap();
    }

    protected Object[] newArray(int size) {
        return new Object[size];
    }

    protected JSON contextForArray() {
        return this;
    }

    protected JSON contextFor(String field) {
        return this;
    }

    protected Object convertTo(Class type, Map map) {
        if (type != null && Convertible.class.isAssignableFrom(type)) {
            try {
                Convertible conv = (Convertible)type.newInstance();
                conv.fromJSON(map);
                return conv;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Convertor convertor = this.getConvertor(type);
        if (convertor != null) {
            return convertor.fromJSON(map);
        }
        return map;
    }

    public void addConvertor(Class forClass, Convertor convertor) {
        this._convertors.put(forClass, convertor);
    }

    protected Convertor getConvertor(Class forClass) {
        Class c = forClass;
        Convertor convertor = (Convertor)this._convertors.get(c);
        if (convertor == null && this != __default) {
            convertor = __default.getConvertor(forClass);
        }
        while (convertor == null && c != null && c != (class$java$lang$Object == null ? JSON.class$("java.lang.Object") : class$java$lang$Object)) {
            Class<?>[] ifs = c.getInterfaces();
            int i = 0;
            while (convertor == null && ifs != null && i < ifs.length) {
                convertor = (Convertor)this._convertors.get(ifs[i++]);
            }
            if (convertor != null) continue;
            c = c.getSuperclass();
            convertor = (Convertor)this._convertors.get(c);
        }
        return convertor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object parse(Source source2, boolean stripOuterComment) {
        int comment_state = 0;
        if (!stripOuterComment) {
            return this.parse(source2);
        }
        int strip_state = 1;
        Object o = null;
        while (true) {
            block27: {
                char c;
                block26: {
                    if (!source2.hasNext()) {
                        return o;
                    }
                    c = source2.peek();
                    if (comment_state != true) break block26;
                    switch (c) {
                        case '/': {
                            comment_state = -1;
                            break;
                        }
                        case '*': {
                            comment_state = 2;
                            if (strip_state == 1) {
                                comment_state = 0;
                                strip_state = 2;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block27;
                }
                if (comment_state > 1) {
                    switch (c) {
                        case '*': {
                            comment_state = 3;
                            break;
                        }
                        case '/': {
                            if (comment_state == 3) {
                                comment_state = 0;
                                if (strip_state != 2) break;
                                return o;
                            }
                            comment_state = 2;
                            break;
                        }
                        default: {
                            comment_state = 2;
                            break;
                        }
                    }
                } else if (comment_state < 0) {
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            comment_state = 0;
                            break;
                        }
                    }
                } else if (!Character.isWhitespace(c)) {
                    if (c == '/') {
                        comment_state = 1;
                    } else if (c == '*') {
                        comment_state = 3;
                    } else if (o == null) {
                        o = this.parse(source2);
                        continue;
                    }
                }
            }
            source2.next();
        }
    }

    public Object parse(Source source2) {
        int comment_state = 0;
        while (source2.hasNext()) {
            char c = source2.peek();
            if (comment_state == 1) {
                switch (c) {
                    case '/': {
                        comment_state = -1;
                        break;
                    }
                    case '*': {
                        comment_state = 2;
                    }
                }
            } else if (comment_state > 1) {
                switch (c) {
                    case '*': {
                        comment_state = 3;
                        break;
                    }
                    case '/': {
                        if (comment_state == 3) {
                            comment_state = 0;
                            break;
                        }
                        comment_state = 2;
                        break;
                    }
                    default: {
                        comment_state = 2;
                        break;
                    }
                }
            } else if (comment_state < 0) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        comment_state = 0;
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '{': {
                        return this.parseObject(source2);
                    }
                    case '[': {
                        return this.parseArray(source2);
                    }
                    case '\"': {
                        return this.parseString(source2);
                    }
                    case '-': {
                        return this.parseNumber(source2);
                    }
                    case 'n': {
                        JSON.complete("null", source2);
                        return null;
                    }
                    case 't': {
                        JSON.complete("true", source2);
                        return Boolean.TRUE;
                    }
                    case 'f': {
                        JSON.complete("false", source2);
                        return Boolean.FALSE;
                    }
                    case 'u': {
                        JSON.complete("undefined", source2);
                        return null;
                    }
                    case '/': {
                        comment_state = 1;
                        break;
                    }
                    default: {
                        if (Character.isDigit(c)) {
                            return this.parseNumber(source2);
                        }
                        if (Character.isWhitespace(c)) break;
                        throw new IllegalStateException("unknown char '" + c + "'(" + c + ") in " + source2);
                    }
                }
            }
            source2.next();
        }
        return null;
    }

    protected Object parseObject(Source source2) {
        String classname;
        if (source2.next() != '{') {
            throw new IllegalStateException();
        }
        Map map = this.newMap();
        char next = this.seekTo("\"}", source2);
        while (source2.hasNext()) {
            if (next == '}') {
                source2.next();
                break;
            }
            String name = this.parseString(source2);
            this.seekTo(':', source2);
            source2.next();
            Object value = this.contextFor(name).parse(source2);
            map.put(name, value);
            this.seekTo(",}", source2);
            next = source2.next();
            if (next == '}') break;
            next = this.seekTo("\"}", source2);
        }
        if ((classname = (String)map.get("class")) != null) {
            try {
                Class c = Loader.loadClass(JSON.class, classname);
                return this.convertTo(c, map);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private Object parseArray(Source source2) {
        if (source2.next() != '[') {
            throw new IllegalStateException();
        }
        int size = 0;
        ArrayList<Object> list = null;
        Object item = null;
        boolean coma = true;
        block8: while (source2.hasNext()) {
            char c = source2.peek();
            switch (c) {
                case ']': {
                    source2.next();
                    switch (size) {
                        case 0: {
                            return this.newArray(0);
                        }
                        case 1: {
                            Object[] array = this.newArray(1);
                            Array.set(array, 0, item);
                            return array;
                        }
                    }
                    return list.toArray(this.newArray(list.size()));
                }
                case ',': {
                    if (coma) {
                        throw new IllegalStateException();
                    }
                    coma = true;
                    source2.next();
                    continue block8;
                }
            }
            if (Character.isWhitespace(c)) {
                source2.next();
                continue;
            }
            coma = false;
            if (size++ == 0) {
                item = this.contextForArray().parse(source2);
                continue;
            }
            if (list == null) {
                list = new ArrayList<Object>();
                list.add(item);
                item = this.contextForArray().parse(source2);
                list.add(item);
                item = null;
                continue;
            }
            item = this.contextForArray().parse(source2);
            list.add(item);
            item = null;
        }
        throw new IllegalStateException("unexpected end of array");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseString(Source source2) {
        char uc;
        char c;
        if (source2.next() != '\"') {
            throw new IllegalStateException();
        }
        boolean escape = false;
        StringBuffer b = null;
        char[] scratch = source2.scratchBuffer();
        if (scratch != null) {
            int i = 0;
            while (source2.hasNext()) {
                if (i >= scratch.length) {
                    b = new StringBuffer(scratch.length * 2);
                    b.append(scratch, 0, i);
                    break;
                }
                c = source2.next();
                if (escape) {
                    escape = false;
                    switch (c) {
                        case '\"': {
                            scratch[i++] = 34;
                            break;
                        }
                        case '\\': {
                            scratch[i++] = 92;
                            break;
                        }
                        case '/': {
                            scratch[i++] = 47;
                            break;
                        }
                        case 'b': {
                            scratch[i++] = 8;
                            break;
                        }
                        case 'f': {
                            scratch[i++] = 12;
                            break;
                        }
                        case 'n': {
                            scratch[i++] = 10;
                            break;
                        }
                        case 'r': {
                            scratch[i++] = 13;
                            break;
                        }
                        case 't': {
                            scratch[i++] = 9;
                            break;
                        }
                        case 'u': {
                            uc = (char)((TypeUtil.convertHexDigit((byte)source2.next()) << 12) + (TypeUtil.convertHexDigit((byte)source2.next()) << 8) + (TypeUtil.convertHexDigit((byte)source2.next()) << 4) + TypeUtil.convertHexDigit((byte)source2.next()));
                            scratch[i++] = uc;
                            break;
                        }
                        default: {
                            scratch[i++] = c;
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (c == '\"') {
                    return this.toString(scratch, 0, i);
                }
                scratch[i++] = c;
            }
            if (b == null) {
                return this.toString(scratch, 0, i);
            }
        } else {
            b = new StringBuffer(this.getStringBufferSize());
        }
        StringBuffer stringBuffer = b;
        synchronized (stringBuffer) {
            while (source2.hasNext()) {
                c = source2.next();
                if (escape) {
                    escape = false;
                    switch (c) {
                        case '\"': {
                            b.append('\"');
                            break;
                        }
                        case '\\': {
                            b.append('\\');
                            break;
                        }
                        case '/': {
                            b.append('/');
                            break;
                        }
                        case 'b': {
                            b.append('\b');
                            break;
                        }
                        case 'f': {
                            b.append('\f');
                            break;
                        }
                        case 'n': {
                            b.append('\n');
                            break;
                        }
                        case 'r': {
                            b.append('\r');
                            break;
                        }
                        case 't': {
                            b.append('\t');
                            break;
                        }
                        case 'u': {
                            uc = (char)((TypeUtil.convertHexDigit((byte)source2.next()) << 12) + (TypeUtil.convertHexDigit((byte)source2.next()) << 8) + (TypeUtil.convertHexDigit((byte)source2.next()) << 4) + TypeUtil.convertHexDigit((byte)source2.next()));
                            b.append(uc);
                            break;
                        }
                        default: {
                            b.append(c);
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (c == '\"') break;
                b.append(c);
            }
            return b.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number parseNumber(Source source2) {
        boolean minus2 = false;
        long number = 0L;
        StringBuffer buffer = null;
        block11: while (source2.hasNext()) {
            char c = source2.peek();
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    number = number * 10L + (long)(c - 48);
                    source2.next();
                    continue block11;
                }
                case '+': 
                case '-': {
                    if (number != 0L) {
                        throw new IllegalStateException("bad number");
                    }
                    minus2 = true;
                    source2.next();
                    continue block11;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    buffer = new StringBuffer(16);
                    if (minus2) {
                        buffer.append('-');
                    }
                    buffer.append(number);
                    buffer.append(c);
                    source2.next();
                    break;
                }
            }
            break;
        }
        if (buffer == null) {
            return TypeUtil.newLong(minus2 ? -1L * number : number);
        }
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            block12: while (source2.hasNext()) {
                char c = source2.peek();
                switch (c) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'E': 
                    case 'e': {
                        buffer.append(c);
                        source2.next();
                        continue block12;
                    }
                }
                break;
            }
            return new Double(buffer.toString());
        }
    }

    protected void seekTo(char seek2, Source source2) {
        while (source2.hasNext()) {
            char c = source2.peek();
            if (c == seek2) {
                return;
            }
            if (!Character.isWhitespace(c)) {
                throw new IllegalStateException("Unexpected '" + c + " while seeking '" + seek2 + "'");
            }
            source2.next();
        }
        throw new IllegalStateException("Expected '" + seek2 + "'");
    }

    protected char seekTo(String seek2, Source source2) {
        while (source2.hasNext()) {
            char c = source2.peek();
            if (seek2.indexOf(c) >= 0) {
                return c;
            }
            if (!Character.isWhitespace(c)) {
                throw new IllegalStateException("Unexpected '" + c + "' while seeking one of '" + seek2 + "'");
            }
            source2.next();
        }
        throw new IllegalStateException("Expected one of '" + seek2 + "'");
    }

    protected static void complete(String seek2, Source source2) {
        int i = 0;
        while (source2.hasNext() && i < seek2.length()) {
            char c = source2.next();
            if (c == seek2.charAt(i++)) continue;
            throw new IllegalStateException("Unexpected '" + c + " while seeking  \"" + seek2 + "\"");
        }
        if (i < seek2.length()) {
            throw new IllegalStateException("Expected \"" + seek2 + "\"");
        }
    }

    public static class Literal
    implements Generator {
        private String _json;

        public Literal(String json) {
            if (Log.isDebugEnabled()) {
                JSON.parse(json);
            }
            this._json = json;
        }

        public String toString() {
            return this._json;
        }

        public void addJSON(StringBuffer buffer) {
            buffer.append(this._json);
        }
    }

    public static interface Generator {
        public void addJSON(StringBuffer var1);
    }

    public static interface Convertor {
        public void toJSON(Object var1, Output var2);

        public Object fromJSON(Map var1);
    }

    public static interface Convertible {
        public void toJSON(Output var1);

        public void fromJSON(Map var1);
    }

    public static interface Output {
        public void addClass(Class var1);

        public void add(Object var1);

        public void add(String var1, Object var2);

        public void add(String var1, double var2);

        public void add(String var1, long var2);

        public void add(String var1, boolean var2);
    }

    public static class ReaderSource
    implements Source {
        private Reader _reader;
        private int _next = -1;
        private char[] scratch;

        public ReaderSource(Reader r) {
            this._reader = r;
        }

        public void setReader(Reader reader) {
            this._reader = reader;
            this._next = -1;
        }

        public boolean hasNext() {
            this.getNext();
            if (this._next < 0) {
                this.scratch = null;
                return false;
            }
            return true;
        }

        public char next() {
            this.getNext();
            char c = (char)this._next;
            this._next = -1;
            return c;
        }

        public char peek() {
            this.getNext();
            return (char)this._next;
        }

        private void getNext() {
            if (this._next < 0) {
                try {
                    this._next = this._reader.read();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public char[] scratchBuffer() {
            if (this.scratch == null) {
                this.scratch = new char[1024];
            }
            return this.scratch;
        }
    }

    public static class StringSource
    implements Source {
        private final String string;
        private int index;
        private char[] scratch;

        public StringSource(String s2) {
            this.string = s2;
        }

        public boolean hasNext() {
            if (this.index < this.string.length()) {
                return true;
            }
            this.scratch = null;
            return false;
        }

        public char next() {
            return this.string.charAt(this.index++);
        }

        public char peek() {
            return this.string.charAt(this.index);
        }

        public String toString() {
            return this.string.substring(0, this.index) + "|||" + this.string.substring(this.index);
        }

        public char[] scratchBuffer() {
            if (this.scratch == null) {
                this.scratch = new char[this.string.length()];
            }
            return this.scratch;
        }
    }

    public static interface Source {
        public boolean hasNext();

        public char next();

        public char peek();

        public char[] scratchBuffer();
    }
}

