/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.Closeable;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;
import org.ehcache.ValueSupplier;
import org.ehcache.expiry.Duration;
import org.ehcache.jsr107.Eh107Expiry;

class ExpiryPolicyToEhcacheExpiry<K, V>
extends Eh107Expiry<K, V>
implements Closeable {
    private final ExpiryPolicy expiryPolicy;

    ExpiryPolicyToEhcacheExpiry(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    public Duration getExpiryForCreation(K key, V value) {
        try {
            javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForCreation();
            if (duration.isEternal()) {
                return Duration.INFINITE;
            }
            return new Duration(duration.getDurationAmount(), duration.getTimeUnit());
        }
        catch (Throwable t) {
            return Duration.ZERO;
        }
    }

    @Override
    public Duration getExpiryForAccess(K key, ValueSupplier<? extends V> value) {
        if (this.isShortCircuitAccessCalls()) {
            return null;
        }
        try {
            javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForAccess();
            if (duration == null) {
                return null;
            }
            if (duration.isEternal()) {
                return Duration.INFINITE;
            }
            return new Duration(duration.getDurationAmount(), duration.getTimeUnit());
        }
        catch (Throwable t) {
            return Duration.ZERO;
        }
    }

    @Override
    public Duration getExpiryForUpdate(K key, ValueSupplier<? extends V> oldValue, V newValue) {
        try {
            javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForUpdate();
            if (duration == null) {
                return null;
            }
            if (duration.isEternal()) {
                return Duration.INFINITE;
            }
            return new Duration(duration.getDurationAmount(), duration.getTimeUnit());
        }
        catch (Throwable t) {
            return Duration.ZERO;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.expiryPolicy instanceof Closeable) {
            ((Closeable)((Object)this.expiryPolicy)).close();
        }
    }
}

