/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.core.EhcacheRuntimeConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.core.Jsr107Cache;
import org.ehcache.core.SpecIterator;
import org.ehcache.core.StatusTransitioner;
import org.ehcache.core.events.CacheEventDispatcher;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.internal.resilience.LoggingRobustResilienceStrategy;
import org.ehcache.core.internal.resilience.RecoveryCache;
import org.ehcache.core.internal.resilience.ResilienceStrategy;
import org.ehcache.core.internal.util.Functions;
import org.ehcache.core.internal.util.ValueSuppliers;
import org.ehcache.core.spi.LifeCycled;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.expiry.Duration;
import org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.ehcache.spi.loaderwriter.CacheWritingException;
import org.slf4j.Logger;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.jsr166e.LongAdder;
import org.terracotta.statistics.observer.OperationObserver;

public class EhcacheWithLoaderWriter<K, V>
implements InternalCache<K, V> {
    private final StatusTransitioner statusTransitioner;
    private final Store<K, V> store;
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final ResilienceStrategy<K, V> resilienceStrategy;
    private final EhcacheRuntimeConfiguration<K, V> runtimeConfiguration;
    private final Jsr107CacheImpl jsr107Cache;
    private final boolean useLoaderInAtomics;
    protected final Logger logger;
    private final OperationObserver<CacheOperationOutcomes.GetOutcome> getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.GetOutcome.class).named("get")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.GetAllOutcome> getAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.GetAllOutcome.class).named("getAll")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.PutOutcome> putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutOutcome.class).named("put")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.PutAllOutcome> putAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutAllOutcome.class).named("putAll")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.RemoveOutcome> removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.RemoveOutcome.class).named("remove")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.RemoveAllOutcome> removeAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.RemoveAllOutcome.class).named("removeAll")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.ConditionalRemoveOutcome.class).named("conditionalRemove")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.CacheLoadingOutcome> cacheLoadingObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.CacheLoadingOutcome.class).named("cacheLoading")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutIfAbsentOutcome.class).named("putIfAbsent")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.ReplaceOutcome> replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.ReplaceOutcome.class).named("replace")).of(this)).tag("cache")).build();
    private final Map<BulkOps, LongAdder> bulkMethodEntries = new EnumMap<BulkOps, LongAdder>(BulkOps.class);
    private static final NullaryFunction<Boolean> REPLACE_FALSE = new NullaryFunction<Boolean>(){

        @Override
        public Boolean apply() {
            return Boolean.FALSE;
        }
    };

    public EhcacheWithLoaderWriter(CacheConfiguration<K, V> configuration, Store<K, V> store, CacheLoaderWriter<? super K, V> cacheLoaderWriter, CacheEventDispatcher<K, V> eventDispatcher, Logger logger) {
        this(configuration, store, cacheLoaderWriter, eventDispatcher, true, logger);
    }

    EhcacheWithLoaderWriter(CacheConfiguration<K, V> runtimeConfiguration, Store<K, V> store, CacheLoaderWriter<? super K, V> cacheLoaderWriter, CacheEventDispatcher<K, V> eventDispatcher, boolean useLoaderInAtomics, Logger logger) {
        this(new EhcacheRuntimeConfiguration<K, V>(runtimeConfiguration), store, cacheLoaderWriter, eventDispatcher, useLoaderInAtomics, logger, new StatusTransitioner(logger));
    }

    EhcacheWithLoaderWriter(EhcacheRuntimeConfiguration<K, V> runtimeConfiguration, Store<K, V> store, CacheLoaderWriter<? super K, V> cacheLoaderWriter, CacheEventDispatcher<K, V> eventDispatcher, boolean useLoaderInAtomics, Logger logger, StatusTransitioner statusTransitioner) {
        this.store = store;
        runtimeConfiguration.addCacheConfigurationListener(store.getConfigurationChangeListeners());
        StatisticsManager.associate(store).withParent(this);
        if (cacheLoaderWriter == null) {
            throw new NullPointerException("CacheLoaderWriter cannot be null.");
        }
        this.cacheLoaderWriter = cacheLoaderWriter;
        this.resilienceStrategy = store instanceof RecoveryCache ? new LoggingRobustResilienceStrategy(this.castToRecoveryCache(store)) : new LoggingRobustResilienceStrategy(EhcacheWithLoaderWriter.recoveryCache(store));
        this.runtimeConfiguration = runtimeConfiguration;
        runtimeConfiguration.addCacheConfigurationListener(eventDispatcher.getConfigurationChangeListeners());
        this.jsr107Cache = new Jsr107CacheImpl();
        this.useLoaderInAtomics = useLoaderInAtomics;
        this.logger = logger;
        this.statusTransitioner = statusTransitioner;
        for (BulkOps bulkOp : BulkOps.values()) {
            this.bulkMethodEntries.put(bulkOp, new LongAdder());
        }
    }

    @Override
    public Map<BulkOps, LongAdder> getBulkMethodEntries() {
        return this.bulkMethodEntries;
    }

    private RecoveryCache<K> castToRecoveryCache(Store<K, V> store) {
        return (RecoveryCache)((Object)store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getNoLoader(K key) {
        this.getObserver.begin();
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(key);
        try {
            Store.ValueHolder<V> valueHolder = this.store.get(key);
            if (valueHolder == null) {
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                return null;
            }
            this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
            return valueHolder.value();
        }
        catch (StoreAccessException e) {
            try {
                V v = this.resilienceStrategy.getFailure(key, e);
                return v;
            }
            finally {
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) throws CacheLoadingException {
        this.getObserver.begin();
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(key);
        Function mappingFunction = Functions.memoize(new Function<K, V>(){

            @Override
            public V apply(K k) {
                Object loaded = null;
                try {
                    EhcacheWithLoaderWriter.this.cacheLoadingObserver.begin();
                    loaded = EhcacheWithLoaderWriter.this.cacheLoaderWriter.load(k);
                    EhcacheWithLoaderWriter.this.cacheLoadingObserver.end(CacheOperationOutcomes.CacheLoadingOutcome.SUCCESS);
                }
                catch (Exception e) {
                    EhcacheWithLoaderWriter.this.cacheLoadingObserver.end(CacheOperationOutcomes.CacheLoadingOutcome.FAILURE);
                    throw new StorePassThroughException(ExceptionFactory.newCacheLoadingException(e));
                }
                return loaded;
            }
        });
        try {
            Store.ValueHolder<V> valueHolder = this.store.computeIfAbsent(key, mappingFunction);
            if (valueHolder == null) {
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                return null;
            }
            this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
            return valueHolder.value();
        }
        catch (StoreAccessException e) {
            try {
                Object fromLoader;
                try {
                    fromLoader = mappingFunction.apply(key);
                }
                catch (StorePassThroughException cpte) {
                    V v = this.resilienceStrategy.getFailure(key, e, (CacheLoadingException)cpte.getCause());
                    this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                    return v;
                }
                V v = this.resilienceStrategy.getFailure(key, fromLoader, e);
                return v;
            }
            finally {
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, final V value) throws CacheWritingException {
        this.putObserver.begin();
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(key, value);
        final AtomicReference previousMapping = new AtomicReference();
        BiFunction remappingFunction = Functions.memoize(new BiFunction<K, V, V>(){

            @Override
            public V apply(K key, V previousValue) {
                previousMapping.set(previousValue);
                try {
                    EhcacheWithLoaderWriter.this.cacheLoaderWriter.write(key, value);
                }
                catch (Exception e) {
                    throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                }
                return value;
            }
        });
        try {
            this.store.compute(key, remappingFunction);
            if (previousMapping.get() != null) {
                this.putObserver.end(CacheOperationOutcomes.PutOutcome.UPDATED);
            } else {
                this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
            }
        }
        catch (StoreAccessException e) {
            try {
                try {
                    remappingFunction.apply(key, value);
                }
                catch (StorePassThroughException cpte) {
                    this.resilienceStrategy.putFailure(key, value, e, (CacheWritingException)cpte.getCause());
                    this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
                    return;
                }
                this.resilienceStrategy.putFailure(key, value, e);
            }
            finally {
                this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
            }
        }
    }

    private boolean newValueAlreadyExpired(K key, V oldValue, V newValue) {
        Duration duration;
        if (newValue == null) {
            return false;
        }
        if (oldValue == null) {
            try {
                duration = this.runtimeConfiguration.getExpiry().getExpiryForCreation(key, newValue);
            }
            catch (RuntimeException re) {
                this.logger.error("Expiry computation caused an exception - Expiry duration will be 0 ", re);
                return true;
            }
        }
        try {
            duration = this.runtimeConfiguration.getExpiry().getExpiryForUpdate(key, ValueSuppliers.supplierOf(oldValue), newValue);
        }
        catch (RuntimeException re) {
            this.logger.error("Expiry computation caused an exception - Expiry duration will be 0 ", re);
            return true;
        }
        return Duration.ZERO.equals(duration);
    }

    @Override
    public boolean containsKey(K key) {
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(key);
        try {
            return this.store.containsKey(key);
        }
        catch (StoreAccessException e) {
            return this.resilienceStrategy.containsKeyFailure(key, e);
        }
    }

    @Override
    public void remove(K key) throws CacheWritingException {
        this.removeInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeInternal(K key) throws CacheWritingException {
        this.removeObserver.begin();
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(key);
        final AtomicBoolean modified = new AtomicBoolean();
        BiFunction remappingFunction = Functions.memoize(new BiFunction<K, V, V>(){

            @Override
            public V apply(K key, V previousValue) {
                modified.set(previousValue != null);
                try {
                    EhcacheWithLoaderWriter.this.cacheLoaderWriter.delete(key);
                }
                catch (Exception e) {
                    throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                }
                return null;
            }
        });
        try {
            this.store.compute(key, remappingFunction);
            if (modified.get()) {
                this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
            } else {
                this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.NOOP);
            }
        }
        catch (StoreAccessException e) {
            try {
                try {
                    remappingFunction.apply(key, null);
                }
                catch (StorePassThroughException f) {
                    this.resilienceStrategy.removeFailure(key, e, (CacheWritingException)f.getCause());
                }
                this.resilienceStrategy.removeFailure(key, e);
            }
            finally {
                this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.FAILURE);
            }
        }
        return modified.get();
    }

    @Override
    public void clear() {
        this.statusTransitioner.checkAvailable();
        try {
            this.store.clear();
        }
        catch (StoreAccessException e) {
            this.resilienceStrategy.clearFailure(e);
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.statusTransitioner.checkAvailable();
        return new CacheEntryIterator(false);
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys2) throws BulkCacheLoadingException {
        return this.getAllInternal(keys2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getAllInternal(Set<? extends K> keys2, boolean includeNulls) throws BulkCacheLoadingException {
        this.getAllObserver.begin();
        this.statusTransitioner.checkAvailable();
        this.checkNonNullContent(keys2);
        if (keys2.isEmpty()) {
            this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.SUCCESS);
            return Collections.emptyMap();
        }
        final HashMap successes = new HashMap();
        final HashMap failures = new HashMap();
        Function computeFunction = new Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>>(){

            @Override
            public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends K> keys2) {
                LinkedHashMap computeResult = new LinkedHashMap();
                for (Object key : keys2) {
                    computeResult.put(key, null);
                }
                Map loaded = Collections.emptyMap();
                try {
                    loaded = EhcacheWithLoaderWriter.this.cacheLoaderWriter.loadAll(computeResult.keySet());
                }
                catch (BulkCacheLoadingException bcle) {
                    EhcacheWithLoaderWriter.this.collectSuccessesAndFailures(bcle, successes, failures);
                }
                catch (Exception e) {
                    for (Object key : computeResult.keySet()) {
                        failures.put(key, e);
                    }
                }
                if (!loaded.isEmpty()) {
                    for (Object key : computeResult.keySet()) {
                        Object value = loaded.get(key);
                        successes.put(key, value);
                        computeResult.put(key, value);
                    }
                }
                return computeResult.entrySet();
            }
        };
        HashMap result = new HashMap();
        try {
            Map<K, Store.ValueHolder<V>> computedMap = this.store.bulkComputeIfAbsent(keys2, computeFunction);
            int hits = 0;
            int keyCount = 0;
            for (Map.Entry<K, Store.ValueHolder<V>> entry : computedMap.entrySet()) {
                ++keyCount;
                if (entry.getValue() != null) {
                    result.put(entry.getKey(), entry.getValue().value());
                    ++hits;
                    continue;
                }
                if (!includeNulls || !failures.isEmpty()) continue;
                result.put(entry.getKey(), null);
            }
            this.addBulkMethodEntriesCount(BulkOps.GET_ALL_HITS, hits);
            if (failures.isEmpty()) {
                this.addBulkMethodEntriesCount(BulkOps.GET_ALL_MISS, keyCount - hits);
                this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.SUCCESS);
                return result;
            }
            successes.putAll(result);
            this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.FAILURE);
            throw new BulkCacheLoadingException(failures, successes);
        }
        catch (StoreAccessException e) {
            try {
                Map<? extends K, V> map;
                HashSet<K> toLoad = new HashSet<K>();
                for (K key : keys2) {
                    toLoad.add(key);
                }
                toLoad.removeAll(successes.keySet());
                toLoad.removeAll(failures.keySet());
                computeFunction.apply(toLoad);
                if (failures.isEmpty()) {
                    map = this.resilienceStrategy.getAllFailure(keys2, successes, e);
                    return map;
                }
                map = this.resilienceStrategy.getAllFailure(keys2, e, new BulkCacheLoadingException(failures, successes));
                return map;
            }
            finally {
                this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.FAILURE);
            }
        }
    }

    LinkedHashSet<Map.Entry<? extends K, ? extends V>> nullValuesForKeys(Iterable<? extends K> keys2) {
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        for (K key : keys2) {
            entries.add(new AbstractMap.SimpleEntry<K, Object>(key, null));
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> entries) throws BulkCacheWritingException {
        this.putAllObserver.begin();
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(entries);
        if (entries.isEmpty()) {
            this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.SUCCESS);
            return;
        }
        final HashSet successes = new HashSet();
        final HashMap failures = new HashMap();
        final HashMap<K, V> entriesToRemap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException();
            }
            entriesToRemap.put(entry.getKey(), entry.getValue());
        }
        final AtomicInteger actualPutCount = new AtomicInteger();
        Function computeFunction = new Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>>(){

            @Override
            public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
                EhcacheWithLoaderWriter.this.cacheLoaderWriterWriteAllCall(entries, entriesToRemap, successes, failures);
                LinkedHashMap mutations = new LinkedHashMap();
                for (Map.Entry entry : entries) {
                    Object newValue;
                    Object existingValue;
                    Object key = entry.getKey();
                    if (EhcacheWithLoaderWriter.this.newValueAlreadyExpired(key, existingValue = entry.getValue(), newValue = entriesToRemap.remove(key))) {
                        mutations.put(key, null);
                        continue;
                    }
                    if (successes.contains(key)) {
                        actualPutCount.incrementAndGet();
                        mutations.put(key, newValue);
                        continue;
                    }
                    mutations.put(key, existingValue);
                }
                return mutations.entrySet();
            }
        };
        try {
            this.store.bulkCompute(entries.keySet(), computeFunction);
            this.addBulkMethodEntriesCount(BulkOps.PUT_ALL, actualPutCount.get());
            if (!failures.isEmpty()) {
                BulkCacheWritingException cacheWritingException = new BulkCacheWritingException(failures, successes);
                this.tryRemoveFailedKeys(entries, failures, cacheWritingException);
                this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.FAILURE);
                throw cacheWritingException;
            }
            this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.SUCCESS);
        }
        catch (StoreAccessException e) {
            try {
                if (!entriesToRemap.isEmpty()) {
                    this.cacheLoaderWriterWriteAllCall(entriesToRemap.entrySet(), entriesToRemap, successes, failures);
                }
                if (failures.isEmpty()) {
                    this.resilienceStrategy.putAllFailure(entries, e);
                } else {
                    this.resilienceStrategy.putAllFailure(entries, e, new BulkCacheWritingException(failures, successes));
                }
            }
            finally {
                this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.FAILURE);
            }
        }
    }

    private void tryRemoveFailedKeys(Map<? extends K, ? extends V> entries, Map<K, Exception> failures, BulkCacheWritingException cacheWritingException) {
        try {
            this.store.bulkCompute(failures.keySet(), new Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>>(){

                @Override
                public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
                    HashMap result = new HashMap();
                    for (Map.Entry entry : entries) {
                        result.put(entry.getKey(), null);
                    }
                    return result.entrySet();
                }
            });
        }
        catch (StoreAccessException e) {
            this.resilienceStrategy.putAllFailure(entries, e, cacheWritingException);
        }
    }

    private void cacheLoaderWriterWriteAllCall(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Map<K, V> entriesToRemap, Set<K> successes, Map<K, Exception> failures) throws IllegalStateException {
        block5: {
            HashMap<K, V> toWrite = new HashMap<K, V>();
            for (Map.Entry<K, V> entry : entries) {
                V value = entriesToRemap.get(entry.getKey());
                if (value == null) continue;
                toWrite.put(entry.getKey(), value);
            }
            try {
                if (toWrite.isEmpty()) break block5;
                this.cacheLoaderWriter.writeAll(toWrite.entrySet());
                successes.addAll(toWrite.keySet());
            }
            catch (BulkCacheWritingException bcwe) {
                EhcacheWithLoaderWriter.collectSuccessesAndFailures(bcwe, successes, failures);
            }
            catch (Exception e) {
                for (Object key : toWrite.keySet()) {
                    failures.put(key, e);
                }
            }
        }
    }

    private static <K> void collectSuccessesAndFailures(BulkCacheWritingException bcwe, Set<K> successes, Map<K, Exception> failures) {
        successes.addAll(bcwe.getSuccesses());
        failures.putAll(bcwe.getFailures());
    }

    private void collectSuccessesAndFailures(BulkCacheLoadingException bcle, Map<K, V> successes, Map<K, Exception> failures) {
        successes.putAll(bcle.getSuccesses());
        failures.putAll(bcle.getFailures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<? extends K> keys2) throws BulkCacheWritingException {
        this.removeAllObserver.begin();
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(keys2);
        if (keys2.isEmpty()) {
            this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.SUCCESS);
            return;
        }
        final HashSet successes = new HashSet();
        final HashMap failures = new HashMap();
        final HashMap entriesToRemove = new HashMap();
        for (K key : keys2) {
            if (key == null) {
                throw new NullPointerException();
            }
            entriesToRemove.put(key, null);
        }
        final AtomicInteger actualRemoveCount = new AtomicInteger();
        Function removalFunction = new Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>>(){

            @Override
            public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
                Set unknowns = EhcacheWithLoaderWriter.this.cacheLoaderWriterDeleteAllCall(entries, entriesToRemove, successes, failures);
                LinkedHashMap results = new LinkedHashMap();
                for (Map.Entry entry : entries) {
                    Object key = entry.getKey();
                    Object existingValue = entry.getValue();
                    if (successes.contains(key)) {
                        if (existingValue != null) {
                            actualRemoveCount.incrementAndGet();
                        }
                        results.put(key, null);
                        entriesToRemove.remove(key);
                        continue;
                    }
                    if (unknowns.contains(key)) {
                        results.put(key, null);
                        continue;
                    }
                    results.put(key, existingValue);
                }
                return results.entrySet();
            }
        };
        try {
            this.store.bulkCompute(keys2, removalFunction);
            this.addBulkMethodEntriesCount(BulkOps.REMOVE_ALL, actualRemoveCount.get());
            if (!failures.isEmpty()) {
                this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.FAILURE);
                throw new BulkCacheWritingException(failures, successes);
            }
            this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.SUCCESS);
        }
        catch (StoreAccessException e) {
            try {
                if (!entriesToRemove.isEmpty()) {
                    this.cacheLoaderWriterDeleteAllCall(entriesToRemove.entrySet(), entriesToRemove, successes, failures);
                }
                if (failures.isEmpty()) {
                    this.resilienceStrategy.removeAllFailure(keys2, e);
                } else {
                    this.resilienceStrategy.removeAllFailure(keys2, e, new BulkCacheWritingException(failures, successes));
                }
            }
            finally {
                this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.FAILURE);
            }
        }
    }

    private Set<K> cacheLoaderWriterDeleteAllCall(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Map<K, ? extends V> entriesToRemove, Set<K> successes, Map<K, Exception> failures) {
        HashSet<K> unknowns = new HashSet<K>();
        HashSet<K> toDelete = new HashSet<K>();
        for (Map.Entry<K, V> entry : entries) {
            Object key = entry.getKey();
            if (!entriesToRemove.containsKey(key)) continue;
            toDelete.add(key);
        }
        try {
            this.cacheLoaderWriter.deleteAll(toDelete);
            successes.addAll(toDelete);
        }
        catch (BulkCacheWritingException bcwe) {
            EhcacheWithLoaderWriter.collectSuccessesAndFailures(bcwe, successes, failures);
        }
        catch (Exception e) {
            for (Object key : toDelete) {
                failures.put(key, e);
                unknowns.add(key);
            }
        }
        return unknowns;
    }

    /*
     * Exception decompiling
     */
    @Override
    public V putIfAbsent(K key, V value) throws CacheWritingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean remove(final K key, final V value) throws CacheWritingException {
        this.conditionalRemoveObserver.begin();
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(key, value);
        final AtomicBoolean hit = new AtomicBoolean();
        final AtomicBoolean removed = new AtomicBoolean();
        BiFunction remappingFunction = Functions.memoize(new BiFunction<K, V, V>(){

            @Override
            public V apply(K k, V inCache) {
                block8: {
                    if (inCache == null) {
                        if (EhcacheWithLoaderWriter.this.useLoaderInAtomics) {
                            try {
                                inCache = EhcacheWithLoaderWriter.this.cacheLoaderWriter.load(key);
                                if (inCache == null) {
                                    return null;
                                }
                                break block8;
                            }
                            catch (Exception e) {
                                throw new StorePassThroughException(ExceptionFactory.newCacheLoadingException(e));
                            }
                        }
                        return null;
                    }
                }
                hit.set(true);
                if (value.equals(inCache)) {
                    try {
                        EhcacheWithLoaderWriter.this.cacheLoaderWriter.delete(k);
                    }
                    catch (Exception e) {
                        throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                    }
                    removed.set(true);
                    return null;
                }
                return inCache;
            }
        });
        try {
            this.store.compute(key, remappingFunction, REPLACE_FALSE);
            if (removed.get()) {
                this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS);
            } else if (hit.get()) {
                this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_PRESENT);
            } else {
                this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_MISSING);
            }
        }
        catch (StoreAccessException e) {
            try {
                try {
                    remappingFunction.apply(key, null);
                }
                catch (StorePassThroughException f) {
                    block14: {
                        Throwable cause = f.getCause();
                        if (cause instanceof CacheLoadingException) {
                            boolean bl = this.resilienceStrategy.removeFailure(key, value, e, (CacheLoadingException)cause);
                            this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE);
                            return bl;
                        }
                        if (!(cause instanceof CacheWritingException)) break block14;
                        boolean bl = this.resilienceStrategy.removeFailure(key, value, e, (CacheWritingException)cause);
                        this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE);
                        return bl;
                    }
                    throw new AssertionError();
                }
                boolean bl = this.resilienceStrategy.removeFailure(key, value, e, removed.get());
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE);
            }
        }
        return removed.get();
    }

    /*
     * Exception decompiling
     */
    @Override
    public V replace(K key, V value) throws CacheLoadingException, CacheWritingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean replace(final K key, final V oldValue, final V newValue) throws CacheLoadingException, CacheWritingException {
        this.replaceObserver.begin();
        this.statusTransitioner.checkAvailable();
        EhcacheWithLoaderWriter.checkNonNull(key, oldValue, newValue);
        final AtomicBoolean success = new AtomicBoolean();
        final AtomicBoolean hit = new AtomicBoolean();
        BiFunction remappingFunction = Functions.memoize(new BiFunction<K, V, V>(){

            @Override
            public V apply(K k, V inCache) {
                block9: {
                    if (inCache == null) {
                        if (EhcacheWithLoaderWriter.this.useLoaderInAtomics) {
                            try {
                                inCache = EhcacheWithLoaderWriter.this.cacheLoaderWriter.load(key);
                                if (inCache == null) {
                                    return null;
                                }
                                break block9;
                            }
                            catch (Exception e) {
                                throw new StorePassThroughException(ExceptionFactory.newCacheLoadingException(e));
                            }
                        }
                        return null;
                    }
                }
                hit.set(true);
                if (oldValue.equals(inCache)) {
                    try {
                        EhcacheWithLoaderWriter.this.cacheLoaderWriter.write(key, newValue);
                    }
                    catch (Exception e) {
                        throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                    }
                    success.set(true);
                    if (EhcacheWithLoaderWriter.this.newValueAlreadyExpired(key, oldValue, newValue)) {
                        return null;
                    }
                    return newValue;
                }
                return inCache;
            }
        });
        try {
            this.store.compute(key, remappingFunction, REPLACE_FALSE);
            if (success.get()) {
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.HIT);
            } else if (hit.get()) {
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.MISS_PRESENT);
            } else {
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT);
            }
            return success.get();
        }
        catch (StoreAccessException e) {
            try {
                try {
                    remappingFunction.apply(key, null);
                }
                catch (StorePassThroughException f) {
                    block14: {
                        Throwable cause = f.getCause();
                        if (cause instanceof CacheLoadingException) {
                            boolean bl = this.resilienceStrategy.replaceFailure(key, oldValue, newValue, e, (CacheLoadingException)cause);
                            this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
                            return bl;
                        }
                        if (!(cause instanceof CacheWritingException)) break block14;
                        boolean bl = this.resilienceStrategy.replaceFailure(key, oldValue, newValue, e, (CacheWritingException)cause);
                        this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
                        return bl;
                    }
                    throw new AssertionError();
                }
                boolean bl = this.resilienceStrategy.replaceFailure(key, oldValue, newValue, e, success.get());
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
            }
        }
    }

    @Override
    public CacheRuntimeConfiguration<K, V> getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    @Override
    public void init() {
        this.statusTransitioner.init().succeeded();
    }

    @Override
    public void close() {
        this.statusTransitioner.close().succeeded();
    }

    @Override
    public Status getStatus() {
        return this.statusTransitioner.currentStatus();
    }

    @Override
    public void addHook(LifeCycled hook) {
        this.statusTransitioner.addHook(hook);
    }

    void removeHook(LifeCycled hook) {
        this.statusTransitioner.removeHook(hook);
    }

    private static void checkNonNull(Object thing) {
        if (thing == null) {
            throw new NullPointerException();
        }
    }

    private static void checkNonNull(Object ... things) {
        for (Object thing : things) {
            EhcacheWithLoaderWriter.checkNonNull(thing);
        }
    }

    private void checkNonNullContent(Collection<?> collectionOfThings) {
        EhcacheWithLoaderWriter.checkNonNull(collectionOfThings);
        for (Object thing : collectionOfThings) {
            EhcacheWithLoaderWriter.checkNonNull(thing);
        }
    }

    private void addBulkMethodEntriesCount(BulkOps op, long count) {
        this.bulkMethodEntries.get((Object)op).add(count);
    }

    @Override
    public Jsr107Cache<K, V> getJsr107Cache() {
        return this.jsr107Cache;
    }

    @Override
    public CacheLoaderWriter<? super K, V> getCacheLoaderWriter() {
        return this.cacheLoaderWriter;
    }

    private static <K> RecoveryCache<K> recoveryCache(final Store<K, ?> store) {
        return new RecoveryCache<K>(){

            @Override
            public void obliterate() throws StoreAccessException {
                store.clear();
            }

            @Override
            public void obliterate(K key) throws StoreAccessException {
                store.remove(key);
            }

            @Override
            public void obliterate(Iterable<? extends K> keys2) throws StoreAccessException {
                for (Object key : keys2) {
                    this.obliterate(key);
                }
            }
        };
    }

    private static class ValueHolderBasedEntry<K, V>
    implements Cache.Entry<K, V> {
        private final Cache.Entry<K, Store.ValueHolder<V>> storeEntry;

        ValueHolderBasedEntry(Cache.Entry<K, Store.ValueHolder<V>> storeEntry) {
            this.storeEntry = storeEntry;
        }

        @Override
        public K getKey() {
            return this.storeEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.storeEntry.getValue().value();
        }
    }

    private class CacheEntryIterator
    implements Iterator<Cache.Entry<K, V>> {
        private final Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator;
        private final boolean quiet;
        private Cache.Entry<K, Store.ValueHolder<V>> current;
        private Cache.Entry<K, Store.ValueHolder<V>> next;
        private StoreAccessException nextException;

        public CacheEntryIterator(boolean quiet) {
            this.quiet = quiet;
            this.iterator = EhcacheWithLoaderWriter.this.store.iterator();
            this.advance();
        }

        private void advance() {
            try {
                while (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (EhcacheWithLoaderWriter.this.getNoLoader(this.next.getKey()) == null) continue;
                    return;
                }
                this.next = null;
            }
            catch (RuntimeException re) {
                this.nextException = new StoreAccessException(re);
                this.next = null;
            }
            catch (StoreAccessException cae) {
                this.nextException = cae;
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            EhcacheWithLoaderWriter.this.statusTransitioner.checkAvailable();
            return this.nextException != null || this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.quiet) {
                EhcacheWithLoaderWriter.this.getObserver.begin();
            }
            if (this.nextException == null) {
                if (!this.quiet) {
                    EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                }
                this.current = this.next;
                this.advance();
                return new ValueHolderBasedEntry(this.current);
            }
            if (!this.quiet) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
            }
            StoreAccessException cae = this.nextException;
            this.nextException = null;
            return EhcacheWithLoaderWriter.this.resilienceStrategy.iteratorFailure(cae);
        }

        @Override
        public void remove() {
            EhcacheWithLoaderWriter.this.statusTransitioner.checkAvailable();
            if (this.current == null) {
                throw new IllegalStateException("No current element");
            }
            EhcacheWithLoaderWriter.this.remove(this.current.getKey(), this.current.getValue().value());
            this.current = null;
        }
    }

    private final class Jsr107CacheImpl
    implements Jsr107Cache<K, V> {
        private Jsr107CacheImpl() {
        }

        @Override
        public void loadAll(Set<? extends K> keys2, boolean replaceExistingValues, Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            if (keys2.isEmpty()) {
                return;
            }
            if (replaceExistingValues) {
                this.loadAllReplace(keys2, loadFunction);
            } else {
                this.loadAllAbsent(keys2, loadFunction);
            }
        }

        @Override
        public Iterator<Cache.Entry<K, V>> specIterator() {
            return new SpecIterator(this, EhcacheWithLoaderWriter.this.store);
        }

        @Override
        public V getNoLoader(K key) {
            return EhcacheWithLoaderWriter.this.getNoLoader(key);
        }

        @Override
        public Map<K, V> getAll(Set<? extends K> keys2) {
            return EhcacheWithLoaderWriter.this.getAllInternal(keys2, false);
        }

        private void loadAllAbsent(Set<? extends K> keys2, final Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                EhcacheWithLoaderWriter.this.store.bulkComputeIfAbsent(keys2, new Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>>(){

                    @Override
                    public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends K> absentKeys) {
                        return Jsr107CacheImpl.this.cacheLoaderWriterLoadAllForKeys(absentKeys, loadFunction).entrySet();
                    }
                });
            }
            catch (StoreAccessException e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        Map<K, V> cacheLoaderWriterLoadAllForKeys(Iterable<? extends K> keys2, Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                Map loaded = loadFunction.apply(keys2);
                LinkedHashMap rv = new LinkedHashMap();
                for (Object key : keys2) {
                    rv.put(key, loaded.get(key));
                }
                return rv;
            }
            catch (Exception e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        private void loadAllReplace(Set<? extends K> keys2, final Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                EhcacheWithLoaderWriter.this.store.bulkCompute(keys2, new Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>>(){

                    @Override
                    public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
                        ArrayList keys2 = new ArrayList();
                        for (Map.Entry entry : entries) {
                            keys2.add(entry.getKey());
                        }
                        return Jsr107CacheImpl.this.cacheLoaderWriterLoadAllForKeys(keys2, loadFunction).entrySet();
                    }
                });
            }
            catch (StoreAccessException e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        @Override
        public void compute(K key, final BiFunction<? super K, ? super V, ? extends V> computeFunction, final NullaryFunction<Boolean> replaceEqual, final NullaryFunction<Boolean> invokeWriter, final NullaryFunction<Boolean> withStatsAndEvents) {
            EhcacheWithLoaderWriter.this.putObserver.begin();
            EhcacheWithLoaderWriter.this.removeObserver.begin();
            EhcacheWithLoaderWriter.this.getObserver.begin();
            try {
                BiFunction fn = new BiFunction<K, V, V>(){

                    @Override
                    public V apply(K mappedKey, V mappedValue) {
                        if (mappedValue == null) {
                            EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                        } else {
                            EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                        }
                        Object newValue = computeFunction.apply(mappedKey, mappedValue);
                        if (newValue == mappedValue && !((Boolean)replaceEqual.apply()).booleanValue()) {
                            return mappedValue;
                        }
                        if (((Boolean)invokeWriter.apply()).booleanValue()) {
                            try {
                                if (newValue != null) {
                                    EhcacheWithLoaderWriter.this.cacheLoaderWriter.write(mappedKey, newValue);
                                } else {
                                    EhcacheWithLoaderWriter.this.cacheLoaderWriter.delete(mappedKey);
                                }
                            }
                            catch (Exception e) {
                                throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                            }
                        }
                        if (EhcacheWithLoaderWriter.this.newValueAlreadyExpired(mappedKey, mappedValue, newValue)) {
                            return null;
                        }
                        if (((Boolean)withStatsAndEvents.apply()).booleanValue()) {
                            if (newValue == null) {
                                EhcacheWithLoaderWriter.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
                            } else {
                                EhcacheWithLoaderWriter.this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
                            }
                        }
                        return newValue;
                    }
                };
                EhcacheWithLoaderWriter.this.store.compute(key, fn, replaceEqual);
            }
            catch (StoreAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public V getAndRemove(K key) {
            EhcacheWithLoaderWriter.this.getObserver.begin();
            EhcacheWithLoaderWriter.this.removeObserver.begin();
            final AtomicReference existingValue = new AtomicReference();
            try {
                EhcacheWithLoaderWriter.this.store.compute(key, new BiFunction<K, V, V>(){

                    @Override
                    public V apply(K mappedKey, V mappedValue) {
                        existingValue.set(mappedValue);
                        try {
                            EhcacheWithLoaderWriter.this.cacheLoaderWriter.delete(mappedKey);
                        }
                        catch (Exception e) {
                            throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                        }
                        return null;
                    }
                });
            }
            catch (StoreAccessException e) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                EhcacheWithLoaderWriter.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.FAILURE);
                throw new RuntimeException(e);
            }
            Object returnValue = existingValue.get();
            if (returnValue != null) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                EhcacheWithLoaderWriter.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
            } else {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
            }
            return returnValue;
        }

        @Override
        public V getAndPut(K key, final V value) {
            EhcacheWithLoaderWriter.this.getObserver.begin();
            EhcacheWithLoaderWriter.this.putObserver.begin();
            final AtomicReference existingValue = new AtomicReference();
            try {
                EhcacheWithLoaderWriter.this.store.compute(key, new BiFunction<K, V, V>(){

                    @Override
                    public V apply(K mappedKey, V mappedValue) {
                        existingValue.set(mappedValue);
                        try {
                            EhcacheWithLoaderWriter.this.cacheLoaderWriter.write(mappedKey, value);
                        }
                        catch (Exception e) {
                            throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                        }
                        if (EhcacheWithLoaderWriter.this.newValueAlreadyExpired(mappedKey, mappedValue, value)) {
                            return null;
                        }
                        return value;
                    }
                });
            }
            catch (StoreAccessException e) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                EhcacheWithLoaderWriter.this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
                throw new RuntimeException(e);
            }
            Object returnValue = existingValue.get();
            if (returnValue != null) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                EhcacheWithLoaderWriter.this.putObserver.end(CacheOperationOutcomes.PutOutcome.UPDATED);
            } else {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                EhcacheWithLoaderWriter.this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
            }
            return returnValue;
        }

        @Override
        public boolean remove(K key) {
            return EhcacheWithLoaderWriter.this.removeInternal(key);
        }

        @Override
        public void removeAll() {
            Store.Iterator iterator2 = EhcacheWithLoaderWriter.this.store.iterator();
            while (iterator2.hasNext()) {
                try {
                    Cache.Entry next = iterator2.next();
                    this.remove(next.getKey());
                }
                catch (StoreAccessException storeAccessException) {}
            }
        }
    }
}

