/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import java.io.PrintWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.webapp.View;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class TextView
extends View {
    private final String contentType;

    protected TextView(View.ViewContext ctx, String contentType) {
        super(ctx);
        this.contentType = contentType;
    }

    @Override
    public PrintWriter writer() {
        this.response().setContentType(this.contentType);
        return super.writer();
    }

    public void echo(Object ... args2) {
        PrintWriter out = this.writer();
        for (Object s2 : args2) {
            String escapedString = StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(s2.toString()));
            out.print(escapedString);
        }
    }

    public void echoWithoutEscapeHtml(Object ... args2) {
        PrintWriter out = this.writer();
        for (Object s2 : args2) {
            out.print(s2);
        }
    }

    public void puts(Object ... args2) {
        this.echo(args2);
        this.writer().println();
    }

    public void putWithoutEscapeHtml(Object args2) {
        this.echoWithoutEscapeHtml(args2);
        this.writer().println();
    }
}

