/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.resolver;

import java.io.BufferedReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.resolver.AbstractSubClusterResolver;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubClusterResolverImpl
extends AbstractSubClusterResolver
implements SubClusterResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSubClusterResolverImpl.class);
    private Configuration conf;
    private static final int NODE_NAME_INDEX = 0;
    private static final int SUBCLUSTER_ID_INDEX = 1;
    private static final int RACK_NAME_INDEX = 2;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public SubClusterId getSubClusterForNode(String nodename) throws YarnException {
        return super.getSubClusterForNode(nodename.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        String fileName = this.conf.get("yarn.federation.machine-list", "");
        try {
            if (fileName == null || fileName.trim().length() == 0) {
                LOG.info("The machine list file path is not specified in the configuration");
                return;
            }
            Path file = null;
            BufferedReader reader = null;
            try {
                file = Paths.get(fileName, new String[0]);
            }
            catch (InvalidPathException e) {
                LOG.info("The configured machine list file path {} does not exist", (Object)fileName);
                return;
            }
            try {
                reader = Files.newBufferedReader(file, Charset.defaultCharset());
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] tokens = line.split(",");
                    if (tokens.length == 3) {
                        String nodeName = tokens[0].trim().toUpperCase();
                        SubClusterId subClusterId = SubClusterId.newInstance(tokens[1].trim());
                        String rackName = tokens[2].trim().toUpperCase();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Loading node into resolver: {} --> {}", (Object)nodeName, (Object)subClusterId);
                            LOG.debug("Loading rack into resolver: {} --> {} ", (Object)rackName, (Object)subClusterId);
                        }
                        this.getNodeToSubCluster().put(nodeName, subClusterId);
                        this.loadRackToSubCluster(rackName, subClusterId);
                        continue;
                    }
                    LOG.warn("Skipping malformed line in machine list: " + line);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            LOG.info("Successfully loaded file {}", (Object)fileName);
        }
        catch (Exception e) {
            LOG.error("Failed to parse file " + fileName, e);
        }
    }

    private void loadRackToSubCluster(String rackName, SubClusterId subClusterId) {
        String rackNameUpper = rackName.toUpperCase();
        if (!this.getRackToSubClusters().containsKey(rackNameUpper)) {
            this.getRackToSubClusters().put(rackNameUpper, new HashSet());
        }
        this.getRackToSubClusters().get(rackNameUpper).add(subClusterId);
    }

    @Override
    public Set<SubClusterId> getSubClustersForRack(String rackname) throws YarnException {
        return super.getSubClustersForRack(rackname.toUpperCase());
    }
}

