/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factories.impl.pb;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RpcServerFactory;

@InterfaceAudience.Private
public class RpcServerFactoryPBImpl
implements RpcServerFactory {
    private static final Log LOG = LogFactory.getLog(RpcServerFactoryPBImpl.class);
    private static final String PROTO_GEN_PACKAGE_NAME = "org.apache.hadoop.yarn.proto";
    private static final String PROTO_GEN_CLASS_SUFFIX = "Service";
    private static final String PB_IMPL_PACKAGE_SUFFIX = "impl.pb.service";
    private static final String PB_IMPL_CLASS_SUFFIX = "PBServiceImpl";
    private static final RpcServerFactoryPBImpl self = new RpcServerFactoryPBImpl();
    private ConcurrentMap<Class<?>, Constructor<?>> serviceCache = new ConcurrentHashMap();
    private ConcurrentMap<Class<?>, Method> protoCache = new ConcurrentHashMap();

    public static RpcServerFactoryPBImpl get() {
        return self;
    }

    private RpcServerFactoryPBImpl() {
    }

    public Server getServer(Class<?> protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers) {
        return this.getServer(protocol, instance, addr, conf, secretManager, numHandlers, null);
    }

    @Override
    public Server getServer(Class<?> protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers, String portRangeConfig) {
        Constructor constructor = (Constructor)this.serviceCache.get(protocol);
        if (constructor == null) {
            Class pbServiceImplClazz = null;
            try {
                pbServiceImplClazz = conf.getClassByName(this.getPbServiceImplClassName(protocol));
            }
            catch (ClassNotFoundException e) {
                throw new YarnRuntimeException("Failed to load class: [" + this.getPbServiceImplClassName(protocol) + "]", e);
            }
            try {
                constructor = pbServiceImplClazz.getConstructor(protocol);
                constructor.setAccessible(true);
                this.serviceCache.putIfAbsent(protocol, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new YarnRuntimeException("Could not find constructor with params: " + Long.TYPE + ", " + InetSocketAddress.class + ", " + Configuration.class, e);
            }
        }
        Object service = null;
        try {
            service = constructor.newInstance(instance);
        }
        catch (InvocationTargetException e) {
            throw new YarnRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new YarnRuntimeException(e);
        }
        Class<?> pbProtocol = service.getClass().getInterfaces()[0];
        Method method = (Method)this.protoCache.get(protocol);
        if (method == null) {
            Class protoClazz = null;
            try {
                protoClazz = conf.getClassByName(this.getProtoClassName(protocol));
            }
            catch (ClassNotFoundException e) {
                throw new YarnRuntimeException("Failed to load class: [" + this.getProtoClassName(protocol) + "]", e);
            }
            try {
                method = protoClazz.getMethod("newReflectiveBlockingService", pbProtocol.getInterfaces()[0]);
                method.setAccessible(true);
                this.protoCache.putIfAbsent(protocol, method);
            }
            catch (NoSuchMethodException e) {
                throw new YarnRuntimeException(e);
            }
        }
        try {
            return this.createServer(pbProtocol, addr, conf, secretManager, numHandlers, (BlockingService)method.invoke(null, service), portRangeConfig);
        }
        catch (InvocationTargetException e) {
            throw new YarnRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnRuntimeException(e);
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
    }

    private String getProtoClassName(Class<?> clazz) {
        String srcClassName = this.getClassName(clazz);
        return "org.apache.hadoop.yarn.proto." + srcClassName + "$" + srcClassName + PROTO_GEN_CLASS_SUFFIX;
    }

    private String getPbServiceImplClassName(Class<?> clazz) {
        String srcPackagePart = this.getPackageName(clazz);
        String srcClassName = this.getClassName(clazz);
        String destPackagePart = srcPackagePart + "." + PB_IMPL_PACKAGE_SUFFIX;
        String destClassPart = srcClassName + PB_IMPL_CLASS_SUFFIX;
        return destPackagePart + "." + destClassPart;
    }

    private String getClassName(Class<?> clazz) {
        String fqName = clazz.getName();
        return fqName.substring(fqName.lastIndexOf(".") + 1, fqName.length());
    }

    private String getPackageName(Class<?> clazz) {
        return clazz.getPackage().getName();
    }

    private Server createServer(Class<?> pbProtocol, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers, BlockingService blockingService, String portRangeConfig) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, pbProtocol, ProtobufRpcEngine.class);
        RPC.Server server = new RPC.Builder(conf).setProtocol(pbProtocol).setInstance((Object)blockingService).setBindAddress(addr.getHostName()).setPort(addr.getPort()).setNumHandlers(numHandlers).setVerbose(false).setSecretManager(secretManager).setPortRangeConfig(portRangeConfig).build();
        LOG.info("Adding protocol " + pbProtocol.getCanonicalName() + " to the server");
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, pbProtocol, (Object)blockingService);
        return server;
    }
}

