/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.integration;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.server.integration.SelectByYarnPersistence;
import org.apache.hadoop.registry.server.services.DeleteCompletionCallback;
import org.apache.hadoop.registry.server.services.RegistryAdminService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN"})
@InterfaceStability.Evolving
public class RMRegistryOperationsService
extends RegistryAdminService {
    private static final Logger LOG = LoggerFactory.getLogger(RMRegistryOperationsService.class);
    private RegistryAdminService.PurgePolicy purgeOnCompletionPolicy = RegistryAdminService.PurgePolicy.PurgeAll;

    public RMRegistryOperationsService(String name) {
        this(name, null);
    }

    public RMRegistryOperationsService(String name, RegistryBindingSource bindingSource) {
        super(name, bindingSource);
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.verifyRealmValidity();
    }

    public RegistryAdminService.PurgePolicy getPurgeOnCompletionPolicy() {
        return this.purgeOnCompletionPolicy;
    }

    public void setPurgeOnCompletionPolicy(RegistryAdminService.PurgePolicy purgeOnCompletionPolicy) {
        this.purgeOnCompletionPolicy = purgeOnCompletionPolicy;
    }

    public void onApplicationAttemptRegistered(ApplicationAttemptId attemptId, String host, int rpcport, String trackingurl) throws IOException {
    }

    public void onApplicationLaunched(ApplicationId id) throws IOException {
    }

    public void onApplicationMasterRegistered(ApplicationAttemptId attemptId) throws IOException {
    }

    public void onAMContainerFinished(ContainerId containerId) throws IOException {
        LOG.info("AM Container {} finished, purging application attempt records", (Object)containerId);
        this.purgeAppAttemptRecords(containerId.getApplicationAttemptId());
        this.onContainerFinished(containerId);
    }

    protected void purgeAppAttemptRecords(ApplicationAttemptId attemptId) {
        this.purgeRecordsAsync("/", attemptId.toString(), "application-attempt");
    }

    public void onApplicationAttemptUnregistered(ApplicationAttemptId attemptId) throws IOException {
        LOG.info("Application attempt {} unregistered, purging app attempt records", (Object)attemptId);
        this.purgeAppAttemptRecords(attemptId);
    }

    public void onApplicationCompleted(ApplicationId id) throws IOException {
        LOG.info("Application {} completed, purging application-level records", (Object)id);
        this.purgeRecordsAsync("/", id.toString(), "application");
    }

    public void onApplicationAttemptAdded(ApplicationAttemptId appAttemptId) {
    }

    public void onStateStoreEvent(ApplicationId applicationId, String user) throws IOException {
        this.initUserRegistryAsync(user);
    }

    public void onContainerFinished(ContainerId id) throws IOException {
        LOG.info("Container {} finished, purging container-level records", (Object)id);
        this.purgeRecordsAsync("/", id.toString(), "container");
    }

    @VisibleForTesting
    public Future<Integer> purgeRecordsAsync(String path, String id, String persistencePolicyMatch) {
        return this.purgeRecordsAsync(path, id, persistencePolicyMatch, this.purgeOnCompletionPolicy, new DeleteCompletionCallback());
    }

    @VisibleForTesting
    public Future<Integer> purgeRecordsAsync(String path, String id, String persistencePolicyMatch, RegistryAdminService.PurgePolicy purgePolicy, BackgroundCallback callback) {
        LOG.info(" records under {} with ID {} and policy {}: {}", path, id, persistencePolicyMatch);
        return this.submit(new RegistryAdminService.AsyncPurge(path, new SelectByYarnPersistence(id, persistencePolicyMatch), purgePolicy, callback));
    }
}

