/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSRegistryOperationsService
extends CompositeService
implements RegistryOperations {
    private FileSystem fs;
    private static final Logger LOG = LoggerFactory.getLogger(FSRegistryOperationsService.class);
    private final RegistryUtils.ServiceRecordMarshal serviceRecordMarshal = new RegistryUtils.ServiceRecordMarshal();

    public FSRegistryOperationsService() {
        super(FSRegistryOperationsService.class.getName());
    }

    @VisibleForTesting
    public FileSystem getFs() {
        return this.fs;
    }

    protected void serviceInit(Configuration conf) {
        try {
            this.fs = FileSystem.get((Configuration)conf);
            LOG.info("Initialized Yarn-registry with Filesystem " + this.fs.getClass().getCanonicalName());
        }
        catch (IOException e) {
            LOG.error("Failed to get FileSystem for registry", e);
            throw new YarnRuntimeException(e);
        }
    }

    private Path makePath(String path) {
        return new Path(path);
    }

    private Path formatDataPath(String basePath) {
        return Path.mergePaths((Path)new Path(basePath), (Path)new Path("/_record"));
    }

    private String relativize(String basePath, String childPath) {
        String relative = new File(basePath).toURI().relativize(new File(childPath).toURI()).getPath();
        return relative;
    }

    @Override
    public boolean mknode(String path, boolean createParents) throws PathNotFoundException, InvalidPathnameException, IOException {
        Path registryPath = this.makePath(path);
        try {
            this.fs.getFileStatus(registryPath);
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (createParents) {
                this.fs.mkdirs(registryPath);
            } else {
                FileStatus parentStatus = null;
                if (registryPath.getParent() != null) {
                    parentStatus = this.fs.getFileStatus(registryPath.getParent());
                }
                if (registryPath.getParent() == null || parentStatus.isDirectory()) {
                    this.fs.mkdirs(registryPath);
                } else {
                    throw new PathNotFoundException("no parent for " + path);
                }
            }
            return true;
        }
    }

    @Override
    public void bind(String path, ServiceRecord record, int flags) throws PathNotFoundException, FileAlreadyExistsException, InvalidPathnameException, IOException {
        Preconditions.checkArgument(record != null, "null record");
        RegistryTypeUtils.validateServiceRecord(path, record);
        Path dataPath = this.formatDataPath(path);
        Boolean overwrite = (flags & 1) != 0;
        if (this.fs.exists(dataPath) && !overwrite.booleanValue()) {
            throw new FileAlreadyExistsException();
        }
        FSDataOutputStream stream = this.fs.create(dataPath);
        byte[] bytes = this.serviceRecordMarshal.toBytes(record);
        stream.write(bytes);
        stream.close();
        LOG.info("Bound record to path " + dataPath);
    }

    @Override
    public ServiceRecord resolve(String path) throws PathNotFoundException, NoRecordException, InvalidRecordException, IOException {
        Long size = this.fs.getFileStatus(this.formatDataPath(path)).getLen();
        byte[] bytes = new byte[size.intValue()];
        FSDataInputStream instream = this.fs.open(this.formatDataPath(path));
        int bytesRead = instream.read(bytes);
        instream.close();
        if ((long)bytesRead < size) {
            throw new InvalidRecordException(path, "Expected " + size + " bytes, but read " + bytesRead);
        }
        ServiceRecord record = (ServiceRecord)this.serviceRecordMarshal.fromBytes(path, bytes);
        RegistryTypeUtils.validateServiceRecord(path, record);
        return record;
    }

    @Override
    public RegistryPathStatus stat(String path) throws PathNotFoundException, InvalidPathnameException, IOException {
        FileStatus fstat = this.fs.getFileStatus(this.formatDataPath(path));
        int numChildren = this.fs.listStatus(this.makePath(path)).length;
        RegistryPathStatus regstat = new RegistryPathStatus(fstat.getPath().toString(), fstat.getModificationTime(), fstat.getLen(), numChildren);
        return regstat;
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.fs.exists(this.makePath(path));
    }

    @Override
    public List<String> list(String path) throws PathNotFoundException, InvalidPathnameException, IOException {
        FileStatus[] statArray = this.fs.listStatus(this.makePath(path));
        String basePath = this.fs.getFileStatus(this.makePath(path)).getPath().toString();
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < statArray.length; ++i) {
            FileStatus stat = statArray[i];
            if (!stat.isDirectory()) continue;
            String relativePath = this.relativize(basePath, stat.getPath().toString());
            paths.add(relativePath);
        }
        return paths;
    }

    @Override
    public void delete(String path, boolean recursive) throws PathNotFoundException, PathIsNotEmptyDirectoryException, InvalidPathnameException, IOException {
        Path dirPath = this.makePath(path);
        if (!this.fs.exists(dirPath)) {
            throw new PathNotFoundException(path);
        }
        if (recursive || this.list(path).isEmpty()) {
            this.fs.delete(this.makePath(path), true);
            return;
        }
        throw new PathIsNotEmptyDirectoryException(path);
    }

    @Override
    public boolean addWriteAccessor(String id, String pass) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void clearWriteAccessors() {
        throw new NotImplementedException();
    }
}

