/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.aggregate;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregator;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorBaseDescriptor;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ValueAggregatorCombiner<K1 extends WritableComparable<?>, V1 extends Writable>
extends Reducer<Text, Text, Text, Text> {
    @Override
    public void reduce(Text key, Iterable<Text> values2, Reducer.Context context) throws IOException, InterruptedException {
        String keyStr = key.toString();
        int pos = keyStr.indexOf(":");
        String type = keyStr.substring(0, pos);
        long uniqCount = context.getConfiguration().getLong("mapreduce.aggregate.max.num.unique.values", Long.MAX_VALUE);
        ValueAggregator aggregator = ValueAggregatorBaseDescriptor.generateValueAggregator(type, uniqCount);
        for (Text val : values2) {
            aggregator.addNextValue(val);
        }
        for (Object v : aggregator.getCombinerOutput()) {
            if (v instanceof Text) {
                context.write(key, (Text)v);
                continue;
            }
            context.write(key, new Text(v.toString()));
        }
    }
}

