/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.fieldsel.FieldSelectionHelper;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FieldSelectionMapReduce<K, V>
implements Mapper<K, V, Text, Text>,
Reducer<Text, Text, Text, Text> {
    private String mapOutputKeyValueSpec;
    private boolean ignoreInputKey;
    private String fieldSeparator = "\t";
    private List<Integer> mapOutputKeyFieldList = new ArrayList<Integer>();
    private List<Integer> mapOutputValueFieldList = new ArrayList<Integer>();
    private int allMapValueFieldsFrom = -1;
    private String reduceOutputKeyValueSpec;
    private List<Integer> reduceOutputKeyFieldList = new ArrayList<Integer>();
    private List<Integer> reduceOutputValueFieldList = new ArrayList<Integer>();
    private int allReduceValueFieldsFrom = -1;
    public static final Log LOG = LogFactory.getLog("FieldSelectionMapReduce");

    private String specToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("fieldSeparator: ").append(this.fieldSeparator).append("\n");
        sb.append("mapOutputKeyValueSpec: ").append(this.mapOutputKeyValueSpec).append("\n");
        sb.append("reduceOutputKeyValueSpec: ").append(this.reduceOutputKeyValueSpec).append("\n");
        sb.append("allMapValueFieldsFrom: ").append(this.allMapValueFieldsFrom).append("\n");
        sb.append("allReduceValueFieldsFrom: ").append(this.allReduceValueFieldsFrom).append("\n");
        int i = 0;
        sb.append("mapOutputKeyFieldList.length: ").append(this.mapOutputKeyFieldList.size()).append("\n");
        for (i = 0; i < this.mapOutputKeyFieldList.size(); ++i) {
            sb.append("\t").append(this.mapOutputKeyFieldList.get(i)).append("\n");
        }
        sb.append("mapOutputValueFieldList.length: ").append(this.mapOutputValueFieldList.size()).append("\n");
        for (i = 0; i < this.mapOutputValueFieldList.size(); ++i) {
            sb.append("\t").append(this.mapOutputValueFieldList.get(i)).append("\n");
        }
        sb.append("reduceOutputKeyFieldList.length: ").append(this.reduceOutputKeyFieldList.size()).append("\n");
        for (i = 0; i < this.reduceOutputKeyFieldList.size(); ++i) {
            sb.append("\t").append(this.reduceOutputKeyFieldList.get(i)).append("\n");
        }
        sb.append("reduceOutputValueFieldList.length: ").append(this.reduceOutputValueFieldList.size()).append("\n");
        for (i = 0; i < this.reduceOutputValueFieldList.size(); ++i) {
            sb.append("\t").append(this.reduceOutputValueFieldList.get(i)).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void map(K key, V val, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        FieldSelectionHelper helper = new FieldSelectionHelper(FieldSelectionHelper.emptyText, FieldSelectionHelper.emptyText);
        helper.extractOutputKeyValue(key.toString(), val.toString(), this.fieldSeparator, this.mapOutputKeyFieldList, this.mapOutputValueFieldList, this.allMapValueFieldsFrom, this.ignoreInputKey, true);
        output.collect(helper.getKey(), helper.getValue());
    }

    private void parseOutputKeyValueSpec() {
        this.allMapValueFieldsFrom = FieldSelectionHelper.parseOutputKeyValueSpec(this.mapOutputKeyValueSpec, this.mapOutputKeyFieldList, this.mapOutputValueFieldList);
        this.allReduceValueFieldsFrom = FieldSelectionHelper.parseOutputKeyValueSpec(this.reduceOutputKeyValueSpec, this.reduceOutputKeyFieldList, this.reduceOutputValueFieldList);
    }

    @Override
    public void configure(JobConf job) {
        this.fieldSeparator = job.get("mapreduce.fieldsel.data.field.separator", "\t");
        this.mapOutputKeyValueSpec = job.get("mapreduce.fieldsel.map.output.key.value.fields.spec", "0-:");
        this.ignoreInputKey = TextInputFormat.class.getCanonicalName().equals(job.getInputFormat().getClass().getCanonicalName());
        this.reduceOutputKeyValueSpec = job.get("mapreduce.fieldsel.reduce.output.key.value.fields.spec", "0-:");
        this.parseOutputKeyValueSpec();
        LOG.info(this.specToString());
    }

    public void close() throws IOException {
    }

    @Override
    public void reduce(Text key, Iterator<Text> values2, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        String keyStr = key.toString() + this.fieldSeparator;
        while (values2.hasNext()) {
            FieldSelectionHelper helper = new FieldSelectionHelper();
            helper.extractOutputKeyValue(keyStr, values2.next().toString(), this.fieldSeparator, this.reduceOutputKeyFieldList, this.reduceOutputValueFieldList, this.allReduceValueFieldsFrom, false, false);
            output.collect(helper.getKey(), helper.getValue());
        }
    }
}

