/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class SlowDiskReports {
    @Nonnull
    private final Map<String, Map<DiskOp, Double>> slowDisks;
    public static final SlowDiskReports EMPTY_REPORT = new SlowDiskReports(ImmutableMap.of());

    private SlowDiskReports(Map<String, Map<DiskOp, Double>> slowDisks) {
        this.slowDisks = slowDisks;
    }

    public static SlowDiskReports create(@Nullable Map<String, Map<DiskOp, Double>> slowDisks) {
        if (slowDisks == null || slowDisks.isEmpty()) {
            return EMPTY_REPORT;
        }
        return new SlowDiskReports(slowDisks);
    }

    public Map<String, Map<DiskOp, Double>> getSlowDisks() {
        return this.slowDisks;
    }

    public boolean haveSlowDisks() {
        return this.slowDisks.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SlowDiskReports)) {
            return false;
        }
        SlowDiskReports that = (SlowDiskReports)o;
        if (this.slowDisks.size() != that.slowDisks.size()) {
            return false;
        }
        if (!this.slowDisks.keySet().containsAll(that.slowDisks.keySet()) || !that.slowDisks.keySet().containsAll(this.slowDisks.keySet())) {
            return false;
        }
        for (Map.Entry<String, Map<DiskOp, Double>> entry : this.slowDisks.entrySet()) {
            if (entry.getValue().equals(that.slowDisks.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.slowDisks.hashCode();
    }

    public static enum DiskOp {
        METADATA("MetadataOp"),
        READ("ReadIO"),
        WRITE("WriteIO");

        private final String value;

        private DiskOp(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }

        public static DiskOp fromValue(String value) {
            for (DiskOp as : DiskOp.values()) {
                if (!as.value.equals(value)) continue;
                return as;
            }
            return null;
        }
    }
}

