/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeVolumeInfo {
    private long usedSpace;
    private long freeSpace;
    private long reservedSpace;
    private long reservedSpaceForReplicas;
    private long numBlocks;
    private StorageType storageType;
    private String path;

    public DatanodeVolumeInfo(String path, long usedSpace, long freeSpace, long reservedSpace, long reservedSpaceForReplicas, long numBlocks, StorageType type) {
        this.usedSpace = usedSpace;
        this.freeSpace = freeSpace;
        this.reservedSpace = reservedSpace;
        this.reservedSpaceForReplicas = reservedSpaceForReplicas;
        this.numBlocks = numBlocks;
        this.storageType = type;
        this.path = path;
    }

    public long getUsedSpace() {
        return this.usedSpace;
    }

    public long getFreeSpace() {
        return this.freeSpace;
    }

    public long getReservedSpace() {
        return this.reservedSpace;
    }

    public long getReservedSpaceForReplicas() {
        return this.reservedSpaceForReplicas;
    }

    public long getNumBlocks() {
        return this.numBlocks;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public String getPath() {
        return this.path;
    }

    public String getDatanodeVolumeReport() {
        StringBuilder report2 = new StringBuilder();
        report2.append("Directory: " + this.path).append("\nStorageType: " + this.storageType).append("\nCapacity Used: " + this.usedSpace + "(" + StringUtils.byteDesc((long)this.usedSpace) + ")").append("\nCapacity Left: " + this.freeSpace + "(" + StringUtils.byteDesc((long)this.freeSpace) + ")").append("\nCapacity Reserved: " + this.reservedSpace + "(" + StringUtils.byteDesc((long)this.reservedSpace) + ")").append("\nReserved Space for Replicas: " + this.reservedSpaceForReplicas + "(" + StringUtils.byteDesc((long)this.reservedSpaceForReplicas) + ")").append("\nBlocks: " + this.numBlocks);
        return report2.toString();
    }
}

