/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.thrift.TCancelLoadParams;
import org.apache.doris.thrift.TCommonDdlType;
import org.apache.doris.thrift.TCreateDbParams;
import org.apache.doris.thrift.TCreateFunctionParams;
import org.apache.doris.thrift.TCreateRollupParams;
import org.apache.doris.thrift.TCreateUserParams;
import org.apache.doris.thrift.TDropDbParams;
import org.apache.doris.thrift.TDropFunctionParams;
import org.apache.doris.thrift.TDropRollupParams;
import org.apache.doris.thrift.TDropTableParams;
import org.apache.doris.thrift.TDropUserParams;
import org.apache.doris.thrift.TLoadParams;
import org.apache.doris.thrift.TPaloInternalServiceVersion;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class TMasterDdlRequest
implements TBase<TMasterDdlRequest, _Fields>,
Serializable,
Cloneable,
Comparable<TMasterDdlRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("TMasterDdlRequest");
    private static final TField PROTOCOL_VERSION_FIELD_DESC = new TField("protocol_version", 8, 1);
    private static final TField DDL_TYPE_FIELD_DESC = new TField("ddl_type", 8, 2);
    private static final TField CREATE_DB_PARAMS_FIELD_DESC = new TField("create_db_params", 12, 3);
    private static final TField DROP_DB_PARAMS_FIELD_DESC = new TField("drop_db_params", 12, 4);
    private static final TField DROP_TABLE_PARAMS_FIELD_DESC = new TField("drop_table_params", 12, 6);
    private static final TField LOAD_PARAMS_FIELD_DESC = new TField("load_params", 12, 7);
    private static final TField CANCEL_LOAD_PARAMS_FIELD_DESC = new TField("cancel_load_params", 12, 8);
    private static final TField CREATE_USER_PARAMS_FIELD_DESC = new TField("create_user_params", 12, 9);
    private static final TField DROP_USER_PARAMS_FIELD_DESC = new TField("drop_user_params", 12, 10);
    private static final TField CREATE_ROLLUP_PARAMS_FIELD_DESC = new TField("create_rollup_params", 12, 11);
    private static final TField DROP_ROLLUP_PARAMS_FIELD_DESC = new TField("drop_rollup_params", 12, 12);
    private static final TField CREATE_FUNCTION_PARAMS_FIELD_DESC = new TField("create_function_params", 12, 13);
    private static final TField DROP_FUNCTION_PARAMS_FIELD_DESC = new TField("drop_function_params", 12, 14);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TMasterDdlRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TMasterDdlRequestTupleSchemeFactory();
    @Nullable
    public TPaloInternalServiceVersion protocol_version;
    @Nullable
    public TCommonDdlType ddl_type;
    @Nullable
    public TCreateDbParams create_db_params;
    @Nullable
    public TDropDbParams drop_db_params;
    @Nullable
    public TDropTableParams drop_table_params;
    @Nullable
    public TLoadParams load_params;
    @Nullable
    public TCancelLoadParams cancel_load_params;
    @Nullable
    public TCreateUserParams create_user_params;
    @Nullable
    public TDropUserParams drop_user_params;
    @Nullable
    public TCreateRollupParams create_rollup_params;
    @Nullable
    public TDropRollupParams drop_rollup_params;
    @Nullable
    public TCreateFunctionParams create_function_params;
    @Nullable
    public TDropFunctionParams drop_function_params;
    private static final _Fields[] optionals = new _Fields[]{_Fields.CREATE_DB_PARAMS, _Fields.DROP_DB_PARAMS, _Fields.DROP_TABLE_PARAMS, _Fields.LOAD_PARAMS, _Fields.CANCEL_LOAD_PARAMS, _Fields.CREATE_USER_PARAMS, _Fields.DROP_USER_PARAMS, _Fields.CREATE_ROLLUP_PARAMS, _Fields.DROP_ROLLUP_PARAMS, _Fields.CREATE_FUNCTION_PARAMS, _Fields.DROP_FUNCTION_PARAMS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TMasterDdlRequest() {
    }

    public TMasterDdlRequest(TPaloInternalServiceVersion protocol_version, TCommonDdlType ddl_type) {
        this();
        this.protocol_version = protocol_version;
        this.ddl_type = ddl_type;
    }

    public TMasterDdlRequest(TMasterDdlRequest other) {
        if (other.isSetProtocolVersion()) {
            this.protocol_version = other.protocol_version;
        }
        if (other.isSetDdlType()) {
            this.ddl_type = other.ddl_type;
        }
        if (other.isSetCreateDbParams()) {
            this.create_db_params = new TCreateDbParams(other.create_db_params);
        }
        if (other.isSetDropDbParams()) {
            this.drop_db_params = new TDropDbParams(other.drop_db_params);
        }
        if (other.isSetDropTableParams()) {
            this.drop_table_params = new TDropTableParams(other.drop_table_params);
        }
        if (other.isSetLoadParams()) {
            this.load_params = new TLoadParams(other.load_params);
        }
        if (other.isSetCancelLoadParams()) {
            this.cancel_load_params = new TCancelLoadParams(other.cancel_load_params);
        }
        if (other.isSetCreateUserParams()) {
            this.create_user_params = new TCreateUserParams(other.create_user_params);
        }
        if (other.isSetDropUserParams()) {
            this.drop_user_params = new TDropUserParams(other.drop_user_params);
        }
        if (other.isSetCreateRollupParams()) {
            this.create_rollup_params = new TCreateRollupParams(other.create_rollup_params);
        }
        if (other.isSetDropRollupParams()) {
            this.drop_rollup_params = new TDropRollupParams(other.drop_rollup_params);
        }
        if (other.isSetCreateFunctionParams()) {
            this.create_function_params = new TCreateFunctionParams(other.create_function_params);
        }
        if (other.isSetDropFunctionParams()) {
            this.drop_function_params = new TDropFunctionParams(other.drop_function_params);
        }
    }

    @Override
    public TMasterDdlRequest deepCopy() {
        return new TMasterDdlRequest(this);
    }

    @Override
    public void clear() {
        this.protocol_version = null;
        this.ddl_type = null;
        this.create_db_params = null;
        this.drop_db_params = null;
        this.drop_table_params = null;
        this.load_params = null;
        this.cancel_load_params = null;
        this.create_user_params = null;
        this.drop_user_params = null;
        this.create_rollup_params = null;
        this.drop_rollup_params = null;
        this.create_function_params = null;
        this.drop_function_params = null;
    }

    @Nullable
    public TPaloInternalServiceVersion getProtocolVersion() {
        return this.protocol_version;
    }

    public TMasterDdlRequest setProtocolVersion(@Nullable TPaloInternalServiceVersion protocol_version) {
        this.protocol_version = protocol_version;
        return this;
    }

    public void unsetProtocolVersion() {
        this.protocol_version = null;
    }

    public boolean isSetProtocolVersion() {
        return this.protocol_version != null;
    }

    public void setProtocolVersionIsSet(boolean value) {
        if (!value) {
            this.protocol_version = null;
        }
    }

    @Nullable
    public TCommonDdlType getDdlType() {
        return this.ddl_type;
    }

    public TMasterDdlRequest setDdlType(@Nullable TCommonDdlType ddl_type) {
        this.ddl_type = ddl_type;
        return this;
    }

    public void unsetDdlType() {
        this.ddl_type = null;
    }

    public boolean isSetDdlType() {
        return this.ddl_type != null;
    }

    public void setDdlTypeIsSet(boolean value) {
        if (!value) {
            this.ddl_type = null;
        }
    }

    @Nullable
    public TCreateDbParams getCreateDbParams() {
        return this.create_db_params;
    }

    public TMasterDdlRequest setCreateDbParams(@Nullable TCreateDbParams create_db_params) {
        this.create_db_params = create_db_params;
        return this;
    }

    public void unsetCreateDbParams() {
        this.create_db_params = null;
    }

    public boolean isSetCreateDbParams() {
        return this.create_db_params != null;
    }

    public void setCreateDbParamsIsSet(boolean value) {
        if (!value) {
            this.create_db_params = null;
        }
    }

    @Nullable
    public TDropDbParams getDropDbParams() {
        return this.drop_db_params;
    }

    public TMasterDdlRequest setDropDbParams(@Nullable TDropDbParams drop_db_params) {
        this.drop_db_params = drop_db_params;
        return this;
    }

    public void unsetDropDbParams() {
        this.drop_db_params = null;
    }

    public boolean isSetDropDbParams() {
        return this.drop_db_params != null;
    }

    public void setDropDbParamsIsSet(boolean value) {
        if (!value) {
            this.drop_db_params = null;
        }
    }

    @Nullable
    public TDropTableParams getDropTableParams() {
        return this.drop_table_params;
    }

    public TMasterDdlRequest setDropTableParams(@Nullable TDropTableParams drop_table_params) {
        this.drop_table_params = drop_table_params;
        return this;
    }

    public void unsetDropTableParams() {
        this.drop_table_params = null;
    }

    public boolean isSetDropTableParams() {
        return this.drop_table_params != null;
    }

    public void setDropTableParamsIsSet(boolean value) {
        if (!value) {
            this.drop_table_params = null;
        }
    }

    @Nullable
    public TLoadParams getLoadParams() {
        return this.load_params;
    }

    public TMasterDdlRequest setLoadParams(@Nullable TLoadParams load_params) {
        this.load_params = load_params;
        return this;
    }

    public void unsetLoadParams() {
        this.load_params = null;
    }

    public boolean isSetLoadParams() {
        return this.load_params != null;
    }

    public void setLoadParamsIsSet(boolean value) {
        if (!value) {
            this.load_params = null;
        }
    }

    @Nullable
    public TCancelLoadParams getCancelLoadParams() {
        return this.cancel_load_params;
    }

    public TMasterDdlRequest setCancelLoadParams(@Nullable TCancelLoadParams cancel_load_params) {
        this.cancel_load_params = cancel_load_params;
        return this;
    }

    public void unsetCancelLoadParams() {
        this.cancel_load_params = null;
    }

    public boolean isSetCancelLoadParams() {
        return this.cancel_load_params != null;
    }

    public void setCancelLoadParamsIsSet(boolean value) {
        if (!value) {
            this.cancel_load_params = null;
        }
    }

    @Nullable
    public TCreateUserParams getCreateUserParams() {
        return this.create_user_params;
    }

    public TMasterDdlRequest setCreateUserParams(@Nullable TCreateUserParams create_user_params) {
        this.create_user_params = create_user_params;
        return this;
    }

    public void unsetCreateUserParams() {
        this.create_user_params = null;
    }

    public boolean isSetCreateUserParams() {
        return this.create_user_params != null;
    }

    public void setCreateUserParamsIsSet(boolean value) {
        if (!value) {
            this.create_user_params = null;
        }
    }

    @Nullable
    public TDropUserParams getDropUserParams() {
        return this.drop_user_params;
    }

    public TMasterDdlRequest setDropUserParams(@Nullable TDropUserParams drop_user_params) {
        this.drop_user_params = drop_user_params;
        return this;
    }

    public void unsetDropUserParams() {
        this.drop_user_params = null;
    }

    public boolean isSetDropUserParams() {
        return this.drop_user_params != null;
    }

    public void setDropUserParamsIsSet(boolean value) {
        if (!value) {
            this.drop_user_params = null;
        }
    }

    @Nullable
    public TCreateRollupParams getCreateRollupParams() {
        return this.create_rollup_params;
    }

    public TMasterDdlRequest setCreateRollupParams(@Nullable TCreateRollupParams create_rollup_params) {
        this.create_rollup_params = create_rollup_params;
        return this;
    }

    public void unsetCreateRollupParams() {
        this.create_rollup_params = null;
    }

    public boolean isSetCreateRollupParams() {
        return this.create_rollup_params != null;
    }

    public void setCreateRollupParamsIsSet(boolean value) {
        if (!value) {
            this.create_rollup_params = null;
        }
    }

    @Nullable
    public TDropRollupParams getDropRollupParams() {
        return this.drop_rollup_params;
    }

    public TMasterDdlRequest setDropRollupParams(@Nullable TDropRollupParams drop_rollup_params) {
        this.drop_rollup_params = drop_rollup_params;
        return this;
    }

    public void unsetDropRollupParams() {
        this.drop_rollup_params = null;
    }

    public boolean isSetDropRollupParams() {
        return this.drop_rollup_params != null;
    }

    public void setDropRollupParamsIsSet(boolean value) {
        if (!value) {
            this.drop_rollup_params = null;
        }
    }

    @Nullable
    public TCreateFunctionParams getCreateFunctionParams() {
        return this.create_function_params;
    }

    public TMasterDdlRequest setCreateFunctionParams(@Nullable TCreateFunctionParams create_function_params) {
        this.create_function_params = create_function_params;
        return this;
    }

    public void unsetCreateFunctionParams() {
        this.create_function_params = null;
    }

    public boolean isSetCreateFunctionParams() {
        return this.create_function_params != null;
    }

    public void setCreateFunctionParamsIsSet(boolean value) {
        if (!value) {
            this.create_function_params = null;
        }
    }

    @Nullable
    public TDropFunctionParams getDropFunctionParams() {
        return this.drop_function_params;
    }

    public TMasterDdlRequest setDropFunctionParams(@Nullable TDropFunctionParams drop_function_params) {
        this.drop_function_params = drop_function_params;
        return this;
    }

    public void unsetDropFunctionParams() {
        this.drop_function_params = null;
    }

    public boolean isSetDropFunctionParams() {
        return this.drop_function_params != null;
    }

    public void setDropFunctionParamsIsSet(boolean value) {
        if (!value) {
            this.drop_function_params = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PROTOCOL_VERSION: {
                if (value == null) {
                    this.unsetProtocolVersion();
                    break;
                }
                this.setProtocolVersion((TPaloInternalServiceVersion)value);
                break;
            }
            case DDL_TYPE: {
                if (value == null) {
                    this.unsetDdlType();
                    break;
                }
                this.setDdlType((TCommonDdlType)value);
                break;
            }
            case CREATE_DB_PARAMS: {
                if (value == null) {
                    this.unsetCreateDbParams();
                    break;
                }
                this.setCreateDbParams((TCreateDbParams)value);
                break;
            }
            case DROP_DB_PARAMS: {
                if (value == null) {
                    this.unsetDropDbParams();
                    break;
                }
                this.setDropDbParams((TDropDbParams)value);
                break;
            }
            case DROP_TABLE_PARAMS: {
                if (value == null) {
                    this.unsetDropTableParams();
                    break;
                }
                this.setDropTableParams((TDropTableParams)value);
                break;
            }
            case LOAD_PARAMS: {
                if (value == null) {
                    this.unsetLoadParams();
                    break;
                }
                this.setLoadParams((TLoadParams)value);
                break;
            }
            case CANCEL_LOAD_PARAMS: {
                if (value == null) {
                    this.unsetCancelLoadParams();
                    break;
                }
                this.setCancelLoadParams((TCancelLoadParams)value);
                break;
            }
            case CREATE_USER_PARAMS: {
                if (value == null) {
                    this.unsetCreateUserParams();
                    break;
                }
                this.setCreateUserParams((TCreateUserParams)value);
                break;
            }
            case DROP_USER_PARAMS: {
                if (value == null) {
                    this.unsetDropUserParams();
                    break;
                }
                this.setDropUserParams((TDropUserParams)value);
                break;
            }
            case CREATE_ROLLUP_PARAMS: {
                if (value == null) {
                    this.unsetCreateRollupParams();
                    break;
                }
                this.setCreateRollupParams((TCreateRollupParams)value);
                break;
            }
            case DROP_ROLLUP_PARAMS: {
                if (value == null) {
                    this.unsetDropRollupParams();
                    break;
                }
                this.setDropRollupParams((TDropRollupParams)value);
                break;
            }
            case CREATE_FUNCTION_PARAMS: {
                if (value == null) {
                    this.unsetCreateFunctionParams();
                    break;
                }
                this.setCreateFunctionParams((TCreateFunctionParams)value);
                break;
            }
            case DROP_FUNCTION_PARAMS: {
                if (value == null) {
                    this.unsetDropFunctionParams();
                    break;
                }
                this.setDropFunctionParams((TDropFunctionParams)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PROTOCOL_VERSION: {
                return this.getProtocolVersion();
            }
            case DDL_TYPE: {
                return this.getDdlType();
            }
            case CREATE_DB_PARAMS: {
                return this.getCreateDbParams();
            }
            case DROP_DB_PARAMS: {
                return this.getDropDbParams();
            }
            case DROP_TABLE_PARAMS: {
                return this.getDropTableParams();
            }
            case LOAD_PARAMS: {
                return this.getLoadParams();
            }
            case CANCEL_LOAD_PARAMS: {
                return this.getCancelLoadParams();
            }
            case CREATE_USER_PARAMS: {
                return this.getCreateUserParams();
            }
            case DROP_USER_PARAMS: {
                return this.getDropUserParams();
            }
            case CREATE_ROLLUP_PARAMS: {
                return this.getCreateRollupParams();
            }
            case DROP_ROLLUP_PARAMS: {
                return this.getDropRollupParams();
            }
            case CREATE_FUNCTION_PARAMS: {
                return this.getCreateFunctionParams();
            }
            case DROP_FUNCTION_PARAMS: {
                return this.getDropFunctionParams();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PROTOCOL_VERSION: {
                return this.isSetProtocolVersion();
            }
            case DDL_TYPE: {
                return this.isSetDdlType();
            }
            case CREATE_DB_PARAMS: {
                return this.isSetCreateDbParams();
            }
            case DROP_DB_PARAMS: {
                return this.isSetDropDbParams();
            }
            case DROP_TABLE_PARAMS: {
                return this.isSetDropTableParams();
            }
            case LOAD_PARAMS: {
                return this.isSetLoadParams();
            }
            case CANCEL_LOAD_PARAMS: {
                return this.isSetCancelLoadParams();
            }
            case CREATE_USER_PARAMS: {
                return this.isSetCreateUserParams();
            }
            case DROP_USER_PARAMS: {
                return this.isSetDropUserParams();
            }
            case CREATE_ROLLUP_PARAMS: {
                return this.isSetCreateRollupParams();
            }
            case DROP_ROLLUP_PARAMS: {
                return this.isSetDropRollupParams();
            }
            case CREATE_FUNCTION_PARAMS: {
                return this.isSetCreateFunctionParams();
            }
            case DROP_FUNCTION_PARAMS: {
                return this.isSetDropFunctionParams();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TMasterDdlRequest) {
            return this.equals((TMasterDdlRequest)that);
        }
        return false;
    }

    public boolean equals(TMasterDdlRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_protocol_version = this.isSetProtocolVersion();
        boolean that_present_protocol_version = that.isSetProtocolVersion();
        if (this_present_protocol_version || that_present_protocol_version) {
            if (!this_present_protocol_version || !that_present_protocol_version) {
                return false;
            }
            if (!this.protocol_version.equals(that.protocol_version)) {
                return false;
            }
        }
        boolean this_present_ddl_type = this.isSetDdlType();
        boolean that_present_ddl_type = that.isSetDdlType();
        if (this_present_ddl_type || that_present_ddl_type) {
            if (!this_present_ddl_type || !that_present_ddl_type) {
                return false;
            }
            if (!this.ddl_type.equals(that.ddl_type)) {
                return false;
            }
        }
        boolean this_present_create_db_params = this.isSetCreateDbParams();
        boolean that_present_create_db_params = that.isSetCreateDbParams();
        if (this_present_create_db_params || that_present_create_db_params) {
            if (!this_present_create_db_params || !that_present_create_db_params) {
                return false;
            }
            if (!this.create_db_params.equals(that.create_db_params)) {
                return false;
            }
        }
        boolean this_present_drop_db_params = this.isSetDropDbParams();
        boolean that_present_drop_db_params = that.isSetDropDbParams();
        if (this_present_drop_db_params || that_present_drop_db_params) {
            if (!this_present_drop_db_params || !that_present_drop_db_params) {
                return false;
            }
            if (!this.drop_db_params.equals(that.drop_db_params)) {
                return false;
            }
        }
        boolean this_present_drop_table_params = this.isSetDropTableParams();
        boolean that_present_drop_table_params = that.isSetDropTableParams();
        if (this_present_drop_table_params || that_present_drop_table_params) {
            if (!this_present_drop_table_params || !that_present_drop_table_params) {
                return false;
            }
            if (!this.drop_table_params.equals(that.drop_table_params)) {
                return false;
            }
        }
        boolean this_present_load_params = this.isSetLoadParams();
        boolean that_present_load_params = that.isSetLoadParams();
        if (this_present_load_params || that_present_load_params) {
            if (!this_present_load_params || !that_present_load_params) {
                return false;
            }
            if (!this.load_params.equals(that.load_params)) {
                return false;
            }
        }
        boolean this_present_cancel_load_params = this.isSetCancelLoadParams();
        boolean that_present_cancel_load_params = that.isSetCancelLoadParams();
        if (this_present_cancel_load_params || that_present_cancel_load_params) {
            if (!this_present_cancel_load_params || !that_present_cancel_load_params) {
                return false;
            }
            if (!this.cancel_load_params.equals(that.cancel_load_params)) {
                return false;
            }
        }
        boolean this_present_create_user_params = this.isSetCreateUserParams();
        boolean that_present_create_user_params = that.isSetCreateUserParams();
        if (this_present_create_user_params || that_present_create_user_params) {
            if (!this_present_create_user_params || !that_present_create_user_params) {
                return false;
            }
            if (!this.create_user_params.equals(that.create_user_params)) {
                return false;
            }
        }
        boolean this_present_drop_user_params = this.isSetDropUserParams();
        boolean that_present_drop_user_params = that.isSetDropUserParams();
        if (this_present_drop_user_params || that_present_drop_user_params) {
            if (!this_present_drop_user_params || !that_present_drop_user_params) {
                return false;
            }
            if (!this.drop_user_params.equals(that.drop_user_params)) {
                return false;
            }
        }
        boolean this_present_create_rollup_params = this.isSetCreateRollupParams();
        boolean that_present_create_rollup_params = that.isSetCreateRollupParams();
        if (this_present_create_rollup_params || that_present_create_rollup_params) {
            if (!this_present_create_rollup_params || !that_present_create_rollup_params) {
                return false;
            }
            if (!this.create_rollup_params.equals(that.create_rollup_params)) {
                return false;
            }
        }
        boolean this_present_drop_rollup_params = this.isSetDropRollupParams();
        boolean that_present_drop_rollup_params = that.isSetDropRollupParams();
        if (this_present_drop_rollup_params || that_present_drop_rollup_params) {
            if (!this_present_drop_rollup_params || !that_present_drop_rollup_params) {
                return false;
            }
            if (!this.drop_rollup_params.equals(that.drop_rollup_params)) {
                return false;
            }
        }
        boolean this_present_create_function_params = this.isSetCreateFunctionParams();
        boolean that_present_create_function_params = that.isSetCreateFunctionParams();
        if (this_present_create_function_params || that_present_create_function_params) {
            if (!this_present_create_function_params || !that_present_create_function_params) {
                return false;
            }
            if (!this.create_function_params.equals(that.create_function_params)) {
                return false;
            }
        }
        boolean this_present_drop_function_params = this.isSetDropFunctionParams();
        boolean that_present_drop_function_params = that.isSetDropFunctionParams();
        if (this_present_drop_function_params || that_present_drop_function_params) {
            if (!this_present_drop_function_params || !that_present_drop_function_params) {
                return false;
            }
            if (!this.drop_function_params.equals(that.drop_function_params)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetProtocolVersion() ? 131071 : 524287);
        if (this.isSetProtocolVersion()) {
            hashCode = hashCode * 8191 + this.protocol_version.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetDdlType() ? 131071 : 524287);
        if (this.isSetDdlType()) {
            hashCode = hashCode * 8191 + this.ddl_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetCreateDbParams() ? 131071 : 524287);
        if (this.isSetCreateDbParams()) {
            hashCode = hashCode * 8191 + this.create_db_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDropDbParams() ? 131071 : 524287);
        if (this.isSetDropDbParams()) {
            hashCode = hashCode * 8191 + this.drop_db_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDropTableParams() ? 131071 : 524287);
        if (this.isSetDropTableParams()) {
            hashCode = hashCode * 8191 + this.drop_table_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLoadParams() ? 131071 : 524287);
        if (this.isSetLoadParams()) {
            hashCode = hashCode * 8191 + this.load_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCancelLoadParams() ? 131071 : 524287);
        if (this.isSetCancelLoadParams()) {
            hashCode = hashCode * 8191 + this.cancel_load_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCreateUserParams() ? 131071 : 524287);
        if (this.isSetCreateUserParams()) {
            hashCode = hashCode * 8191 + this.create_user_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDropUserParams() ? 131071 : 524287);
        if (this.isSetDropUserParams()) {
            hashCode = hashCode * 8191 + this.drop_user_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCreateRollupParams() ? 131071 : 524287);
        if (this.isSetCreateRollupParams()) {
            hashCode = hashCode * 8191 + this.create_rollup_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDropRollupParams() ? 131071 : 524287);
        if (this.isSetDropRollupParams()) {
            hashCode = hashCode * 8191 + this.drop_rollup_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCreateFunctionParams() ? 131071 : 524287);
        if (this.isSetCreateFunctionParams()) {
            hashCode = hashCode * 8191 + this.create_function_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDropFunctionParams() ? 131071 : 524287);
        if (this.isSetDropFunctionParams()) {
            hashCode = hashCode * 8191 + this.drop_function_params.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TMasterDdlRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetProtocolVersion()).compareTo(other.isSetProtocolVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProtocolVersion() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.protocol_version), (Comparable)((Object)other.protocol_version))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDdlType()).compareTo(other.isSetDdlType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDdlType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.ddl_type), (Comparable)((Object)other.ddl_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreateDbParams()).compareTo(other.isSetCreateDbParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateDbParams() && (lastComparison = TBaseHelper.compareTo(this.create_db_params, other.create_db_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDropDbParams()).compareTo(other.isSetDropDbParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDropDbParams() && (lastComparison = TBaseHelper.compareTo(this.drop_db_params, other.drop_db_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDropTableParams()).compareTo(other.isSetDropTableParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDropTableParams() && (lastComparison = TBaseHelper.compareTo(this.drop_table_params, other.drop_table_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLoadParams()).compareTo(other.isSetLoadParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLoadParams() && (lastComparison = TBaseHelper.compareTo(this.load_params, other.load_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCancelLoadParams()).compareTo(other.isSetCancelLoadParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCancelLoadParams() && (lastComparison = TBaseHelper.compareTo(this.cancel_load_params, other.cancel_load_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreateUserParams()).compareTo(other.isSetCreateUserParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateUserParams() && (lastComparison = TBaseHelper.compareTo(this.create_user_params, other.create_user_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDropUserParams()).compareTo(other.isSetDropUserParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDropUserParams() && (lastComparison = TBaseHelper.compareTo(this.drop_user_params, other.drop_user_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreateRollupParams()).compareTo(other.isSetCreateRollupParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateRollupParams() && (lastComparison = TBaseHelper.compareTo(this.create_rollup_params, other.create_rollup_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDropRollupParams()).compareTo(other.isSetDropRollupParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDropRollupParams() && (lastComparison = TBaseHelper.compareTo(this.drop_rollup_params, other.drop_rollup_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreateFunctionParams()).compareTo(other.isSetCreateFunctionParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateFunctionParams() && (lastComparison = TBaseHelper.compareTo(this.create_function_params, other.create_function_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDropFunctionParams()).compareTo(other.isSetDropFunctionParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDropFunctionParams() && (lastComparison = TBaseHelper.compareTo(this.drop_function_params, other.drop_function_params)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        TMasterDdlRequest.scheme(iprot).read(iprot, (TMasterDdlRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        TMasterDdlRequest.scheme(oprot).write(oprot, (TMasterDdlRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TMasterDdlRequest(");
        boolean first = true;
        sb.append("protocol_version:");
        if (this.protocol_version == null) {
            sb.append("null");
        } else {
            sb.append(this.protocol_version);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ddl_type:");
        if (this.ddl_type == null) {
            sb.append("null");
        } else {
            sb.append(this.ddl_type);
        }
        first = false;
        if (this.isSetCreateDbParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("create_db_params:");
            if (this.create_db_params == null) {
                sb.append("null");
            } else {
                sb.append(this.create_db_params);
            }
            first = false;
        }
        if (this.isSetDropDbParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("drop_db_params:");
            if (this.drop_db_params == null) {
                sb.append("null");
            } else {
                sb.append(this.drop_db_params);
            }
            first = false;
        }
        if (this.isSetDropTableParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("drop_table_params:");
            if (this.drop_table_params == null) {
                sb.append("null");
            } else {
                sb.append(this.drop_table_params);
            }
            first = false;
        }
        if (this.isSetLoadParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("load_params:");
            if (this.load_params == null) {
                sb.append("null");
            } else {
                sb.append(this.load_params);
            }
            first = false;
        }
        if (this.isSetCancelLoadParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("cancel_load_params:");
            if (this.cancel_load_params == null) {
                sb.append("null");
            } else {
                sb.append(this.cancel_load_params);
            }
            first = false;
        }
        if (this.isSetCreateUserParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("create_user_params:");
            if (this.create_user_params == null) {
                sb.append("null");
            } else {
                sb.append(this.create_user_params);
            }
            first = false;
        }
        if (this.isSetDropUserParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("drop_user_params:");
            if (this.drop_user_params == null) {
                sb.append("null");
            } else {
                sb.append(this.drop_user_params);
            }
            first = false;
        }
        if (this.isSetCreateRollupParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("create_rollup_params:");
            if (this.create_rollup_params == null) {
                sb.append("null");
            } else {
                sb.append(this.create_rollup_params);
            }
            first = false;
        }
        if (this.isSetDropRollupParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("drop_rollup_params:");
            if (this.drop_rollup_params == null) {
                sb.append("null");
            } else {
                sb.append(this.drop_rollup_params);
            }
            first = false;
        }
        if (this.isSetCreateFunctionParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("create_function_params:");
            if (this.create_function_params == null) {
                sb.append("null");
            } else {
                sb.append(this.create_function_params);
            }
            first = false;
        }
        if (this.isSetDropFunctionParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("drop_function_params:");
            if (this.drop_function_params == null) {
                sb.append("null");
            } else {
                sb.append(this.drop_function_params);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.protocol_version == null) {
            throw new TProtocolException("Required field 'protocol_version' was not present! Struct: " + this.toString());
        }
        if (this.ddl_type == null) {
            throw new TProtocolException("Required field 'ddl_type' was not present! Struct: " + this.toString());
        }
        if (this.create_db_params != null) {
            this.create_db_params.validate();
        }
        if (this.drop_db_params != null) {
            this.drop_db_params.validate();
        }
        if (this.drop_table_params != null) {
            this.drop_table_params.validate();
        }
        if (this.load_params != null) {
            this.load_params.validate();
        }
        if (this.cancel_load_params != null) {
            this.cancel_load_params.validate();
        }
        if (this.create_user_params != null) {
            this.create_user_params.validate();
        }
        if (this.drop_user_params != null) {
            this.drop_user_params.validate();
        }
        if (this.create_rollup_params != null) {
            this.create_rollup_params.validate();
        }
        if (this.drop_rollup_params != null) {
            this.drop_rollup_params.validate();
        }
        if (this.create_function_params != null) {
            this.create_function_params.validate();
        }
        if (this.drop_function_params != null) {
            this.drop_function_params.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PROTOCOL_VERSION, new FieldMetaData("protocol_version", 1, new EnumMetaData(16, TPaloInternalServiceVersion.class)));
        tmpMap.put(_Fields.DDL_TYPE, new FieldMetaData("ddl_type", 1, new EnumMetaData(16, TCommonDdlType.class)));
        tmpMap.put(_Fields.CREATE_DB_PARAMS, new FieldMetaData("create_db_params", 2, new StructMetaData(12, TCreateDbParams.class)));
        tmpMap.put(_Fields.DROP_DB_PARAMS, new FieldMetaData("drop_db_params", 2, new StructMetaData(12, TDropDbParams.class)));
        tmpMap.put(_Fields.DROP_TABLE_PARAMS, new FieldMetaData("drop_table_params", 2, new StructMetaData(12, TDropTableParams.class)));
        tmpMap.put(_Fields.LOAD_PARAMS, new FieldMetaData("load_params", 2, new StructMetaData(12, TLoadParams.class)));
        tmpMap.put(_Fields.CANCEL_LOAD_PARAMS, new FieldMetaData("cancel_load_params", 2, new StructMetaData(12, TCancelLoadParams.class)));
        tmpMap.put(_Fields.CREATE_USER_PARAMS, new FieldMetaData("create_user_params", 2, new StructMetaData(12, TCreateUserParams.class)));
        tmpMap.put(_Fields.DROP_USER_PARAMS, new FieldMetaData("drop_user_params", 2, new StructMetaData(12, TDropUserParams.class)));
        tmpMap.put(_Fields.CREATE_ROLLUP_PARAMS, new FieldMetaData("create_rollup_params", 2, new StructMetaData(12, TCreateRollupParams.class)));
        tmpMap.put(_Fields.DROP_ROLLUP_PARAMS, new FieldMetaData("drop_rollup_params", 2, new StructMetaData(12, TDropRollupParams.class)));
        tmpMap.put(_Fields.CREATE_FUNCTION_PARAMS, new FieldMetaData("create_function_params", 2, new StructMetaData(12, TCreateFunctionParams.class)));
        tmpMap.put(_Fields.DROP_FUNCTION_PARAMS, new FieldMetaData("drop_function_params", 2, new StructMetaData(12, TDropFunctionParams.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TMasterDdlRequest.class, metaDataMap);
    }

    private static class TMasterDdlRequestTupleScheme
    extends TupleScheme<TMasterDdlRequest> {
        private TMasterDdlRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TMasterDdlRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.protocol_version.getValue());
            oprot.writeI32(struct.ddl_type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetCreateDbParams()) {
                optionals.set(0);
            }
            if (struct.isSetDropDbParams()) {
                optionals.set(1);
            }
            if (struct.isSetDropTableParams()) {
                optionals.set(2);
            }
            if (struct.isSetLoadParams()) {
                optionals.set(3);
            }
            if (struct.isSetCancelLoadParams()) {
                optionals.set(4);
            }
            if (struct.isSetCreateUserParams()) {
                optionals.set(5);
            }
            if (struct.isSetDropUserParams()) {
                optionals.set(6);
            }
            if (struct.isSetCreateRollupParams()) {
                optionals.set(7);
            }
            if (struct.isSetDropRollupParams()) {
                optionals.set(8);
            }
            if (struct.isSetCreateFunctionParams()) {
                optionals.set(9);
            }
            if (struct.isSetDropFunctionParams()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetCreateDbParams()) {
                struct.create_db_params.write(oprot);
            }
            if (struct.isSetDropDbParams()) {
                struct.drop_db_params.write(oprot);
            }
            if (struct.isSetDropTableParams()) {
                struct.drop_table_params.write(oprot);
            }
            if (struct.isSetLoadParams()) {
                struct.load_params.write(oprot);
            }
            if (struct.isSetCancelLoadParams()) {
                struct.cancel_load_params.write(oprot);
            }
            if (struct.isSetCreateUserParams()) {
                struct.create_user_params.write(oprot);
            }
            if (struct.isSetDropUserParams()) {
                struct.drop_user_params.write(oprot);
            }
            if (struct.isSetCreateRollupParams()) {
                struct.create_rollup_params.write(oprot);
            }
            if (struct.isSetDropRollupParams()) {
                struct.drop_rollup_params.write(oprot);
            }
            if (struct.isSetCreateFunctionParams()) {
                struct.create_function_params.write(oprot);
            }
            if (struct.isSetDropFunctionParams()) {
                struct.drop_function_params.write(oprot);
            }
        }

        @Override
        public void read(TProtocol prot, TMasterDdlRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.protocol_version = TPaloInternalServiceVersion.findByValue(iprot.readI32());
            struct.setProtocolVersionIsSet(true);
            struct.ddl_type = TCommonDdlType.findByValue(iprot.readI32());
            struct.setDdlTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.create_db_params = new TCreateDbParams();
                struct.create_db_params.read(iprot);
                struct.setCreateDbParamsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.drop_db_params = new TDropDbParams();
                struct.drop_db_params.read(iprot);
                struct.setDropDbParamsIsSet(true);
            }
            if (incoming.get(2)) {
                struct.drop_table_params = new TDropTableParams();
                struct.drop_table_params.read(iprot);
                struct.setDropTableParamsIsSet(true);
            }
            if (incoming.get(3)) {
                struct.load_params = new TLoadParams();
                struct.load_params.read(iprot);
                struct.setLoadParamsIsSet(true);
            }
            if (incoming.get(4)) {
                struct.cancel_load_params = new TCancelLoadParams();
                struct.cancel_load_params.read(iprot);
                struct.setCancelLoadParamsIsSet(true);
            }
            if (incoming.get(5)) {
                struct.create_user_params = new TCreateUserParams();
                struct.create_user_params.read(iprot);
                struct.setCreateUserParamsIsSet(true);
            }
            if (incoming.get(6)) {
                struct.drop_user_params = new TDropUserParams();
                struct.drop_user_params.read(iprot);
                struct.setDropUserParamsIsSet(true);
            }
            if (incoming.get(7)) {
                struct.create_rollup_params = new TCreateRollupParams();
                struct.create_rollup_params.read(iprot);
                struct.setCreateRollupParamsIsSet(true);
            }
            if (incoming.get(8)) {
                struct.drop_rollup_params = new TDropRollupParams();
                struct.drop_rollup_params.read(iprot);
                struct.setDropRollupParamsIsSet(true);
            }
            if (incoming.get(9)) {
                struct.create_function_params = new TCreateFunctionParams();
                struct.create_function_params.read(iprot);
                struct.setCreateFunctionParamsIsSet(true);
            }
            if (incoming.get(10)) {
                struct.drop_function_params = new TDropFunctionParams();
                struct.drop_function_params.read(iprot);
                struct.setDropFunctionParamsIsSet(true);
            }
        }
    }

    private static class TMasterDdlRequestTupleSchemeFactory
    implements SchemeFactory {
        private TMasterDdlRequestTupleSchemeFactory() {
        }

        public TMasterDdlRequestTupleScheme getScheme() {
            return new TMasterDdlRequestTupleScheme();
        }
    }

    private static class TMasterDdlRequestStandardScheme
    extends StandardScheme<TMasterDdlRequest> {
        private TMasterDdlRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TMasterDdlRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.protocol_version = TPaloInternalServiceVersion.findByValue(iprot.readI32());
                            struct.setProtocolVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.ddl_type = TCommonDdlType.findByValue(iprot.readI32());
                            struct.setDdlTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 12) {
                            struct.create_db_params = new TCreateDbParams();
                            struct.create_db_params.read(iprot);
                            struct.setCreateDbParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.drop_db_params = new TDropDbParams();
                            struct.drop_db_params.read(iprot);
                            struct.setDropDbParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.drop_table_params = new TDropTableParams();
                            struct.drop_table_params.read(iprot);
                            struct.setDropTableParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.load_params = new TLoadParams();
                            struct.load_params.read(iprot);
                            struct.setLoadParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.cancel_load_params = new TCancelLoadParams();
                            struct.cancel_load_params.read(iprot);
                            struct.setCancelLoadParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 12) {
                            struct.create_user_params = new TCreateUserParams();
                            struct.create_user_params.read(iprot);
                            struct.setCreateUserParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 12) {
                            struct.drop_user_params = new TDropUserParams();
                            struct.drop_user_params.read(iprot);
                            struct.setDropUserParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 12) {
                            struct.create_rollup_params = new TCreateRollupParams();
                            struct.create_rollup_params.read(iprot);
                            struct.setCreateRollupParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 12) {
                            struct.drop_rollup_params = new TDropRollupParams();
                            struct.drop_rollup_params.read(iprot);
                            struct.setDropRollupParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 12) {
                            struct.create_function_params = new TCreateFunctionParams();
                            struct.create_function_params.read(iprot);
                            struct.setCreateFunctionParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 12) {
                            struct.drop_function_params = new TDropFunctionParams();
                            struct.drop_function_params.read(iprot);
                            struct.setDropFunctionParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TMasterDdlRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.protocol_version != null) {
                oprot.writeFieldBegin(PROTOCOL_VERSION_FIELD_DESC);
                oprot.writeI32(struct.protocol_version.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.ddl_type != null) {
                oprot.writeFieldBegin(DDL_TYPE_FIELD_DESC);
                oprot.writeI32(struct.ddl_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.create_db_params != null && struct.isSetCreateDbParams()) {
                oprot.writeFieldBegin(CREATE_DB_PARAMS_FIELD_DESC);
                struct.create_db_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.drop_db_params != null && struct.isSetDropDbParams()) {
                oprot.writeFieldBegin(DROP_DB_PARAMS_FIELD_DESC);
                struct.drop_db_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.drop_table_params != null && struct.isSetDropTableParams()) {
                oprot.writeFieldBegin(DROP_TABLE_PARAMS_FIELD_DESC);
                struct.drop_table_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.load_params != null && struct.isSetLoadParams()) {
                oprot.writeFieldBegin(LOAD_PARAMS_FIELD_DESC);
                struct.load_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.cancel_load_params != null && struct.isSetCancelLoadParams()) {
                oprot.writeFieldBegin(CANCEL_LOAD_PARAMS_FIELD_DESC);
                struct.cancel_load_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.create_user_params != null && struct.isSetCreateUserParams()) {
                oprot.writeFieldBegin(CREATE_USER_PARAMS_FIELD_DESC);
                struct.create_user_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.drop_user_params != null && struct.isSetDropUserParams()) {
                oprot.writeFieldBegin(DROP_USER_PARAMS_FIELD_DESC);
                struct.drop_user_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.create_rollup_params != null && struct.isSetCreateRollupParams()) {
                oprot.writeFieldBegin(CREATE_ROLLUP_PARAMS_FIELD_DESC);
                struct.create_rollup_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.drop_rollup_params != null && struct.isSetDropRollupParams()) {
                oprot.writeFieldBegin(DROP_ROLLUP_PARAMS_FIELD_DESC);
                struct.drop_rollup_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.create_function_params != null && struct.isSetCreateFunctionParams()) {
                oprot.writeFieldBegin(CREATE_FUNCTION_PARAMS_FIELD_DESC);
                struct.create_function_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.drop_function_params != null && struct.isSetDropFunctionParams()) {
                oprot.writeFieldBegin(DROP_FUNCTION_PARAMS_FIELD_DESC);
                struct.drop_function_params.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TMasterDdlRequestStandardSchemeFactory
    implements SchemeFactory {
        private TMasterDdlRequestStandardSchemeFactory() {
        }

        public TMasterDdlRequestStandardScheme getScheme() {
            return new TMasterDdlRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PROTOCOL_VERSION(1, "protocol_version"),
        DDL_TYPE(2, "ddl_type"),
        CREATE_DB_PARAMS(3, "create_db_params"),
        DROP_DB_PARAMS(4, "drop_db_params"),
        DROP_TABLE_PARAMS(6, "drop_table_params"),
        LOAD_PARAMS(7, "load_params"),
        CANCEL_LOAD_PARAMS(8, "cancel_load_params"),
        CREATE_USER_PARAMS(9, "create_user_params"),
        DROP_USER_PARAMS(10, "drop_user_params"),
        CREATE_ROLLUP_PARAMS(11, "create_rollup_params"),
        DROP_ROLLUP_PARAMS(12, "drop_rollup_params"),
        CREATE_FUNCTION_PARAMS(13, "create_function_params"),
        DROP_FUNCTION_PARAMS(14, "drop_function_params");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PROTOCOL_VERSION;
                }
                case 2: {
                    return DDL_TYPE;
                }
                case 3: {
                    return CREATE_DB_PARAMS;
                }
                case 4: {
                    return DROP_DB_PARAMS;
                }
                case 6: {
                    return DROP_TABLE_PARAMS;
                }
                case 7: {
                    return LOAD_PARAMS;
                }
                case 8: {
                    return CANCEL_LOAD_PARAMS;
                }
                case 9: {
                    return CREATE_USER_PARAMS;
                }
                case 10: {
                    return DROP_USER_PARAMS;
                }
                case 11: {
                    return CREATE_ROLLUP_PARAMS;
                }
                case 12: {
                    return DROP_ROLLUP_PARAMS;
                }
                case 13: {
                    return CREATE_FUNCTION_PARAMS;
                }
                case 14: {
                    return DROP_FUNCTION_PARAMS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

