/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.etl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class EtlJobConfig
implements Serializable {
    public static final String GLOBAL_DICT_TABLE_NAME = "doris_global_dict_table_%d";
    public static final String DISTINCT_KEY_TABLE_NAME = "doris_distinct_key_table_%d_%s";
    public static final String DORIS_INTERMEDIATE_HIVE_TABLE_NAME = "doris_intermediate_hive_table_%d_%s";
    private static final String ETL_OUTPUT_PATH_FORMAT = "%s/jobs/%d/%s/%d";
    private static final String ETL_OUTPUT_FILE_NAME_DESC_V1 = "version.label.tableId.partitionId.indexId.bucket.schemaHash.parquet";
    public static final String TABLET_META_FORMAT = "%d.%d.%d.%d.%d";
    public static final String ETL_OUTPUT_FILE_FORMAT = "parquet";
    public static final String DPP_RESULT_NAME = "dpp_result.json";
    @SerializedName(value="tables")
    public Map<Long, EtlTable> tables;
    @SerializedName(value="outputPath")
    public String outputPath;
    @SerializedName(value="outputFilePattern")
    public String outputFilePattern;
    @SerializedName(value="label")
    public String label;
    @SerializedName(value="properties")
    public EtlJobProperty properties;
    @SerializedName(value="configVersion")
    public ConfigVersion configVersion;

    public EtlJobConfig(Map<Long, EtlTable> tables, String outputFilePattern, String label, EtlJobProperty properties) {
        this.tables = tables;
        this.outputPath = null;
        this.outputFilePattern = outputFilePattern;
        this.label = label;
        this.properties = properties;
        this.configVersion = ConfigVersion.V1;
    }

    public String toString() {
        return "EtlJobConfig{tables=" + this.tables + ", outputPath='" + this.outputPath + '\'' + ", outputFilePattern='" + this.outputFilePattern + '\'' + ", label='" + this.label + '\'' + ", properties=" + this.properties + ", version=" + (Object)((Object)this.configVersion) + '}';
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public static String getOutputPath(String hdfsEtlPath, long dbId, String loadLabel, long taskSignature) {
        return String.format(ETL_OUTPUT_PATH_FORMAT, hdfsEtlPath, dbId, loadLabel, taskSignature);
    }

    public static String getOutputFilePattern(String loadLabel, FilePatternVersion filePatternVersion) {
        return String.format("%s.%s.%s.%s", filePatternVersion.name(), loadLabel, TABLET_META_FORMAT, ETL_OUTPUT_FILE_FORMAT);
    }

    public static String getDppResultFilePath(String outputPath) {
        return outputPath + "/" + DPP_RESULT_NAME;
    }

    public static String getTabletMetaStr(String filePath) throws Exception {
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
        String[] fileNameArr = fileName.split("\\.");
        switch (FilePatternVersion.valueOf(fileNameArr[0])) {
            case V1: {
                if (fileNameArr.length != ETL_OUTPUT_FILE_NAME_DESC_V1.split("\\.").length) {
                    throw new Exception("etl output file name error, format: version.label.tableId.partitionId.indexId.bucket.schemaHash.parquet, name: " + fileName);
                }
                long tableId = Long.parseLong(fileNameArr[2]);
                long partitionId = Long.parseLong(fileNameArr[3]);
                long indexId = Long.parseLong(fileNameArr[4]);
                int bucket = Integer.parseInt(fileNameArr[5]);
                int schemaHash = Integer.parseInt(fileNameArr[6]);
                return String.format(TABLET_META_FORMAT, tableId, partitionId, indexId, bucket, schemaHash);
            }
        }
        throw new Exception("etl output file version error. version: " + fileNameArr[0]);
    }

    public String configToJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.addDeserializationExclusionStrategy(new HiddenAnnotationExclusionStrategy());
        Gson gson = gsonBuilder.create();
        return gson.toJson(this);
    }

    public static EtlJobConfig configFromJson(String jsonConfig) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return gson.fromJson(jsonConfig, EtlJobConfig.class);
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        @Override
        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(SerializedName.class) == null;
        }

        @Override
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    public static class EtlColumnMapping
    implements Serializable {
        @SerializedName(value="functionName")
        public String functionName;
        @SerializedName(value="args")
        public List<String> args;
        @SerializedName(value="expr")
        public String expr;
        private static Map<String, String> functionMap = new ImmutableMap.Builder<String, String>().put("md5sum", "md5").build();

        public EtlColumnMapping(String functionName, List<String> args2) {
            this.functionName = functionName;
            this.args = args2;
        }

        public EtlColumnMapping(String expr) {
            this.expr = expr;
        }

        public String toDescription() {
            StringBuilder sb = new StringBuilder();
            if (this.functionName == null) {
                sb.append(this.expr);
            } else {
                if (functionMap.containsKey(this.functionName)) {
                    sb.append(functionMap.get(this.functionName));
                } else {
                    sb.append(this.functionName);
                }
                sb.append("(");
                if (this.args != null) {
                    for (String arg : this.args) {
                        sb.append(arg);
                        sb.append(",");
                    }
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(")");
            }
            return sb.toString();
        }

        public String toString() {
            return "EtlColumnMapping{functionName='" + this.functionName + '\'' + ", args=" + this.args + ", expr=" + this.expr + '}';
        }
    }

    public static class EtlFileGroup
    implements Serializable {
        @SerializedName(value="sourceType")
        public SourceType sourceType = SourceType.FILE;
        @SerializedName(value="filePaths")
        public List<String> filePaths;
        @SerializedName(value="fileFieldNames")
        public List<String> fileFieldNames;
        @SerializedName(value="columnsFromPath")
        public List<String> columnsFromPath;
        @SerializedName(value="columnSeparator")
        public String columnSeparator;
        @SerializedName(value="lineDelimiter")
        public String lineDelimiter;
        @SerializedName(value="isNegative")
        public boolean isNegative;
        @SerializedName(value="fileFormat")
        public String fileFormat;
        @SerializedName(value="columnMappings")
        public Map<String, EtlColumnMapping> columnMappings;
        @SerializedName(value="where")
        public String where;
        @SerializedName(value="partitions")
        public List<Long> partitions;
        @SerializedName(value="hiveDbTableName")
        public String hiveDbTableName;
        @SerializedName(value="hiveTableProperties")
        public Map<String, String> hiveTableProperties;
        public String dppHiveDbTableName;

        public EtlFileGroup(SourceType sourceType, List<String> filePaths, List<String> fileFieldNames, List<String> columnsFromPath, String columnSeparator, String lineDelimiter, boolean isNegative, String fileFormat, Map<String, EtlColumnMapping> columnMappings, String where, List<Long> partitions) {
            this.sourceType = sourceType;
            this.filePaths = filePaths;
            this.fileFieldNames = fileFieldNames;
            this.columnsFromPath = columnsFromPath;
            this.columnSeparator = Strings.isNullOrEmpty(columnSeparator) ? "\t" : columnSeparator;
            this.lineDelimiter = lineDelimiter;
            this.isNegative = isNegative;
            this.fileFormat = fileFormat;
            this.columnMappings = columnMappings;
            this.where = where;
            this.partitions = partitions;
        }

        public EtlFileGroup(SourceType sourceType, String hiveDbTableName, Map<String, String> hiveTableProperties, boolean isNegative, Map<String, EtlColumnMapping> columnMappings, String where, List<Long> partitions) {
            this.sourceType = sourceType;
            this.hiveDbTableName = hiveDbTableName;
            this.hiveTableProperties = hiveTableProperties;
            this.isNegative = isNegative;
            this.columnMappings = columnMappings;
            this.where = where;
            this.partitions = partitions;
        }

        public String toString() {
            return "EtlFileGroup{sourceType=" + (Object)((Object)this.sourceType) + ", filePaths=" + this.filePaths + ", fileFieldNames=" + this.fileFieldNames + ", columnsFromPath=" + this.columnsFromPath + ", columnSeparator='" + this.columnSeparator + '\'' + ", lineDelimiter='" + this.lineDelimiter + '\'' + ", isNegative=" + this.isNegative + ", fileFormat='" + this.fileFormat + '\'' + ", columnMappings=" + this.columnMappings + ", where='" + this.where + '\'' + ", partitions=" + this.partitions + ", hiveDbTableName='" + this.hiveDbTableName + '\'' + ", hiveTableProperties=" + this.hiveTableProperties + '}';
        }
    }

    public static class EtlPartition
    implements Serializable {
        @SerializedName(value="partitionId")
        public long partitionId;
        @SerializedName(value="startKeys")
        public List<Object> startKeys;
        @SerializedName(value="endKeys")
        public List<Object> endKeys;
        @SerializedName(value="isMaxPartition")
        public boolean isMaxPartition;
        @SerializedName(value="bucketNum")
        public int bucketNum;

        public EtlPartition(long partitionId, List<Object> startKeys, List<Object> endKeys, boolean isMaxPartition, int bucketNum) {
            this.partitionId = partitionId;
            this.startKeys = startKeys;
            this.endKeys = endKeys;
            this.isMaxPartition = isMaxPartition;
            this.bucketNum = bucketNum;
        }

        public String toString() {
            return "EtlPartition{partitionId=" + this.partitionId + ", startKeys=" + this.startKeys + ", endKeys=" + this.endKeys + ", isMaxPartition=" + this.isMaxPartition + ", bucketNum=" + this.bucketNum + '}';
        }
    }

    public static class EtlPartitionInfo
    implements Serializable {
        @SerializedName(value="partitionType")
        public String partitionType;
        @SerializedName(value="partitionColumnRefs")
        public List<String> partitionColumnRefs;
        @SerializedName(value="distributionColumnRefs")
        public List<String> distributionColumnRefs;
        @SerializedName(value="partitions")
        public List<EtlPartition> partitions;

        public EtlPartitionInfo(String partitionType, List<String> partitionColumnRefs, List<String> distributionColumnRefs, List<EtlPartition> etlPartitions) {
            this.partitionType = partitionType;
            this.partitionColumnRefs = partitionColumnRefs;
            this.distributionColumnRefs = distributionColumnRefs;
            this.partitions = etlPartitions;
        }

        public String toString() {
            return "EtlPartitionInfo{partitionType='" + this.partitionType + '\'' + ", partitionColumnRefs=" + this.partitionColumnRefs + ", distributionColumnRefs=" + this.distributionColumnRefs + ", partitions=" + this.partitions + '}';
        }
    }

    public static class EtlIndex
    implements Serializable {
        @SerializedName(value="indexId")
        public long indexId;
        @SerializedName(value="columns")
        public List<EtlColumn> columns;
        @SerializedName(value="schemaHash")
        public int schemaHash;
        @SerializedName(value="indexType")
        public String indexType;
        @SerializedName(value="isBaseIndex")
        public boolean isBaseIndex;

        public EtlIndex(long indexId, List<EtlColumn> etlColumns, int schemaHash, String indexType, boolean isBaseIndex) {
            this.indexId = indexId;
            this.columns = etlColumns;
            this.schemaHash = schemaHash;
            this.indexType = indexType;
            this.isBaseIndex = isBaseIndex;
        }

        public EtlColumn getColumn(String name) {
            for (EtlColumn column : this.columns) {
                if (!column.columnName.equals(name)) continue;
                return column;
            }
            return null;
        }

        public String toString() {
            return "EtlIndex{indexId=" + this.indexId + ", columns=" + this.columns + ", schemaHash=" + this.schemaHash + ", indexType='" + this.indexType + '\'' + ", isBaseIndex=" + this.isBaseIndex + '}';
        }
    }

    public static class EtlIndexComparator
    implements Comparator<EtlIndex> {
        @Override
        public int compare(EtlIndex a, EtlIndex b) {
            int diff = a.columns.size() - b.columns.size();
            if (diff == 0) {
                return 0;
            }
            if (diff > 0) {
                return 1;
            }
            return -1;
        }
    }

    public static class EtlColumn
    implements Serializable {
        @SerializedName(value="columnName")
        public String columnName;
        @SerializedName(value="columnType")
        public String columnType;
        @SerializedName(value="isAllowNull")
        public boolean isAllowNull;
        @SerializedName(value="isKey")
        public boolean isKey;
        @SerializedName(value="aggregationType")
        public String aggregationType;
        @SerializedName(value="defaultValue")
        public String defaultValue;
        @SerializedName(value="stringLength")
        public int stringLength;
        @SerializedName(value="precision")
        public int precision;
        @SerializedName(value="scale")
        public int scale;
        @SerializedName(value="defineExpr")
        public String defineExpr;

        public EtlColumn() {
        }

        public EtlColumn(String columnName, String columnType, boolean isAllowNull, boolean isKey, String aggregationType, String defaultValue, int stringLength, int precision, int scale) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.isAllowNull = isAllowNull;
            this.isKey = isKey;
            this.aggregationType = aggregationType;
            this.defaultValue = defaultValue;
            this.stringLength = stringLength;
            this.precision = precision;
            this.scale = scale;
            this.defineExpr = null;
        }

        public String toString() {
            return "EtlColumn{columnName='" + this.columnName + '\'' + ", columnType='" + this.columnType + '\'' + ", isAllowNull=" + this.isAllowNull + ", isKey=" + this.isKey + ", aggregationType='" + this.aggregationType + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", stringLength=" + this.stringLength + ", precision=" + this.precision + ", scale=" + this.scale + ", defineExpr='" + this.defineExpr + '\'' + '}';
        }
    }

    public static class EtlTable
    implements Serializable {
        @SerializedName(value="indexes")
        public List<EtlIndex> indexes;
        @SerializedName(value="partitionInfo")
        public EtlPartitionInfo partitionInfo;
        @SerializedName(value="fileGroups")
        public List<EtlFileGroup> fileGroups;

        public EtlTable(List<EtlIndex> etlIndexes, EtlPartitionInfo etlPartitionInfo) {
            this.indexes = etlIndexes;
            this.partitionInfo = etlPartitionInfo;
            this.fileGroups = Lists.newArrayList();
        }

        public void addFileGroup(EtlFileGroup etlFileGroup) {
            this.fileGroups.add(etlFileGroup);
        }

        public String toString() {
            return "EtlTable{indexes=" + this.indexes + ", partitionInfo=" + this.partitionInfo + ", fileGroups=" + this.fileGroups + '}';
        }
    }

    public static enum SourceType {
        FILE,
        HIVE;

    }

    public static enum FilePatternVersion {
        V1;

    }

    public static enum ConfigVersion {
        V1;

    }

    public static class EtlJobProperty
    implements Serializable {
        @SerializedName(value="strictMode")
        public boolean strictMode;
        @SerializedName(value="timezone")
        public String timezone;

        public String toString() {
            return "EtlJobProperty{strictMode=" + this.strictMode + ", timezone='" + this.timezone + '\'' + '}';
        }
    }
}

