/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.common.SparkDppException;
import org.apache.doris.load.loadv2.dpp.BigDecimalSumAggregator;
import org.apache.doris.load.loadv2.dpp.BitmapUnionAggregator;
import org.apache.doris.load.loadv2.dpp.ByteSumAggregator;
import org.apache.doris.load.loadv2.dpp.DoubleSumAggregator;
import org.apache.doris.load.loadv2.dpp.FloatSumAggregator;
import org.apache.doris.load.loadv2.dpp.HllUnionAggregator;
import org.apache.doris.load.loadv2.dpp.IntSumAggregator;
import org.apache.doris.load.loadv2.dpp.LargeIntMaxAggregator;
import org.apache.doris.load.loadv2.dpp.LargeIntMinAggregator;
import org.apache.doris.load.loadv2.dpp.LargeIntSumAggregator;
import org.apache.doris.load.loadv2.dpp.LongSumAggregator;
import org.apache.doris.load.loadv2.dpp.NumberMaxAggregator;
import org.apache.doris.load.loadv2.dpp.NumberMinAggregator;
import org.apache.doris.load.loadv2.dpp.ReplaceAggregator;
import org.apache.doris.load.loadv2.dpp.ReplaceIfNotNullAggregator;
import org.apache.doris.load.loadv2.dpp.ShortSumAggregator;
import org.apache.doris.load.loadv2.dpp.StringMaxAggregator;
import org.apache.doris.load.loadv2.dpp.StringMinAggregator;
import org.apache.doris.load.loadv2.etl.EtlJobConfig;

public abstract class SparkRDDAggregator<T>
implements Serializable {
    T init(Object value) {
        return (T)value;
    }

    abstract T update(T var1, T var2);

    Object finalize(Object value) {
        return value;
    }

    public static SparkRDDAggregator buildAggregator(EtlJobConfig.EtlColumn column) throws SparkDppException {
        String aggType = StringUtils.lowerCase((String)column.aggregationType);
        String columnType = StringUtils.lowerCase((String)column.columnType);
        switch (aggType) {
            case "bitmap_union": {
                return new BitmapUnionAggregator();
            }
            case "hll_union": {
                return new HllUnionAggregator();
            }
            case "max": {
                switch (columnType) {
                    case "tinyint": 
                    case "smallint": 
                    case "int": 
                    case "bigint": 
                    case "float": 
                    case "double": 
                    case "decimalv2": 
                    case "decimal32": 
                    case "decimal64": 
                    case "decimal128": 
                    case "date": 
                    case "datetime": 
                    case "datev2": 
                    case "datetimev2": {
                        return new NumberMaxAggregator();
                    }
                    case "char": 
                    case "varchar": {
                        return new StringMaxAggregator();
                    }
                    case "largeint": {
                        return new LargeIntMaxAggregator();
                    }
                }
                throw new SparkDppException(String.format("unsupported max aggregator for column type:%s", columnType));
            }
            case "min": {
                switch (columnType) {
                    case "tinyint": 
                    case "smallint": 
                    case "int": 
                    case "bigint": 
                    case "float": 
                    case "double": 
                    case "decimalv2": 
                    case "decimal32": 
                    case "decimal64": 
                    case "decimal128": 
                    case "date": 
                    case "datetime": 
                    case "datev2": 
                    case "datetimev2": {
                        return new NumberMinAggregator();
                    }
                    case "char": 
                    case "varchar": {
                        return new StringMinAggregator();
                    }
                    case "largeint": {
                        return new LargeIntMinAggregator();
                    }
                }
                throw new SparkDppException(String.format("unsupported min aggregator for column type:%s", columnType));
            }
            case "sum": {
                switch (columnType) {
                    case "tinyint": {
                        return new ByteSumAggregator();
                    }
                    case "smallint": {
                        return new ShortSumAggregator();
                    }
                    case "int": {
                        return new IntSumAggregator();
                    }
                    case "bigint": {
                        return new LongSumAggregator();
                    }
                    case "float": {
                        return new FloatSumAggregator();
                    }
                    case "double": {
                        return new DoubleSumAggregator();
                    }
                    case "largeint": {
                        return new LargeIntSumAggregator();
                    }
                    case "decimalv2": 
                    case "decimal32": 
                    case "decimal64": 
                    case "decimal128": {
                        return new BigDecimalSumAggregator();
                    }
                }
                throw new SparkDppException(String.format("unsupported sum aggregator for column type:%s", columnType));
            }
            case "replace_if_not_null": {
                return new ReplaceIfNotNullAggregator();
            }
            case "replace": {
                return new ReplaceAggregator();
            }
        }
        throw new SparkDppException(String.format("unsupported aggregate type %s", aggType));
    }
}

