/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import java.io.Serializable;
import java.util.List;
import org.apache.doris.load.loadv2.dpp.DppColumns;
import org.apache.doris.load.loadv2.etl.EtlJobConfig;
import org.apache.spark.Partitioner;

public class DorisRangePartitioner
extends Partitioner {
    private static final String UNPARTITIONED_TYPE = "UNPARTITIONED";
    private EtlJobConfig.EtlPartitionInfo partitionInfo;
    private List<PartitionRangeKey> partitionRangeKeys;
    List<Integer> partitionKeyIndexes;

    public DorisRangePartitioner(EtlJobConfig.EtlPartitionInfo partitionInfo, List<Integer> partitionKeyIndexes, List<PartitionRangeKey> partitionRangeKeys) {
        this.partitionInfo = partitionInfo;
        this.partitionKeyIndexes = partitionKeyIndexes;
        this.partitionRangeKeys = partitionRangeKeys;
    }

    public int numPartitions() {
        if (this.partitionInfo == null) {
            return 0;
        }
        if (this.partitionInfo.partitionType.equalsIgnoreCase(UNPARTITIONED_TYPE)) {
            return 1;
        }
        return this.partitionInfo.partitions.size();
    }

    public int getPartition(Object var1) {
        if (this.partitionInfo.partitionType != null && this.partitionInfo.partitionType.equalsIgnoreCase(UNPARTITIONED_TYPE)) {
            return 0;
        }
        DppColumns key = (DppColumns)var1;
        DppColumns partitionKey = new DppColumns(key, this.partitionKeyIndexes);
        for (int i = 0; i < this.partitionRangeKeys.size(); ++i) {
            if (!this.partitionRangeKeys.get(i).isRowContained(partitionKey)) continue;
            return i;
        }
        return -1;
    }

    public static class PartitionRangeKey
    implements Serializable {
        public boolean isMaxPartition;
        public DppColumns startKeys;
        public DppColumns endKeys;

        public boolean isRowContained(DppColumns row) {
            if (this.isMaxPartition) {
                return this.startKeys.compareTo(row) <= 0;
            }
            return this.startKeys.compareTo(row) <= 0 && this.endKeys.compareTo(row) > 0;
        }

        public String toString() {
            return "PartitionRangeKey{isMaxPartition=" + this.isMaxPartition + ", startKeys=" + this.startKeys + ", endKeys=" + this.endKeys + '}';
        }
    }
}

