/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(LimitOutputStream.class.getName());
    protected final OutputStream out;
    protected final int speed;
    protected long bytesWriteTotal;
    protected long startTime;
    protected boolean bstart;
    byte[] oneByte = new byte[1];

    public LimitOutputStream(OutputStream out, int limitspeed) throws IOException {
        if (out == null) {
            throw new IOException("OutputStream is null");
        }
        this.speed = limitspeed;
        LOG.debug("LimitOutputStream limit speed: {}", (Object)this.speed);
        this.out = out;
        this.bytesWriteTotal = 0L;
        this.bstart = false;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long resetTime;
        long sleepTime = 0L;
        long curTime = 0L;
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.speed > 0 && !this.bstart) {
            this.startTime = System.currentTimeMillis();
            this.bstart = true;
        }
        if ((resetTime = System.currentTimeMillis()) - this.startTime > 1000L) {
            this.bytesWriteTotal = 0L;
            this.startTime = resetTime;
        }
        this.out.write(b, off, len);
        if (len >= 0) {
            this.bytesWriteTotal += (long)len;
            if (this.speed > 0 && (sleepTime = this.bytesWriteTotal / (long)this.speed * 1000L - ((curTime = System.currentTimeMillis()) - this.startTime)) > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    LOG.warn("Thread sleep is interrupted");
                }
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)(b & 0xFF);
        this.write(this.oneByte, 0, this.oneByte.length);
    }
}

