/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import org.apache.doris.common.io.FastByteArrayOutputStream;
import org.apache.doris.common.io.Writable;
import org.apache.doris.meta.MetaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepCopy {
    private static final Logger LOG = LoggerFactory.getLogger(DeepCopy.class);
    public static final String READ_FIELDS_METHOD_NAME = "readFields";
    public static final String READ_METHOD_NAME = "read";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(Writable orig, Writable dest, Class c, int metaVersion) {
        MetaContext metaContext = new MetaContext();
        metaContext.setMetaVersion(metaVersion);
        metaContext.setThreadLocalInfo();
        FastByteArrayOutputStream byteArrayOutputStream = new FastByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
        try {
            orig.write(out);
            out.flush();
            out.close();
            DataInputStream in = new DataInputStream(byteArrayOutputStream.getInputStream());
            Method readMethod = c.getDeclaredMethod(READ_FIELDS_METHOD_NAME, DataInput.class);
            readMethod.invoke((Object)dest, in);
            in.close();
        }
        catch (Exception e) {
            LOG.warn("failed to copy object.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            MetaContext.remove();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T copy(Writable orig, Class<T> c, int metaVersion) {
        MetaContext metaContext = new MetaContext();
        metaContext.setMetaVersion(metaVersion);
        metaContext.setThreadLocalInfo();
        FastByteArrayOutputStream byteArrayOutputStream = new FastByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
        try {
            orig.write(out);
            out.flush();
            out.close();
            DataInputStream in = new DataInputStream(byteArrayOutputStream.getInputStream());
            Method readMethod = c.getDeclaredMethod(READ_METHOD_NAME, DataInput.class);
            Object result = readMethod.invoke((Object)orig, in);
            in.close();
            Object object = result;
            return (T)object;
        }
        catch (Exception e) {
            LOG.warn("failed to copy object.", e);
            T t = null;
            return t;
        }
        finally {
            MetaContext.remove();
        }
    }
}

