/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class Fastjson1xSupport {
    static final Class CLASS_FASTJSON_OBJECT;
    static Function UNSAFE_OBJECT_CREATOR;
    static Supplier UNSAFE_OBJECT_WRITER;

    public static Function createObjectSupplier(Class objectClass) {
        Constructor constructor;
        if (JDKUtils.UNSAFE_SUPPORT) {
            if (UNSAFE_OBJECT_CREATOR != null) {
                return UNSAFE_OBJECT_CREATOR;
            }
            UNSAFE_OBJECT_CREATOR = new ObjectCreatorUF(objectClass);
            return UNSAFE_OBJECT_CREATOR;
        }
        try {
            constructor = objectClass.getConstructor(Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new JSONException("create JSONObject1 error");
        }
        return arg -> {
            try {
                return constructor.newInstance(arg);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("create JSONObject1 error");
            }
        };
    }

    static {
        Class<?> objectClass = null;
        try {
            objectClass = Class.forName("com.alibaba.fastjson.JSONObject");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        CLASS_FASTJSON_OBJECT = objectClass;
    }

    static class ObjectCreatorUF
    implements Function {
        final Class objectClass;
        final Field map;
        final long mapOffset;

        ObjectCreatorUF(Class objectClass) {
            this.objectClass = objectClass;
            try {
                this.map = objectClass.getDeclaredField("map");
            }
            catch (NoSuchFieldException e) {
                throw new JSONException("field map not found", e);
            }
            this.mapOffset = UnsafeUtils.UNSAFE.objectFieldOffset(this.map);
        }

        public Object apply(Object map) {
            Object object;
            if (map == null) {
                map = new HashMap();
            }
            try {
                object = UnsafeUtils.UNSAFE.allocateInstance(this.objectClass);
                UnsafeUtils.UNSAFE.putObject(object, this.mapOffset, map);
            }
            catch (InstantiationException e) {
                throw new JSONException("create " + this.objectClass.getName() + " error", e);
            }
            return object;
        }
    }
}

