/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.AutoBoxing;

public final class Utilities {
    @Nonnull
    public static final Object[] NO_ARGS = new Object[0];
    public static final boolean JAVA8;
    public static final boolean HOTSPOT_VM;

    private Utilities() {
    }

    public static void ensureThatMemberIsAccessible(@Nonnull AccessibleObject classMember) {
        if (!classMember.isAccessible()) {
            classMember.setAccessible(true);
        }
    }

    @Nonnull
    public static Class<?> getClassType(@Nonnull Type declaredType) {
        while (true) {
            if (declaredType instanceof Class) {
                return (Class)declaredType;
            }
            if (declaredType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)declaredType).getRawType();
            }
            if (declaredType instanceof GenericArrayType) {
                declaredType = ((GenericArrayType)declaredType).getGenericComponentType();
                continue;
            }
            if (declaredType instanceof TypeVariable) {
                declaredType = ((TypeVariable)declaredType).getBounds()[0];
                continue;
            }
            if (!(declaredType instanceof WildcardType)) break;
            declaredType = ((WildcardType)declaredType).getUpperBounds()[0];
        }
        throw new IllegalArgumentException("Type of unexpected kind: " + declaredType);
    }

    public static boolean containsReference(@Nonnull List<?> references, @Nullable Object toBeFound) {
        int n = references.size();
        for (int i = 0; i < n; ++i) {
            if (references.get(i) != toBeFound) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Object convertFromString(@Nonnull Class<?> targetType, @Nonnull String value) {
        if (targetType == String.class) {
            return value;
        }
        if (Utilities.isCharacter(targetType)) {
            return Character.valueOf(value.charAt(0));
        }
        if (targetType.isPrimitive()) {
            return Utilities.newWrapperInstanceForPrimitiveType(targetType, value);
        }
        if (AutoBoxing.isWrapperOfPrimitiveType(targetType)) {
            return Utilities.newWrapperInstance(targetType, value);
        }
        if (targetType == BigDecimal.class) {
            return new BigDecimal(value.trim());
        }
        if (targetType == BigInteger.class) {
            return new BigInteger(value.trim());
        }
        if (targetType == AtomicInteger.class) {
            return new AtomicInteger(Integer.parseInt(value.trim()));
        }
        if (targetType == AtomicLong.class) {
            return new AtomicLong(Long.parseLong(value.trim()));
        }
        if (targetType.isEnum()) {
            return Utilities.enumValue(targetType, value);
        }
        return null;
    }

    private static boolean isCharacter(@Nonnull Class<?> targetType) {
        return targetType == Character.TYPE || targetType == Character.class;
    }

    @Nonnull
    private static Object newWrapperInstanceForPrimitiveType(@Nonnull Class<?> targetType, @Nonnull String value) {
        Class<?> wrapperClass = AutoBoxing.getWrapperType(targetType);
        assert (wrapperClass != null);
        return Utilities.newWrapperInstance(wrapperClass, value);
    }

    @Nonnull
    private static Object newWrapperInstance(@Nonnull Class<?> wrapperClass, @Nonnull String value) {
        for (Constructor<?> constructor : wrapperClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes;
            if (!Modifier.isPublic(constructor.getModifiers()) || (parameterTypes = constructor.getParameterTypes()).length != 1 || parameterTypes[0] != String.class) continue;
            try {
                return constructor.newInstance(value.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Unable to instantiate " + wrapperClass + " with value \"" + value + '\"');
    }

    @Nonnull
    private static <E extends Enum<E>> Object enumValue(Class<?> targetType, @Nonnull String value) {
        Class<?> enumType = targetType;
        return Enum.valueOf(enumType, value);
    }

    @Nonnull
    public static String getClassFileLocationPath(@Nonnull Class<?> aClass) {
        CodeSource codeSource = aClass.getProtectionDomain().getCodeSource();
        return Utilities.getClassFileLocationPath(codeSource);
    }

    @Nonnull
    public static String getClassFileLocationPath(@Nonnull CodeSource codeSource) {
        String locationPath = codeSource.getLocation().getPath();
        try {
            locationPath = URLDecoder.decode(locationPath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return locationPath;
    }

    static {
        float javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        JAVA8 = javaVersion >= 1.8f;
        String vmName = System.getProperty("java.vm.name");
        HOTSPOT_VM = vmName.contains("HotSpot") || vmName.contains("OpenJDK");
    }
}

