/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.StackTrace;
import sun.reflect.ReflectionFactory;

public abstract class InstanceFactory {
    private static final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();
    private static final Constructor<?> OBJECT_CONSTRUCTOR;
    @Nonnull
    private final Class<?> concreteClass;
    @Nullable
    Object lastInstance;

    InstanceFactory(@Nonnull Class<?> concreteClass) {
        this.concreteClass = concreteClass;
    }

    @Nonnull
    final <T> T newUninitializedConcreteClassInstance() {
        try {
            Constructor<?> fakeConstructor = REFLECTION_FACTORY.newConstructorForSerialization(this.concreteClass, OBJECT_CONSTRUCTOR);
            if (fakeConstructor == null) {
                return null;
            }
            Object newInstance = fakeConstructor.newInstance(new Object[0]);
            return (T)newInstance;
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            StackTrace.filterStackTrace(e);
            e.printStackTrace();
            throw e;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Nonnull
    public abstract Object create();

    @Nullable
    public final Object getLastInstance() {
        return this.lastInstance;
    }

    public abstract void clearLastInstance();

    static {
        try {
            OBJECT_CONSTRUCTOR = Object.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static final class ClassInstanceFactory
    extends InstanceFactory {
        ClassInstanceFactory(@Nonnull Class<?> concreteClass) {
            super(concreteClass);
        }

        @Override
        @Nonnull
        public Object create() {
            this.lastInstance = this.newUninitializedConcreteClassInstance();
            return this.lastInstance;
        }

        @Override
        public void clearLastInstance() {
            this.lastInstance = null;
        }
    }

    static final class InterfaceInstanceFactory
    extends InstanceFactory {
        @Nullable
        private Object emptyProxy;

        InterfaceInstanceFactory(@Nonnull Object emptyProxy) {
            super(emptyProxy.getClass());
            this.emptyProxy = emptyProxy;
        }

        @Override
        @Nonnull
        public Object create() {
            if (this.emptyProxy == null) {
                this.emptyProxy = this.newUninitializedConcreteClassInstance();
            }
            this.lastInstance = this.emptyProxy;
            return this.emptyProxy;
        }

        @Override
        public void clearLastInstance() {
            this.emptyProxy = null;
            this.lastInstance = null;
        }
    }
}

